/*
 * Decompiled with CFR 0.152.
 */
package com.opensource.svgaplayer;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import android.text.TextPaint;
import com.opensource.svgaplayer.SVGAPath;
import com.opensource.svgaplayer.SVGAPlayer;
import com.opensource.svgaplayer.SVGARect;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.opensource.svgaplayer.SVGAVideoShapeEntity;
import com.opensource.svgaplayer.SVGAVideoSpriteEntity;
import com.opensource.svgaplayer.SVGAVideoSpriteFrameEntity;

class SVGADrawer
implements Runnable {
    private static final String TAG = "SVGADrawer";
    protected static Object mLock = new Object();
    protected SVGAPlayer textureView;
    protected SVGAVideoEntity videoItem;
    protected int videoWidth;
    protected float scaledDensity;
    protected Canvas currentCanvas;
    protected int loopCount = 0;
    protected int currentFrame = 0;
    protected long nextTimestamp = 0L;
    protected boolean paused = false;
    Matrix drawTransform = new Matrix();
    Paint paint = new Paint();
    Matrix concatTransform = new Matrix();
    private Paint maskPaint = new Paint();

    SVGADrawer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int fps = this.videoItem.FPS;
        boolean waiting = false;
        while (this.textureView.animating) {
            Object object;
            if (this.textureView.isAvailable()) {
                object = mLock;
                synchronized (object) {
                    if (this.paused) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else if (waiting) {
                        if (System.currentTimeMillis() < this.nextTimestamp) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                        if (null != this.currentCanvas) {
                            this.textureView.unlockCanvasAndPost(this.currentCanvas);
                            this.currentCanvas = null;
                        }
                        waiting = false;
                        this.stepFrame();
                    } else {
                        this.nextTimestamp = System.currentTimeMillis() + (long)(1000 / fps);
                        this.currentCanvas = this.textureView.lockCanvas();
                        if (this.currentCanvas != null) {
                            this.drawFrame(this.currentCanvas);
                        }
                        waiting = true;
                    }
                    continue;
                }
            }
            object = mLock;
            synchronized (object) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.paused) {
                    this.stepFrame();
                }
            }
        }
    }

    void pause() {
        this.paused = true;
    }

    void restore() {
        this.paused = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void draw() {
        if (this.textureView.isAvailable()) {
            Object object = mLock;
            synchronized (object) {
                if (null != this.currentCanvas) {
                    this.textureView.unlockCanvasAndPost(this.currentCanvas);
                    this.currentCanvas = null;
                }
                this.currentCanvas = this.textureView.lockCanvas();
                if (this.currentCanvas != null) {
                    this.drawFrame(this.currentCanvas);
                    this.textureView.unlockCanvasAndPost(this.currentCanvas);
                    this.currentCanvas = null;
                }
            }
        }
    }

    private void stepFrame() {
        if (this.videoItem.sprites.size() == 0) {
            return;
        }
        ++this.currentFrame;
        if (this.currentFrame >= this.videoItem.frames) {
            this.currentFrame = 0;
            ++this.loopCount;
            if (this.textureView.loops > 0 && this.loopCount >= this.textureView.loops) {
                this.textureView.animating = false;
                this.textureView.stopDrawing(this.textureView.clearsAfterStop);
                if (null != this.textureView.callback) {
                    this.textureView.callback.onFinished(this.textureView);
                }
                this.textureView.releaseDrawer();
            }
        }
        if (this.textureView.callback != null && this.videoItem.frames > 0) {
            this.textureView.callback.onStep(this.textureView, this.currentFrame, (float)this.currentFrame / (float)this.videoItem.frames);
        }
    }

    private void drawFrame(Canvas canvas) {
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        if (null != this.videoItem) {
            this.drawTransform.setScale((float)((double)this.videoWidth / (this.videoItem.videoSize.width / (double)this.scaledDensity)), (float)((double)this.videoWidth / (this.videoItem.videoSize.width / (double)this.scaledDensity)));
            for (int i = 0; i < this.videoItem.sprites.size(); ++i) {
                BitmapWithScale bitmap;
                SVGAVideoSpriteEntity sprite = this.videoItem.sprites.get(i);
                SVGAVideoSpriteFrameEntity frame = sprite.frames.get(this.currentFrame);
                if (null == frame || !(frame.alpha > 0.0)) continue;
                BitmapDrawable bitmapDrawable = this.videoItem.images.get(sprite.imageKey);
                if (this.textureView.dynamicImages.containsKey(sprite.imageKey)) {
                    bitmapDrawable = this.textureView.dynamicImages.get(sprite.imageKey);
                }
                if (null != bitmapDrawable && null != (bitmap = this.scaleBitmap(bitmapDrawable, frame.layout))) {
                    this.paint.setAlpha((int)(frame.alpha * 255.0));
                    this.concatTransform.setConcat(this.drawTransform, frame.transform);
                    if (bitmap.mScale > 0.0f) {
                        this.concatTransform.preScale(bitmap.mScale, bitmap.mScale);
                    }
                    if (null != frame.maskPath) {
                        this.drawBitmap(canvas, bitmap.mBitmap, frame.maskPath, this.concatTransform);
                    } else {
                        canvas.drawBitmap(bitmap.mBitmap, this.concatTransform, this.paint);
                    }
                    if (this.textureView.dynamicTexts.containsKey(sprite.imageKey)) {
                        String text = this.textureView.dynamicTexts.get(sprite.imageKey);
                        TextPaint textPaint = this.textureView.dynamicTextPaints.get(sprite.imageKey);
                        textPaint.setAlpha(this.paint.getAlpha());
                        float[] values = new float[9];
                        this.concatTransform.getValues(values);
                        Rect bounds = new Rect();
                        textPaint.getTextBounds(text, 0, text.length(), bounds);
                        int x = (int)((double)values[2] + ((double)values[0] * frame.layout.width - (double)bounds.width()) / 2.0);
                        int targetRectTop = (int)values[5];
                        int targetRectBottom = (int)((double)values[5] + (double)values[4] * frame.layout.height);
                        int fontMetricsBottom = (int)textPaint.getFontMetrics().bottom;
                        int fontMetricsTop = (int)textPaint.getFontMetrics().top;
                        int y = (targetRectBottom + targetRectTop - fontMetricsBottom - fontMetricsTop) / 2;
                        canvas.drawText(text, (float)x, (float)y, (Paint)textPaint);
                    }
                }
                if (frame.shapes.length <= 0) continue;
                for (int j = 0; j < frame.shapes.length; ++j) {
                    SVGAVideoShapeEntity shape = frame.shapes[j];
                    this.concatTransform.reset();
                    this.concatTransform.setConcat(this.drawTransform, frame.transform);
                    this.drawShape(canvas, shape, this.concatTransform);
                }
            }
        }
    }

    private void drawBitmap(Canvas canvas, Bitmap imageBitmap, Path maskPath, Matrix matrix) {
        canvas.save();
        canvas.setMatrix(matrix);
        canvas.clipRect(0, 0, imageBitmap.getWidth(), imageBitmap.getHeight());
        BitmapShader bitmapShader = new BitmapShader(imageBitmap, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
        this.maskPaint.setShader((Shader)bitmapShader);
        canvas.drawPath(maskPath, this.maskPaint);
        canvas.restore();
    }

    private BitmapWithScale scaleBitmap(BitmapDrawable bitmapDrawable, SVGARect layout) {
        Bitmap bitmap = bitmapDrawable.getBitmap();
        if (Math.abs(layout.width - (double)bitmap.getWidth()) < (double)0.01f && Math.abs(layout.height - (double)bitmap.getHeight()) < (double)0.01f) {
            return new BitmapWithScale(bitmap);
        }
        if (layout.width > 0.0 && layout.height > 0.0) {
            double scale = layout.width / (double)bitmap.getWidth();
            return new BitmapWithScale(bitmap, (float)scale);
        }
        return new BitmapWithScale(bitmapDrawable.getBitmap());
    }

    private void drawShape(Canvas canvas, SVGAVideoShapeEntity shape, Matrix drawTransform) {
        Object xv;
        Path finalPath = new Path();
        if (shape.type == SVGAVideoShapeEntity.Type.shape) {
            Object d = shape.args.get("d");
            if (d instanceof String) {
                SVGAPath svgaPath = new SVGAPath();
                svgaPath.setValues((String)d);
                finalPath = svgaPath.getPath();
            }
        } else if (shape.type == SVGAVideoShapeEntity.Type.ellipse) {
            xv = shape.args.get("x");
            Object yv = shape.args.get("y");
            Object rxv = shape.args.get("radiusX");
            Object ryv = shape.args.get("radiusY");
            if (xv instanceof Number && yv instanceof Number && rxv instanceof Number && ryv instanceof Number) {
                float x = ((Number)xv).floatValue();
                float y = ((Number)yv).floatValue();
                float rx = ((Number)rxv).floatValue();
                float ry = ((Number)ryv).floatValue();
                if (Build.VERSION.SDK_INT >= 21) {
                    finalPath.addOval(x - rx, y - ry, x + rx, y + ry, Path.Direction.CW);
                } else if ((double)Math.abs(rx - ry) < 0.1) {
                    finalPath.addCircle(x, y, rx, Path.Direction.CW);
                }
            }
        } else if (shape.type == SVGAVideoShapeEntity.Type.rect) {
            xv = shape.args.get("x");
            Object yv = shape.args.get("y");
            Object wv = shape.args.get("width");
            Object hv = shape.args.get("height");
            Object crv = shape.args.get("cornerRadius");
            if (xv instanceof Number && yv instanceof Number && wv instanceof Number && hv instanceof Number && crv instanceof Number) {
                float x = ((Number)xv).floatValue();
                float y = ((Number)yv).floatValue();
                float width = ((Number)wv).floatValue();
                float height = ((Number)hv).floatValue();
                float cornerRadius = ((Number)crv).floatValue();
                if (Build.VERSION.SDK_INT >= 21) {
                    finalPath.addRoundRect(x, y, x + width, y + height, cornerRadius, cornerRadius, Path.Direction.CW);
                } else {
                    finalPath.addRect(x, y, x + width, y + height, Path.Direction.CW);
                }
            }
        }
        if (finalPath != null) {
            Matrix thisTransform = new Matrix();
            thisTransform.postConcat(shape.transform);
            thisTransform.postConcat(drawTransform);
            finalPath.transform(thisTransform);
            if (shape.styles.fill != 0) {
                this.paint.reset();
                this.paint.setAntiAlias(true);
                this.paint.setColor(shape.styles.fill);
                canvas.drawPath(finalPath, this.paint);
            }
            if (shape.styles.strokeWidth > 0.0f) {
                this.resetShapeStrokePaint(shape);
                canvas.drawPath(this.trimmedPath(finalPath, shape.styles.trimStart, shape.styles.trimEnd), this.paint);
            }
        }
    }

    private Path trimmedPath(Path path, float start, float end) {
        if (Math.abs((double)start - 0.0) < 0.01 && Math.abs((double)end - 1.0) < 0.01) {
            return path;
        }
        Path currentPath = new Path(path);
        Path tmpPath = new Path();
        tmpPath.set(currentPath);
        PathMeasure pathMeasure = new PathMeasure();
        pathMeasure.setPath(tmpPath, false);
        float length = pathMeasure.getLength();
        float _start = length * start;
        float _end = length * end;
        float newStart = Math.min(_start, _end);
        float newEnd = Math.max(_start, _end);
        currentPath.reset();
        if (newStart > length && newEnd > length) {
            newStart %= length;
            newEnd %= length;
        }
        if (newStart > newEnd) {
            newStart -= length;
        }
        pathMeasure.getSegment(newStart, newEnd, currentPath, true);
        return currentPath;
    }

    private void resetShapeStrokePaint(SVGAVideoShapeEntity shape) {
        this.paint.reset();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(shape.styles.stroke);
        this.paint.setStrokeWidth(shape.styles.strokeWidth);
        if (shape.styles.lineCap.equalsIgnoreCase("butt")) {
            this.paint.setStrokeCap(Paint.Cap.BUTT);
        } else if (shape.styles.lineCap.equalsIgnoreCase("round")) {
            this.paint.setStrokeCap(Paint.Cap.ROUND);
        } else if (shape.styles.lineCap.equalsIgnoreCase("square")) {
            this.paint.setStrokeCap(Paint.Cap.SQUARE);
        }
        if (shape.styles.lineJoin.equalsIgnoreCase("miter")) {
            this.paint.setStrokeJoin(Paint.Join.MITER);
        } else if (shape.styles.lineJoin.equalsIgnoreCase("round")) {
            this.paint.setStrokeJoin(Paint.Join.ROUND);
        } else if (shape.styles.lineJoin.equalsIgnoreCase("bevel")) {
            this.paint.setStrokeJoin(Paint.Join.BEVEL);
        }
        this.paint.setStrokeMiter((float)shape.styles.miterLimit);
        if (shape.styles.lineDash.length == 3) {
            this.paint.setPathEffect((PathEffect)new DashPathEffect(new float[]{shape.styles.lineDash[0] < 1.0f ? 1.0f : shape.styles.lineDash[0], shape.styles.lineDash[1] < 0.1f ? 0.1f : shape.styles.lineDash[1]}, shape.styles.lineDash[2]));
        }
    }

    static class BitmapWithScale {
        final Bitmap mBitmap;
        final float mScale;

        BitmapWithScale(Bitmap bitmap) {
            this(bitmap, -1.0f);
        }

        BitmapWithScale(Bitmap bitmap, float scale) {
            this.mBitmap = bitmap;
            this.mScale = scale;
        }
    }
}

