/*
 * Decompiled with CFR 0.152.
 */
package com.yzq.zxinglibrary.view;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.google.zxing.ResultPoint;
import com.yzq.zxinglibrary.R;
import com.yzq.zxinglibrary.bean.ZxingConfig;
import com.yzq.zxinglibrary.camera.CameraManager;
import java.util.ArrayList;
import java.util.List;

public final class ViewfinderView
extends View {
    private static final long ANIMATION_DELAY = 80L;
    private static final int CURRENT_POINT_OPACITY = 160;
    private static final int MAX_RESULT_POINTS = 20;
    private static final int POINT_SIZE = 6;
    private CameraManager cameraManager;
    private Paint paint;
    private Paint scanLinePaint;
    private Paint reactPaint;
    private Paint frameLinePaint;
    private Bitmap resultBitmap;
    private int maskColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.viewfinder_mask);
    private int resultColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.result_view);
    private int resultPointColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.possible_result_points);
    private int reactColor;
    private int scanLineColor;
    private int frameLineColor = -1;
    private List<ResultPoint> possibleResultPoints = new ArrayList<ResultPoint>(10);
    private List<ResultPoint> lastPossibleResultPoints = null;
    private int scanLineTop;
    private ZxingConfig config;
    private ValueAnimator valueAnimator;
    private Rect frame;

    public ViewfinderView(Context context) {
        this(context, null);
    }

    public ViewfinderView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public void setZxingConfig(ZxingConfig config) {
        this.config = config;
        this.reactColor = ContextCompat.getColor((Context)this.getContext(), (int)config.getReactColor());
        if (config.getFrameLineColor() != -1) {
            this.frameLineColor = ContextCompat.getColor((Context)this.getContext(), (int)config.getFrameLineColor());
        }
        this.scanLineColor = ContextCompat.getColor((Context)this.getContext(), (int)config.getScanLineColor());
        this.initPaint();
    }

    public ViewfinderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    private void initPaint() {
        this.paint = new Paint(1);
        this.reactPaint = new Paint(1);
        this.reactPaint.setColor(this.reactColor);
        this.reactPaint.setStyle(Paint.Style.FILL);
        this.reactPaint.setStrokeWidth((float)this.dp2px(1));
        if (this.frameLineColor != -1) {
            this.frameLinePaint = new Paint(1);
            this.frameLinePaint.setColor(ContextCompat.getColor((Context)this.getContext(), (int)this.config.getFrameLineColor()));
            this.frameLinePaint.setStrokeWidth((float)this.dp2px(1));
            this.frameLinePaint.setStyle(Paint.Style.STROKE);
        }
        this.scanLinePaint = new Paint(1);
        this.scanLinePaint.setStrokeWidth((float)this.dp2px(2));
        this.scanLinePaint.setStyle(Paint.Style.FILL);
        this.scanLinePaint.setDither(true);
        this.scanLinePaint.setColor(this.scanLineColor);
    }

    private void initAnimator() {
        if (this.valueAnimator == null) {
            this.valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.frame.top, this.frame.bottom});
            this.valueAnimator.setDuration(3000L);
            this.valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            this.valueAnimator.setRepeatMode(1);
            this.valueAnimator.setRepeatCount(-1);
            this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ViewfinderView.this.scanLineTop = (Integer)animation.getAnimatedValue();
                    ViewfinderView.this.invalidate();
                }
            });
            this.valueAnimator.start();
        }
    }

    public void setCameraManager(CameraManager cameraManager) {
        this.cameraManager = cameraManager;
    }

    public void stopAnimator() {
        if (this.valueAnimator != null) {
            this.valueAnimator.end();
            this.valueAnimator.cancel();
            this.valueAnimator = null;
        }
    }

    @SuppressLint(value={"DrawAllocation"})
    public void onDraw(Canvas canvas) {
        if (this.cameraManager == null) {
            return;
        }
        this.frame = this.cameraManager.getFramingRect();
        Rect previewFrame = this.cameraManager.getFramingRectInPreview();
        if (this.frame == null || previewFrame == null) {
            return;
        }
        this.initAnimator();
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.drawMaskView(canvas, this.frame, width, height);
        this.drawFrameBounds(canvas, this.frame);
        if (this.resultBitmap != null) {
            this.paint.setAlpha(160);
            canvas.drawBitmap(this.resultBitmap, null, this.frame, this.paint);
        } else {
            this.drawScanLight(canvas, this.frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawPoint(Canvas canvas, Rect frame, Rect previewFrame) {
        List<ResultPoint> list;
        float scaleX = (float)frame.width() / (float)previewFrame.width();
        float scaleY = (float)frame.height() / (float)previewFrame.height();
        List<ResultPoint> currentPossible = this.possibleResultPoints;
        List<ResultPoint> currentLast = this.lastPossibleResultPoints;
        int frameLeft = frame.left;
        int frameTop = frame.top;
        if (currentPossible.isEmpty()) {
            this.lastPossibleResultPoints = null;
        } else {
            this.possibleResultPoints = new ArrayList<ResultPoint>(5);
            this.lastPossibleResultPoints = currentPossible;
            this.paint.setAlpha(160);
            this.paint.setColor(this.resultPointColor);
            list = currentPossible;
            synchronized (list) {
                for (ResultPoint point : currentPossible) {
                    canvas.drawCircle((float)(frameLeft + (int)(point.getX() * scaleX)), (float)(frameTop + (int)(point.getY() * scaleY)), 6.0f, this.paint);
                }
            }
        }
        if (currentLast != null) {
            this.paint.setAlpha(80);
            this.paint.setColor(this.resultPointColor);
            list = currentLast;
            synchronized (list) {
                float radius = 3.0f;
                for (ResultPoint point : currentLast) {
                    canvas.drawCircle((float)(frameLeft + (int)(point.getX() * scaleX)), (float)(frameTop + (int)(point.getY() * scaleY)), radius, this.paint);
                }
            }
        }
        this.postInvalidateDelayed(80L, frame.left - 6, frame.top - 6, frame.right + 6, frame.bottom + 6);
    }

    private void drawMaskView(Canvas canvas, Rect frame, int width, int height) {
        this.paint.setColor(this.resultBitmap != null ? this.resultColor : this.maskColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)frame.top, this.paint);
        canvas.drawRect(0.0f, (float)frame.top, (float)frame.left, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect((float)(frame.right + 1), (float)frame.top, (float)width, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect(0.0f, (float)(frame.bottom + 1), (float)width, (float)height, this.paint);
    }

    private void drawFrameBounds(Canvas canvas, Rect frame) {
        int width;
        int corLength;
        int corWidth;
        if (this.frameLineColor != -1) {
            canvas.drawRect(frame, this.frameLinePaint);
        }
        corWidth = (corWidth = (int)((double)(corLength = (int)((double)(width = frame.width()) * 0.07)) * 0.2)) > 15 ? 15 : corWidth;
        canvas.drawRect((float)(frame.left - corWidth), (float)frame.top, (float)frame.left, (float)(frame.top + corLength), this.reactPaint);
        canvas.drawRect((float)(frame.left - corWidth), (float)(frame.top - corWidth), (float)(frame.left + corLength), (float)frame.top, this.reactPaint);
        canvas.drawRect((float)frame.right, (float)frame.top, (float)(frame.right + corWidth), (float)(frame.top + corLength), this.reactPaint);
        canvas.drawRect((float)(frame.right - corLength), (float)(frame.top - corWidth), (float)(frame.right + corWidth), (float)frame.top, this.reactPaint);
        canvas.drawRect((float)(frame.left - corWidth), (float)(frame.bottom - corLength), (float)frame.left, (float)frame.bottom, this.reactPaint);
        canvas.drawRect((float)(frame.left - corWidth), (float)frame.bottom, (float)(frame.left + corLength), (float)(frame.bottom + corWidth), this.reactPaint);
        canvas.drawRect((float)frame.right, (float)(frame.bottom - corLength), (float)(frame.right + corWidth), (float)frame.bottom, this.reactPaint);
        canvas.drawRect((float)(frame.right - corLength), (float)frame.bottom, (float)(frame.right + corWidth), (float)(frame.bottom + corWidth), this.reactPaint);
    }

    private void drawScanLight(Canvas canvas, Rect frame) {
        canvas.drawLine((float)frame.left, (float)this.scanLineTop, (float)frame.right, (float)this.scanLineTop, this.scanLinePaint);
    }

    public void drawViewfinder() {
        Bitmap resultBitmap = this.resultBitmap;
        this.resultBitmap = null;
        if (resultBitmap != null) {
            resultBitmap.recycle();
        }
        this.invalidate();
    }

    public void drawResultBitmap(Bitmap barcode) {
        this.resultBitmap = barcode;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPossibleResultPoint(ResultPoint point) {
        List<ResultPoint> points;
        List<ResultPoint> list = points = this.possibleResultPoints;
        synchronized (list) {
            points.add(point);
            int size = points.size();
            if (size > 20) {
                points.subList(0, size - 10).clear();
            }
        }
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }
}

