/*
 * Decompiled with CFR 0.152.
 */
package com.yzq.zxinglibrary.decode;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Log;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.yzq.zxinglibrary.decode.BitmapLuminanceSource;
import com.yzq.zxinglibrary.decode.DecodeFormatManager;
import com.yzq.zxinglibrary.decode.DecodeImgCallback;
import java.util.Hashtable;
import java.util.Vector;

public class DecodeImgThread
extends Thread {
    private String imgPath;
    private DecodeImgCallback callback;
    private Bitmap scanBitmap;

    public DecodeImgThread(String imgPath, DecodeImgCallback callback) {
        this.imgPath = imgPath;
        this.callback = callback;
    }

    @Override
    public void run() {
        super.run();
        if (TextUtils.isEmpty((CharSequence)this.imgPath) || this.callback == null) {
            return;
        }
        Bitmap scanBitmap = DecodeImgThread.getBitmap(this.imgPath, 400, 400);
        MultiFormatReader multiFormatReader = new MultiFormatReader();
        Hashtable hints = new Hashtable(2);
        Vector<BarcodeFormat> decodeFormats = new Vector<BarcodeFormat>();
        decodeFormats.addAll(DecodeFormatManager.ONE_D_FORMATS);
        decodeFormats.addAll(DecodeFormatManager.QR_CODE_FORMATS);
        decodeFormats.addAll(DecodeFormatManager.DATA_MATRIX_FORMATS);
        hints.put(DecodeHintType.POSSIBLE_FORMATS, decodeFormats);
        multiFormatReader.setHints(hints);
        Result rawResult = null;
        try {
            rawResult = multiFormatReader.decodeWithState(new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BitmapLuminanceSource(scanBitmap))));
            Log.i((String)"\u89e3\u6790\u7ed3\u679c", (String)rawResult.getText());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (rawResult != null) {
            this.callback.onImageDecodeSuccess(rawResult);
        } else {
            this.callback.onImageDecodeFailed();
        }
    }

    private static Bitmap getBitmap(String filePath, int maxWidth, int maxHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        options.inSampleSize = DecodeImgThread.calculateInSampleSize(options, maxWidth, maxHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int maxWidth, int maxHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        while ((width >>= 1) >= maxWidth && (height >>= 1) >= maxHeight) {
            inSampleSize <<= 1;
        }
        return inSampleSize;
    }
}

