/*
 * Decompiled with CFR 0.152.
 */
package com.yzq.zxinglibrary.android;

import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import com.google.zxing.Result;
import com.yzq.zxinglibrary.android.CaptureActivity;
import com.yzq.zxinglibrary.camera.CameraManager;
import com.yzq.zxinglibrary.decode.DecodeThread;
import com.yzq.zxinglibrary.view.ViewfinderResultPointCallback;

public final class CaptureActivityHandler
extends Handler {
    private static final String TAG = CaptureActivityHandler.class.getSimpleName();
    private final CaptureActivity activity;
    private final DecodeThread decodeThread;
    private State state;
    private final CameraManager cameraManager;

    public CaptureActivityHandler(CaptureActivity activity, CameraManager cameraManager) {
        this.activity = activity;
        this.decodeThread = new DecodeThread(activity, new ViewfinderResultPointCallback(activity.getViewfinderView()));
        this.decodeThread.start();
        this.state = State.SUCCESS;
        this.cameraManager = cameraManager;
        cameraManager.startPreview();
        this.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        switch (message.what) {
            case 6: {
                this.restartPreviewAndDecode();
                break;
            }
            case 3: {
                this.state = State.SUCCESS;
                this.activity.handleDecode((Result)message.obj);
                break;
            }
            case 2: {
                this.state = State.PREVIEW;
                this.cameraManager.requestPreviewFrame(this.decodeThread.getHandler(), 1);
                break;
            }
            case 7: {
                this.activity.setResult(-1, (Intent)message.obj);
                this.activity.finish();
                break;
            }
            case 8: {
                this.activity.switchFlashImg(8);
                break;
            }
            case 9: {
                this.activity.switchFlashImg(9);
            }
        }
    }

    public void quitSynchronously() {
        this.state = State.DONE;
        this.cameraManager.stopPreview();
        Message quit = Message.obtain((Handler)this.decodeThread.getHandler(), (int)5);
        quit.sendToTarget();
        try {
            this.decodeThread.join(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeMessages(3);
        this.removeMessages(2);
    }

    public void restartPreviewAndDecode() {
        if (this.state == State.SUCCESS) {
            this.state = State.PREVIEW;
            this.cameraManager.requestPreviewFrame(this.decodeThread.getHandler(), 1);
            this.activity.drawViewfinder();
        }
    }

    private static enum State {
        PREVIEW,
        SUCCESS,
        DONE;

    }
}

