/*
 * Decompiled with CFR 0.152.
 */
package com.yzq.zxinglibrary.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.util.AttributeSet;
import android.view.View;
import com.google.zxing.ResultPoint;
import com.yzq.zxinglibrary.R;
import com.yzq.zxinglibrary.camera.CameraManager;
import java.util.ArrayList;
import java.util.List;

public final class ViewfinderView
extends View {
    private static final int[] SCANNER_ALPHA = new int[]{0, 64, 128, 192, 255, 192, 128, 64};
    private static final long ANIMATION_DELAY = 80L;
    private static final int CURRENT_POINT_OPACITY = 160;
    private static final int MAX_RESULT_POINTS = 20;
    private static final int POINT_SIZE = 6;
    private CameraManager cameraManager;
    private final Paint paint = new Paint(1);
    private Bitmap resultBitmap;
    private final int maskColor;
    private final int resultColor;
    private final int laserColor;
    private final int resultPointColor;
    private final int statusColor;
    private int scannerAlpha;
    private List<ResultPoint> possibleResultPoints;
    private List<ResultPoint> lastPossibleResultPoints;
    private int scanLineTop;
    private final int SCAN_VELOCITY = 10;
    Bitmap scanLight;

    public ViewfinderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources resources = this.getResources();
        this.maskColor = resources.getColor(R.color.viewfinder_mask);
        this.resultColor = resources.getColor(R.color.result_view);
        this.laserColor = resources.getColor(R.color.viewfinder_laser);
        this.resultPointColor = resources.getColor(R.color.possible_result_points);
        this.statusColor = resources.getColor(R.color.status_text);
        this.scannerAlpha = 0;
        this.possibleResultPoints = new ArrayList<ResultPoint>(5);
        this.lastPossibleResultPoints = null;
        this.scanLight = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.scan_light);
    }

    public void setCameraManager(CameraManager cameraManager) {
        this.cameraManager = cameraManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DrawAllocation"})
    public void onDraw(Canvas canvas) {
        if (this.cameraManager == null) {
            return;
        }
        Rect frame = this.cameraManager.getFramingRect();
        Rect previewFrame = this.cameraManager.getFramingRectInPreview();
        if (frame == null || previewFrame == null) {
            return;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.paint.setColor(this.resultBitmap != null ? this.resultColor : this.maskColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)frame.top, this.paint);
        canvas.drawRect(0.0f, (float)frame.top, (float)frame.left, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect((float)(frame.right + 1), (float)frame.top, (float)width, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect(0.0f, (float)(frame.bottom + 1), (float)width, (float)height, this.paint);
        if (this.resultBitmap != null) {
            this.paint.setAlpha(160);
            canvas.drawBitmap(this.resultBitmap, null, frame, this.paint);
        } else {
            List<ResultPoint> list;
            this.drawFrameBounds(canvas, frame);
            this.drawStatusText(canvas, frame, width);
            this.drawScanLight(canvas, frame);
            float scaleX = (float)frame.width() / (float)previewFrame.width();
            float scaleY = (float)frame.height() / (float)previewFrame.height();
            List<ResultPoint> currentPossible = this.possibleResultPoints;
            List<ResultPoint> currentLast = this.lastPossibleResultPoints;
            int frameLeft = frame.left;
            int frameTop = frame.top;
            if (currentPossible.isEmpty()) {
                this.lastPossibleResultPoints = null;
            } else {
                this.possibleResultPoints = new ArrayList<ResultPoint>(5);
                this.lastPossibleResultPoints = currentPossible;
                this.paint.setAlpha(160);
                this.paint.setColor(this.resultPointColor);
                list = currentPossible;
                synchronized (list) {
                    for (ResultPoint point : currentPossible) {
                        canvas.drawCircle((float)(frameLeft + (int)(point.getX() * scaleX)), (float)(frameTop + (int)(point.getY() * scaleY)), 6.0f, this.paint);
                    }
                }
            }
            if (currentLast != null) {
                this.paint.setAlpha(80);
                this.paint.setColor(this.resultPointColor);
                list = currentLast;
                synchronized (list) {
                    float radius = 3.0f;
                    for (ResultPoint point : currentLast) {
                        canvas.drawCircle((float)(frameLeft + (int)(point.getX() * scaleX)), (float)(frameTop + (int)(point.getY() * scaleY)), radius, this.paint);
                    }
                }
            }
            this.postInvalidateDelayed(80L, frame.left - 6, frame.top - 6, frame.right + 6, frame.bottom + 6);
        }
    }

    private void drawFrameBounds(Canvas canvas, Rect frame) {
        this.paint.setColor(-1);
        this.paint.setStrokeWidth(2.0f);
        this.paint.setStyle(Paint.Style.STROKE);
        canvas.drawRect(frame, this.paint);
        this.paint.setColor(-16776961);
        this.paint.setStyle(Paint.Style.FILL);
        int corWidth = 15;
        int corLength = 45;
        canvas.drawRect((float)(frame.left - corWidth), (float)frame.top, (float)frame.left, (float)(frame.top + corLength), this.paint);
        canvas.drawRect((float)(frame.left - corWidth), (float)(frame.top - corWidth), (float)(frame.left + corLength), (float)frame.top, this.paint);
        canvas.drawRect((float)frame.right, (float)frame.top, (float)(frame.right + corWidth), (float)(frame.top + corLength), this.paint);
        canvas.drawRect((float)(frame.right - corLength), (float)(frame.top - corWidth), (float)(frame.right + corWidth), (float)frame.top, this.paint);
        canvas.drawRect((float)(frame.left - corWidth), (float)(frame.bottom - corLength), (float)frame.left, (float)frame.bottom, this.paint);
        canvas.drawRect((float)(frame.left - corWidth), (float)frame.bottom, (float)(frame.left + corLength), (float)(frame.bottom + corWidth), this.paint);
        canvas.drawRect((float)frame.right, (float)(frame.bottom - corLength), (float)(frame.right + corWidth), (float)frame.bottom, this.paint);
        canvas.drawRect((float)(frame.right - corLength), (float)frame.bottom, (float)(frame.right + corWidth), (float)(frame.bottom + corWidth), this.paint);
    }

    private void drawStatusText(Canvas canvas, Rect frame, int width) {
        String statusText1 = this.getResources().getString(R.string.viewfinderview_status_text1);
        String statusText2 = this.getResources().getString(R.string.viewfinderview_status_text2);
        int statusTextSize = 45;
        int statusPaddingTop = 180;
        this.paint.setColor(this.statusColor);
        this.paint.setTextSize((float)statusTextSize);
        int textWidth1 = (int)this.paint.measureText(statusText1);
        canvas.drawText(statusText1, (float)((width - textWidth1) / 2), (float)(frame.top - statusPaddingTop), this.paint);
        int textWidth2 = (int)this.paint.measureText(statusText2);
        canvas.drawText(statusText2, (float)((width - textWidth2) / 2), (float)(frame.top - statusPaddingTop + 60), this.paint);
    }

    private void drawFlashlight(Canvas canvas, Rect frame, int width) {
        int left = frame.left + 20;
        int top = frame.bottom + 20;
        this.paint.setColor(this.statusColor);
        BitmapDrawable flashlightDrawable = (BitmapDrawable)this.getResources().getDrawable(R.drawable.flashlight);
        canvas.drawBitmap(flashlightDrawable.getBitmap(), (float)left, (float)top, this.paint);
    }

    private void drawScanLight(Canvas canvas, Rect frame) {
        if (this.scanLineTop == 0) {
            this.scanLineTop = frame.top;
        }
        this.scanLineTop = this.scanLineTop >= frame.bottom ? frame.top : (this.scanLineTop += 10);
        Rect scanRect = new Rect(frame.left, this.scanLineTop, frame.right, this.scanLineTop + 30);
        canvas.drawBitmap(this.scanLight, null, scanRect, this.paint);
    }

    public void drawViewfinder() {
        Bitmap resultBitmap = this.resultBitmap;
        this.resultBitmap = null;
        if (resultBitmap != null) {
            resultBitmap.recycle();
        }
        this.invalidate();
    }

    public void drawResultBitmap(Bitmap barcode) {
        this.resultBitmap = barcode;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPossibleResultPoint(ResultPoint point) {
        List<ResultPoint> points;
        List<ResultPoint> list = points = this.possibleResultPoints;
        synchronized (list) {
            points.add(point);
            int size = points.size();
            if (size > 20) {
                points.subList(0, size - 10).clear();
            }
        }
    }
}

