/*
 * Decompiled with CFR 0.152.
 */
package com.yzq.zxinglibrary.decode;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.yzq.zxinglibrary.android.CaptureActivity;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;

public final class DecodeHandler
extends Handler {
    private static final String TAG = DecodeHandler.class.getSimpleName();
    private final CaptureActivity activity;
    private final MultiFormatReader multiFormatReader = new MultiFormatReader();
    private boolean running = true;

    DecodeHandler(CaptureActivity activity, Map<DecodeHintType, Object> hints) {
        this.multiFormatReader.setHints(hints);
        this.activity = activity;
    }

    public void handleMessage(Message message) {
        if (!this.running) {
            return;
        }
        switch (message.what) {
            case 1: {
                this.decode((byte[])message.obj, message.arg1, message.arg2);
                break;
            }
            case 5: {
                this.running = false;
                Looper.myLooper().quit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode(byte[] data, int width, int height) {
        long start = System.currentTimeMillis();
        Result rawResult = null;
        byte[] rotatedData = new byte[data.length];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                rotatedData[x * height + height - y - 1] = data[x + y * width];
            }
        }
        int tmp = width;
        width = height;
        height = tmp;
        data = rotatedData;
        PlanarYUVLuminanceSource source = this.activity.getCameraManager().buildLuminanceSource(data, width, height);
        if (source != null) {
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            try {
                rawResult = this.multiFormatReader.decodeWithState(bitmap);
            }
            catch (ReaderException readerException) {
            }
            finally {
                this.multiFormatReader.reset();
            }
        }
        Handler handler = this.activity.getHandler();
        if (rawResult != null) {
            long end = System.currentTimeMillis();
            Log.d((String)TAG, (String)("Found barcode in " + (end - start) + " ms"));
            if (handler != null) {
                Message message = Message.obtain((Handler)handler, (int)3, (Object)rawResult);
                Bundle bundle = new Bundle();
                DecodeHandler.bundleThumbnail(source, bundle);
                message.setData(bundle);
                message.sendToTarget();
            }
        } else if (handler != null) {
            Message message = Message.obtain((Handler)handler, (int)2);
            message.sendToTarget();
        }
    }

    private static void bundleThumbnail(PlanarYUVLuminanceSource source, Bundle bundle) {
        int[] pixels = source.renderThumbnail();
        int width = source.getThumbnailWidth();
        int height = source.getThumbnailHeight();
        Bitmap bitmap = Bitmap.createBitmap((int[])pixels, (int)0, (int)width, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)out);
        bundle.putByteArray("barcode_bitmap", out.toByteArray());
        bundle.putFloat("barcode_scaled_factor", (float)width / (float)source.getWidth());
    }
}

