/*
 * Decompiled with CFR 0.152.
 */
package com.yzq.zxinglibrary.camera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Point;
import android.hardware.Camera;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.yzq.zxinglibrary.camera.CameraConfigurationUtils;
import java.lang.reflect.Method;

final class CameraConfigurationManager {
    private static final String TAG = "CameraConfiguration";
    private final Context context;
    private Point screenResolution;
    private Point cameraResolution;

    CameraConfigurationManager(Context context) {
        this.context = context;
    }

    @SuppressLint(value={"NewApi"})
    void initFromCameraParameters(Camera camera) {
        Point theScreenResolution;
        Camera.Parameters parameters = camera.getParameters();
        WindowManager manager = (WindowManager)this.context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        this.screenResolution = theScreenResolution = new Point(display.getWidth(), display.getHeight());
        Log.i((String)TAG, (String)("Screen resolution: " + this.screenResolution));
        Point screenResolutionForCamera = new Point();
        screenResolutionForCamera.x = this.screenResolution.x;
        screenResolutionForCamera.y = this.screenResolution.y;
        if (this.screenResolution.x < this.screenResolution.y) {
            screenResolutionForCamera.x = this.screenResolution.y;
            screenResolutionForCamera.y = this.screenResolution.x;
        }
        this.cameraResolution = CameraConfigurationUtils.findBestPreviewSizeValue(parameters, screenResolutionForCamera);
        Log.i((String)TAG, (String)("Camera resolution: " + this.cameraResolution));
    }

    void setDesiredCameraParameters(Camera camera, boolean safeMode) {
        Camera.Parameters parameters = camera.getParameters();
        if (parameters == null) {
            Log.w((String)TAG, (String)"Device error: no camera parameters are available. Proceeding without configuration.");
            return;
        }
        Log.i((String)TAG, (String)("Initial camera parameters: " + parameters.flatten()));
        if (safeMode) {
            Log.w((String)TAG, (String)"In camera config safe mode -- most settings will not be honored");
        }
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        CameraConfigurationUtils.setFocus(parameters, prefs.getBoolean("preferences_auto_focus", true), prefs.getBoolean("preferences_disable_continuous_focus", true), safeMode);
        parameters.setPreviewSize(this.cameraResolution.x, this.cameraResolution.y);
        this.setDisplayOrientation(camera, 90);
        Log.i((String)TAG, (String)("Final camera parameters: " + parameters.flatten()));
        camera.setParameters(parameters);
        Camera.Parameters afterParameters = camera.getParameters();
        Camera.Size afterSize = afterParameters.getPreviewSize();
        if (afterSize != null && (this.cameraResolution.x != afterSize.width || this.cameraResolution.y != afterSize.height)) {
            Log.w((String)TAG, (String)("Camera said it supported preview size " + this.cameraResolution.x + 'x' + this.cameraResolution.y + ", but after setting it, preview size is " + afterSize.width + 'x' + afterSize.height));
            this.cameraResolution.x = afterSize.width;
            this.cameraResolution.y = afterSize.height;
        }
    }

    void setDisplayOrientation(Camera camera, int angle) {
        try {
            Method method = camera.getClass().getMethod("setDisplayOrientation", Integer.TYPE);
            if (method != null) {
                method.invoke((Object)camera, angle);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    Point getCameraResolution() {
        return this.cameraResolution;
    }

    Point getScreenResolution() {
        return this.screenResolution;
    }
}

