/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuweiguocn.library.greendao;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.StandardDatabase;
import org.greenrobot.greendao.internal.DaoConfig;

public final class MigrationHelper {
    public static boolean DEBUG = false;
    private static String TAG = "MigrationHelper";
    private static final String SQLITE_MASTER = "sqlite_master";
    private static final String SQLITE_TEMP_MASTER = "sqlite_temp_master";
    private static WeakReference<ReCreateAllTableListener> weakListener;

    public static void migrate(SQLiteDatabase db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        MigrationHelper.printLog("\u3010The Old Database Version\u3011" + db.getVersion());
        StandardDatabase database = new StandardDatabase(db);
        MigrationHelper.migrate((Database)database, daoClasses);
    }

    public static void migrate(SQLiteDatabase db, ReCreateAllTableListener listener, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        weakListener = new WeakReference<ReCreateAllTableListener>(listener);
        MigrationHelper.migrate(db, daoClasses);
    }

    public static void migrate(Database database, ReCreateAllTableListener listener, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        weakListener = new WeakReference<ReCreateAllTableListener>(listener);
        MigrationHelper.migrate(database, daoClasses);
    }

    public static void migrate(Database database, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        MigrationHelper.printLog("\u3010Generate temp table\u3011start");
        MigrationHelper.generateTempTables(database, daoClasses);
        MigrationHelper.printLog("\u3010Generate temp table\u3011complete");
        ReCreateAllTableListener listener = null;
        if (weakListener != null) {
            listener = (ReCreateAllTableListener)weakListener.get();
        }
        if (listener != null) {
            listener.onDropAllTables(database, true);
            MigrationHelper.printLog("\u3010Drop all table by listener\u3011");
            listener.onCreateAllTables(database, false);
            MigrationHelper.printLog("\u3010Create all table by listener\u3011");
        } else {
            MigrationHelper.dropAllTables(database, true, daoClasses);
            MigrationHelper.createAllTables(database, false, daoClasses);
        }
        MigrationHelper.printLog("\u3010Restore data\u3011start");
        MigrationHelper.restoreData(database, daoClasses);
        MigrationHelper.printLog("\u3010Restore data\u3011complete");
    }

    private static void generateTempTables(Database db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        for (int i = 0; i < daoClasses.length; ++i) {
            String tempTableName = null;
            DaoConfig daoConfig = new DaoConfig(db, daoClasses[i]);
            String tableName = daoConfig.tablename;
            if (!MigrationHelper.isTableExists(db, false, tableName)) {
                MigrationHelper.printLog("\u3010New Table\u3011" + tableName);
                continue;
            }
            try {
                tempTableName = daoConfig.tablename.concat("_TEMP");
                StringBuilder dropTableStringBuilder = new StringBuilder();
                dropTableStringBuilder.append("DROP TABLE IF EXISTS ").append(tempTableName).append(";");
                db.execSQL(dropTableStringBuilder.toString());
                StringBuilder insertTableStringBuilder = new StringBuilder();
                insertTableStringBuilder.append("CREATE TEMPORARY TABLE ").append(tempTableName);
                insertTableStringBuilder.append(" AS SELECT * FROM ").append(tableName).append(";");
                db.execSQL(insertTableStringBuilder.toString());
                MigrationHelper.printLog("\u3010Table\u3011" + tableName + "\n ---Columns-->" + MigrationHelper.getColumnsStr(daoConfig));
                MigrationHelper.printLog("\u3010Generate temp table\u3011" + tempTableName);
                continue;
            }
            catch (SQLException e) {
                Log.e((String)TAG, (String)("\u3010Failed to generate temp table\u3011" + tempTableName), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTableExists(Database db, boolean isTemp, String tableName) {
        if (db == null || TextUtils.isEmpty((CharSequence)tableName)) {
            return false;
        }
        String dbName = isTemp ? SQLITE_TEMP_MASTER : SQLITE_MASTER;
        String sql = "SELECT COUNT(*) FROM " + dbName + " WHERE type = ? AND name = ?";
        int count = 0;
        try (Cursor cursor = null;){
            cursor = db.rawQuery(sql, new String[]{"table", tableName});
            if (cursor == null || !cursor.moveToFirst()) {
                boolean bl = false;
                return bl;
            }
            count = cursor.getInt(0);
        }
        return count > 0;
    }

    private static String getColumnsStr(DaoConfig daoConfig) {
        if (daoConfig == null) {
            return "no columns";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < daoConfig.allColumns.length; ++i) {
            builder.append(daoConfig.allColumns[i]);
            builder.append(",");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private static void dropAllTables(Database db, boolean ifExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        MigrationHelper.reflectMethod(db, "dropTable", ifExists, daoClasses);
        MigrationHelper.printLog("\u3010Drop all table by reflect\u3011");
    }

    private static void createAllTables(Database db, boolean ifNotExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        MigrationHelper.reflectMethod(db, "createTable", ifNotExists, daoClasses);
        MigrationHelper.printLog("\u3010Create all table by reflect\u3011");
    }

    private static void reflectMethod(Database db, String methodName, boolean isExists, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        if (daoClasses.length < 1) {
            return;
        }
        try {
            for (Class<AbstractDao<?, ?>> clazz : daoClasses) {
                Method method = clazz.getDeclaredMethod(methodName, Database.class, Boolean.TYPE);
                method.invoke(null, db, isExists);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static void restoreData(Database db, Class<? extends AbstractDao<?, ?>> ... daoClasses) {
        for (int i = 0; i < daoClasses.length; ++i) {
            DaoConfig daoConfig = new DaoConfig(db, daoClasses[i]);
            String tableName = daoConfig.tablename;
            String tempTableName = daoConfig.tablename.concat("_TEMP");
            if (!MigrationHelper.isTableExists(db, true, tempTableName)) continue;
            try {
                String column;
                List newTableInfos = TableInfo.getTableInfo(db, tableName);
                List tempTableInfos = TableInfo.getTableInfo(db, tempTableName);
                ArrayList<String> selectColumns = new ArrayList<String>(newTableInfos.size());
                ArrayList<String> intoColumns = new ArrayList<String>(newTableInfos.size());
                for (TableInfo tableInfo : tempTableInfos) {
                    if (!newTableInfos.contains(tableInfo)) continue;
                    column = '`' + tableInfo.name + '`';
                    intoColumns.add(column);
                    selectColumns.add(column);
                }
                for (TableInfo tableInfo : newTableInfos) {
                    if (!tableInfo.notnull || tempTableInfos.contains(tableInfo)) continue;
                    column = '`' + tableInfo.name + '`';
                    intoColumns.add(column);
                    String value = tableInfo.dfltValue != null ? "'" + tableInfo.dfltValue + "' AS " : "'' AS ";
                    selectColumns.add(value + column);
                }
                if (intoColumns.size() != 0) {
                    StringBuilder insertTableStringBuilder = new StringBuilder();
                    insertTableStringBuilder.append("REPLACE INTO ").append(tableName).append(" (");
                    insertTableStringBuilder.append(TextUtils.join((CharSequence)",", intoColumns));
                    insertTableStringBuilder.append(") SELECT ");
                    insertTableStringBuilder.append(TextUtils.join((CharSequence)",", selectColumns));
                    insertTableStringBuilder.append(" FROM ").append(tempTableName).append(";");
                    db.execSQL(insertTableStringBuilder.toString());
                    MigrationHelper.printLog("\u3010Restore data\u3011 to " + tableName);
                }
                StringBuilder dropTableStringBuilder = new StringBuilder();
                dropTableStringBuilder.append("DROP TABLE ").append(tempTableName);
                db.execSQL(dropTableStringBuilder.toString());
                MigrationHelper.printLog("\u3010Drop temp table\u3011" + tempTableName);
                continue;
            }
            catch (SQLException e) {
                Log.e((String)TAG, (String)("\u3010Failed to restore data from temp table \u3011" + tempTableName), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getColumns(Database db, String tableName) {
        List<String> columns;
        block9: {
            columns = null;
            Cursor cursor = null;
            try {
                cursor = db.rawQuery("SELECT * FROM " + tableName + " limit 0", null);
                if (null != cursor && cursor.getColumnCount() > 0) {
                    columns = Arrays.asList(cursor.getColumnNames());
                }
                if (cursor == null) break block9;
            }
            catch (Exception e) {
                block10: {
                    try {
                        e.printStackTrace();
                        if (cursor == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (cursor != null) {
                            cursor.close();
                        }
                        if (null == columns) {
                            columns = new ArrayList<String>();
                        }
                        throw throwable;
                    }
                    cursor.close();
                }
                if (null == columns) {
                    columns = new ArrayList();
                }
            }
            cursor.close();
        }
        if (null == columns) {
            columns = new ArrayList();
        }
        return columns;
    }

    private static void printLog(String info) {
        if (DEBUG) {
            Log.d((String)TAG, (String)info);
        }
    }

    private static class TableInfo {
        int cid;
        String name;
        String type;
        boolean notnull;
        String dfltValue;
        boolean pk;

        private TableInfo() {
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.name.equals(((TableInfo)o).name);
        }

        public String toString() {
            return "TableInfo{cid=" + this.cid + ", name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", notnull=" + this.notnull + ", dfltValue='" + this.dfltValue + '\'' + ", pk=" + this.pk + '}';
        }

        private static List<TableInfo> getTableInfo(Database db, String tableName) {
            String sql = "PRAGMA table_info(" + tableName + ")";
            MigrationHelper.printLog(sql);
            Cursor cursor = db.rawQuery(sql, null);
            if (cursor == null) {
                return new ArrayList<TableInfo>();
            }
            ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
            while (cursor.moveToNext()) {
                TableInfo tableInfo = new TableInfo();
                tableInfo.cid = cursor.getInt(0);
                tableInfo.name = cursor.getString(1);
                tableInfo.type = cursor.getString(2);
                tableInfo.notnull = cursor.getInt(3) == 1;
                tableInfo.dfltValue = cursor.getString(4);
                tableInfo.pk = cursor.getInt(5) == 1;
                tableInfos.add(tableInfo);
            }
            cursor.close();
            return tableInfos;
        }
    }

    public static interface ReCreateAllTableListener {
        public void onCreateAllTables(Database var1, boolean var2);

        public void onDropAllTables(Database var1, boolean var2);
    }
}

