/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.support.annotation.NonNull;
import com.budiyev.android.codescanner.DecodeCallback;
import com.budiyev.android.codescanner.Point;
import com.budiyev.android.codescanner.Rect;
import com.budiyev.android.codescanner.Utils;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;

final class DecodeTask {
    private final byte[] mImage;
    private final Point mImageSize;
    private final Point mPreviewSize;
    private final Point mViewSize;
    private final int mOrientation;
    private final boolean mSquareFrame;
    private final boolean mReverseHorizontal;
    private final DecodeCallback mCallback;

    public DecodeTask(@NonNull byte[] image, @NonNull Point imageSize, @NonNull Point previewSize, @NonNull Point viewSize, int orientation, boolean squareFrame, boolean reverseHorizontal, @NonNull DecodeCallback callback) {
        this.mImage = image;
        this.mImageSize = imageSize;
        this.mPreviewSize = previewSize;
        this.mViewSize = viewSize;
        this.mOrientation = orientation;
        this.mSquareFrame = squareFrame;
        this.mReverseHorizontal = reverseHorizontal;
        this.mCallback = callback;
    }

    @NonNull
    public DecodeCallback getCallback() {
        return this.mCallback;
    }

    @NonNull
    public Result decode(@NonNull MultiFormatReader reader) throws ReaderException {
        int height;
        int width;
        byte[] image;
        int imageWidth = this.mImageSize.getX();
        int imageHeight = this.mImageSize.getY();
        if (this.mOrientation == 0) {
            image = this.mImage;
            width = imageWidth;
            height = imageHeight;
        } else {
            image = Utils.rotateNV21(this.mImage, imageWidth, imageHeight, this.mOrientation);
            if (this.mOrientation == 90 || this.mOrientation == 270) {
                width = imageHeight;
                height = imageWidth;
            } else {
                width = imageWidth;
                height = imageHeight;
            }
        }
        Rect frameRect = Utils.getImageFrameRect(this.mSquareFrame, width, height, this.mPreviewSize, this.mViewSize);
        return reader.decodeWithState(new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new PlanarYUVLuminanceSource(image, width, height, frameRect.getLeft(), frameRect.getTop(), frameRect.getWidth(), frameRect.getHeight(), this.mReverseHorizontal))));
    }
}

