/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import com.budiyev.android.codescanner.R;
import com.budiyev.android.codescanner.ViewFinderView;

public final class CodeScannerView
extends ViewGroup {
    private static final boolean DEFAULT_SQUARE_FRAME = false;
    private static final int DEFAULT_MASK_COLOR = 0x77000000;
    private static final int DEFAULT_FRAME_COLOR = -1;
    private static final float DEFAULT_FRAME_WIDTH_DP = 2.0f;
    private static final float DEFAULT_FRAME_CORNER_SIZE_DP = 50.0f;
    private SurfaceView mPreviewView;
    private ViewFinderView mViewFinderView;
    private Point mFrameSize;
    private LayoutListener mLayoutListener;

    public CodeScannerView(@NonNull Context context) {
        super(context);
        this.initialize(context, null);
    }

    public CodeScannerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs);
    }

    public CodeScannerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this.mPreviewView = new SurfaceView(context);
        this.mPreviewView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mViewFinderView = new ViewFinderView(context);
        this.mViewFinderView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (attributeSet == null) {
            this.mViewFinderView.setSquareFrame(false);
            this.mViewFinderView.setMaskColor(0x77000000);
            this.mViewFinderView.setFrameColor(-1);
            this.mViewFinderView.setFrameWidth(Math.round(2.0f * displayMetrics.density));
            this.mViewFinderView.setFrameCornersSize(Math.round(50.0f * displayMetrics.density));
        } else {
            TypedArray attributes = null;
            try {
                attributes = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.CodeScannerView, 0, 0);
                this.mViewFinderView.setSquareFrame(attributes.getBoolean(R.styleable.CodeScannerView_squareFrame, false));
                this.mViewFinderView.setMaskColor(attributes.getColor(R.styleable.CodeScannerView_maskColor, 0x77000000));
                this.mViewFinderView.setFrameColor(attributes.getColor(R.styleable.CodeScannerView_frameColor, -1));
                this.mViewFinderView.setFrameWidth(attributes.getDimensionPixelSize(R.styleable.CodeScannerView_frameWidth, Math.round(2.0f * displayMetrics.density)));
                this.mViewFinderView.setFrameCornersSize(attributes.getDimensionPixelSize(R.styleable.CodeScannerView_frameCornersSize, Math.round(50.0f * displayMetrics.density)));
            }
            finally {
                if (attributes != null) {
                    attributes.recycle();
                }
            }
        }
        this.addView((View)this.mPreviewView);
        this.addView(this.mViewFinderView);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int width = right - left;
        int height = bottom - top;
        Point frameSize = this.mFrameSize;
        if (frameSize == null) {
            this.mPreviewView.layout(left, top, right, bottom);
        } else {
            int d;
            int frameLeft = left;
            int frameTop = top;
            int frameRight = right;
            int frameBottom = bottom;
            if (frameSize.x > width) {
                d = (frameSize.x - width) / 2;
                frameLeft -= d;
                frameRight += d;
            }
            if (frameSize.y > height) {
                d = (frameSize.y - height) / 2;
                frameTop -= d;
                frameBottom += d;
            }
            this.mPreviewView.layout(frameLeft, frameTop, frameRight, frameBottom);
        }
        this.mViewFinderView.layout(left, top, right, bottom);
        LayoutListener listener = this.mLayoutListener;
        if (listener != null) {
            listener.onLayout(width, height);
        }
    }

    public void setSquareFrame(boolean squareFrame) {
        this.mViewFinderView.setSquareFrame(squareFrame);
    }

    public void setMaskColor(@ColorInt int color) {
        this.mViewFinderView.setMaskColor(color);
    }

    public void setFrameColor(@ColorInt int color) {
        this.mViewFinderView.setFrameColor(color);
    }

    public void setFrameWidth(@Px int width) {
        this.mViewFinderView.setFrameWidth(width);
    }

    public void setFrameCornersSize(@Px int size) {
        this.mViewFinderView.setFrameCornersSize(size);
    }

    boolean isSquareFrame() {
        return this.mViewFinderView.isSquareFrame();
    }

    SurfaceView getPreviewView() {
        return this.mPreviewView;
    }

    ViewFinderView getViewFinderView() {
        return this.mViewFinderView;
    }

    void setFrameSize(@Nullable Point frameSize) {
        this.mFrameSize = frameSize;
        this.requestLayout();
    }

    void setLayoutListener(@Nullable LayoutListener layoutListener) {
        this.mLayoutListener = layoutListener;
    }

    static interface LayoutListener {
        public void onLayout(int var1, int var2);
    }
}

