/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.os.Process;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.budiyev.android.codescanner.DecodeCallback;
import com.budiyev.android.codescanner.DecodeTask;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

final class Decoder {
    private final MultiFormatReader mReader;
    private final DecoderThread mDecoderThread;
    private final StateListener mStateListener;
    private final Map<DecodeHintType, Object> mHints;
    private final Object mTaskLock = new Object();
    private volatile DecodeCallback mCallback;
    private volatile DecodeTask mTask;
    private volatile State mState;

    public Decoder(@NonNull StateListener stateListener, @NonNull Thread.UncaughtExceptionHandler exceptionHandler, @NonNull List<BarcodeFormat> formats, @Nullable DecodeCallback callback) {
        this.mReader = new MultiFormatReader();
        this.mDecoderThread = new DecoderThread();
        this.mDecoderThread.setUncaughtExceptionHandler(exceptionHandler);
        this.mHints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        this.mHints.put(DecodeHintType.POSSIBLE_FORMATS, formats);
        this.mReader.setHints(this.mHints);
        this.mCallback = callback;
        this.mStateListener = stateListener;
        this.mState = State.INITIALIZED;
    }

    public void setFormats(@NonNull List<BarcodeFormat> formats) {
        this.mHints.put(DecodeHintType.POSSIBLE_FORMATS, formats);
        this.mReader.setHints(this.mHints);
    }

    public void setCallback(@Nullable DecodeCallback callback) {
        this.mCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(@NonNull DecodeTask task) {
        Object object = this.mTaskLock;
        synchronized (object) {
            if (this.mState != State.STOPPED) {
                this.mTask = task;
                this.mTaskLock.notify();
            }
        }
    }

    public void start() {
        if (this.mState != State.INITIALIZED) {
            throw new IllegalStateException("Illegal decoder state");
        }
        this.mDecoderThread.start();
    }

    public void shutdown() {
        this.mDecoderThread.interrupt();
        this.mTask = null;
    }

    @NonNull
    public State getState() {
        return this.mState;
    }

    private boolean setState(@NonNull State state) {
        this.mState = state;
        return this.mStateListener.onStateChanged(state);
    }

    public static enum State {
        INITIALIZED,
        IDLE,
        DECODING,
        DECODED,
        STOPPED;

    }

    public static interface StateListener {
        public boolean onStateChanged(@NonNull State var1);
    }

    private final class DecoderThread
    extends Thread {
        public DecoderThread() {
            super("cs-decoder");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            while (true) {
                Decoder.this.setState(State.IDLE);
                Result result = null;
                try {
                    DecodeTask task;
                    while (true) {
                        Object object = Decoder.this.mTaskLock;
                        synchronized (object) {
                            DecodeTask t = Decoder.this.mTask;
                            if (t != null) {
                                Decoder.this.mTask = null;
                                task = t;
                                break;
                            }
                            try {
                                Decoder.this.mTaskLock.wait();
                            }
                            catch (InterruptedException e) {
                                Decoder.this.setState(State.STOPPED);
                                // MONITOREXIT @DISABLED, blocks:[0, 5, 6, 9, 10] lbl23 : MonitorExitStatement: MONITOREXIT : var3_4
                                if (result == null) return;
                                Decoder.this.mTask = null;
                                if (!Decoder.this.setState(State.DECODED)) return;
                                DecodeCallback callback = Decoder.this.mCallback;
                                if (callback == null) return;
                                callback.onDecoded(result);
                                return;
                            }
                        }
                    }
                    Decoder.this.setState(State.DECODING);
                    result = task.decode(Decoder.this.mReader);
                    if (result == null) continue;
                }
                catch (ReaderException callback) {
                    if (result == null) continue;
                    Decoder.this.mTask = null;
                    if (!Decoder.this.setState(State.DECODED) || (callback = Decoder.this.mCallback) == null) continue;
                    callback.onDecoded(result);
                    continue;
                }
                catch (Throwable throwable) {
                    if (result == null) throw throwable;
                    Decoder.this.mTask = null;
                    if (!Decoder.this.setState(State.DECODED)) throw throwable;
                    DecodeCallback callback = Decoder.this.mCallback;
                    if (callback == null) throw throwable;
                    callback.onDecoded(result);
                    throw throwable;
                }
                Decoder.this.mTask = null;
                if (!Decoder.this.setState(State.DECODED) || (callback = Decoder.this.mCallback) == null) continue;
                callback.onDecoded(result);
                continue;
                break;
            }
        }
    }
}

