/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.circularprogressbar;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.budiyev.android.circularprogressbar.R;

public class CircularProgressBar
extends View {
    private static final float DEFAULT_MAXIMUM = 100.0f;
    private static final float DEFAULT_PROGRESS = 0.0f;
    private static final float DEFAULT_FOREGROUND_STROKE_WIDTH_DP = 3.0f;
    private static final float DEFAULT_BACKGROUND_STROKE_WIDTH_DP = 1.0f;
    private static final float DEFAULT_START_ANGLE = 270.0f;
    private static final float DEFAULT_INDETERMINATE_MINIMUM_ANGLE = 60.0f;
    private static final int DEFAULT_FOREGROUND_STROKE_COLOR = -16776961;
    private static final int DEFAULT_BACKGROUND_STROKE_COLOR = -16777216;
    private static final int DEFAULT_PROGRESS_ANIMATION_DURATION = 100;
    private static final int DEFAULT_INDETERMINATE_ROTATION_ANIMATION_DURATION = 1200;
    private static final int DEFAULT_INDETERMINATE_ARC_ANIMATION_DURATION = 600;
    private static final boolean DEFAULT_ANIMATE_PROGRESS = true;
    private static final boolean DEFAULT_DRAW_BACKGROUND_STROKE = true;
    private static final boolean DEFAULT_INDETERMINATE = false;
    private final Runnable mSweepRestartAction = new SweepRestartAction();
    private float mMaximum;
    private float mProgress;
    private float mStartAngle;
    private float mIndeterminateStartAngle;
    private float mIndeterminateSweepAngle;
    private float mIndeterminateOffsetAngle;
    private float mIndeterminateMinimumAngle;
    private boolean mIndeterminate;
    private boolean mAnimateProgress;
    private boolean mDrawBackgroundStroke;
    private boolean mIndeterminateGrowMode;
    private Paint mForegroundStrokePaint;
    private Paint mBackgroundStrokePaint;
    private RectF mDrawRect;
    private ValueAnimator mProgressAnimator;
    private ValueAnimator mIndeterminateStartAnimator;
    private ValueAnimator mIndeterminateSweepAnimator;

    public CircularProgressBar(@NonNull Context context) {
        super(context);
        this.initialize(context, null, 0, 0);
    }

    public CircularProgressBar(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs, 0, 0);
    }

    public CircularProgressBar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public CircularProgressBar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(context, attrs, defStyleAttr, defStyleRes);
    }

    public float getProgress() {
        return this.mProgress;
    }

    @MainThread
    public void setProgress(float progress) {
        if (this.mIndeterminate) {
            this.mProgress = progress;
        } else {
            this.stopProgressAnimation();
            if (this.mAnimateProgress && this.isLaidOutCompat()) {
                this.setProgressAnimated(progress);
            } else {
                this.setProgressInternal(progress);
            }
        }
    }

    @NonNull
    @MainThread
    public Configurator configure() {
        return new Configurator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(@NonNull Context context, @Nullable AttributeSet attributeSet, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        this.mDrawRect = new RectF();
        this.mForegroundStrokePaint = new Paint(1);
        this.mBackgroundStrokePaint = new Paint(1);
        this.mForegroundStrokePaint.setStyle(Paint.Style.STROKE);
        this.mBackgroundStrokePaint.setStyle(Paint.Style.STROKE);
        this.mProgressAnimator = new ValueAnimator();
        this.mIndeterminateStartAnimator = new ValueAnimator();
        this.mIndeterminateSweepAnimator = new ValueAnimator();
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (attributeSet == null) {
            this.mMaximum = 100.0f;
            this.mProgress = 0.0f;
            this.mStartAngle = 270.0f;
            this.mIndeterminateMinimumAngle = 60.0f;
            this.mProgressAnimator.setDuration(100L);
            this.mIndeterminate = false;
            this.mAnimateProgress = true;
            this.mDrawBackgroundStroke = true;
            this.mForegroundStrokePaint.setColor(-16776961);
            this.mForegroundStrokePaint.setStrokeWidth((float)Math.round(3.0f * displayMetrics.density));
            this.mBackgroundStrokePaint.setColor(-16777216);
            this.mBackgroundStrokePaint.setStrokeWidth((float)Math.round(1.0f * displayMetrics.density));
            this.mIndeterminateStartAnimator.setDuration(1200L);
            this.mIndeterminateSweepAnimator.setDuration(600L);
        } else {
            TypedArray attributes = null;
            try {
                attributes = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.CircularProgressBar, defStyleAttr, defStyleRes);
                this.mMaximum = attributes.getFloat(R.styleable.CircularProgressBar_maximum, 100.0f);
                this.mProgress = attributes.getFloat(R.styleable.CircularProgressBar_progress, 0.0f);
                this.mStartAngle = attributes.getFloat(R.styleable.CircularProgressBar_startAngle, 270.0f);
                this.mIndeterminateMinimumAngle = attributes.getFloat(R.styleable.CircularProgressBar_indeterminateMinimumAngle, 60.0f);
                this.mProgressAnimator.setDuration((long)attributes.getInteger(R.styleable.CircularProgressBar_progressAnimationDuration, 100));
                this.mIndeterminateStartAnimator.setDuration((long)attributes.getInteger(R.styleable.CircularProgressBar_indeterminateRotationAnimationDuration, 1200));
                this.mIndeterminateSweepAnimator.setDuration((long)attributes.getInteger(R.styleable.CircularProgressBar_indeterminateArcAnimationDuration, 600));
                this.mForegroundStrokePaint.setColor(attributes.getColor(R.styleable.CircularProgressBar_foregroundStrokeColor, -16776961));
                this.mBackgroundStrokePaint.setColor(attributes.getColor(R.styleable.CircularProgressBar_backgroundStrokeColor, -16777216));
                this.mForegroundStrokePaint.setStrokeWidth((float)attributes.getDimensionPixelSize(R.styleable.CircularProgressBar_foregroundStrokeWidth, Math.round(3.0f * displayMetrics.density)));
                this.mBackgroundStrokePaint.setStrokeWidth((float)attributes.getDimensionPixelSize(R.styleable.CircularProgressBar_backgroundStrokeWidth, Math.round(1.0f * displayMetrics.density)));
                this.mAnimateProgress = attributes.getBoolean(R.styleable.CircularProgressBar_animateProgress, true);
                this.mDrawBackgroundStroke = attributes.getBoolean(R.styleable.CircularProgressBar_drawBackgroundStroke, true);
                this.mIndeterminate = attributes.getBoolean(R.styleable.CircularProgressBar_indeterminate, false);
            }
            finally {
                if (attributes != null) {
                    attributes.recycle();
                }
            }
        }
        this.mProgressAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.mProgressAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new ProgressUpdateListener());
        this.mIndeterminateStartAnimator.setFloatValues(new float[]{360.0f});
        this.mIndeterminateStartAnimator.setRepeatMode(1);
        this.mIndeterminateStartAnimator.setRepeatCount(-1);
        this.mIndeterminateStartAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mIndeterminateStartAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new StartUpdateListener());
        this.mIndeterminateSweepAnimator.setFloatValues(new float[]{360.0f - this.mIndeterminateMinimumAngle * 2.0f});
        this.mIndeterminateSweepAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.mIndeterminateSweepAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new SweepUpdateListener());
        this.mIndeterminateSweepAnimator.addListener((Animator.AnimatorListener)new SweepAnimatorListener());
    }

    private boolean isLaidOutCompat() {
        return this.getWidth() > 0 && this.getHeight() > 0;
    }

    private void invalidateDrawRect() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width > 0 && height > 0) {
            this.invalidateDrawRect(width, height);
        }
    }

    private void invalidateDrawRect(int width, int height) {
        float thickness = this.mDrawBackgroundStroke ? Math.max(this.mForegroundStrokePaint.getStrokeWidth(), this.mBackgroundStrokePaint.getStrokeWidth()) : this.mForegroundStrokePaint.getStrokeWidth();
        if (width > height) {
            float offset = (float)(width - height) / 2.0f;
            this.mDrawRect.set(offset + thickness / 2.0f + 1.0f, thickness / 2.0f + 1.0f, (float)width - offset - thickness / 2.0f - 1.0f, (float)height - thickness / 2.0f - 1.0f);
        } else if (width < height) {
            float offset = (float)(height - width) / 2.0f;
            this.mDrawRect.set(thickness / 2.0f + 1.0f, offset + thickness / 2.0f + 1.0f, (float)width - thickness / 2.0f - 1.0f, (float)height - offset - thickness / 2.0f - 1.0f);
        } else {
            this.mDrawRect.set(thickness / 2.0f + 1.0f, thickness / 2.0f + 1.0f, (float)width - thickness / 2.0f - 1.0f, (float)height - thickness / 2.0f - 1.0f);
        }
    }

    private void setProgressInternal(float progress) {
        this.mProgress = progress;
        this.invalidate();
    }

    private void setProgressAnimated(float progress) {
        this.mProgressAnimator.setFloatValues(new float[]{this.mProgress, progress});
        this.mProgressAnimator.start();
    }

    private void stopProgressAnimation() {
        if (this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
        }
    }

    private void stopIndeterminateAnimations() {
        if (this.mIndeterminateStartAnimator.isRunning()) {
            this.mIndeterminateStartAnimator.cancel();
        }
        if (this.mIndeterminateSweepAnimator.isRunning()) {
            this.mIndeterminateSweepAnimator.cancel();
        }
    }

    private void startIndeterminateAnimations() {
        if (!this.mIndeterminateStartAnimator.isRunning()) {
            this.mIndeterminateStartAnimator.start();
        }
        if (!this.mIndeterminateSweepAnimator.isRunning()) {
            this.mIndeterminateSweepAnimator.start();
        }
    }

    protected void onDraw(Canvas canvas) {
        float sweep;
        float start;
        if (this.mDrawBackgroundStroke) {
            canvas.drawOval(this.mDrawRect, this.mBackgroundStrokePaint);
        }
        if (this.mIndeterminate) {
            float startAngle = this.mIndeterminateStartAngle;
            float sweepAngle = this.mIndeterminateSweepAngle;
            float offsetAngle = this.mIndeterminateOffsetAngle;
            float minimumAngle = this.mIndeterminateMinimumAngle;
            if (this.mIndeterminateGrowMode) {
                start = startAngle - offsetAngle;
                sweep = sweepAngle + minimumAngle;
            } else {
                start = startAngle + sweepAngle - offsetAngle;
                sweep = 360.0f - sweepAngle - minimumAngle;
            }
        } else {
            float maximum = this.mMaximum;
            float progress = this.mProgress;
            start = this.mStartAngle;
            sweep = Math.abs(progress) < Math.abs(maximum) ? progress / maximum * 360.0f : 360.0f;
        }
        canvas.drawArc(this.mDrawRect, start, sweep, false, this.mForegroundStrokePaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = CircularProgressBar.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int height = CircularProgressBar.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        this.invalidateDrawRect(width, height);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        this.invalidateDrawRect(width, height);
    }

    public void onVisibilityAggregated(boolean visible) {
        super.onVisibilityAggregated(visible);
        if (this.mIndeterminate) {
            if (visible) {
                this.startIndeterminateAnimations();
            } else {
                this.stopIndeterminateAnimations();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mIndeterminate) {
            this.startIndeterminateAnimations();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopIndeterminateAnimations();
        this.stopProgressAnimation();
    }

    private final class SweepRestartAction
    implements Runnable {
        private SweepRestartAction() {
        }

        @Override
        public void run() {
            CircularProgressBar.this.mIndeterminateGrowMode = !CircularProgressBar.this.mIndeterminateGrowMode;
            if (CircularProgressBar.this.mIndeterminateGrowMode) {
                CircularProgressBar.this.mIndeterminateOffsetAngle = (CircularProgressBar.this.mIndeterminateOffsetAngle + CircularProgressBar.this.mIndeterminateMinimumAngle * 2.0f) % 360.0f;
            }
            if (CircularProgressBar.this.mIndeterminateSweepAnimator.isRunning()) {
                CircularProgressBar.this.mIndeterminateSweepAnimator.cancel();
            }
            CircularProgressBar.this.mIndeterminateSweepAnimator.start();
        }
    }

    private final class SweepAnimatorListener
    implements Animator.AnimatorListener {
        private boolean mCancelled;

        private SweepAnimatorListener() {
        }

        public void onAnimationStart(Animator animation) {
            this.mCancelled = false;
        }

        public void onAnimationEnd(Animator animation) {
            if (!this.mCancelled) {
                CircularProgressBar.this.post(CircularProgressBar.this.mSweepRestartAction);
            }
        }

        public void onAnimationCancel(Animator animation) {
            this.mCancelled = true;
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    private final class SweepUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private SweepUpdateListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            CircularProgressBar.this.mIndeterminateSweepAngle = ((Float)animation.getAnimatedValue()).floatValue();
        }
    }

    private final class StartUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private StartUpdateListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            CircularProgressBar.this.mIndeterminateStartAngle = ((Float)animation.getAnimatedValue()).floatValue();
            CircularProgressBar.this.invalidate();
        }
    }

    private final class ProgressUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private ProgressUpdateListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            CircularProgressBar.this.setProgressInternal(((Float)animation.getAnimatedValue()).floatValue());
        }
    }

    public final class Configurator {
        private long progressAnimationDuration;
        private long indeterminateRotationAnimationDuration;
        private long indeterminateArcAnimationDuration;
        private float maximum;
        private float progress;
        private float startAngle;
        private float indeterminateMinimumAngle;
        private float foregroundStrokeWidth;
        private float backgroundStrokeWidth;
        private int foregroundStrokeColor;
        private int backgroundStrokeColor;
        private boolean indeterminate;
        private boolean animateProgress;
        private boolean drawBackgroundStroke;

        private Configurator() {
            this.progressAnimationDuration = CircularProgressBar.this.mProgressAnimator.getDuration();
            this.indeterminateRotationAnimationDuration = CircularProgressBar.this.mIndeterminateStartAnimator.getDuration();
            this.indeterminateArcAnimationDuration = CircularProgressBar.this.mIndeterminateSweepAnimator.getDuration();
            this.maximum = CircularProgressBar.this.mMaximum;
            this.progress = CircularProgressBar.this.mProgress;
            this.startAngle = CircularProgressBar.this.mStartAngle;
            this.indeterminateMinimumAngle = CircularProgressBar.this.mIndeterminateMinimumAngle;
            this.indeterminate = CircularProgressBar.this.mIndeterminate;
            this.animateProgress = CircularProgressBar.this.mAnimateProgress;
            this.drawBackgroundStroke = CircularProgressBar.this.mDrawBackgroundStroke;
            Paint foregroundStrokePaint = CircularProgressBar.this.mForegroundStrokePaint;
            Paint backgroundStrokePaint = CircularProgressBar.this.mBackgroundStrokePaint;
            this.foregroundStrokeColor = foregroundStrokePaint.getColor();
            this.backgroundStrokeColor = backgroundStrokePaint.getColor();
            this.foregroundStrokeWidth = foregroundStrokePaint.getStrokeWidth();
            this.backgroundStrokeWidth = backgroundStrokePaint.getStrokeWidth();
        }

        @MainThread
        public void apply() {
            boolean indeterminateChanged;
            CircularProgressBar.this.stopProgressAnimation();
            boolean bl = indeterminateChanged = this.indeterminate != CircularProgressBar.this.mIndeterminate;
            if (indeterminateChanged && !this.indeterminate) {
                CircularProgressBar.this.stopIndeterminateAnimations();
            }
            CircularProgressBar.this.mIndeterminate = this.indeterminate;
            CircularProgressBar.this.mMaximum = this.maximum;
            CircularProgressBar.this.mAnimateProgress = this.animateProgress;
            CircularProgressBar.this.mProgressAnimator.setDuration(this.progressAnimationDuration);
            CircularProgressBar.this.mIndeterminateStartAnimator.setDuration(this.indeterminateRotationAnimationDuration);
            CircularProgressBar.this.mIndeterminateSweepAnimator.setDuration(this.indeterminateArcAnimationDuration);
            CircularProgressBar.this.mIndeterminateSweepAnimator.setFloatValues(new float[]{360.0f - this.indeterminateMinimumAngle * 2.0f});
            Paint foregroundStrokePaint = CircularProgressBar.this.mForegroundStrokePaint;
            Paint backgroundStrokePaint = CircularProgressBar.this.mBackgroundStrokePaint;
            foregroundStrokePaint.setColor(this.foregroundStrokeColor);
            backgroundStrokePaint.setColor(this.backgroundStrokeColor);
            foregroundStrokePaint.setStrokeWidth(this.foregroundStrokeWidth);
            backgroundStrokePaint.setStrokeWidth(this.backgroundStrokeWidth);
            CircularProgressBar.this.mStartAngle = this.startAngle;
            CircularProgressBar.this.mIndeterminateMinimumAngle = this.indeterminateMinimumAngle;
            CircularProgressBar.this.mDrawBackgroundStroke = this.drawBackgroundStroke;
            CircularProgressBar.this.invalidateDrawRect();
            if (this.indeterminate) {
                CircularProgressBar.this.mProgress = this.progress;
            } else if (this.animateProgress && CircularProgressBar.this.isLaidOutCompat()) {
                CircularProgressBar.this.setProgressAnimated(this.progress);
            } else {
                CircularProgressBar.this.setProgressInternal(this.progress);
            }
            if (indeterminateChanged && this.indeterminate) {
                CircularProgressBar.this.startIndeterminateAnimations();
            }
            CircularProgressBar.this.invalidate();
        }

        @NonNull
        public Configurator maximum(float value) {
            this.maximum = value;
            return this;
        }

        @NonNull
        public Configurator progress(float value) {
            this.progress = value;
            return this;
        }

        @NonNull
        public Configurator startAngle(float value) {
            this.startAngle = value;
            return this;
        }

        @NonNull
        public Configurator indeterminateMinimumAngle(float value) {
            this.indeterminateMinimumAngle = value;
            return this;
        }

        public void indeterminateRotationAnimationDuration(long value) {
            this.indeterminateRotationAnimationDuration = value;
        }

        public void indeterminateArcAnimationDuration(long value) {
            this.indeterminateArcAnimationDuration = value;
        }

        @NonNull
        public Configurator indeterminate(boolean value) {
            this.indeterminate = value;
            return this;
        }

        @NonNull
        public Configurator animateProgress(boolean value) {
            this.animateProgress = value;
            return this;
        }

        @NonNull
        public Configurator progressAnimationDuration(long value) {
            this.progressAnimationDuration = value;
            return this;
        }

        @NonNull
        public Configurator drawBackgroundStroke(boolean value) {
            this.drawBackgroundStroke = value;
            return this;
        }

        @NonNull
        public Configurator foregroundStrokeColor(@ColorInt int value) {
            this.foregroundStrokeColor = value;
            return this;
        }

        @NonNull
        public Configurator backgroundStrokeColor(@ColorInt int value) {
            this.backgroundStrokeColor = value;
            return this;
        }

        @NonNull
        public Configurator foregroundStrokeWidth(@Px int value) {
            this.foregroundStrokeWidth = value;
            return this;
        }

        @NonNull
        public Configurator backgroundStrokeWidth(@Px int value) {
            this.backgroundStrokeWidth = value;
            return this;
        }
    }
}

