/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.toolkit;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class TableHelper {
    private static final Map<Class<?>, TableInfo> TABLE_INFO_CACHE = new ConcurrentHashMap();

    public static void init(Class<?> newClass, Class<?> oldClass) {
        TableInfo oldInfo;
        TableInfo info;
        if (Objects.nonNull(newClass) && Objects.isNull(info = TableInfoHelper.getTableInfo(newClass)) && Objects.nonNull(oldClass) && Objects.nonNull(oldInfo = TableInfoHelper.getTableInfo(oldClass))) {
            TABLE_INFO_CACHE.put(newClass, oldInfo);
        }
    }

    public static TableInfo get(Class<?> clazz) {
        if (Objects.nonNull(clazz)) {
            Class<?> currentClass;
            TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
            if (Objects.nonNull(tableInfo)) {
                return tableInfo;
            }
            TableInfo info = TABLE_INFO_CACHE.get(clazz);
            for (currentClass = clazz; Object.class != currentClass; currentClass = currentClass.getSuperclass()) {
                info = TABLE_INFO_CACHE.get(ClassUtils.getUserClass(currentClass));
            }
            if (Objects.nonNull(info)) {
                TABLE_INFO_CACHE.put(currentClass, info);
            }
            return info;
        }
        return null;
    }
}

