/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.toolkit;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TableList {
    private List<Node> all = new ArrayList<Node>();
    private Class<?> rootClass;
    private String alias;
    private List<Node> child = new ArrayList<Node>();

    public void put(Integer pIndex, Class<?> clazz, boolean hasAlias, String alias, int index) {
        Node n = new Node(clazz, hasAlias, alias, pIndex, index);
        this.all.add(n);
        if (Objects.isNull(pIndex)) {
            this.child.add(n);
        } else {
            Node node = this.getByIndex(pIndex);
            node.put(n);
        }
    }

    public String getPrefix(Integer index, Class<?> clazz, boolean isLabel) {
        if (Objects.isNull(index)) {
            if (!isLabel && this.rootClass == clazz) {
                return this.alias;
            }
            Node node = this.getByClassFirst(clazz);
            if (Objects.isNull(node)) {
                return this.alias;
            }
            return node.isHasAlias() ? node.getAlias() : node.getAlias() + node.getIndex();
        }
        Node node = this.getByIndex(index);
        if (node.getClazz() != clazz) {
            Node dg = this.dg(node, clazz);
            if (Objects.nonNull(dg)) {
                node = dg;
            } else {
                if (this.rootClass != clazz) {
                    List<Node> list = this.getByClass(clazz);
                    for (int i = list.size() - 1; i >= 0; --i) {
                        Node n = list.get(i);
                        if (n.getClazz() != clazz) continue;
                        return n.hasAlias ? n.getAlias() : n.getAlias() + n.getIndex();
                    }
                }
                return this.alias;
            }
        }
        if (node.hasAlias) {
            return node.getAlias();
        }
        return node.getAlias() + node.getIndex();
    }

    public String getPrefixOther(Integer index, Class<?> clazz) {
        if (Objects.isNull(index)) {
            List<Node> list = this.getByClass(clazz);
            if (list.size() == 1 && list.get(0).getClazz() == clazz) {
                return this.alias;
            }
            if (list.size() > 1) {
                for (Node n : list) {
                    if (n.getClazz() != clazz) continue;
                    return n.isHasAlias() ? n.getAlias() : n.getAlias() + n.getIndex();
                }
                return this.alias;
            }
            return this.alias;
        }
        Node node = this.getByIndex(index);
        Node dg = this.dg(node, node.getClazz());
        if (Objects.nonNull(dg)) {
            return dg.hasAlias ? dg.alias : dg.alias + dg.getIndex();
        }
        if (Objects.equals(this.rootClass, node.getClazz())) {
            return this.alias;
        }
        List<Node> list = this.getByClass(node.getClazz());
        if (list.size() == 1) {
            Node n = list.get(0);
            if (n.getClazz() == node.getClazz()) {
                return this.alias;
            }
            return n.isHasAlias() ? n.getAlias() : n.getAlias() + n.getIndex();
        }
        if (list.size() > 1) {
            for (Node n : list) {
                if (n.getIndex() == node.getIndex()) continue;
                return n.isHasAlias() ? n.getAlias() : n.getAlias() + n.getIndex();
            }
            return this.alias;
        }
        return this.alias;
    }

    private Node dg(Node node, Class<?> clazz) {
        if (Objects.isNull(node.getPIndex())) {
            return null;
        }
        Node pNode = this.getByIndex(node.getPIndex());
        if (pNode.getClazz() == clazz) {
            return pNode;
        }
        return this.dg(pNode, clazz);
    }

    public String getPrefixByClass(Class<?> clazz) {
        Node node = this.getByClassFirst(clazz);
        if (Objects.isNull(node)) {
            return this.alias;
        }
        return node.hasAlias ? node.getAlias() : node.getAlias() + node.getIndex();
    }

    private Node getByIndex(int index) {
        return this.all.stream().filter(i -> i.getIndex() == index).findFirst().orElse(null);
    }

    private Node getByClassFirst(Class<?> clazz) {
        return this.all.stream().filter(i -> i.getClazz() == clazz).findFirst().orElse(null);
    }

    private List<Node> getByClass(Class<?> clazz) {
        return this.all.stream().filter(i -> i.getClazz() == clazz).collect(Collectors.toList());
    }

    public void clear() {
        this.all.clear();
        this.child.clear();
    }

    public List<Node> getAll() {
        return this.all;
    }

    public Class<?> getRootClass() {
        return this.rootClass;
    }

    public String getAlias() {
        return this.alias;
    }

    public List<Node> getChild() {
        return this.child;
    }

    public void setAll(List<Node> all) {
        this.all = all;
    }

    public void setRootClass(Class<?> rootClass) {
        this.rootClass = rootClass;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setChild(List<Node> child) {
        this.child = child;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableList)) {
            return false;
        }
        TableList other = (TableList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Node> this$all = this.getAll();
        List<Node> other$all = other.getAll();
        if (this$all == null ? other$all != null : !((Object)this$all).equals(other$all)) {
            return false;
        }
        Class<?> this$rootClass = this.getRootClass();
        Class<?> other$rootClass = other.getRootClass();
        if (this$rootClass == null ? other$rootClass != null : !this$rootClass.equals(other$rootClass)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        List<Node> this$child = this.getChild();
        List<Node> other$child = other.getChild();
        return !(this$child == null ? other$child != null : !((Object)this$child).equals(other$child));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Node> $all = this.getAll();
        result = result * 59 + ($all == null ? 43 : ((Object)$all).hashCode());
        Class<?> $rootClass = this.getRootClass();
        result = result * 59 + ($rootClass == null ? 43 : $rootClass.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        List<Node> $child = this.getChild();
        result = result * 59 + ($child == null ? 43 : ((Object)$child).hashCode());
        return result;
    }

    public String toString() {
        return "TableList(all=" + this.getAll() + ", rootClass=" + this.getRootClass() + ", alias=" + this.getAlias() + ", child=" + this.getChild() + ")";
    }

    public static class Node {
        private Class<?> clazz;
        private boolean hasAlias;
        private String alias;
        private Integer pIndex;
        private int index;
        private List<Node> list;

        public Node(Class<?> clazz, boolean hasAlias, String alias, Integer pIndex, int index) {
            this.clazz = clazz;
            this.hasAlias = hasAlias;
            this.alias = alias;
            this.pIndex = pIndex;
            this.index = index;
        }

        public void put(Node node) {
            if (Objects.isNull(this.list)) {
                this.list = new ArrayList<Node>();
            }
            this.list.add(node);
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public boolean isHasAlias() {
            return this.hasAlias;
        }

        public String getAlias() {
            return this.alias;
        }

        public Integer getPIndex() {
            return this.pIndex;
        }

        public int getIndex() {
            return this.index;
        }

        public List<Node> getList() {
            return this.list;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public void setHasAlias(boolean hasAlias) {
            this.hasAlias = hasAlias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public void setPIndex(Integer pIndex) {
            this.pIndex = pIndex;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setList(List<Node> list) {
            this.list = list;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isHasAlias() != other.isHasAlias()) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            Integer this$pIndex = this.getPIndex();
            Integer other$pIndex = other.getPIndex();
            if (this$pIndex == null ? other$pIndex != null : !((Object)this$pIndex).equals(other$pIndex)) {
                return false;
            }
            Class<?> this$clazz = this.getClazz();
            Class<?> other$clazz = other.getClazz();
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
                return false;
            }
            List<Node> this$list = this.getList();
            List<Node> other$list = other.getList();
            return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Node;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHasAlias() ? 79 : 97);
            result = result * 59 + this.getIndex();
            Integer $pIndex = this.getPIndex();
            result = result * 59 + ($pIndex == null ? 43 : ((Object)$pIndex).hashCode());
            Class<?> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            List<Node> $list = this.getList();
            result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
            return result;
        }

        public String toString() {
            return "TableList.Node(clazz=" + this.getClazz() + ", hasAlias=" + this.isHasAlias() + ", alias=" + this.getAlias() + ", pIndex=" + this.getPIndex() + ", index=" + this.getIndex() + ", list=" + this.getList() + ")";
        }
    }
}

