/*
 * Decompiled with CFR 0.152.
 */
package yuku.ambilwarna.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.util.AttributeSet;
import android.view.View;
import yuku.ambilwarna.AmbilWarnaDialog;
import yuku.ambilwarna.R;

public class AmbilWarnaPreference
extends Preference {
    private final boolean supportsAlpha;
    int value;

    public AmbilWarnaPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.AmbilWarnaPreference);
        this.supportsAlpha = ta.getBoolean(R.styleable.AmbilWarnaPreference_supportsAlpha, false);
        this.setWidgetLayoutResource(R.layout.ambilwarna_pref_widget);
    }

    protected void onBindView(View view) {
        super.onBindView(view);
        View box = view.findViewById(R.id.ambilwarna_pref_widget_box);
        if (box != null) {
            box.setBackgroundColor(this.value);
        }
    }

    protected void onClick() {
        new AmbilWarnaDialog(this.getContext(), this.value, this.supportsAlpha, new AmbilWarnaDialog.OnAmbilWarnaListener(){

            @Override
            public void onOk(AmbilWarnaDialog dialog, int color) {
                if (!AmbilWarnaPreference.this.callChangeListener(color)) {
                    return;
                }
                AmbilWarnaPreference.this.value = color;
                AmbilWarnaPreference.this.persistInt(AmbilWarnaPreference.this.value);
                AmbilWarnaPreference.this.notifyChanged();
            }

            @Override
            public void onCancel(AmbilWarnaDialog dialog) {
            }
        }).show();
    }

    public void forceSetValue(int value) {
        this.value = value;
        this.persistInt(value);
        this.notifyChanged();
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getInteger(index, 0);
    }

    protected void onSetInitialValue(boolean restoreValue, Object defaultValue) {
        if (restoreValue) {
            this.value = this.getPersistedInt(this.value);
        } else {
            int value;
            this.value = value = ((Integer)defaultValue).intValue();
            this.persistInt(value);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.value = this.value;
        return myState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        this.value = myState.value;
        this.notifyChanged();
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        int value;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.value = source.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.value);
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }
    }
}

