/*
 * Decompiled with CFR 0.152.
 */
package com.github.youyinnn.youdbutils.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SqlStringUtils {
    private static final String SELECT_ALL_FROM = "SELECT * FROM ";

    public static String getSelectAllSql(String tableName, ArrayList<String> queryFieldList) {
        StringBuffer sb = new StringBuffer();
        SqlStringUtils.getSelectFromSubStr(sb, queryFieldList);
        sb.append(tableName);
        return sb.toString();
    }

    public static String getSelectFromWhereSql(String tableName, Set<String> conditionKeySet, String separateMark, ArrayList<String> queryFieldList) {
        StringBuffer sb = new StringBuffer();
        SqlStringUtils.getSelectFromSubStr(sb, queryFieldList);
        sb.append(tableName).append(SqlStringUtils.getWhereSubStr(conditionKeySet, separateMark));
        return sb.toString();
    }

    public static String getSelectFromWhereLikeSql(String tableName, HashMap<String, Object> conditionsMap, String separateMark, ArrayList<String> queryFieldList) {
        StringBuffer sb = new StringBuffer();
        SqlStringUtils.getSelectFromSubStr(sb, queryFieldList);
        sb.append(tableName).append(SqlStringUtils.getWhereLikeSubStr(conditionsMap, separateMark));
        return sb.toString();
    }

    public static String getUpdateSetWhereSql(String tableName, Set<String> updateFieldSet, String separateMark, Set<String> conditionKeySet) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ").append(tableName).append(" SET ");
        for (String updateField : updateFieldSet) {
            sb.append(updateField).append(" = ? , ");
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        if (conditionKeySet != null) {
            sb.append(SqlStringUtils.getWhereSubStr(conditionKeySet, separateMark));
        }
        return sb.toString();
    }

    public static String getInsertSql(String tableName, Set<String> insertFieldSet) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(tableName).append("(");
        for (String insertField : insertFieldSet) {
            sb.append(insertField).append(",");
        }
        int lastIndexOf = sb.lastIndexOf(",");
        sb.replace(lastIndexOf, lastIndexOf + 1, ")");
        sb.append(" VALUES(");
        for (int i = 0; i < insertFieldSet.size(); ++i) {
            sb.append("?,");
        }
        lastIndexOf = sb.lastIndexOf(",");
        sb.replace(lastIndexOf, lastIndexOf + 1, ")");
        return sb.toString();
    }

    public static String getDeleteSql(String tableName, String separateMark, Set<String> conditionKeySet) {
        return "DELETE FROM " + tableName + SqlStringUtils.getWhereSubStr(conditionKeySet, separateMark);
    }

    private static void getSelectFromSubStr(StringBuffer sb, ArrayList<String> queryFieldList) {
        if (queryFieldList == null) {
            sb.append(SELECT_ALL_FROM);
        } else {
            sb.append("SELECT ");
            for (String s : queryFieldList) {
                sb.append(s).append(", ");
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
            sb.append(" FROM ");
        }
    }

    public static String getWhereSubStr(Set<String> conditionKeySet, String separateMark) {
        StringBuilder sb = new StringBuilder(" WHERE ");
        for (String s : conditionKeySet) {
            sb.append(s).append(" = ? ").append(separateMark).append(" ");
        }
        sb.delete(sb.lastIndexOf(separateMark), sb.length() - 1);
        return sb.toString();
    }

    private static String getWhereLikeSubStr(HashMap<String, Object> conditionsMap, String separateMark) {
        StringBuilder sb = new StringBuilder(" WHERE ");
        for (Map.Entry<String, Object> stringObjectEntry : conditionsMap.entrySet()) {
            sb.append(stringObjectEntry.getKey()).append(" LIKE ").append("'%").append(stringObjectEntry.getValue()).append("%' ").append(separateMark).append(" ");
        }
        sb.delete(sb.lastIndexOf(separateMark), sb.length() - 1);
        return sb.toString();
    }
}

