/*
 * Decompiled with CFR 0.152.
 */
package com.github.youyinnn.youdbutils.ioc;

import com.github.youyinnn.youdbutils.YouDbManager;
import com.github.youyinnn.youdbutils.ioc.YouServiceIocContainer;
import com.github.youyinnn.youdbutils.ioc.annotations.YouService;
import com.github.youyinnn.youwebutils.third.ClassUtils;
import com.github.youyinnn.youwebutils.third.Log4j2Helper;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.Vector;

public class ServiceScanner {
    private ServiceScanner() {
    }

    public static void scanPackageForService(String servicePackageNamePrefix, String dataSourceName) {
        Set serviceClassSet = ClassUtils.findFileClass((String)servicePackageNamePrefix);
        for (Class aClass : serviceClassSet) {
            YouService annotation = aClass.getAnnotation(YouService.class);
            if (annotation == null) continue;
            YouServiceIocContainer.registerYouService(aClass);
        }
        if (YouDbManager.isYouDruidLogEnable(dataSourceName)) {
            Log4j2Helper.getLogger((String)"$db_manager").info("\u6570\u636e\u6e90: \"{}\" \u6240\u6301\u6709\u7684Service\u7c7b\u626b\u63cf\u7ed3\u679c\u4e3a:" + System.lineSeparator() + "|--\u591a\u4f8b: {}." + System.lineSeparator() + "---\u5355\u4f8b: {}.", (Object)dataSourceName, YouServiceIocContainer.getPrototypeServiceMap(), YouServiceIocContainer.getSingletonServiceMap());
        }
    }

    public static void showCurrentProjectLoadedClass() {
        try {
            Field field = ClassLoader.class.getDeclaredField("classes");
            field.setAccessible(true);
            Vector classes = (Vector)field.get(ClassLoader.getSystemClassLoader());
            for (Class aClass : classes) {
                String className = aClass.getName();
                System.out.println(className);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showCurrentProjectLoadedClass(String packageName) {
        try {
            Field field = ClassLoader.class.getDeclaredField("classes");
            field.setAccessible(true);
            Vector classes = (Vector)field.get(ClassLoader.getSystemClassLoader());
            for (Class aClass : classes) {
                String className = aClass.getName();
                if (!className.contains(packageName)) continue;
                System.out.println(className);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

