/*
 * Decompiled with CFR 0.152.
 */
package com.github.youyinnn.youdbutils.dao.model;

import com.github.youyinnn.youdbutils.dao.model.FieldMapping;
import com.github.youyinnn.youdbutils.dao.model.ModelTableMessage;
import com.github.youyinnn.youdbutils.exceptions.ModelResultTransferException;
import com.github.youyinnn.youwebutils.third.ReflectionUtils;
import java.sql.ResultSet;
import java.util.ArrayList;

public class ModelResultFactory<T> {
    private Class<T> modelClass;
    private ArrayList<String> fieldList;
    private FieldMapping fieldMapping;

    public ModelResultFactory(Class<T> modelClass) {
        this.modelClass = modelClass;
        this.fieldList = ModelTableMessage.getModelFieldList(modelClass.getSimpleName());
        this.fieldMapping = ModelTableMessage.getFieldMapping(modelClass.getSimpleName());
    }

    public ArrayList<T> getResultModelList(ResultSet resultSet) {
        ArrayList<T> resultModelList = new ArrayList<T>();
        try {
            while (resultSet.next()) {
                T instance = this.getResultModel(resultSet, false);
                resultModelList.add(instance);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultModelList;
    }

    public T getResultModel(ResultSet resultSet, boolean isOneResult) {
        T instance = null;
        try {
            if (isOneResult) {
                resultSet.next();
            }
            if (this.fieldList == null | this.fieldMapping == null) {
                throw new ModelResultTransferException("Model\uff1a[" + this.modelClass.getSimpleName() + "] \u6ca1\u6709\u5728ModelTableMessage\u4e2d\u6ce8\u518c\u3002");
            }
            instance = this.modelClass.newInstance();
            for (String field : this.fieldList) {
                boolean rsHasThisField = true;
                try {
                    resultSet.findColumn(this.fieldMapping.getTableField(field));
                }
                catch (Exception ignore) {
                    rsHasThisField = false;
                }
                if (!rsHasThisField) continue;
                Object value = this.fieldMapping.needToReplace(field) ? resultSet.getObject(this.fieldMapping.getTableField(field)) : resultSet.getObject(field);
                ReflectionUtils.setFieldValue(instance, (String)field, (Object)value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instance;
    }

    public String toString() {
        return "ModelResultFactory{modelClass=" + this.modelClass + ", fieldList=" + this.fieldList + ", fieldMapping=" + this.fieldMapping + '}';
    }
}

