/*
 * Decompiled with CFR 0.152.
 */
package com.github.youyinnn.youdbutils.dao.model;

import com.github.youyinnn.youdbutils.dao.SqlExecutor;
import com.github.youyinnn.youdbutils.dao.model.MappingHandler;
import com.github.youyinnn.youdbutils.dao.model.ModelResultFactory;
import com.github.youyinnn.youdbutils.dao.model.ModelTableMessage;
import com.github.youyinnn.youdbutils.druid.ThreadLocalPropContainer;
import com.github.youyinnn.youdbutils.exceptions.NoneffectiveUpdateExecuteException;
import com.github.youyinnn.youdbutils.utils.SqlStringUtils;
import com.github.youyinnn.youwebutils.third.ReflectionUtils;
import com.github.youyinnn.youwebutils.third.YouCollectionsUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class ModelHandler<T>
extends SqlExecutor
implements com.github.youyinnn.youdbutils.dao.interfaces.ModelHandler<T> {
    private ModelResultFactory<T> modelResultFactory;
    private String modelName;
    private String tableName;

    public ModelHandler(Class<T> modelClass, String dataSourceName) {
        this.modelResultFactory = new ModelResultFactory<T>(modelClass);
        this.modelName = modelClass.getSimpleName();
        this.tableName = ModelTableMessage.getTableName(this.modelName);
        super.setDataSourceName(dataSourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<T> getStatementResultModelList(String sql) {
        ResultSet resultSet = null;
        ArrayList<T> resultModelList = null;
        Statement statement = null;
        try {
            resultSet = this.executeStatementQuery(sql);
            statement = resultSet.getStatement();
            resultModelList = this.modelResultFactory.getResultModelList(resultSet);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                ThreadLocalPropContainer.release(resultSet, statement, null);
                throw throwable;
            }
            ThreadLocalPropContainer.release(resultSet, statement, null);
        }
        ThreadLocalPropContainer.release(resultSet, statement, null);
        return resultModelList;
    }

    @Override
    public ArrayList<T> getList(String sql) {
        return this.getStatementResultModelList(sql);
    }

    @Override
    public ArrayList<T> getListForAll(ArrayList<String> queryFieldList) {
        try {
            queryFieldList = MappingHandler.mappingHandle(this.modelName, queryFieldList);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        String sql = SqlStringUtils.getSelectAllSql(this.tableName, queryFieldList);
        return this.getStatementResultModelList(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<T> getListWhere(HashMap<String, Object> conditionsMap, ArrayList<String> queryFieldList, String separateMark) {
        ResultSet resultSet = null;
        ArrayList<T> resultModelList = null;
        Statement statement = null;
        try {
            queryFieldList = MappingHandler.mappingHandle(this.modelName, queryFieldList);
            conditionsMap = MappingHandler.mappingHandle(this.modelName, conditionsMap);
            resultSet = this.executePreparedStatementQuery(this.tableName, queryFieldList, conditionsMap, separateMark);
            statement = resultSet.getStatement();
            resultModelList = this.modelResultFactory.getResultModelList(resultSet);
            ThreadLocalPropContainer.release(resultSet, statement, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ThreadLocalPropContainer.release(resultSet, statement, null);
        }
        return resultModelList;
    }

    @Override
    public ArrayList<T> getListWhereLike(HashMap<String, Object> conditionsMap, ArrayList<String> queryFieldList, String separateMark) {
        try {
            queryFieldList = MappingHandler.mappingHandle(this.modelName, queryFieldList);
            conditionsMap = MappingHandler.mappingHandle(this.modelName, conditionsMap);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        String sql = SqlStringUtils.getSelectFromWhereLikeSql(this.tableName, conditionsMap, separateMark, queryFieldList);
        return this.getStatementResultModelList(sql);
    }

    @Override
    public int saveModel(T model) throws NoneffectiveUpdateExecuteException {
        HashMap<String, Object> newFieldValuesMap = new HashMap<String, Object>(10);
        for (String field : ModelTableMessage.getModelFieldList(this.modelName)) {
            Object fieldValue = ReflectionUtils.getFieldValue(model, (String)field);
            if (fieldValue == null) continue;
            newFieldValuesMap.put(field, fieldValue);
        }
        try {
            newFieldValuesMap = MappingHandler.mappingHandle(this.modelName, newFieldValuesMap);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return this.executePreparedStatementInsert(this.tableName, newFieldValuesMap);
    }

    @Override
    public T getModel(String sql) {
        T resultModel = null;
        try {
            ResultSet resultSet = this.executeStatementQuery(sql);
            if (!resultSet.isBeforeFirst()) {
                return null;
            }
            resultModel = this.modelResultFactory.getResultModel(resultSet, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultModel;
    }

    @Override
    public T getModel(String sql, ArrayList<String> conditionValues) {
        T resultModel = null;
        try {
            ResultSet resultSet = this.executePreparedStatementQuery(sql, conditionValues);
            if (!resultSet.isBeforeFirst()) {
                return null;
            }
            resultModel = this.modelResultFactory.getResultModel(resultSet, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultModel;
    }

    @Override
    public T getModel(HashMap<String, Object> conditionsMap, ArrayList<String> queryFieldList, String separateMark) {
        T resultModel = null;
        try {
            queryFieldList = MappingHandler.mappingHandle(this.modelName, queryFieldList);
            conditionsMap = MappingHandler.mappingHandle(this.modelName, conditionsMap);
            ResultSet resultSet = this.executePreparedStatementQuery(this.tableName, queryFieldList, conditionsMap, separateMark);
            if (!resultSet.isBeforeFirst()) {
                return null;
            }
            resultModel = this.modelResultFactory.getResultModel(resultSet, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultModel;
    }

    @Override
    public Object getModelFieldValue(String fieldName, HashMap<String, Object> conditionsMap, String separateMark) {
        Object value = null;
        try {
            conditionsMap = MappingHandler.mappingHandle(this.modelName, conditionsMap);
            fieldName = MappingHandler.mappingHandle(this.modelName, fieldName);
            ResultSet resultSet = this.executePreparedStatementQuery(this.tableName, YouCollectionsUtils.getYouArrayList((String[])new String[]{fieldName}), conditionsMap, separateMark);
            if (!resultSet.isBeforeFirst()) {
                return null;
            }
            resultSet.next();
            value = resultSet.getObject(fieldName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public int updateModel(HashMap<String, Object> newFieldValuesMap, HashMap<String, Object> conditionsMap, String separateMark) throws NoneffectiveUpdateExecuteException {
        try {
            newFieldValuesMap = MappingHandler.mappingHandle(this.modelName, newFieldValuesMap);
            conditionsMap = MappingHandler.mappingHandle(this.modelName, conditionsMap);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return this.executePreparedStatementUpdate(this.tableName, newFieldValuesMap, conditionsMap, separateMark);
    }

    @Override
    public int deleteModel(HashMap<String, Object> conditionsMap, String separateMark) throws NoneffectiveUpdateExecuteException {
        try {
            conditionsMap = MappingHandler.mappingHandle(this.modelName, conditionsMap);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return this.executePreparedStatementDelete(this.tableName, conditionsMap, separateMark);
    }

    @Override
    public int addition(String modelField, double b, HashMap<String, Object> conditionsMap) throws NoneffectiveUpdateExecuteException {
        return this.basicArithmetic(modelField, b, conditionsMap, "+");
    }

    @Override
    public int subtraction(String modelField, double b, HashMap<String, Object> conditionsMap) throws NoneffectiveUpdateExecuteException {
        return this.basicArithmetic(modelField, b, conditionsMap, "-");
    }

    @Override
    public int multiplication(String modelField, double b, HashMap<String, Object> conditionsMap) throws NoneffectiveUpdateExecuteException {
        return this.basicArithmetic(modelField, b, conditionsMap, "*");
    }

    @Override
    public int division(String modelField, double b, HashMap<String, Object> conditionsMap) throws NoneffectiveUpdateExecuteException {
        return this.basicArithmetic(modelField, b, conditionsMap, "/");
    }

    private int basicArithmetic(String modelField, double b, HashMap<String, Object> conditionsMap, String op) throws NoneffectiveUpdateExecuteException {
        String tableField = null;
        try {
            tableField = MappingHandler.mappingHandle(this.modelName, modelField);
            conditionsMap = MappingHandler.mappingHandle(this.modelName, conditionsMap);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        ArrayList<Object> conditionValues = new ArrayList<Object>(conditionsMap.values());
        String sql = "UPDATE " + this.tableName + " SET " + tableField + " = " + tableField + op + " ?" + SqlStringUtils.getWhereSubStr(conditionsMap.keySet(), "AND");
        return this.executePreparedStatementUpdate(sql, YouCollectionsUtils.getYouArrayList((String[])new String[]{b + ""}), conditionValues);
    }
}

