/*
 * Decompiled with CFR 0.152.
 */
package com.github.youyinnn.youdbutils;

import com.github.youyinnn.youdbutils.dao.model.ModelTableMessage;
import com.github.youyinnn.youdbutils.dao.model.ModelTableScanner;
import com.github.youyinnn.youdbutils.druid.YouDruid;
import com.github.youyinnn.youdbutils.exceptions.YouDbManagerException;
import com.github.youyinnn.youdbutils.ioc.ServiceScanner;
import com.github.youyinnn.youdbutils.ioc.YouServiceIocContainer;
import com.github.youyinnn.youwebutils.third.Log4j2Helper;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class YouDbManager {
    private static final Logger logger = Log4j2Helper.getLogger((String)"$db_manager");
    private static HashMap<String, YouDruid> youDruidMap = new HashMap(3);
    private static HashMap<String, Set<String>> dataSourceMappingModels = new HashMap(3);
    private static HashMap<String, URL> dataSourceInitSqlFileURL = new HashMap(3);

    public static String getModelMappingDataSourceName(String modelName) {
        for (Map.Entry<String, Set<String>> entry : dataSourceMappingModels.entrySet()) {
            for (String name : entry.getValue()) {
                if (!name.equalsIgnoreCase(modelName)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public static YouDruid youDruid(String dataSourceName) {
        return youDruidMap.get(dataSourceName);
    }

    public static void checkDataSourceName(String dataSourceName) throws YouDbManagerException {
        if (!youDruidMap.containsKey(dataSourceName)) {
            throw new YouDbManagerException("\u6ca1\u6709\u540d\u79f0\u4e3a:" + dataSourceName + "\u7684\u6570\u636e\u6e90\u5728YouDbManager\u4e2d\u6ce8\u518c\u8fc7!");
        }
    }

    public static void signInYouDruid(YouDruid youDruid) {
        youDruidMap.put(youDruid.getDataSourceName(), youDruid);
    }

    public static void scanPackageForModelAndService(String modelPackagePath, String servicePackagePath, String dataSourceName) throws YouDbManagerException {
        YouDbManager.scanPackageForModel(modelPackagePath, dataSourceName);
        YouDbManager.scanPackageForService(servicePackagePath, dataSourceName);
    }

    private static void scanPackageForService(String packageName, String dataSourceName) throws YouDbManagerException {
        YouDbManager.checkDataSourceName(dataSourceName);
        ServiceScanner.scanPackageForService(packageName, dataSourceName);
    }

    private static void scanPackageForModel(String packageName, String dataSourceName) throws YouDbManagerException {
        YouDbManager.checkDataSourceName(dataSourceName);
        ModelTableScanner.scanPackageForModel(packageName, dataSourceName);
        Set<String> modelNameSet = ModelTableMessage.getAllModelNameSet();
        dataSourceMappingModels.put(dataSourceName, modelNameSet);
        try {
            ModelTableScanner.scanDataBaseForTable(modelNameSet, youDruidMap.get(dataSourceName).getCurrentDataSourceConn(), dataSourceName);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ModelTableMessage.setFieldMapping(dataSourceName);
    }

    public static void showService() {
        YouServiceIocContainer.showServiceMap();
    }

    public static void printAllModelField() {
        System.out.println(ModelTableMessage.getAllModelField());
    }

    public static void printAllTableField() {
        System.out.println(ModelTableMessage.getAllTableField());
    }

    public static void printAllModelTableFieldMapping() {
        System.out.println(ModelTableMessage.getAllModelTableFieldMapping());
    }

    public static void setInitSql(String dataSourceName, URL initSqlFileURL) throws YouDbManagerException, IOException {
        YouDbManager.checkDataSourceName(dataSourceName);
        dataSourceInitSqlFileURL.put(dataSourceName, initSqlFileURL);
    }

    public static URL getDataSourceInitSqlFileURL(String dataSourceName) throws YouDbManagerException, IOException {
        YouDbManager.checkDataSourceName(dataSourceName);
        URL url = dataSourceInitSqlFileURL.get(dataSourceName);
        if (url == null) {
            URL resource;
            if (YouDbManager.isYouDruidLogEnable(dataSourceName)) {
                logger.info("\u7528\u6237\u5e76\u65e0\u914d\u7f6e\u597d\u7684\u521d\u59cb\u5316\u6587\u4ef6, \u5c1d\u8bd5\u7d22\u5f15\u9ed8\u8ba4\u7684\u521d\u59cb\u5316SQL\u6587\u4ef6:{}", (Object)(dataSourceName + "-init.sql"));
            }
            if ((resource = ClassLoader.getSystemClassLoader().getResource(dataSourceName + "-init.sql")) != null && YouDbManager.isYouDruidLogEnable(dataSourceName)) {
                logger.info("\u5b58\u5728\u6570\u636e\u5e93\u5bf9\u5e94\u7684\u9ed8\u8ba4\u7684\u521d\u59cb\u5316SQL\u6587\u4ef6:{}, \u542f\u7528\u8be5\u914d\u7f6e.", (Object)(dataSourceName + "-init.sql"));
                YouDbManager.setInitSql(dataSourceName, resource);
            }
        }
        return dataSourceInitSqlFileURL.get(dataSourceName);
    }

    public static boolean isYouDruidLogEnable(String dataSourceName) {
        return youDruidMap.get(dataSourceName).isEmbeddedLogEnable();
    }
}

