/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.next;

import com.github.yoojia.next.NextResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;

final class DownloadTransferAdapter {
    private final File inputFile;

    private DownloadTransferAdapter(Path path) {
        this.inputFile = path.toFile();
    }

    static DownloadTransferAdapter use(Path path) {
        return new DownloadTransferAdapter(path);
    }

    public void dispatch(NextResponse response) throws Exception {
        try (FileChannel in = new FileInputStream(this.inputFile).getChannel();
             WritableByteChannel out = Channels.newChannel((OutputStream)response.httpResponse.getOutputStream());){
            in.transferTo(0L, in.size(), out);
        }
    }
}

