/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.next;

import com.github.yoojia.next.DownloadTransferAdapter;
import com.github.yoojia.next.Downloads;
import com.github.yoojia.next.NextRequest;
import com.github.yoojia.next.NextResponse;
import com.github.yoojia.next.supports.AbstractModule;
import com.github.yoojia.next.supports.Config;
import com.github.yoojia.next.supports.Context;
import com.github.yoojia.next.supports.DispatchChain;
import com.github.yoojia.next.utils.TimeAnalysis;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DownloadManager
extends AbstractModule {
    private static final int DEFAULT_PRIORITY = 50;
    private static final String DIR = "/files";
    private Context mContext;

    public void init(Context context, Config config) {
        this.mLogger.debug("Init...");
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onService(NextRequest request, NextResponse response, DispatchChain chain) throws Exception {
        long start;
        block4: {
            String userSetPath = Downloads.getResourcePath(request);
            if (userSetPath == null || userSetPath.isEmpty()) {
                chain.onService(request, response, chain);
                return;
            }
            start = System.nanoTime();
            try {
                Path local = this.mContext.resolve(Paths.get(DIR, userSetPath));
                response.setStatusCode(200);
                if (Files.exists(local, new LinkOption[0])) {
                    response.httpResponse.setContentLengthLong(Files.size(local));
                    response.setContentType("application/octet-stream");
                    String userSetName = Downloads.getResourceName(request);
                    String attachName = userSetName != null ? userSetName : local.getFileName().toString();
                    response.httpResponse.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(attachName, "UTF-8"));
                    DownloadTransferAdapter.use(local).dispatch(response);
                    break block4;
                }
                response.setStatusCode(404);
            }
            catch (Throwable throwable) {
                TimeAnalysis.log((long)start, (String)String.format("DownloadManager.send(:%s)", request.uri));
                throw throwable;
            }
        }
        TimeAnalysis.log((long)start, (String)String.format("DownloadManager.send(:%s)", request.uri));
    }

    public int getPriority() {
        return 50;
    }
}

