package com.github.yoojia.next;

import java.io.File;
import java.io.FileInputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;

/**
 * @author YOOJIA.CHEN (yoojia.chen@gmail.com)
 */
final class DownloadTransferAdapter {

    private final File inputFile;

    private DownloadTransferAdapter(Path path) {
        inputFile = path.toFile();
    }

    static DownloadTransferAdapter use(Path path) {
        return new DownloadTransferAdapter(path);
    }

    public void dispatch(NextResponse response) throws Exception {
        try(FileChannel in = new FileInputStream(inputFile).getChannel();
            WritableByteChannel out = Channels.newChannel(response.httpResponse.getOutputStream())){
            in.transferTo(0, in.size(), out);
        }
    }
}
