package com.github.yoojia.next;

import com.github.yoojia.next.supports.*;
import com.github.yoojia.next.utils.TimeAnalysis;

import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

/**
 * @author YOOJIA.CHEN (yoojia.chen@gmail.com)
 */
public class DownloadManager extends AbstractModule {

    private static final int DEFAULT_PRIORITY = 50;

    private static final String DIR = "/files";

    private Context mContext;

    @Override
    public void init(Context context, Config config) {
        mLogger.debug("Init...");
        mContext = context;
    }

    @Override
    public void onService(NextRequest request, NextResponse response, DispatchChain chain) throws Exception {
        final String userSetPath = Downloads.getResourcePath(request);
        if(userSetPath == null || userSetPath.isEmpty()) {
            chain.onService(request, response, chain);
            return;
        }
        final long start = System.nanoTime();
        try{
            final Path local = mContext.resolve(Paths.get(DIR, userSetPath));
            response.setStatusCode(StatusCode.OK);
            if (Files.exists(local)){
                response.httpResponse.setContentLengthLong(Files.size(local));
                response.setContentType("application/octet-stream");
                final String userSetName = Downloads.getResourceName(request);
                final String attachName = userSetName != null ? userSetName : local.getFileName().toString();
                response.httpResponse.addHeader("Content-Disposition",
                        "attachment; filename=" + URLEncoder.encode(attachName, "UTF-8"));
                DownloadTransferAdapter.use(local).dispatch(response);
            }else{
                response.setStatusCode(StatusCode.NOT_FOUND);
            }
        }finally {
            TimeAnalysis.log(start, String.format("DownloadManager.send(:%s)", request.uri));
        }
    }

    @Override
    public int getPriority() {
        return DEFAULT_PRIORITY;
    }
}
