/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events.supports;

import com.github.yoojia.events.supports.Filter;
import com.github.yoojia.events.supports.Transformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Functions {
    public static <T> List<T> filter(List<T> src, Filter<T> func) {
        if (src == null || src.isEmpty()) {
            return Collections.emptyList();
        }
        int size = src.size();
        ArrayList<T> output = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            T item = src.get(i);
            if (!func.accept(item)) continue;
            output.add(item);
        }
        return output;
    }

    public static <S, M> List<M> map(List<S> src, Transformer<S, M> func) {
        if (src == null || src.isEmpty()) {
            return Collections.emptyList();
        }
        int size = src.size();
        ArrayList<M> output = new ArrayList<M>(size);
        for (int i = 0; i < size; ++i) {
            output.add(func.transform(src.get(i)));
        }
        return output;
    }
}

