/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events;

import com.github.yoojia.events.Element;
import com.github.yoojia.events.EventSubscriber;
import com.github.yoojia.events.On;
import com.github.yoojia.events.ScheduleLooper;
import com.github.yoojia.events.emitter.Invoker;
import com.github.yoojia.events.emitter.Scheduler;
import com.github.yoojia.events.emitter.Subscriber;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;

public class ThreadsScheduler
implements Scheduler {
    private final Queue<Element> mLoopTasks = new ConcurrentLinkedQueue<Element>();
    private final ExecutorService mWorkerThreads;
    private final ExecutorService mLoopThread;
    private final ScheduleLooper mLooper = new ScheduleLooper(){

        @Override
        protected void step() {
            Element el = (Element)ThreadsScheduler.this.mLoopTasks.poll();
            if (el == null) {
                this.await();
            } else {
                ThreadsScheduler.this.invoke(el.scheduleOn, el.event, el.handler);
            }
        }
    };

    public ThreadsScheduler(ExecutorService workerThreads, ExecutorService loopThread) {
        this.mWorkerThreads = workerThreads;
        this.mLoopThread = loopThread;
        this.mLoopThread.submit(this.mLooper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(Object event, List<? extends Subscriber> handlers) {
        for (Subscriber subscriber : handlers) {
            EventSubscriber handler = (EventSubscriber)subscriber;
            On scheduleOn = handler.scheduleOn();
            if (On.CALLER_THREAD.equals((Object)scheduleOn)) {
                new Invoker(event, handler).run();
                continue;
            }
            this.mLoopTasks.offer(new Element(event, handler, scheduleOn));
            ScheduleLooper scheduleLooper = this.mLooper;
            synchronized (scheduleLooper) {
                this.mLooper.notify();
            }
        }
    }

    public final ExecutorService getWorkerThreads() {
        return this.mWorkerThreads;
    }

    public final ExecutorService getLoopThread() {
        return this.mLoopThread;
    }

    protected void invoke(On type, Object event, Subscriber subscriber) {
        switch (type) {
            case IO_THREAD: {
                this.mWorkerThreads.submit(new Invoker(event, subscriber));
                break;
            }
            case MAIN_THREAD: {
                subscriber.onError(new IllegalArgumentException("Unsupported <MAIN_THREAD> schedule type! "));
                break;
            }
            default: {
                subscriber.onError(new IllegalArgumentException("Unsupported schedule type: " + (Object)((Object)type)));
            }
        }
    }
}

