/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events.emitter;

import com.github.yoojia.events.emitter.CallerScheduler;
import com.github.yoojia.events.emitter.EventFilter;
import com.github.yoojia.events.emitter.EventInterceptor;
import com.github.yoojia.events.emitter.RealSubscriber;
import com.github.yoojia.events.emitter.Scheduler;
import com.github.yoojia.events.emitter.Submit;
import com.github.yoojia.events.emitter.Subscriber;
import com.github.yoojia.events.supports.Filter;
import com.github.yoojia.events.supports.Functions;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventEmitter {
    private final Submit mSubmit;
    final Scheduler scheduler;
    final CopyOnWriteArrayList<RealSubscriber> subscribers = new CopyOnWriteArrayList();
    final CopyOnWriteArrayList<EventInterceptor> eventInterceptors = new CopyOnWriteArrayList();

    public EventEmitter() {
        this(new CallerScheduler());
    }

    public EventEmitter(Scheduler schedule) {
        this.scheduler = schedule;
        this.mSubmit = new Submit(this);
    }

    public void emit(Object event) {
        this.mSubmit.submit(event);
    }

    public void addSubscriber(Subscriber subscriber, EventFilter filter) {
        this.addSubscriber(subscriber, Arrays.asList(filter));
    }

    public void addSubscriber(Subscriber subscriber, List<EventFilter> filters) {
        this.addSubscriber(new RealSubscriber(subscriber, filters));
    }

    public void addSubscriber(RealSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    public void removeSubscriber(RealSubscriber subscriber) {
        this.removeSubscriber(subscriber.subscriber);
    }

    public void removeSubscriber(final Subscriber subscriber) {
        this.subscribers.removeAll(Functions.filter(this.subscribers, new Filter<RealSubscriber>(){

            @Override
            public boolean accept(RealSubscriber item) {
                return item.subscriber == subscriber;
            }
        }));
    }

    public void addEventInterceptor(EventInterceptor interceptor) {
        this.eventInterceptors.add(interceptor);
    }

    public void removeEventInterceptor(EventInterceptor interceptor) {
        this.eventInterceptors.remove(interceptor);
    }
}

