/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events;

import com.github.yoojia.events.supports.Preconditions;
import java.util.Arrays;

public class EventPayload {
    public static final String DEAD_EVENT = "next.events.<dead-event>";
    public final String name;
    public final String origin;
    public final Object[] values;
    public final Class<?>[] types;

    EventPayload(String name, EventPayload src) {
        this.name = name;
        this.origin = src.name;
        this.values = src.values;
        this.types = src.types;
    }

    public EventPayload(String name, Object payload) {
        Preconditions.notEmpty(name, "name not allow empty");
        this.name = name;
        this.origin = null;
        Object[] parsed = EventPayload.checkParse(payload);
        this.values = (Object[])parsed[0];
        this.types = (Class[])parsed[1];
    }

    public String toString() {
        return "{ name='" + this.name + '\'' + (this.origin == null ? "" : ", origin='" + this.origin + "'") + ", values=" + Arrays.toString(this.values) + '}';
    }

    public static Object[] checkParse(Object payloads) {
        Class[] types;
        Object[] values;
        if (payloads != null) {
            Class<?> type = payloads.getClass();
            if (type.isArray()) {
                values = (Object[])payloads;
                types = new Class[values.length];
                for (int i = 0; i < values.length; ++i) {
                    if (null == values[i]) {
                        throw new IllegalArgumentException("When emit MULTI-PAYLOADS, values CANNOT contains <NULL> value !");
                    }
                    types[i] = values[i].getClass();
                }
            } else {
                types = new Class[]{type};
                values = new Object[]{payloads};
            }
        } else {
            values = new Object[]{};
            types = new Class[]{};
        }
        return new Object[]{values, types};
    }
}

