/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events.supports;

import com.github.yoojia.events.supports.Filter;
import com.github.yoojia.events.supports.Preconditions;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;

public abstract class Annotated<T extends AnnotatedElement> {
    protected List<Filter<T>> mResourceFilters = new ArrayList<Filter<T>>();
    protected Filter<Class<?>> mTypeFilter;

    public Annotated() {
        this.setTypesFilter(new Filter<Class<?>>(){

            @Override
            public boolean accept(Class<?> type) {
                String name = type.getName();
                return !name.startsWith("java.") && !name.startsWith("javax.") && !name.startsWith("android.") && !name.startsWith("com.android.");
            }
        });
    }

    public Annotated<T> addResourceFilter(Filter<T> filter) {
        Preconditions.notNull(filter, "filter == null");
        this.mResourceFilters.add(filter);
        return this;
    }

    public Annotated<T> setTypesFilter(Filter<Class<?>> filter) {
        Preconditions.notNull(filter, "filter == null");
        this.mTypeFilter = filter;
        return this;
    }

    public List<T> find(Class<?> targetType) {
        Preconditions.notNull(targetType, "Class target type == null");
        ArrayList<AnnotatedElement> output = new ArrayList<AnnotatedElement>();
        Class<?> type = targetType;
        while (!Object.class.equals(type) && this.mTypeFilter.accept(type)) {
            AnnotatedElement[] resources;
            for (AnnotatedElement res : resources = this.getResource(type)) {
                for (Filter<AnnotatedElement> filter : this.mResourceFilters) {
                    if (!filter.accept(res)) break;
                    output.add(res);
                }
            }
            type = type.getSuperclass();
        }
        return output;
    }

    protected abstract T[] getResource(Class<?> var1);
}

