/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events;

import com.github.yoojia.events.MethodDefine;
import com.github.yoojia.events.Subscribe;
import com.github.yoojia.events.supports.AnnotatedMethod;
import com.github.yoojia.events.supports.Filter;
import java.lang.reflect.Method;
import java.util.List;

class Methods {
    private static final Filter<Method> SIGNATURE_FILTER = new MethodSignFilter();

    Methods() {
    }

    public static List<Method> getAnnotated(Class<?> clazz, Filter<Method> customMethodFilter) {
        AnnotatedMethod methods = new AnnotatedMethod(Subscribe.class);
        methods.addResourceFilter(SIGNATURE_FILTER);
        if (customMethodFilter != null) {
            methods.addResourceFilter(customMethodFilter);
        }
        return methods.find(clazz);
    }

    public static MethodDefine parse(Method method) {
        Class<?>[] types;
        Subscribe annotation = method.getAnnotation(Subscribe.class);
        int schedule = annotation.schedule().scheduleFlag;
        String names = annotation.events();
        for (Class<?> type : types = method.getParameterTypes()) {
            if (!Object.class.equals(type)) continue;
            throw new IllegalArgumentException("@Subscribe method params NOT-ALLOW contains <Object> type, use <Any> instead !");
        }
        return new MethodDefine(schedule, types, names);
    }

    private static class MethodSignFilter
    implements Filter<Method> {
        private MethodSignFilter() {
        }

        @Override
        public boolean accept(Method method) {
            if (!Void.TYPE.equals(method.getReturnType())) {
                throw new IllegalArgumentException("Return type of @Subscribe annotated methods must be <VOID>, method: " + method);
            }
            return false;
        }
    }
}

