/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events;

import com.github.yoojia.events.Any;
import com.github.yoojia.events.EventHandler;
import com.github.yoojia.events.EventPayload;
import com.github.yoojia.events.MethodDefine;
import com.github.yoojia.events.On;
import com.github.yoojia.events.supports.ClassTypes;
import java.lang.reflect.Method;

class MethodHandler
implements EventHandler {
    private final On mScheduleOn;
    private final Method mMethod;
    private final Object mObjectRef;
    private final MethodDefine mDefine;

    private MethodHandler(On scheduleOn, Object object, Method method, MethodDefine define) {
        this.mScheduleOn = scheduleOn;
        this.mMethod = method;
        this.mObjectRef = object;
        this.mDefine = define;
    }

    @Override
    public void onEvent(Object event) throws Exception {
        EventPayload payload = (EventPayload)event;
        this.mMethod.setAccessible(true);
        if (this.mDefine.isNoArgs) {
            this.mMethod.invoke(this.mObjectRef, new Object[0]);
        } else if (this.mDefine.isAny) {
            this.mMethod.invoke(this.mObjectRef, new Any(payload.values, payload.types));
        } else {
            this.mMethod.invoke(this.mObjectRef, MethodHandler.reorderArgs(this.mDefine.types, payload));
        }
    }

    @Override
    public void onErrors(Exception errors) {
        throw new RuntimeException(errors);
    }

    @Override
    public On scheduleOn() {
        return this.mScheduleOn;
    }

    static Object[] reorderArgs(Class<?>[] defineTypes, EventPayload payload) {
        Object[] values = new Object[defineTypes.length];
        boolean[] used = new boolean[values.length];
        block0: for (int i = 0; i < defineTypes.length; ++i) {
            for (int j = 0; j < values.length; ++j) {
                Class<?> defType = defineTypes[i];
                if (used[j] || !ClassTypes.lenientlyEquals(defType, payload.types[j])) continue;
                values[i] = payload.values[j];
                used[j] = true;
                continue block0;
            }
        }
        return values;
    }

    public static MethodHandler create(On scheduleOn, Object object, Method method, MethodDefine args) {
        return new MethodHandler(scheduleOn, object, method, args);
    }
}

