/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events;

import com.github.yoojia.events.EventPayload;
import com.github.yoojia.events.MethodDefine;
import com.github.yoojia.events.internal.DeadEvent;
import com.github.yoojia.events.internal.EventFilter;
import com.github.yoojia.events.supports.ClassTypes;

class InternalFilter
implements EventFilter {
    private final MethodDefine mDefine;

    public InternalFilter(MethodDefine define) {
        this.mDefine = define;
    }

    @Override
    public boolean accept(Object event) {
        EventPayload payload = (EventPayload)(event instanceof DeadEvent ? ((DeadEvent)event).raw : event);
        if (this.mDefine.isNoArgs || this.mDefine.isAny) {
            return this.isNamesMatched(payload.name);
        }
        return this.isNamesMatched(payload.name) && InternalFilter.isTypesMatched(this.mDefine.types, payload.types);
    }

    private boolean isNamesMatched(String eventName) {
        return this.mDefine.name.equals(eventName);
    }

    static boolean isTypesMatched(Class<?>[] defines, Class<?>[] sources) {
        if (defines.length == sources.length) {
            int hits = 0;
            boolean[] used = new boolean[sources.length];
            block0: for (Class<?> defType : defines) {
                for (int i = 0; i < sources.length; ++i) {
                    Class<?> srcType = sources[i];
                    if (used[i] || !ClassTypes.lenientlyEquals(defType, srcType)) continue;
                    ++hits;
                    used[i] = true;
                    continue block0;
                }
            }
            return hits == defines.length;
        }
        return false;
    }
}

