/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.events;

import com.github.yoojia.events.Acceptors;
import com.github.yoojia.events.ObjectCached;
import com.github.yoojia.events.PayloadEvent;
import com.github.yoojia.events.SharedScheduler;
import com.github.yoojia.events.internal.Acceptor;
import com.github.yoojia.events.internal.DeadEvent;
import com.github.yoojia.events.internal.Dispatcher;
import com.github.yoojia.events.internal.EventFilter;
import com.github.yoojia.events.internal.Handler;
import com.github.yoojia.events.internal.Logger;
import com.github.yoojia.events.internal.OnEventHandler;
import com.github.yoojia.events.internal.Scheduler;
import com.github.yoojia.events.supports.Filter;
import com.github.yoojia.events.supports.Preconditions;
import java.lang.reflect.Method;
import java.util.List;

public class NextEvents {
    private final Dispatcher mDispatcher;
    private final ObjectCached mObjectCached = new ObjectCached();

    public NextEvents() {
        this(SharedScheduler.getDefault());
    }

    public NextEvents(Scheduler schedule) {
        Preconditions.notNull(schedule, "schedule == null");
        this.mDispatcher = new Dispatcher(schedule);
        this.mDispatcher.addOnEventHandler(new OnEventHandler(){

            @Override
            public boolean handleEvent(Object event) {
                boolean isDeadEvent = event instanceof DeadEvent;
                if (isDeadEvent) {
                    PayloadEvent payload = (PayloadEvent)((DeadEvent)event).raw;
                    if ("next.events.<DEAD-EVENT>".equals(payload.name)) {
                        Logger.debug("NextEvents", "- No handlers for DEAD-EVENT: " + payload);
                    } else {
                        NextEvents.this.emit(new PayloadEvent("next.events.<DEAD-EVENT>", payload.values));
                    }
                }
                return isDeadEvent;
            }
        });
    }

    public void register(Object object) {
        this.register(object, null);
    }

    public void register(Object object, Filter<Method> customMethodFilter) {
        Preconditions.notNull(object, "object == null");
        Acceptors acceptors = this.mObjectCached.find(object, customMethodFilter);
        for (Acceptor acceptor : acceptors) {
            this.mDispatcher.addHandler(acceptor.handler, acceptor.filters);
        }
    }

    public void unregister(Object object) {
        Preconditions.notNull(object, "object == null");
        Acceptors acceptors = this.mObjectCached.getSafety(object);
        for (Acceptor acceptor : acceptors) {
            this.mDispatcher.removeHandler(acceptor.handler);
        }
        this.mObjectCached.remove(object);
    }

    public void emit(String name, Object ... payloads) {
        if (payloads == null || payloads.length == 0) {
            throw new IllegalArgumentException("payloads is empty");
        }
        this.mDispatcher.emit(new PayloadEvent(name, payloads));
    }

    public void emit(PayloadEvent event) {
        Preconditions.notNull(event, "event == null");
        this.mDispatcher.emit(event);
    }

    public void emit(Object event) {
        if (!(event instanceof PayloadEvent)) {
            throw new IllegalArgumentException("Call emit(PayloadEvent) instead");
        }
        this.mDispatcher.emit(event);
    }

    public void addHandler(Handler handler, EventFilter filter) {
        Preconditions.notNull(handler, "handler == null");
        Preconditions.notNull(filter, "filter == null");
        this.mDispatcher.addHandler(handler, filter);
    }

    public void addHandler(Handler handler, List<EventFilter> filters) {
        Preconditions.notNull(handler, "handler == null");
        Preconditions.notNull(filters, "filters == null");
        this.mDispatcher.addHandler(handler, filters);
    }

    public void removeHandler(Handler handler) {
        this.mDispatcher.removeHandler(handler);
    }
}

