/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.keyboard;

import android.app.Activity;
import android.content.Context;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.view.View;
import android.widget.TextView;
import com.github.yoojia.keyboard.AbstractKeyboard;
import com.github.yoojia.keyboard.OnKeyActionListener;
import com.github.yoojia.keyboard.OnKeyboardActionHandler;
import com.github.yoojia.keyboard.R;

public class PasswordKeyboard
extends AbstractKeyboard {
    private final KeyboardView mKeyboardView;
    private final Keyboard mNumberKeyboard;
    private final TextView[] mNumbersTextView = new TextView[6];
    private TextView mSelectedTextView;

    public PasswordKeyboard(Context context, OnKeyActionListener commitListener) {
        super(context, commitListener);
        View contentView = this.putContentView(R.layout.keyboard_password);
        this.mNumbersTextView[0] = (TextView)contentView.findViewById(R.id.keyboard_number_0);
        this.mNumbersTextView[1] = (TextView)contentView.findViewById(R.id.keyboard_number_1);
        this.mNumbersTextView[2] = (TextView)contentView.findViewById(R.id.keyboard_number_2);
        this.mNumbersTextView[3] = (TextView)contentView.findViewById(R.id.keyboard_number_3);
        this.mNumbersTextView[4] = (TextView)contentView.findViewById(R.id.keyboard_number_4);
        this.mNumbersTextView[5] = (TextView)contentView.findViewById(R.id.keyboard_number_5);
        View.OnClickListener listener = this.createNumberListener();
        for (TextView view : this.mNumbersTextView) {
            view.setSoundEffectsEnabled(false);
            view.setOnClickListener(listener);
        }
        this.mNumberKeyboard = new Keyboard(context, R.xml.keyboard_numbers);
        this.mKeyboardView = (KeyboardView)contentView.findViewById(R.id.keyboard_view);
        this.mKeyboardView.setOnKeyboardActionListener((KeyboardView.OnKeyboardActionListener)new OnKeyboardActionHandler(){

            @Override
            public void onKey(int charCode, int[] keyCodes) {
                PasswordKeyboard.this.mSelectedTextView.setText((CharSequence)Character.toString((char)charCode));
                PasswordKeyboard.this.nextNumber();
            }
        });
        this.mKeyboardView.setPreviewEnabled(false);
        this.mKeyboardView.setKeyboard(this.mNumberKeyboard);
    }

    @Override
    protected void onShow() {
        this.mNumbersTextView[0].performClick();
    }

    private void nextNumber() {
        String number = this.getInput(this.mNumbersTextView);
        int viewId = this.mSelectedTextView.getId();
        if (viewId == R.id.keyboard_number_0) {
            this.mOnKeyActionListener.onProcess(number);
            this.mNumbersTextView[1].performClick();
        } else if (viewId == R.id.keyboard_number_1) {
            this.mOnKeyActionListener.onProcess(number);
            this.mNumbersTextView[2].performClick();
        } else if (viewId == R.id.keyboard_number_2) {
            this.mOnKeyActionListener.onProcess(number);
            this.mNumbersTextView[3].performClick();
        } else if (viewId == R.id.keyboard_number_3) {
            this.mOnKeyActionListener.onProcess(number);
            this.mNumbersTextView[4].performClick();
        } else if (viewId == R.id.keyboard_number_4) {
            this.mOnKeyActionListener.onProcess(number);
            this.mNumbersTextView[5].performClick();
        } else if (viewId == R.id.keyboard_number_5 && number.length() == this.mNumbersTextView.length) {
            this.mOnKeyActionListener.onFinish(number);
            this.dismiss();
        }
    }

    private View.OnClickListener createNumberListener() {
        return new View.OnClickListener(){

            public void onClick(View view) {
                if (PasswordKeyboard.this.mSelectedTextView != null) {
                    PasswordKeyboard.this.mSelectedTextView.setActivated(false);
                }
                PasswordKeyboard.this.mSelectedTextView = (TextView)view;
                PasswordKeyboard.this.mSelectedTextView.setActivated(true);
            }
        };
    }

    public static void show(Activity context, OnKeyActionListener listener) {
        new PasswordKeyboard((Context)context, listener).show(context.getWindow().getDecorView().getRootView());
    }

    public static PasswordKeyboard create(Context context, OnKeyActionListener listener) {
        return new PasswordKeyboard(context, listener);
    }
}

