/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.keyboard;

import android.app.Activity;
import android.content.Context;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.github.yoojia.keyboard.AbstractKeyboard;
import com.github.yoojia.keyboard.OnCommitListener;
import com.github.yoojia.keyboard.OnKeyboardActionHandler;
import com.github.yoojia.keyboard.R;

public class VehiclePlateKeyboard
extends AbstractKeyboard {
    private static final int NUMBER_LENGTH = 7;
    private static final String CHINESE = "|\u4eac\u6d25\u664b\u5180\u8499\u8fbd\u5409\u9ed1\u6caa\u82cf\u6d59\u7696\u95fd\u8d63\u9c81\u8c6b\u9102\u6e58\u7ca4\u6842\u743c\u6e1d\u5ddd\u8d35\u4e91\u85cf\u9655\u7518\u9752\u5b81\u65b0|\u6e2f\u6fb3\u8b66\u5b66\u6302";
    private final KeyboardView mKeyboardView;
    private final TextView[] mNumbersTextView = new TextView[7];
    private View mCommitButton;
    private int mShowKeyboard = 0;
    private TextView mSelectedTextView;
    private Keyboard mProvinceKeyboard;
    private Keyboard mCityCodeKeyboard;
    private Keyboard mNumberKeyboard;
    private Keyboard mNumberExtraKeyboard;
    private String mDefaultPlateNumber;

    public VehiclePlateKeyboard(Context context, OnCommitListener commitListener) {
        super(context, commitListener);
        View contentView = this.putContentView(R.layout.keyboard_vehicle_plate);
        this.mNumbersTextView[0] = (TextView)contentView.findViewById(R.id.keyboard_number_0);
        this.mNumbersTextView[1] = (TextView)contentView.findViewById(R.id.keyboard_number_1);
        this.mNumbersTextView[2] = (TextView)contentView.findViewById(R.id.keyboard_number_2);
        this.mNumbersTextView[3] = (TextView)contentView.findViewById(R.id.keyboard_number_3);
        this.mNumbersTextView[4] = (TextView)contentView.findViewById(R.id.keyboard_number_4);
        this.mNumbersTextView[5] = (TextView)contentView.findViewById(R.id.keyboard_number_5);
        this.mNumbersTextView[6] = (TextView)contentView.findViewById(R.id.keyboard_number_6);
        View.OnClickListener listener = this.createNumberListener();
        for (TextView m : this.mNumbersTextView) {
            m.setOnClickListener(listener);
        }
        this.mProvinceKeyboard = new Keyboard(context, R.xml.keyboard_vehicle_province);
        this.mCityCodeKeyboard = new Keyboard(context, R.xml.keyboard_vehicle_code);
        this.mNumberKeyboard = new Keyboard(context, R.xml.keyboard_vehicle_number);
        this.mNumberExtraKeyboard = new Keyboard(context, R.xml.keyboard_vehicle_number_extra);
        this.mKeyboardView = (KeyboardView)contentView.findViewById(R.id.keyboard_view);
        this.mKeyboardView.setOnKeyboardActionListener((KeyboardView.OnKeyboardActionListener)new OnKeyboardActionHandler(){

            @Override
            public void onKey(int charCode, int[] keyCodes) {
                if (charCode >= 400) {
                    charCode = VehiclePlateKeyboard.CHINESE.charAt(charCode - 400);
                }
                VehiclePlateKeyboard.this.mSelectedTextView.setText((CharSequence)Character.toString((char)charCode));
                VehiclePlateKeyboard.this.nextNumber();
            }
        });
        this.mKeyboardView.setPreviewEnabled(false);
        this.mCommitButton = contentView.findViewById(R.id.keyboard_commit);
        this.mCommitButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String number = VehiclePlateKeyboard.this.getInput(VehiclePlateKeyboard.this.mNumbersTextView);
                if (number.length() == VehiclePlateKeyboard.this.mNumbersTextView.length) {
                    VehiclePlateKeyboard.this.mCommitListener.onCommit(number);
                    VehiclePlateKeyboard.this.dismiss();
                }
            }
        });
    }

    public void setDefaultPlateNumber(String number) {
        this.mDefaultPlateNumber = number;
    }

    @Override
    public void show(View anchorView) {
        if (!TextUtils.isEmpty((CharSequence)this.mDefaultPlateNumber)) {
            if (7 != this.mDefaultPlateNumber.length()) {
                throw new IllegalArgumentException("Illegal vehicle number:" + this.mDefaultPlateNumber);
            }
            char[] numbers = this.mDefaultPlateNumber.toUpperCase().toCharArray();
            for (int i = 0; i < 7; ++i) {
                this.mNumbersTextView[i].setText((CharSequence)Character.toString(numbers[i]));
            }
        }
        super.show(anchorView);
    }

    @Override
    protected void onShow() {
        this.mNumbersTextView[0].performClick();
    }

    private void nextNumber() {
        int viewId = this.mSelectedTextView.getId();
        if (viewId == R.id.keyboard_number_0) {
            this.mNumbersTextView[1].performClick();
        } else if (viewId == R.id.keyboard_number_1) {
            this.mNumbersTextView[2].performClick();
        } else if (viewId == R.id.keyboard_number_2) {
            this.mNumbersTextView[3].performClick();
        } else if (viewId == R.id.keyboard_number_3) {
            this.mNumbersTextView[4].performClick();
        } else if (viewId == R.id.keyboard_number_4) {
            this.mNumbersTextView[5].performClick();
        } else if (viewId == R.id.keyboard_number_5) {
            this.mNumbersTextView[6].performClick();
        } else if (viewId == R.id.keyboard_number_6) {
            this.mCommitButton.performClick();
        }
    }

    private View.OnClickListener createNumberListener() {
        View.OnClickListener listener = new View.OnClickListener(){

            public void onClick(View view) {
                if (VehiclePlateKeyboard.this.mSelectedTextView != null) {
                    VehiclePlateKeyboard.this.mSelectedTextView.setActivated(false);
                }
                VehiclePlateKeyboard.this.mSelectedTextView = (TextView)view;
                VehiclePlateKeyboard.this.mSelectedTextView.setActivated(true);
                int id2 = view.getId();
                if (id2 == R.id.keyboard_number_0) {
                    if (VehiclePlateKeyboard.this.mShowKeyboard != R.xml.keyboard_vehicle_province) {
                        VehiclePlateKeyboard.this.mShowKeyboard = R.xml.keyboard_vehicle_province;
                        VehiclePlateKeyboard.this.mKeyboardView.setKeyboard(VehiclePlateKeyboard.this.mProvinceKeyboard);
                    }
                } else if (id2 == R.id.keyboard_number_1) {
                    if (VehiclePlateKeyboard.this.mShowKeyboard != R.xml.keyboard_vehicle_code) {
                        VehiclePlateKeyboard.this.mShowKeyboard = R.xml.keyboard_vehicle_code;
                        VehiclePlateKeyboard.this.mKeyboardView.setKeyboard(VehiclePlateKeyboard.this.mCityCodeKeyboard);
                    }
                } else if (id2 == R.id.keyboard_number_6) {
                    if (VehiclePlateKeyboard.this.mShowKeyboard != R.xml.keyboard_vehicle_number_extra) {
                        VehiclePlateKeyboard.this.mShowKeyboard = R.xml.keyboard_vehicle_number_extra;
                        VehiclePlateKeyboard.this.mKeyboardView.setKeyboard(VehiclePlateKeyboard.this.mNumberExtraKeyboard);
                    }
                } else if (VehiclePlateKeyboard.this.mShowKeyboard != R.xml.keyboard_vehicle_number) {
                    VehiclePlateKeyboard.this.mShowKeyboard = R.xml.keyboard_vehicle_number;
                    VehiclePlateKeyboard.this.mKeyboardView.setKeyboard(VehiclePlateKeyboard.this.mNumberKeyboard);
                }
                VehiclePlateKeyboard.this.mKeyboardView.invalidateAllKeys();
                VehiclePlateKeyboard.this.mKeyboardView.invalidate();
            }
        };
        return listener;
    }

    public static void create(Activity context, OnCommitListener listener) {
        new VehiclePlateKeyboard((Context)context, listener).show(context.getWindow().getDecorView().getRootView());
    }

    public static VehiclePlateKeyboard create(Context context, OnCommitListener listener) {
        return new VehiclePlateKeyboard(context, listener);
    }
}

