/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.keyboard;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.github.yoojia.keyboard.OnCommitListener;

class AbstractKeyboard {
    private final Context mContext;
    private final PopupWindow mPopupWindow;
    protected final OnCommitListener mCommitListener;

    public AbstractKeyboard(Context context, OnCommitListener commitListener) {
        this.mContext = context;
        this.mCommitListener = commitListener;
        this.mPopupWindow = new PopupWindow(-1, -2);
        this.mPopupWindow.setFocusable(true);
        this.mPopupWindow.setOutsideTouchable(false);
        this.mPopupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable(context.getResources(), (Bitmap)null));
    }

    protected View putContentView(int layoutResId) {
        View view = View.inflate((Context)this.mContext, (int)layoutResId, null);
        this.mPopupWindow.setContentView(view);
        return view;
    }

    public void show(View anchorView) {
        this.mPopupWindow.showAtLocation(anchorView, 81, 0, 0);
        this.onShow();
    }

    protected void onShow() {
    }

    public void dismiss() {
        this.mPopupWindow.dismiss();
    }

    protected String getInput(TextView[] inputs) {
        StringBuilder value = new StringBuilder(inputs.length);
        for (TextView item : inputs) {
            if (TextUtils.isEmpty((CharSequence)item.getText())) continue;
            value.append(item.getText());
        }
        return value.toString();
    }
}

