/*
 * Decompiled with CFR 0.152.
 */
package com.github.yoojia.keyboard;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.text.TextUtils;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.github.yoojia.keyboard.OnKeyboardActionHandler;
import com.github.yoojia.keyboard.OnNumberCommitListener;
import com.github.yoojia.keyboard.R;

public class CoolNumberKeyboard {
    private static final int NUMBER_LEN = 7;
    private static final String CHINESE = "|\u4eac\u6d25\u664b\u5180\u8499\u8fbd\u5409\u9ed1\u6caa\u82cf\u6d59\u7696\u95fd\u8d63\u9c81\u8c6b\u9102\u6e58\u7ca4\u6842\u743c\u6e1d\u5ddd\u8d35\u4e91\u85cf\u9655\u7518\u9752\u5b81\u65b0|\u6e2f\u6fb3\u8b66\u5b66\u6302";
    private final Context mContext;
    private final PopupWindow mPopupWindow;
    private final KeyboardView mKeyboardView;
    private final TextView[] mNumber = new TextView[7];
    private final OnKeyboardActionHandler mKeyboardActionHandler = new OnKeyboardActionHandler(){

        @Override
        public void onKey(int charCode, int[] keyCodes) {
            if (charCode >= 400) {
                charCode = CoolNumberKeyboard.CHINESE.charAt(charCode - 400);
            }
            CoolNumberKeyboard.this.mSelectedTextView.setText((CharSequence)Character.toString((char)charCode));
            CoolNumberKeyboard.this.autoNextNumber();
        }
    };
    private final View.OnClickListener mNumberSelectedHandler = new View.OnClickListener(){

        public void onClick(View view) {
            if (CoolNumberKeyboard.this.mSelectedTextView != null) {
                CoolNumberKeyboard.this.mSelectedTextView.setActivated(false);
            }
            CoolNumberKeyboard.this.mSelectedTextView = (TextView)view;
            CoolNumberKeyboard.this.mSelectedTextView.setActivated(true);
            int id2 = view.getId();
            if (id2 == R.id.keyboard_number_0) {
                if (CoolNumberKeyboard.this.mShowKeyboard != R.xml.keyboard_province) {
                    CoolNumberKeyboard.this.mShowKeyboard = R.xml.keyboard_province;
                    CoolNumberKeyboard.this.mKeyboardView.setKeyboard(CoolNumberKeyboard.this.mProvinceKeyboard);
                }
            } else if (id2 == R.id.keyboard_number_1) {
                if (CoolNumberKeyboard.this.mShowKeyboard != R.xml.keyboard_city_code) {
                    CoolNumberKeyboard.this.mShowKeyboard = R.xml.keyboard_city_code;
                    CoolNumberKeyboard.this.mKeyboardView.setKeyboard(CoolNumberKeyboard.this.mCityCodeKeyboard);
                }
            } else if (id2 == R.id.keyboard_number_6) {
                if (CoolNumberKeyboard.this.mShowKeyboard != R.xml.keyboard_number_extra) {
                    CoolNumberKeyboard.this.mShowKeyboard = R.xml.keyboard_number_extra;
                    CoolNumberKeyboard.this.mKeyboardView.setKeyboard(CoolNumberKeyboard.this.mNumberExtraKeyboard);
                }
            } else if (CoolNumberKeyboard.this.mShowKeyboard != R.xml.keyboard_number) {
                CoolNumberKeyboard.this.mShowKeyboard = R.xml.keyboard_number;
                CoolNumberKeyboard.this.mKeyboardView.setKeyboard(CoolNumberKeyboard.this.mNumberKeyboard);
            }
            CoolNumberKeyboard.this.mKeyboardView.invalidateAllKeys();
            CoolNumberKeyboard.this.mKeyboardView.invalidate();
        }
    };
    private final View.OnClickListener mCommitClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            StringBuilder number = new StringBuilder(7);
            for (TextView i : CoolNumberKeyboard.this.mNumber) {
                if (" ".equals(i.getText())) continue;
                number.append(i.getText());
            }
            if (number.length() == 7) {
                CoolNumberKeyboard.this.mCommitListener.onCommit(number.toString());
                CoolNumberKeyboard.this.dismiss();
            }
        }
    };
    private final boolean mAutoCommit;
    private View mCommitButton;
    private int mShowKeyboard = 0;
    private TextView mSelectedTextView;
    private OnNumberCommitListener mCommitListener;
    private Keyboard mProvinceKeyboard;
    private Keyboard mCityCodeKeyboard;
    private Keyboard mNumberKeyboard;
    private Keyboard mNumberExtraKeyboard;

    public CoolNumberKeyboard(Context context) {
        this(context, false);
    }

    public CoolNumberKeyboard(Context context, boolean autoCommit) {
        this.mContext = context;
        this.mAutoCommit = autoCommit;
        View contentView = View.inflate((Context)context, (int)R.layout.vehicle_keyboard, null);
        this.mNumber[0] = (TextView)contentView.findViewById(R.id.keyboard_number_0);
        this.mNumber[1] = (TextView)contentView.findViewById(R.id.keyboard_number_1);
        this.mNumber[2] = (TextView)contentView.findViewById(R.id.keyboard_number_2);
        this.mNumber[3] = (TextView)contentView.findViewById(R.id.keyboard_number_3);
        this.mNumber[4] = (TextView)contentView.findViewById(R.id.keyboard_number_4);
        this.mNumber[5] = (TextView)contentView.findViewById(R.id.keyboard_number_5);
        this.mNumber[6] = (TextView)contentView.findViewById(R.id.keyboard_number_6);
        for (TextView m : this.mNumber) {
            m.setOnClickListener(this.mNumberSelectedHandler);
        }
        this.mProvinceKeyboard = new Keyboard(this.mContext, R.xml.keyboard_province);
        this.mCityCodeKeyboard = new Keyboard(this.mContext, R.xml.keyboard_city_code);
        this.mNumberKeyboard = new Keyboard(this.mContext, R.xml.keyboard_number);
        this.mNumberExtraKeyboard = new Keyboard(this.mContext, R.xml.keyboard_number_extra);
        this.mKeyboardView = (KeyboardView)contentView.findViewById(R.id.keyboard_view);
        this.mKeyboardView.setOnKeyboardActionListener((KeyboardView.OnKeyboardActionListener)this.mKeyboardActionHandler);
        this.mKeyboardView.setPreviewEnabled(false);
        this.mPopupWindow = new PopupWindow(contentView, -1, -2);
        this.mPopupWindow.setFocusable(true);
        this.mPopupWindow.setOutsideTouchable(false);
        this.mPopupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable(context.getResources(), (Bitmap)null));
        this.mCommitButton = contentView.findViewById(R.id.keyboard_commit);
        this.mCommitButton.setOnClickListener(this.mCommitClickListener);
    }

    public void show(Activity activity, String givenNumber, OnNumberCommitListener commitListener) {
        this.mCommitListener = commitListener;
        this.show(activity.getWindow().getDecorView().getRootView());
        if (TextUtils.isEmpty((CharSequence)givenNumber)) {
            for (TextView i : this.mNumber) {
                i.setText((CharSequence)" ");
            }
        } else {
            if (7 != givenNumber.length()) {
                throw new IllegalArgumentException("Illegal vehicle number length");
            }
            char[] numbers = givenNumber.toUpperCase().toCharArray();
            for (int i = 0; i < 7; ++i) {
                this.mNumber[i].setText((CharSequence)Character.toString(numbers[i]));
            }
        }
    }

    public void dismiss() {
        this.mPopupWindow.dismiss();
    }

    private void autoNextNumber() {
        int numberId = this.mSelectedTextView.getId();
        if (numberId == R.id.keyboard_number_0) {
            this.mNumber[1].performClick();
        } else if (numberId == R.id.keyboard_number_1) {
            this.mNumber[2].performClick();
        } else if (numberId == R.id.keyboard_number_2) {
            this.mNumber[3].performClick();
        } else if (numberId == R.id.keyboard_number_3) {
            this.mNumber[4].performClick();
        } else if (numberId == R.id.keyboard_number_4) {
            this.mNumber[5].performClick();
        } else if (numberId == R.id.keyboard_number_5) {
            this.mNumber[6].performClick();
        } else if (numberId == R.id.keyboard_number_6 && this.mAutoCommit) {
            this.mCommitButton.performClick();
        }
    }

    private void show(View anchorView) {
        this.mPopupWindow.showAtLocation(anchorView, 81, 0, 0);
        this.mNumber[0].performClick();
    }
}

