/*
 * Decompiled with CFR 0.152.
 */
package com.lzh.easythread;

import com.lzh.easythread.CallbackDelegate;
import com.lzh.easythread.Configs;
import com.lzh.easythread.Tools;
import java.util.concurrent.Callable;

final class RunnableWrapper
implements Runnable {
    private String name;
    private CallbackDelegate delegate;
    private Runnable runnable;
    private Callable callable;
    private long delay;

    RunnableWrapper(Configs configs) {
        this.name = configs.name;
        this.delay = configs.delay;
        this.delegate = new CallbackDelegate(configs.callback, configs.deliver, configs.asyncCallback);
    }

    RunnableWrapper setRunnable(Runnable runnable) {
        this.runnable = runnable;
        return this;
    }

    RunnableWrapper setCallable(Callable callable) {
        this.callable = callable;
        return this;
    }

    @Override
    public void run() {
        Thread current = Thread.currentThread();
        Tools.resetThread(current, this.name, this.delegate);
        Tools.sleepThread(this.delay);
        this.delegate.onStart(this.name);
        if (this.runnable != null) {
            this.runnable.run();
        } else if (this.callable != null) {
            try {
                Object result = this.callable.call();
                this.delegate.onSuccess(result);
            }
            catch (Exception e) {
                this.delegate.onError(this.name, e);
            }
        }
        this.delegate.onCompleted(this.name);
    }
}

