/*
 * Decompiled with CFR 0.152.
 */
package com.lzh.easythread;

import android.os.Handler;
import android.os.Looper;
import com.lzh.easythread.CallableWrapper;
import com.lzh.easythread.Callback;
import com.lzh.easythread.RunnableWrapper;
import com.lzh.easythread.Tools;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public final class EasyThread {
    private ExecutorService pool;
    private String defName;
    private Callback defCallback;
    private String name;
    private Callback callback;

    private EasyThread(int type, int size, int priority, String name, Callback callback) {
        this.pool = this.createPool(type, size, priority);
        this.defName = name;
        this.defCallback = callback;
    }

    public EasyThread name(String name) {
        this.name = name;
        return this;
    }

    public EasyThread callback(Callback callback) {
        this.callback = callback;
        return this;
    }

    public void execute(Runnable runnable) {
        this.pool.execute(new RunnableWrapper(this.getName(), this.getCallback(), runnable));
        this.release();
    }

    public <T> Future<T> submit(Callable<T> callable) {
        Future<T> future = this.pool.submit(new CallableWrapper<T>(this.getName(), this.getCallback(), callable));
        this.release();
        return future;
    }

    private void release() {
        this.name = null;
        this.callback = null;
    }

    private String getName() {
        return Tools.isEmpty(this.name) ? this.defName : this.name;
    }

    private Callback getCallback() {
        Callback used;
        Callback callback = used = this.callback == null ? this.defCallback : this.callback;
        if (Tools.isAndroid) {
            return new AndroidCallback(used);
        }
        return used;
    }

    private ExecutorService createPool(int type, int size, int priority) {
        switch (type) {
            case 0: {
                return Executors.newCachedThreadPool(new DefaultFactory(priority));
            }
            case 1: {
                return Executors.newFixedThreadPool(size, new DefaultFactory(priority));
            }
        }
        return Executors.newSingleThreadExecutor(new DefaultFactory(priority));
    }

    public static class Builder {
        static final int TYPE_CACHEABLE = 0;
        static final int TYPE_FIXED = 1;
        static final int TYPE_SINGLE = 2;
        int type;
        int size;
        int priority = 5;
        String name;
        Callback callback;

        private Builder(int size, int type) {
            this.size = size;
            this.type = type;
        }

        public static Builder cacheable() {
            return new Builder(0, 0);
        }

        public static Builder fixed(int size) {
            return new Builder(size, 1);
        }

        public static Builder single() {
            return new Builder(0, 2);
        }

        public Builder name(String name) {
            if (!Tools.isEmpty(name)) {
                this.name = name;
            }
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder callback(Callback callback) {
            this.callback = callback;
            return this;
        }

        public EasyThread build() {
            this.priority = Math.max(1, this.priority);
            this.priority = Math.min(10, this.priority);
            this.size = Math.max(0, this.size);
            if (Tools.isEmpty(this.name)) {
                switch (this.type) {
                    case 0: {
                        this.name = "CACHEABLE";
                        break;
                    }
                    case 1: {
                        this.name = "FIXED";
                        break;
                    }
                    case 2: {
                        this.name = "SINGLE";
                    }
                }
            }
            return new EasyThread(this.type, this.size, this.priority, this.name, this.callback);
        }
    }

    private static class AndroidCallback
    implements Callback {
        private static Handler main = new Handler(Looper.getMainLooper());
        private Callback delegate;

        AndroidCallback(Callback delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onError(final Thread thread, final Throwable t) {
            main.post(new Runnable(){

                @Override
                public void run() {
                    if (AndroidCallback.this.delegate != null) {
                        AndroidCallback.this.delegate.onError(thread, t);
                    }
                }
            });
        }

        @Override
        public void onCompleted(final Thread thread) {
            main.post(new Runnable(){

                @Override
                public void run() {
                    if (AndroidCallback.this.delegate != null) {
                        AndroidCallback.this.delegate.onCompleted(thread);
                    }
                }
            });
        }

        @Override
        public void onStart(final Thread thread) {
            main.post(new Runnable(){

                @Override
                public void run() {
                    if (AndroidCallback.this.delegate != null) {
                        AndroidCallback.this.delegate.onStart(thread);
                    }
                }
            });
        }
    }

    private static class DefaultFactory
    implements ThreadFactory {
        private int priority;

        DefaultFactory(int priority) {
            this.priority = priority;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setPriority(this.priority);
            return thread;
        }
    }
}

