/*
 * Decompiled with CFR 0.152.
 */
package com.chaoliu.spanlite;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Color;
import android.graphics.MaskFilter;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.RequiresApi;
import android.support.annotation.StyleRes;
import android.text.SpannableStringBuilder;
import android.text.method.LinkMovementMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.MaskFilterSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.widget.TextView;

final class Util {
    Util() {
    }

    public static MaskFilterSpan drawBlurMaskFilter(float radius, BlurMaskFilter.Blur style) {
        BlurMaskFilter filter = new BlurMaskFilter(radius, style);
        return new MaskFilterSpan((MaskFilter)filter);
    }

    public static ImageSpan drawImageSpan(Context context, @DrawableRes int drawableRes) {
        return new ImageSpan(context, drawableRes);
    }

    public static ImageSpan drawImageSpan(Drawable drawable, int verticalAlignment) {
        return new ImageSpan(drawable, verticalAlignment);
    }

    public static ImageSpan drawImageDrawableSpan(Context context, @DrawableRes int drawableRes) {
        Drawable d = context.getResources().getDrawable(drawableRes);
        d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
        return new ImageSpan(d);
    }

    public static ImageSpan drawImageSpanWidthHeight(Context context, @DrawableRes int drawableRes, int width, int height) {
        Drawable d = context.getResources().getDrawable(drawableRes);
        d.setBounds(0, 0, width, height);
        return new ImageSpan(d);
    }

    public static UnderlineSpan drawUnderlineSpan() {
        return new UnderlineSpan();
    }

    public static StrikethroughSpan drawStrikethroughSpan() {
        return new StrikethroughSpan();
    }

    public static StyleSpan drawTypeFaceBoldItalic() {
        return Util.drawStyleSpan(3);
    }

    public static StyleSpan drawTypeFaceBold() {
        return Util.drawStyleSpan(1);
    }

    public static StyleSpan drawTypeFaceItalic() {
        return Util.drawStyleSpan(2);
    }

    public static StyleSpan drawTypeFaceNormal() {
        return Util.drawStyleSpan(0);
    }

    private static StyleSpan drawStyleSpan(int style) {
        return new StyleSpan(style);
    }

    public static AbsoluteSizeSpan drawTextSizeAbsolute(int size) {
        return new AbsoluteSizeSpan(size);
    }

    public static RelativeSizeSpan drawTextSizeRelative(float size) {
        return new RelativeSizeSpan(size);
    }

    public static ScaleXSpan drawScaleXSpan(float proportion) {
        return new ScaleXSpan(proportion);
    }

    public static SuperscriptSpan drawSuperscriptSpan() {
        return new SuperscriptSpan();
    }

    public static SubscriptSpan drawSubscriptSpan() {
        return new SubscriptSpan();
    }

    @RequiresApi(api=28)
    public static TypefaceSpan drawTypefaceSpan(Typeface typeface) {
        return new TypefaceSpan(typeface);
    }

    public static TypefaceSpan drawTypefaceSpan(String typeface) {
        return new TypefaceSpan(typeface);
    }

    public static URLSpan drawURLSpan(String url) {
        return new URLSpan(url);
    }

    public static TextAppearanceSpan drawTextAppearanceSpan(Context context, @StyleRes int style) {
        return new TextAppearanceSpan(context, style);
    }

    public static int getColor(String colorString) {
        return Color.parseColor((String)colorString);
    }

    public static ForegroundColorSpan drawTextColorSpan(int color) {
        return new ForegroundColorSpan(color);
    }

    public static BackgroundColorSpan drawTextBackgroundColorSpan(int color) {
        return new BackgroundColorSpan(color);
    }

    public static ForegroundColorSpan drawTextColorSpan(String colorString) {
        return new ForegroundColorSpan(Util.getColor(colorString));
    }

    public static BackgroundColorSpan drawTextBackgroundColorSpan(String colorString) {
        return new BackgroundColorSpan(Util.getColor(colorString));
    }

    public static void setSpanExEx(SpannableStringBuilder spanBuilder, Object what) {
        int length = spanBuilder.length();
        Util.setSpanExEx(spanBuilder, what, 0, length);
    }

    public static void setSpanExIn(SpannableStringBuilder spanBuilder, Object what) {
        int length = spanBuilder.length();
        Util.setSpanExIn(spanBuilder, what, 0, length);
    }

    public static void setSpanInEx(SpannableStringBuilder spanBuilder, Object what) {
        int length = spanBuilder.length();
        Util.setSpanInEx(spanBuilder, what, 0, length);
    }

    public static void setSpanInIn(SpannableStringBuilder spanBuilder, Object what) {
        int length = spanBuilder.length();
        Util.setSpanInIn(spanBuilder, what, 0, length);
    }

    public static void setSpanExEx(SpannableStringBuilder spanBuilder, Object what, int start, int end) {
        spanBuilder.setSpan(what, start, end, 33);
    }

    public static void setSpanExIn(SpannableStringBuilder spanBuilder, Object what, int start, int end) {
        spanBuilder.setSpan(what, start, end, 34);
    }

    public static void setSpanInEx(SpannableStringBuilder spanBuilder, Object what, int start, int end) {
        spanBuilder.setSpan(what, start, end, 17);
    }

    public static void setSpanInIn(SpannableStringBuilder spanBuilder, Object what, int start, int end) {
        spanBuilder.setSpan(what, start, end, 18);
    }

    public static void setSpan(SpannableStringBuilder spanBuilder, Object what, int start, int end, int flags) {
        spanBuilder.setSpan(what, start, end, flags);
    }

    public static void setMovementMethod(TextView spanTv) {
        spanTv.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public static void setHighlightColor(TextView spanTv) {
        spanTv.setHighlightColor(0);
    }
}

