/*
 * Decompiled with CFR 0.152.
 */
package com.creativityapps.gmailbackgroundlibrary;

import android.app.Fragment;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.ArrayRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.creativityapps.gmailbackgroundlibrary.R;
import com.creativityapps.gmailbackgroundlibrary.util.GmailSender;
import com.creativityapps.gmailbackgroundlibrary.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BackgroundMail {
    String TAG = "BackgroundMail";
    private String username;
    private String password;
    private String mailto;
    private String subject;
    private String body;
    private String sendingMessage;
    private String sendingMessageSuccess;
    private String sendingMessageError;
    private boolean processVisibility = true;
    private ArrayList<String> attachments = new ArrayList();
    private Context mContext;
    private OnSuccessCallback onSuccessCallback;
    private OnFailCallback onFailCallback;

    public BackgroundMail(Fragment fragment) {
        this(fragment.getActivity().getApplicationContext());
    }

    public BackgroundMail(Context context) {
        this.mContext = context;
        this.sendingMessage = context.getString(R.string.msg_sending_email);
        this.sendingMessageSuccess = context.getString(R.string.msg_email_sent_successfully);
        this.sendingMessageError = context.getString(R.string.msg_error_sending_email);
    }

    private BackgroundMail(Builder builder) {
        this.mContext = builder.context;
        this.attachments = builder.attachments;
        this.username = builder.username;
        this.password = builder.password;
        this.mailto = builder.mailto;
        this.subject = builder.subject;
        this.body = builder.body;
        this.setSendingMessage(builder.sendingMessage);
        this.setSendingMessageSuccess(builder.sendingMessageSuccess);
        this.setSendingMessageError(builder.sendingMessageError);
        this.processVisibility = builder.processVisibility;
        this.setOnSuccessCallback(builder.onSuccessCallback);
        this.setOnFailCallback(builder.onFailCallback);
    }

    public static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    public static Builder newBuilder(Fragment fragment) {
        return new Builder(fragment.getActivity().getApplicationContext());
    }

    public void setGmailUserName(@NonNull String string2) {
        this.username = string2;
    }

    public void setGmailUserName(@StringRes int strRes) {
        this.username = this.mContext.getResources().getString(strRes);
    }

    @NonNull
    public String getGmailUserName() {
        return this.username;
    }

    public void setGmailPassword(@NonNull String string2) {
        this.password = string2;
    }

    public void setGmailPassword(@StringRes int strRes) {
        this.password = this.mContext.getResources().getString(strRes);
    }

    @NonNull
    public String getGmailPassword() {
        return this.password;
    }

    public void showVisibleProgress(boolean state) {
        this.processVisibility = state;
    }

    public boolean isProgressVisible() {
        return this.processVisibility;
    }

    public void setMailTo(@NonNull String string2) {
        this.mailto = string2;
    }

    public void setMailTo(@StringRes int strRes) {
        this.mailto = this.mContext.getResources().getString(strRes);
    }

    @NonNull
    public String getMailTo() {
        return this.mailto;
    }

    public void setFormSubject(@NonNull String string2) {
        this.subject = string2;
    }

    public void setFormSubject(@StringRes int strRes) {
        this.subject = this.mContext.getResources().getString(strRes);
    }

    @NonNull
    public String getFormSubject() {
        return this.subject;
    }

    public void setFormBody(@NonNull String string2) {
        this.body = string2;
    }

    public void setFormBody(@StringRes int strRes) {
        this.body = this.mContext.getResources().getString(strRes);
    }

    @NonNull
    public String getFormBody() {
        return this.body;
    }

    public void setSendingMessage(@NonNull String string2) {
        this.sendingMessage = string2;
    }

    public void setSendingMessage(@StringRes int strRes) {
        this.sendingMessage = this.mContext.getResources().getString(strRes);
    }

    @NonNull
    public String getSendingMessage() {
        return this.sendingMessage;
    }

    public void setSendingMessageSuccess(@Nullable String string2) {
        this.sendingMessageSuccess = string2;
    }

    public void setSendingMessageSuccess(@StringRes int strRes) {
        this.sendingMessageSuccess = this.mContext.getResources().getString(strRes);
    }

    @Nullable
    public String getSendingMessageSuccess() {
        return this.sendingMessageSuccess;
    }

    public void setSendingMessageError(@Nullable String string2) {
        this.sendingMessageError = string2;
    }

    public void setSendingMessageError(@StringRes int strRes) {
        this.sendingMessageError = this.mContext.getResources().getString(strRes);
    }

    @Nullable
    public String getSeningMessageError() {
        return this.sendingMessageError;
    }

    public void addAttachment(@NonNull String attachment) {
        this.attachments.add(attachment);
    }

    public void addAttachment(@StringRes int strRes) {
        this.attachments.add(this.mContext.getResources().getString(strRes));
    }

    public void addAttachments(@NonNull List<String> attachments) {
        this.attachments.addAll(attachments);
    }

    public void addAttachments(String ... attachments) {
        this.attachments.addAll(Arrays.asList(attachments));
    }

    @NonNull
    public List<String> getAttachments() {
        return this.attachments;
    }

    public void setOnSuccessCallback(OnSuccessCallback onSuccessCallback) {
        this.onSuccessCallback = onSuccessCallback;
    }

    public void setOnFailCallback(OnFailCallback onFailCallback) {
        this.onFailCallback = onFailCallback;
    }

    public void send() {
        if (TextUtils.isEmpty((CharSequence)this.username)) {
            throw new IllegalArgumentException("You didn't set a Gmail username");
        }
        if (TextUtils.isEmpty((CharSequence)this.password)) {
            throw new IllegalArgumentException("You didn't set a Gmail password");
        }
        if (TextUtils.isEmpty((CharSequence)this.mailto)) {
            throw new IllegalArgumentException("You didn't set a Gmail recipient");
        }
        if (TextUtils.isEmpty((CharSequence)this.body)) {
            throw new IllegalArgumentException("You didn't set a body");
        }
        if (TextUtils.isEmpty((CharSequence)this.subject)) {
            throw new IllegalArgumentException("You didn't set a subject");
        }
        if (!Utils.isNetworkAvailable(this.mContext)) {
            Log.d((String)this.TAG, (String)"you need internet connection to send the email");
        }
        new SendEmailTask().execute(new String[0]);
    }

    public static final class Builder {
        private Context context;
        private String username;
        private String password;
        private String mailto;
        private String subject;
        private String body;
        private ArrayList<String> attachments = new ArrayList();
        private String sendingMessage;
        private String sendingMessageSuccess;
        private String sendingMessageError;
        private boolean processVisibility;
        private OnSuccessCallback onSuccessCallback;
        private OnFailCallback onFailCallback;

        private Builder(Context context) {
            this.context = context;
            this.sendingMessage = context.getString(R.string.msg_sending_email);
            this.sendingMessageSuccess = context.getString(R.string.msg_email_sent_successfully);
            this.sendingMessageError = context.getString(R.string.msg_error_sending_email);
        }

        public Builder withUsername(@NonNull String username) {
            this.username = username;
            return this;
        }

        public Builder withUsername(@StringRes int usernameRes) {
            this.username = this.context.getResources().getString(usernameRes);
            return this;
        }

        public Builder withPassword(@NonNull String password) {
            this.password = password;
            return this;
        }

        public Builder withPassword(@StringRes int passwordRes) {
            this.password = this.context.getResources().getString(passwordRes);
            return this;
        }

        public Builder withMailto(@NonNull String mailto) {
            this.mailto = mailto;
            return this;
        }

        public Builder withMailto(@StringRes int mailtoRes) {
            this.mailto = this.context.getResources().getString(mailtoRes);
            return this;
        }

        public Builder withSubject(@NonNull String subject) {
            this.subject = subject;
            return this;
        }

        public Builder withSubject(@StringRes int subjectRes) {
            this.subject = this.context.getResources().getString(subjectRes);
            return this;
        }

        public Builder withBody(@NonNull String body) {
            this.body = body;
            return this;
        }

        public Builder withBody(@StringRes int bodyRes) {
            this.body = this.context.getResources().getString(bodyRes);
            return this;
        }

        public Builder withAttachments(@NonNull ArrayList<String> attachments) {
            this.attachments.addAll(attachments);
            return this;
        }

        public Builder withAttachments(String ... attachments) {
            this.attachments.addAll(Arrays.asList(attachments));
            return this;
        }

        public Builder withAttachments(@ArrayRes int attachmentsRes) {
            this.attachments.addAll(Arrays.asList(this.context.getResources().getStringArray(attachmentsRes)));
            return this;
        }

        public Builder withSendingMessage(@NonNull String sendingMessage) {
            this.sendingMessage = sendingMessage;
            return this;
        }

        public Builder withSendingMessage(@StringRes int sendingMessageRes) {
            this.sendingMessage = this.context.getResources().getString(sendingMessageRes);
            return this;
        }

        public Builder withSendingMessageSuccess(@Nullable String sendingMessageSuccess) {
            this.sendingMessageSuccess = sendingMessageSuccess;
            return this;
        }

        public Builder withSendingMessageSuccess(@StringRes int sendingMessageSuccessRes) {
            this.sendingMessageSuccess = this.context.getResources().getString(sendingMessageSuccessRes);
            return this;
        }

        public Builder withSendingMessageError(@Nullable String sendingMessageError) {
            this.sendingMessageError = sendingMessageError;
            return this;
        }

        public Builder withSendingMessageError(@StringRes int sendingMessageError) {
            this.sendingMessageError = this.context.getResources().getString(sendingMessageError);
            return this;
        }

        public Builder withProcessVisibility(boolean processVisibility) {
            this.processVisibility = processVisibility;
            return this;
        }

        public Builder withOnSuccessCallback(OnSuccessCallback onSuccessCallback) {
            this.onSuccessCallback = onSuccessCallback;
            return this;
        }

        public Builder withOnFailCallback(OnFailCallback onFailCallback) {
            this.onFailCallback = onFailCallback;
            return this;
        }

        public BackgroundMail build() {
            return new BackgroundMail(this);
        }

        public BackgroundMail send() {
            BackgroundMail backgroundMail = this.build();
            backgroundMail.send();
            return backgroundMail;
        }
    }

    public class SendEmailTask
    extends AsyncTask<String, Void, Boolean> {
        private ProgressDialog progressDialog;

        protected void onPreExecute() {
            super.onPreExecute();
            if (BackgroundMail.this.processVisibility) {
                this.progressDialog = new ProgressDialog(BackgroundMail.this.mContext);
                this.progressDialog.setMessage((CharSequence)BackgroundMail.this.sendingMessage);
                this.progressDialog.setCancelable(false);
                this.progressDialog.show();
            }
        }

        protected Boolean doInBackground(String ... arg0) {
            try {
                GmailSender sender = new GmailSender(BackgroundMail.this.username, BackgroundMail.this.password);
                if (!BackgroundMail.this.attachments.isEmpty()) {
                    for (int i = 0; i < BackgroundMail.this.attachments.size(); ++i) {
                        if (((String)BackgroundMail.this.attachments.get(i)).isEmpty()) continue;
                        sender.addAttachment((String)BackgroundMail.this.attachments.get(i));
                    }
                }
                sender.sendMail(BackgroundMail.this.subject, BackgroundMail.this.body, BackgroundMail.this.username, BackgroundMail.this.mailto);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }

        protected void onPostExecute(Boolean result) {
            super.onPostExecute((Object)result);
            if (BackgroundMail.this.processVisibility) {
                this.progressDialog.dismiss();
                if (result.booleanValue()) {
                    if (!TextUtils.isEmpty((CharSequence)BackgroundMail.this.sendingMessageSuccess)) {
                        Toast.makeText((Context)BackgroundMail.this.mContext, (CharSequence)BackgroundMail.this.sendingMessageSuccess, (int)0).show();
                    }
                    if (BackgroundMail.this.onSuccessCallback != null) {
                        BackgroundMail.this.onSuccessCallback.onSuccess();
                    }
                } else {
                    if (!TextUtils.isEmpty((CharSequence)BackgroundMail.this.sendingMessageError)) {
                        Toast.makeText((Context)BackgroundMail.this.mContext, (CharSequence)BackgroundMail.this.sendingMessageError, (int)0).show();
                    }
                    if (BackgroundMail.this.onFailCallback != null) {
                        BackgroundMail.this.onFailCallback.onFail();
                    }
                }
            }
        }
    }

    public static interface OnFailCallback {
        public void onFail();
    }

    public static interface OnSuccessCallback {
        public void onSuccess();
    }
}

