/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.media.MediaMuxer;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.hw.videoprocessor.AudioProcessThread;
import com.hw.videoprocessor.VideoDecodeThread;
import com.hw.videoprocessor.VideoEncodeThread;
import com.hw.videoprocessor.VideoUtil;
import com.hw.videoprocessor.util.AudioFadeUtil;
import com.hw.videoprocessor.util.AudioUtil;
import com.hw.videoprocessor.util.CL;
import com.hw.videoprocessor.util.PcmToWavUtil;
import com.hw.videoprocessor.util.VideoMultiStepProgress;
import com.hw.videoprocessor.util.VideoProgressAve;
import com.hw.videoprocessor.util.VideoProgressListener;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=21)
public class VideoProcessor {
    static final String TAG = "VideoProcessor";
    static final String OUTPUT_MIME_TYPE = "video/avc";
    public static int DEFAULT_FRAME_RATE = 20;
    public static final int DEFAULT_I_FRAME_INTERVAL = 1;
    public static final int DEFAULT_AAC_BITRATE = 192000;
    public static boolean AUDIO_MIX_REPEAT = true;
    static final int TIMEOUT_USEC = 2500;

    public static void scaleVideo(Context context, String input, String output, int outWidth, int outHeight) throws Exception {
        VideoProcessor.processor(context).input(input).output(output).outWidth(outWidth).outHeight(outHeight).process();
    }

    public static void cutVideo(Context context, String input, String output, int startTimeMs, int endTimeMs) throws Exception {
        VideoProcessor.processor(context).input(input).output(output).startTimeMs(startTimeMs).endTimeMs(endTimeMs).process();
    }

    public static void changeVideoSpeed(Context context, String input, String output, float speed) throws Exception {
        VideoProcessor.processor(context).input(input).output(output).speed(speed).process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reverseVideo(Context context, String input, String output, boolean reverseAudio, @Nullable VideoProgressListener listener) throws Exception {
        block8: {
            File tempFile = new File(context.getCacheDir(), System.currentTimeMillis() + ".temp");
            File temp2File = new File(context.getCacheDir(), System.currentTimeMillis() + ".temp2");
            try {
                MediaExtractor extractor = new MediaExtractor();
                extractor.setDataSource(input);
                int trackIndex = VideoUtil.selectTrack(extractor, false);
                extractor.selectTrack(trackIndex);
                int keyFrameCount = 0;
                int frameCount = 0;
                ArrayList<Long> frameTimeStamps = new ArrayList<Long>();
                while (true) {
                    long sampleTime;
                    int flags;
                    if ((flags = extractor.getSampleFlags()) > 0 && (flags & 1) != 0) {
                        ++keyFrameCount;
                    }
                    if ((sampleTime = extractor.getSampleTime()) < 0L) break;
                    frameTimeStamps.add(sampleTime);
                    ++frameCount;
                    extractor.advance();
                }
                extractor.release();
                if (frameCount == keyFrameCount || frameCount == keyFrameCount + 1) {
                    VideoProcessor.reverseVideoNoDecode(input, output, reverseAudio, frameTimeStamps, listener);
                    break block8;
                }
                VideoMultiStepProgress stepProgress = new VideoMultiStepProgress(new float[]{0.45f, 0.1f, 0.45f}, listener);
                stepProgress.setCurrentStep(0);
                float bitrateMultiple = (float)(frameCount - keyFrameCount) / (float)keyFrameCount + 1.0f;
                MediaMetadataRetriever retriever = new MediaMetadataRetriever();
                retriever.setDataSource(input);
                int oriBitrate = Integer.parseInt(retriever.extractMetadata(20));
                int duration = Integer.parseInt(retriever.extractMetadata(9));
                try {
                    VideoProcessor.processor(context).input(input).output(tempFile.getAbsolutePath()).bitrate((int)((float)oriBitrate * bitrateMultiple)).iFrameInterval(0).progressListener(stepProgress).process();
                }
                catch (MediaCodec.CodecException e) {
                    CL.e(e);
                    VideoProcessor.processor(context).input(input).output(tempFile.getAbsolutePath()).bitrate((int)((float)oriBitrate * bitrateMultiple)).iFrameInterval(-1).progressListener(stepProgress).process();
                }
                stepProgress.setCurrentStep(1);
                VideoProcessor.reverseVideoNoDecode(tempFile.getAbsolutePath(), temp2File.getAbsolutePath(), reverseAudio, null, stepProgress);
                int oriIFrameInterval = (int)((float)keyFrameCount / ((float)duration / 1000.0f));
                oriIFrameInterval = oriIFrameInterval == 0 ? 1 : oriIFrameInterval;
                stepProgress.setCurrentStep(2);
                VideoProcessor.processor(context).input(temp2File.getAbsolutePath()).output(output).bitrate(oriBitrate).iFrameInterval(oriIFrameInterval).progressListener(stepProgress).process();
            }
            finally {
                tempFile.delete();
                temp2File.delete();
            }
        }
    }

    public static void processVideo(@NonNull Context context, @NonNull Processor processor) throws Exception {
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(processor.input);
        int originWidth = Integer.parseInt(retriever.extractMetadata(18));
        int originHeight = Integer.parseInt(retriever.extractMetadata(19));
        int rotationValue = Integer.parseInt(retriever.extractMetadata(24));
        int oriBitrate = Integer.parseInt(retriever.extractMetadata(20));
        int durationMs = Integer.parseInt(retriever.extractMetadata(9));
        retriever.release();
        if (processor.bitrate == null) {
            processor.bitrate = oriBitrate;
        }
        if (processor.iFrameInterval == null) {
            processor.iFrameInterval = 1;
        }
        int resultWidth = processor.outWidth == null ? originWidth : processor.outWidth;
        int resultHeight = processor.outHeight == null ? originHeight : processor.outHeight;
        resultWidth = resultWidth % 2 == 0 ? resultWidth : resultWidth + 1;
        int n = resultHeight = resultHeight % 2 == 0 ? resultHeight : resultHeight + 1;
        if (rotationValue == 90 || rotationValue == 270) {
            int temp = resultHeight;
            resultHeight = resultWidth;
            resultWidth = temp;
        }
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(processor.input);
        int videoIndex = VideoUtil.selectTrack(extractor, false);
        int audioIndex = VideoUtil.selectTrack(extractor, true);
        MediaMuxer mediaMuxer = new MediaMuxer(processor.output, 0);
        int muxerAudioTrackIndex = 0;
        boolean shouldChangeAudioSpeed = processor.changeAudioSpeed == null ? true : processor.changeAudioSpeed;
        Integer audioEndTimeMs = processor.endTimeMs;
        if (audioIndex >= 0) {
            MediaFormat audioTrackFormat = extractor.getTrackFormat(audioIndex);
            String audioMimeType = "audio/mp4a-latm";
            int bitrate = AudioUtil.getAudioBitrate(audioTrackFormat);
            int channelCount = audioTrackFormat.getInteger("channel-count");
            int sampleRate = audioTrackFormat.getInteger("sample-rate");
            int maxBufferSize = AudioUtil.getAudioMaxBufferSize(audioTrackFormat);
            MediaFormat audioEncodeFormat = MediaFormat.createAudioFormat((String)audioMimeType, (int)sampleRate, (int)channelCount);
            audioEncodeFormat.setInteger("bitrate", bitrate);
            audioEncodeFormat.setInteger("aac-profile", 2);
            audioEncodeFormat.setInteger("max-input-size", maxBufferSize);
            if (shouldChangeAudioSpeed) {
                if (processor.startTimeMs != null || processor.endTimeMs != null || processor.speed != null) {
                    long durationUs = audioTrackFormat.getLong("durationUs");
                    if (processor.startTimeMs != null && processor.endTimeMs != null) {
                        durationUs = (processor.endTimeMs - processor.startTimeMs) * 1000;
                    }
                    if (processor.speed != null) {
                        durationUs = (long)((float)durationUs / processor.speed.floatValue());
                    }
                    audioEncodeFormat.setLong("durationUs", durationUs);
                }
            } else {
                long videoDurationUs = durationMs * 1000;
                long audioDurationUs = audioTrackFormat.getLong("durationUs");
                if (processor.startTimeMs != null || processor.endTimeMs != null || processor.speed != null) {
                    if (processor.startTimeMs != null && processor.endTimeMs != null) {
                        videoDurationUs = (processor.endTimeMs - processor.startTimeMs) * 1000;
                    }
                    if (processor.speed != null) {
                        videoDurationUs = (long)((float)videoDurationUs / processor.speed.floatValue());
                    }
                    long avDurationUs = videoDurationUs < audioDurationUs ? videoDurationUs : audioDurationUs;
                    audioEncodeFormat.setLong("durationUs", avDurationUs);
                    audioEndTimeMs = (processor.startTimeMs == null ? 0 : processor.startTimeMs) + (int)(avDurationUs / 1000L);
                }
            }
            AudioUtil.checkCsd(audioEncodeFormat, 2, sampleRate, channelCount);
            muxerAudioTrackIndex = mediaMuxer.addTrack(audioEncodeFormat);
        }
        extractor.selectTrack(videoIndex);
        if (processor.startTimeMs != null) {
            extractor.seekTo((long)(processor.startTimeMs * 1000), 0);
        } else {
            extractor.seekTo(0L, 0);
        }
        VideoProgressAve progressAve = new VideoProgressAve(processor.listener);
        progressAve.setSpeed(processor.speed);
        progressAve.setStartTimeMs(processor.startTimeMs == null ? 0 : processor.startTimeMs);
        progressAve.setEndTimeMs(processor.endTimeMs == null ? durationMs : processor.endTimeMs);
        AtomicBoolean decodeDone = new AtomicBoolean(false);
        CountDownLatch muxerStartLatch = new CountDownLatch(1);
        VideoEncodeThread encodeThread = new VideoEncodeThread(extractor, mediaMuxer, processor.bitrate, resultWidth, resultHeight, processor.iFrameInterval, processor.frameRate == null ? DEFAULT_FRAME_RATE : processor.frameRate, videoIndex, decodeDone, muxerStartLatch);
        int srcFrameRate = VideoUtil.getFrameRate(processor.input);
        if (srcFrameRate <= 0) {
            srcFrameRate = (int)Math.ceil(VideoUtil.getAveFrameRate(processor.input));
        }
        VideoDecodeThread decodeThread = new VideoDecodeThread(encodeThread, extractor, processor.startTimeMs, processor.endTimeMs, srcFrameRate, processor.frameRate == null ? DEFAULT_FRAME_RATE : processor.frameRate, processor.speed, processor.dropFrames, videoIndex, decodeDone);
        AudioProcessThread audioProcessThread = new AudioProcessThread(context, processor.input, mediaMuxer, processor.startTimeMs, audioEndTimeMs, shouldChangeAudioSpeed ? processor.speed : null, muxerAudioTrackIndex, muxerStartLatch);
        encodeThread.setProgressAve(progressAve);
        audioProcessThread.setProgressAve(progressAve);
        decodeThread.start();
        encodeThread.start();
        audioProcessThread.start();
        try {
            long s = System.currentTimeMillis();
            decodeThread.join();
            encodeThread.join();
            long e1 = System.currentTimeMillis();
            audioProcessThread.join();
            long e2 = System.currentTimeMillis();
            CL.w(String.format("\u7f16\u89e3\u7801:%dms,\u97f3\u9891:%dms", e1 - s, e2 - s), new Object[0]);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            mediaMuxer.release();
            extractor.release();
        }
        catch (Exception e2) {
            CL.e(e2);
        }
        if (encodeThread.getException() != null) {
            throw encodeThread.getException();
        }
        if (decodeThread.getException() != null) {
            throw decodeThread.getException();
        }
        if (audioProcessThread.getException() != null) {
            throw audioProcessThread.getException();
        }
    }

    public static void reverseVideoNoDecode(String input, String output, boolean reverseAudio) throws IOException {
        VideoProcessor.reverseVideoNoDecode(input, output, reverseAudio, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reverseVideoNoDecode(String input, String output, boolean reverseAudio, List<Long> videoFrameTimeStamps, @Nullable VideoProgressListener listener) throws IOException {
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(input);
        int durationMs = Integer.parseInt(retriever.extractMetadata(9));
        retriever.release();
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(input);
        int videoTrackIndex = VideoUtil.selectTrack(extractor, false);
        int audioTrackIndex = VideoUtil.selectTrack(extractor, true);
        boolean audioExist = audioTrackIndex >= 0;
        int MIN_FRAME_INTERVAL = 10000;
        MediaMuxer mediaMuxer = new MediaMuxer(output, 0);
        extractor.selectTrack(videoTrackIndex);
        MediaFormat videoTrackFormat = extractor.getTrackFormat(videoTrackIndex);
        long videoDurationUs = videoTrackFormat.getLong("durationUs");
        long audioDurationUs = 0L;
        int videoMuxerTrackIndex = mediaMuxer.addTrack(videoTrackFormat);
        int audioMuxerTrackIndex = 0;
        if (audioExist) {
            MediaFormat audioTrackFormat = extractor.getTrackFormat(audioTrackIndex);
            audioMuxerTrackIndex = mediaMuxer.addTrack(audioTrackFormat);
            audioDurationUs = audioTrackFormat.getLong("durationUs");
        }
        mediaMuxer.start();
        int maxBufferSize = videoTrackFormat.getInteger("max-input-size");
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        VideoUtil.seekToLastFrame(extractor, videoTrackIndex, durationMs);
        long lastFrameTimeUs = -1L;
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        try {
            if (videoFrameTimeStamps != null && videoFrameTimeStamps.size() > 0) {
                for (int i = videoFrameTimeStamps.size() - 1; i >= 0; --i) {
                    extractor.seekTo(videoFrameTimeStamps.get(i).longValue(), 2);
                    long sampleTime = extractor.getSampleTime();
                    if (lastFrameTimeUs == -1L) {
                        lastFrameTimeUs = sampleTime;
                    }
                    info.presentationTimeUs = lastFrameTimeUs - sampleTime;
                    info.size = extractor.readSampleData(buffer, 0);
                    info.flags = extractor.getSampleFlags();
                    if (info.size >= 0) {
                        mediaMuxer.writeSampleData(videoMuxerTrackIndex, buffer, info);
                        if (listener == null) continue;
                        float videoProgress = (float)info.presentationTimeUs / (float)videoDurationUs;
                        videoProgress = videoProgress > 1.0f ? 1.0f : videoProgress;
                        listener.onProgress(videoProgress *= 0.7f);
                        continue;
                    }
                    break;
                }
            } else {
                while (true) {
                    long seekTime;
                    long sampleTime = extractor.getSampleTime();
                    if (lastFrameTimeUs == -1L) {
                        lastFrameTimeUs = sampleTime;
                    }
                    info.presentationTimeUs = lastFrameTimeUs - sampleTime;
                    info.size = extractor.readSampleData(buffer, 0);
                    info.flags = extractor.getSampleFlags();
                    if (info.size < 0) break;
                    mediaMuxer.writeSampleData(videoMuxerTrackIndex, buffer, info);
                    if (listener != null) {
                        float videoProgress = (float)info.presentationTimeUs / (float)videoDurationUs;
                        videoProgress = videoProgress > 1.0f ? 1.0f : videoProgress;
                        listener.onProgress(videoProgress *= 0.7f);
                    }
                    if ((seekTime = sampleTime - 10000L) <= 0L) break;
                    extractor.seekTo(seekTime, 0);
                }
            }
            if (audioExist) {
                extractor.unselectTrack(videoTrackIndex);
                extractor.selectTrack(audioTrackIndex);
                if (reverseAudio) {
                    List<Long> audioFrameStamps = VideoUtil.getFrameTimeStampsList(extractor);
                    lastFrameTimeUs = -1L;
                    for (int i = audioFrameStamps.size() - 1; i >= 0; --i) {
                        extractor.seekTo(audioFrameStamps.get(i).longValue(), 2);
                        long sampleTime = extractor.getSampleTime();
                        if (lastFrameTimeUs == -1L) {
                            lastFrameTimeUs = sampleTime;
                        }
                        info.presentationTimeUs = lastFrameTimeUs - sampleTime;
                        info.size = extractor.readSampleData(buffer, 0);
                        info.flags = extractor.getSampleFlags();
                        if (info.size >= 0) {
                            mediaMuxer.writeSampleData(audioMuxerTrackIndex, buffer, info);
                            if (listener == null) continue;
                            float audioProgress = (float)info.presentationTimeUs / (float)audioDurationUs;
                            audioProgress = audioProgress > 1.0f ? 1.0f : audioProgress;
                            audioProgress = 0.7f + audioProgress * 0.3f;
                            listener.onProgress(audioProgress);
                            continue;
                        }
                        break;
                    }
                } else {
                    long sampleTime;
                    extractor.seekTo(0L, 2);
                    while ((sampleTime = extractor.getSampleTime()) != -1L) {
                        info.presentationTimeUs = sampleTime;
                        info.size = extractor.readSampleData(buffer, 0);
                        info.flags = extractor.getSampleFlags();
                        if (info.size >= 0) {
                            mediaMuxer.writeSampleData(audioMuxerTrackIndex, buffer, info);
                            if (listener != null) {
                                float audioProgress = (float)info.presentationTimeUs / (float)audioDurationUs;
                                audioProgress = audioProgress > 1.0f ? 1.0f : audioProgress;
                                audioProgress = 0.7f + audioProgress * 0.3f;
                                listener.onProgress(audioProgress);
                            }
                            extractor.advance();
                            continue;
                        }
                        break;
                    }
                }
            }
            if (listener != null) {
                listener.onProgress(1.0f);
            }
        }
        catch (Exception e) {
            CL.e(e);
        }
        finally {
            extractor.release();
            mediaMuxer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adjustVideoVolume(Context context, String videoInput, String output, @IntRange(from=0L, to=100L) int videoVolume, float faceInSec, float fadeOutSec) throws IOException {
        if (videoVolume == 100 && faceInSec == 0.0f && fadeOutSec == 0.0f) {
            AudioUtil.copyFile(videoInput, output);
            return;
        }
        File cacheDir = new File(context.getCacheDir(), "pcm");
        cacheDir.mkdir();
        MediaExtractor oriExtrator = new MediaExtractor();
        oriExtrator.setDataSource(videoInput);
        int oriAudioIndex = VideoUtil.selectTrack(oriExtrator, true);
        if (oriAudioIndex < 0) {
            CL.e("no audio stream!", new Object[0]);
            AudioUtil.copyFile(videoInput, output);
            return;
        }
        long time = System.currentTimeMillis();
        File videoPcmFile = new File(cacheDir, "video_" + time + ".pcm");
        File videoPcmAdjustedFile = new File(cacheDir, "video_" + time + "_adjust.pcm");
        File videoWavFile = new File(cacheDir, "video_" + time + ".wav");
        AudioUtil.decodeToPCM(videoInput, videoPcmFile.getAbsolutePath(), null, null);
        AudioUtil.adjustPcmVolume(videoPcmFile.getAbsolutePath(), videoPcmAdjustedFile.getAbsolutePath(), videoVolume);
        MediaFormat audioTrackFormat = oriExtrator.getTrackFormat(oriAudioIndex);
        int sampleRate = audioTrackFormat.getInteger("sample-rate");
        int channelCount = audioTrackFormat.containsKey("channel-count") ? audioTrackFormat.getInteger("channel-count") : 1;
        int channelConfig = 16;
        if (channelCount == 2) {
            channelConfig = 12;
        }
        if (faceInSec > 0.0f || fadeOutSec > 0.0f) {
            AudioFadeUtil.audioFade(videoPcmAdjustedFile.getAbsolutePath(), sampleRate, channelCount, faceInSec, fadeOutSec);
        }
        new PcmToWavUtil(sampleRate, channelConfig, channelCount, 2).pcmToWav(videoPcmAdjustedFile.getAbsolutePath(), videoWavFile.getAbsolutePath());
        int TIMEOUT_US = 2500;
        int audioBitrate = AudioUtil.getAudioBitrate(audioTrackFormat);
        int oriVideoIndex = VideoUtil.selectTrack(oriExtrator, false);
        MediaFormat oriVideoFormat = oriExtrator.getTrackFormat(oriVideoIndex);
        int rotation = oriVideoFormat.containsKey("rotation-degrees") ? oriVideoFormat.getInteger("rotation-degrees") : 0;
        MediaMuxer mediaMuxer = new MediaMuxer(output, 0);
        mediaMuxer.setOrientationHint(rotation);
        int muxerVideoIndex = mediaMuxer.addTrack(oriVideoFormat);
        int muxerAudioIndex = mediaMuxer.addTrack(audioTrackFormat);
        mediaMuxer.start();
        MediaExtractor pcmExtrator = new MediaExtractor();
        pcmExtrator.setDataSource(videoWavFile.getAbsolutePath());
        int audioTrack = VideoUtil.selectTrack(pcmExtrator, true);
        pcmExtrator.selectTrack(audioTrack);
        MediaFormat pcmTrackFormat = pcmExtrator.getTrackFormat(audioTrack);
        int maxBufferSize = AudioUtil.getAudioMaxBufferSize(pcmTrackFormat);
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        MediaFormat encodeFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channelCount);
        encodeFormat.setInteger("bitrate", audioBitrate);
        encodeFormat.setInteger("aac-profile", 2);
        encodeFormat.setInteger("max-input-size", maxBufferSize);
        MediaCodec encoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
        encoder.configure(encodeFormat, null, null, 1);
        encoder.start();
        boolean encodeInputDone = false;
        boolean encodeDone = false;
        long lastAudioFrameTimeUs = -1L;
        int AAC_FRAME_TIME_US = 1024000000 / sampleRate;
        boolean detectTimeError = false;
        try {
            long sampleTimeUs;
            block7: while (!encodeDone) {
                int outputBufferIndex;
                int inputBufferIndex = encoder.dequeueInputBuffer(2500L);
                if (!encodeInputDone && inputBufferIndex >= 0) {
                    long sampleTime = pcmExtrator.getSampleTime();
                    if (sampleTime < 0L) {
                        encodeInputDone = true;
                        encoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                    } else {
                        int flags = pcmExtrator.getSampleFlags();
                        buffer.clear();
                        int size = pcmExtrator.readSampleData(buffer, 0);
                        ByteBuffer inputBuffer = encoder.getInputBuffer(inputBufferIndex);
                        inputBuffer.clear();
                        inputBuffer.put(buffer);
                        inputBuffer.position(0);
                        CL.it(TAG, "audio queuePcmBuffer " + sampleTime / 1000L + " size:" + size, new Object[0]);
                        encoder.queueInputBuffer(inputBufferIndex, 0, size, sampleTime, flags);
                        pcmExtrator.advance();
                    }
                }
                while ((outputBufferIndex = encoder.dequeueOutputBuffer(info, 2500L)) != -1) {
                    if (outputBufferIndex == -2) {
                        MediaFormat newFormat = encoder.getOutputFormat();
                        CL.it(TAG, "audio decode newFormat = " + newFormat, new Object[0]);
                        continue;
                    }
                    if (outputBufferIndex < 0) {
                        CL.et(TAG, "unexpected result from audio decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                        continue;
                    }
                    if (info.flags == 4) {
                        encodeDone = true;
                        continue block7;
                    }
                    ByteBuffer encodeOutputBuffer = encoder.getOutputBuffer(outputBufferIndex);
                    CL.it(TAG, "audio writeSampleData " + info.presentationTimeUs + " size:" + info.size + " flags:" + info.flags, new Object[0]);
                    if (!detectTimeError && lastAudioFrameTimeUs != -1L && info.presentationTimeUs < lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US) {
                        CL.et(TAG, "audio \u65f6\u95f4\u6233\u9519\u8bef\uff0clastAudioFrameTimeUs:" + lastAudioFrameTimeUs + " info.presentationTimeUs:" + info.presentationTimeUs, new Object[0]);
                        detectTimeError = true;
                    }
                    if (detectTimeError) {
                        info.presentationTimeUs = lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US;
                        CL.et(TAG, "audio \u65f6\u95f4\u6233\u9519\u8bef\uff0c\u4f7f\u7528\u4fee\u6b63\u7684\u65f6\u95f4\u6233:" + info.presentationTimeUs, new Object[0]);
                        detectTimeError = false;
                    }
                    if (info.flags != 2) {
                        lastAudioFrameTimeUs = info.presentationTimeUs;
                    }
                    mediaMuxer.writeSampleData(muxerAudioIndex, encodeOutputBuffer, info);
                    encodeOutputBuffer.clear();
                    encoder.releaseOutputBuffer(outputBufferIndex, false);
                }
            }
            if (oriAudioIndex >= 0) {
                oriExtrator.unselectTrack(oriAudioIndex);
            }
            oriExtrator.selectTrack(oriVideoIndex);
            oriExtrator.seekTo(0L, 0);
            maxBufferSize = oriVideoFormat.getInteger("max-input-size");
            int frameRate = oriVideoFormat.containsKey("frame-rate") ? oriVideoFormat.getInteger("frame-rate") : (int)Math.ceil(VideoUtil.getAveFrameRate(videoInput));
            buffer = ByteBuffer.allocateDirect(maxBufferSize);
            int VIDEO_FRAME_TIME_US = (int)(1000000.0f / (float)frameRate);
            long lastVideoFrameTimeUs = -1L;
            detectTimeError = false;
            while ((sampleTimeUs = oriExtrator.getSampleTime()) != -1L) {
                info.presentationTimeUs = sampleTimeUs;
                info.flags = oriExtrator.getSampleFlags();
                info.size = oriExtrator.readSampleData(buffer, 0);
                if (info.size < 0) {
                    break;
                }
                if (!detectTimeError && lastVideoFrameTimeUs != -1L && info.presentationTimeUs < lastVideoFrameTimeUs + (long)VIDEO_FRAME_TIME_US) {
                    CL.et(TAG, "video \u65f6\u95f4\u6233\u9519\u8bef\uff0clastVideoFrameTimeUs:" + lastVideoFrameTimeUs + " info.presentationTimeUs:" + info.presentationTimeUs + " VIDEO_FRAME_TIME_US:" + VIDEO_FRAME_TIME_US, new Object[0]);
                    detectTimeError = true;
                }
                if (detectTimeError) {
                    info.presentationTimeUs = lastVideoFrameTimeUs + (long)VIDEO_FRAME_TIME_US;
                    CL.et(TAG, "video \u65f6\u95f4\u6233\u9519\u8bef\uff0c\u4f7f\u7528\u4fee\u6b63\u7684\u65f6\u95f4\u6233:" + info.presentationTimeUs, new Object[0]);
                    detectTimeError = false;
                }
                if (info.flags != 2) {
                    lastVideoFrameTimeUs = info.presentationTimeUs;
                }
                CL.wt(TAG, "video writeSampleData:" + info.presentationTimeUs + " type:" + info.flags + " size:" + info.size, new Object[0]);
                mediaMuxer.writeSampleData(muxerVideoIndex, buffer, info);
                oriExtrator.advance();
            }
        }
        finally {
            videoPcmFile.delete();
            videoPcmAdjustedFile.delete();
            videoWavFile.delete();
            try {
                pcmExtrator.release();
                oriExtrator.release();
                mediaMuxer.release();
                encoder.stop();
                encoder.release();
            }
            catch (Exception e) {
                CL.e(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mixAudioTrack(Context context, final String videoInput, final String audioInput, String output, Integer startTimeMs, Integer endTimeMs, @IntRange(from=0L, to=100L) int videoVolume, @IntRange(from=0L, to=100L) int aacVolume, float fadeInSec, float fadeOutSec) throws IOException {
        int muxerAudioIndex;
        int audioBitrate;
        File wavFile;
        File adjustedPcm;
        int sampleRate;
        int channelCount;
        int videoDurationMs;
        MediaMetadataRetriever retriever;
        Integer endTimeUs;
        File cacheDir = new File(context.getCacheDir(), "pcm");
        cacheDir.mkdir();
        final File videoPcmFile = new File(cacheDir, "video_" + System.currentTimeMillis() + ".pcm");
        File aacPcmFile = new File(cacheDir, "aac_" + System.currentTimeMillis() + ".pcm");
        final Integer startTimeUs = startTimeMs == null ? 0 : startTimeMs * 1000;
        Integer n = endTimeUs = endTimeMs == null ? null : Integer.valueOf(endTimeMs * 1000);
        if (endTimeUs == null) {
            retriever = new MediaMetadataRetriever();
            retriever.setDataSource(videoInput);
            videoDurationMs = Integer.parseInt(retriever.extractMetadata(9));
        } else {
            videoDurationMs = (endTimeUs - startTimeUs) / 1000;
        }
        retriever = new MediaMetadataRetriever();
        retriever.setDataSource(audioInput);
        final int aacDurationMs = Integer.parseInt(retriever.extractMetadata(9));
        retriever.release();
        MediaExtractor oriExtrator = new MediaExtractor();
        oriExtrator.setDataSource(videoInput);
        int oriAudioIndex = VideoUtil.selectTrack(oriExtrator, true);
        MediaExtractor audioExtractor = new MediaExtractor();
        audioExtractor.setDataSource(audioInput);
        int aacAudioIndex = VideoUtil.selectTrack(audioExtractor, true);
        int TIMEOUT_US = 2500;
        int oriVideoIndex = VideoUtil.selectTrack(oriExtrator, false);
        MediaFormat oriVideoFormat = oriExtrator.getTrackFormat(oriVideoIndex);
        int rotation = oriVideoFormat.containsKey("rotation-degrees") ? oriVideoFormat.getInteger("rotation-degrees") : 0;
        MediaMuxer mediaMuxer = new MediaMuxer(output, 0);
        mediaMuxer.setOrientationHint(rotation);
        int muxerVideoIndex = mediaMuxer.addTrack(oriVideoFormat);
        if (oriAudioIndex >= 0) {
            long s1 = System.currentTimeMillis();
            final CountDownLatch latch = new CountDownLatch(2);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AudioUtil.decodeToPCM(videoInput, videoPcmFile.getAbsolutePath(), startTimeUs, endTimeUs);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }).start();
            final File finalAacPcmFile = aacPcmFile;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AudioUtil.decodeToPCM(audioInput, finalAacPcmFile.getAbsolutePath(), 0, aacDurationMs > videoDurationMs ? videoDurationMs * 1000 : aacDurationMs * 1000);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }).start();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            long s2 = System.currentTimeMillis();
            Pair<Integer, Integer> resultPair = AudioUtil.checkAndAdjustAudioFormat(videoPcmFile.getAbsolutePath(), aacPcmFile.getAbsolutePath(), oriExtrator.getTrackFormat(oriAudioIndex), audioExtractor.getTrackFormat(aacAudioIndex));
            channelCount = (Integer)resultPair.first;
            sampleRate = (Integer)resultPair.second;
            audioExtractor.release();
            long s3 = System.currentTimeMillis();
            if (AUDIO_MIX_REPEAT) {
                aacPcmFile = AudioUtil.checkAndFillPcm(aacPcmFile, aacDurationMs, videoDurationMs);
            }
            adjustedPcm = new File(cacheDir, "adjusted_" + System.currentTimeMillis() + ".pcm");
            AudioUtil.mixPcm(videoPcmFile.getAbsolutePath(), aacPcmFile.getAbsolutePath(), adjustedPcm.getAbsolutePath(), videoVolume, aacVolume);
            wavFile = new File(context.getCacheDir(), adjustedPcm.getName() + ".wav");
            long s4 = System.currentTimeMillis();
            int channelConfig = 16;
            if (channelCount == 2) {
                channelConfig = 12;
            }
            if (fadeInSec != 0.0f || fadeOutSec != 0.0f) {
                AudioFadeUtil.audioFade(adjustedPcm.getAbsolutePath(), sampleRate, channelCount, fadeInSec, fadeOutSec);
            }
            new PcmToWavUtil(sampleRate, channelConfig, channelCount, 2).pcmToWav(adjustedPcm.getAbsolutePath(), wavFile.getAbsolutePath());
            long s5 = System.currentTimeMillis();
            CL.et("hwLog", String.format("decode:%dms,resample:%dms,mix:%dms,fade:%dms", s2 - s1, s3 - s2, s4 - s3, s5 - s4), new Object[0]);
            MediaFormat oriAudioFormat = oriExtrator.getTrackFormat(oriAudioIndex);
            audioBitrate = AudioUtil.getAudioBitrate(oriAudioFormat);
            oriAudioFormat.setString("mime", "audio/mp4a-latm");
            AudioUtil.checkCsd(oriAudioFormat, 2, sampleRate, channelCount);
            muxerAudioIndex = mediaMuxer.addTrack(oriAudioFormat);
        } else {
            AudioUtil.decodeToPCM(audioInput, aacPcmFile.getAbsolutePath(), 0, aacDurationMs > videoDurationMs ? videoDurationMs * 1000 : aacDurationMs * 1000);
            MediaFormat audioTrackFormat = audioExtractor.getTrackFormat(aacAudioIndex);
            audioBitrate = AudioUtil.getAudioBitrate(audioTrackFormat);
            channelCount = audioTrackFormat.containsKey("channel-count") ? audioTrackFormat.getInteger("channel-count") : 1;
            sampleRate = audioTrackFormat.containsKey("sample-rate") ? audioTrackFormat.getInteger("sample-rate") : 44100;
            int channelConfig = 16;
            if (channelCount == 2) {
                channelConfig = 12;
            }
            AudioUtil.checkCsd(audioTrackFormat, 2, sampleRate, channelCount);
            audioTrackFormat.setString("mime", "audio/mp4a-latm");
            muxerAudioIndex = mediaMuxer.addTrack(audioTrackFormat);
            sampleRate = audioTrackFormat.getInteger("sample-rate");
            int n2 = channelCount = audioTrackFormat.containsKey("channel-count") ? audioTrackFormat.getInteger("channel-count") : 1;
            if (channelCount > 2) {
                File tempFile = new File(aacPcmFile + ".channel");
                AudioUtil.stereoToMonoSimple(aacPcmFile.getAbsolutePath(), tempFile.getAbsolutePath(), channelCount);
                channelCount = 1;
                aacPcmFile.delete();
                aacPcmFile = tempFile;
            }
            if (aacVolume != 50) {
                adjustedPcm = new File(cacheDir, "adjusted_" + System.currentTimeMillis() + ".pcm");
                AudioUtil.adjustPcmVolume(aacPcmFile.getAbsolutePath(), adjustedPcm.getAbsolutePath(), aacVolume);
            } else {
                adjustedPcm = aacPcmFile;
            }
            channelConfig = 16;
            if (channelCount == 2) {
                channelConfig = 12;
            }
            wavFile = new File(context.getCacheDir(), adjustedPcm.getName() + ".wav");
            if (fadeInSec != 0.0f || fadeOutSec != 0.0f) {
                AudioFadeUtil.audioFade(adjustedPcm.getAbsolutePath(), sampleRate, channelCount, fadeInSec, fadeOutSec);
            }
            new PcmToWavUtil(sampleRate, channelConfig, channelCount, 2).pcmToWav(adjustedPcm.getAbsolutePath(), wavFile.getAbsolutePath());
        }
        mediaMuxer.start();
        MediaExtractor pcmExtrator = new MediaExtractor();
        pcmExtrator.setDataSource(wavFile.getAbsolutePath());
        int audioTrack = VideoUtil.selectTrack(pcmExtrator, true);
        pcmExtrator.selectTrack(audioTrack);
        MediaFormat pcmTrackFormat = pcmExtrator.getTrackFormat(audioTrack);
        int maxBufferSize = AudioUtil.getAudioMaxBufferSize(pcmTrackFormat);
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        MediaFormat encodeFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channelCount);
        encodeFormat.setInteger("bitrate", audioBitrate);
        encodeFormat.setInteger("aac-profile", 2);
        encodeFormat.setInteger("max-input-size", maxBufferSize);
        MediaCodec encoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
        encoder.configure(encodeFormat, null, null, 1);
        encoder.start();
        boolean encodeInputDone = false;
        boolean encodeDone = false;
        long lastAudioFrameTimeUs = -1L;
        int AAC_FRAME_TIME_US = 1024000000 / sampleRate;
        boolean detectTimeError = false;
        try {
            long sampleTimeUs;
            block9: while (!encodeDone) {
                int outputBufferIndex;
                int inputBufferIndex = encoder.dequeueInputBuffer(2500L);
                if (!encodeInputDone && inputBufferIndex >= 0) {
                    long sampleTime = pcmExtrator.getSampleTime();
                    if (sampleTime < 0L) {
                        encodeInputDone = true;
                        encoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                    } else {
                        int flags = pcmExtrator.getSampleFlags();
                        buffer.clear();
                        int size = pcmExtrator.readSampleData(buffer, 0);
                        ByteBuffer inputBuffer = encoder.getInputBuffer(inputBufferIndex);
                        inputBuffer.clear();
                        inputBuffer.put(buffer);
                        inputBuffer.position(0);
                        CL.it(TAG, "audio queuePcmBuffer " + sampleTime / 1000L + " size:" + size, new Object[0]);
                        encoder.queueInputBuffer(inputBufferIndex, 0, size, sampleTime, flags);
                        pcmExtrator.advance();
                    }
                }
                while ((outputBufferIndex = encoder.dequeueOutputBuffer(info, 2500L)) != -1) {
                    if (outputBufferIndex == -2) {
                        MediaFormat newFormat = encoder.getOutputFormat();
                        CL.it(TAG, "audio decode newFormat = " + newFormat, new Object[0]);
                        continue;
                    }
                    if (outputBufferIndex < 0) {
                        CL.et(TAG, "unexpected result from audio decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                        continue;
                    }
                    if (info.flags == 4) {
                        encodeDone = true;
                        continue block9;
                    }
                    ByteBuffer encodeOutputBuffer = encoder.getOutputBuffer(outputBufferIndex);
                    CL.it(TAG, "audio writeSampleData " + info.presentationTimeUs + " size:" + info.size + " flags:" + info.flags, new Object[0]);
                    if (!detectTimeError && lastAudioFrameTimeUs != -1L && info.presentationTimeUs < lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US) {
                        CL.et(TAG, "audio \u65f6\u95f4\u6233\u9519\u8bef\uff0clastAudioFrameTimeUs:" + lastAudioFrameTimeUs + " info.presentationTimeUs:" + info.presentationTimeUs, new Object[0]);
                        detectTimeError = true;
                    }
                    if (detectTimeError) {
                        info.presentationTimeUs = lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US;
                        CL.et(TAG, "audio \u65f6\u95f4\u6233\u9519\u8bef\uff0c\u4f7f\u7528\u4fee\u6b63\u7684\u65f6\u95f4\u6233:" + info.presentationTimeUs, new Object[0]);
                        detectTimeError = false;
                    }
                    if (info.flags != 2) {
                        lastAudioFrameTimeUs = info.presentationTimeUs;
                    }
                    mediaMuxer.writeSampleData(muxerAudioIndex, encodeOutputBuffer, info);
                    encodeOutputBuffer.clear();
                    encoder.releaseOutputBuffer(outputBufferIndex, false);
                }
            }
            if (oriAudioIndex >= 0) {
                oriExtrator.unselectTrack(oriAudioIndex);
            }
            oriExtrator.selectTrack(oriVideoIndex);
            oriExtrator.seekTo((long)startTimeUs.intValue(), 0);
            maxBufferSize = oriVideoFormat.getInteger("max-input-size");
            int frameRate = oriVideoFormat.containsKey("frame-rate") ? oriVideoFormat.getInteger("frame-rate") : (int)Math.ceil(VideoUtil.getAveFrameRate(videoInput));
            buffer = ByteBuffer.allocateDirect(maxBufferSize);
            int VIDEO_FRAME_TIME_US = (int)(1000000.0f / (float)frameRate);
            long lastVideoFrameTimeUs = -1L;
            detectTimeError = false;
            while ((sampleTimeUs = oriExtrator.getSampleTime()) != -1L) {
                if (sampleTimeUs < (long)startTimeUs.intValue()) {
                    oriExtrator.advance();
                    continue;
                }
                if (endTimeUs != null && sampleTimeUs > (long)endTimeUs.intValue()) {
                    break;
                }
                info.presentationTimeUs = sampleTimeUs - (long)startTimeUs.intValue();
                info.flags = oriExtrator.getSampleFlags();
                info.size = oriExtrator.readSampleData(buffer, 0);
                if (info.size < 0) {
                    break;
                }
                if (!detectTimeError && lastVideoFrameTimeUs != -1L && info.presentationTimeUs < lastVideoFrameTimeUs + (long)VIDEO_FRAME_TIME_US) {
                    CL.et(TAG, "video \u65f6\u95f4\u6233\u9519\u8bef\uff0clastVideoFrameTimeUs:" + lastVideoFrameTimeUs + " info.presentationTimeUs:" + info.presentationTimeUs + " VIDEO_FRAME_TIME_US:" + VIDEO_FRAME_TIME_US, new Object[0]);
                    detectTimeError = true;
                }
                if (detectTimeError) {
                    info.presentationTimeUs = lastVideoFrameTimeUs + (long)VIDEO_FRAME_TIME_US;
                    CL.et(TAG, "video \u65f6\u95f4\u6233\u9519\u8bef\uff0c\u4f7f\u7528\u4fee\u6b63\u7684\u65f6\u95f4\u6233:" + info.presentationTimeUs, new Object[0]);
                    detectTimeError = false;
                }
                if (info.flags != 2) {
                    lastVideoFrameTimeUs = info.presentationTimeUs;
                }
                CL.wt(TAG, "video writeSampleData:" + info.presentationTimeUs + " type:" + info.flags + " size:" + info.size, new Object[0]);
                mediaMuxer.writeSampleData(muxerVideoIndex, buffer, info);
                oriExtrator.advance();
            }
        }
        finally {
            aacPcmFile.delete();
            videoPcmFile.delete();
            adjustedPcm.delete();
            wavFile.delete();
            try {
                pcmExtrator.release();
                oriExtrator.release();
                encoder.stop();
                encoder.release();
                mediaMuxer.release();
            }
            catch (Exception e) {
                CL.e(e);
            }
        }
    }

    public static Processor processor(Context context) {
        return new Processor(context);
    }

    public static class Processor {
        private Context context;
        private String input;
        private String output;
        @Nullable
        private Integer outWidth;
        @Nullable
        private Integer outHeight;
        @Nullable
        private Integer startTimeMs;
        @Nullable
        private Integer endTimeMs;
        @Nullable
        private Float speed;
        @Nullable
        private Boolean changeAudioSpeed;
        @Nullable
        private Integer bitrate;
        @Nullable
        private Integer frameRate;
        @Nullable
        private Integer iFrameInterval;
        @Nullable
        private VideoProgressListener listener;
        private boolean dropFrames = true;

        public Processor(Context context) {
            this.context = context;
        }

        public Processor input(String input) {
            this.input = input;
            return this;
        }

        public Processor output(String output) {
            this.output = output;
            return this;
        }

        public Processor outWidth(int outWidth) {
            this.outWidth = outWidth;
            return this;
        }

        public Processor outHeight(int outHeight) {
            this.outHeight = outHeight;
            return this;
        }

        public Processor startTimeMs(int startTimeMs) {
            this.startTimeMs = startTimeMs;
            return this;
        }

        public Processor endTimeMs(int endTimeMs) {
            this.endTimeMs = endTimeMs;
            return this;
        }

        public Processor speed(float speed) {
            this.speed = Float.valueOf(speed);
            return this;
        }

        public Processor changeAudioSpeed(boolean changeAudioSpeed) {
            this.changeAudioSpeed = changeAudioSpeed;
            return this;
        }

        public Processor bitrate(int bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public Processor frameRate(int frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public Processor iFrameInterval(int iFrameInterval) {
            this.iFrameInterval = iFrameInterval;
            return this;
        }

        public Processor dropFrames(boolean dropFrames) {
            this.dropFrames = dropFrames;
            return this;
        }

        public Processor progressListener(VideoProgressListener listener) {
            this.listener = listener;
            return this;
        }

        public void process() throws Exception {
            VideoProcessor.processVideo(this.context, this);
        }
    }
}

