/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor.util;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.hw.videoprocessor.VideoUtil;
import com.hw.videoprocessor.jssrc.SSRC;
import com.hw.videoprocessor.util.CL;
import com.hw.videoprocessor.util.PcmToWavUtil;
import com.hw.videoprocessor.util.VideoProgressListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import net.surina.soundtouch.SoundTouch;

public class AudioUtil {
    static final String TAG = "VideoProcessor";
    public static int VOLUMN_MAX_RATIO = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adjustPcmVolume(String fromPath, String toPath, @IntRange(from=0L, to=100L) int volume) throws IOException {
        if (volume == 100) {
            AudioUtil.copyFile(fromPath, toPath);
            return;
        }
        float vol = AudioUtil.normalizeVolume(volume);
        byte[] buffer = new byte[2048];
        FileInputStream fileInputStream = new FileInputStream(fromPath);
        FileOutputStream fileOutputStream = new FileOutputStream(toPath);
        try {
            while (fileInputStream.read(buffer) != -1) {
                for (int i = 0; i < buffer.length; i += 2) {
                    int tmp = buffer[i] & 0xFF | (buffer[i + 1] & 0xFF) << 8;
                    if ((tmp = (int)((float)tmp * vol)) > Short.MAX_VALUE) {
                        tmp = Short.MAX_VALUE;
                    } else if (tmp < Short.MIN_VALUE) {
                        tmp = Short.MIN_VALUE;
                    }
                    buffer[i] = (byte)(tmp & 0xFF);
                    buffer[i + 1] = (byte)(tmp >>> 8 & 0xFF);
                }
                fileOutputStream.write(buffer);
            }
        }
        finally {
            fileInputStream.close();
            fileOutputStream.close();
        }
    }

    public static void adjustAacVolume(Context context, String aacPath, String outPath, @IntRange(from=0L, to=100L) int volume, @Nullable VideoProgressListener listener) throws IOException {
        String name = new File(aacPath).getName();
        File pcmFile = new File(VideoUtil.getVideoCacheDir(context), name + ".pcm");
        File pcmFile2 = new File(VideoUtil.getVideoCacheDir(context), name + "_2.pcm");
        File wavFile = new File(VideoUtil.getVideoCacheDir(context), name + ".wav");
        AudioUtil.decodeToPCM(aacPath, pcmFile.getAbsolutePath(), null, null);
        AudioUtil.adjustPcmVolume(pcmFile.getAbsolutePath(), pcmFile2.getAbsolutePath(), volume);
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(aacPath);
        int trackIndex = VideoUtil.selectTrack(extractor, true);
        MediaFormat aacFormat = extractor.getTrackFormat(trackIndex);
        int sampleRate = aacFormat.getInteger("sample-rate");
        int oriChannelCount = aacFormat.getInteger("channel-count");
        int channelConfig = 16;
        if (oriChannelCount == 2) {
            channelConfig = 12;
        }
        new PcmToWavUtil(sampleRate, channelConfig, oriChannelCount, 2).pcmToWav(pcmFile2.getAbsolutePath(), wavFile.getAbsolutePath());
        AudioUtil.encodeWAVToAAC(wavFile.getPath(), outPath, aacFormat, listener);
    }

    private static float normalizeVolume(@IntRange(from=0L, to=100L) int volume) {
        return (float)volume / 100.0f * (float)VOLUMN_MAX_RATIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mixPcm(String pcm1Path, String pcm2Path, String toPath, @IntRange(from=0L, to=100L) int volume1, @IntRange(from=0L, to=100L) int volume2) throws IOException {
        float vol1 = AudioUtil.normalizeVolume(volume1);
        float vol2 = AudioUtil.normalizeVolume(volume2);
        byte[] buffer1 = new byte[2048];
        byte[] buffer2 = new byte[2048];
        byte[] buffer3 = new byte[2048];
        FileInputStream is1 = new FileInputStream(pcm1Path);
        FileInputStream is2 = new FileInputStream(pcm2Path);
        FileOutputStream fileOutputStream = new FileOutputStream(toPath);
        boolean end1 = false;
        boolean end2 = false;
        try {
            while (!end1 || !end2) {
                if (!end1) {
                    end1 = is1.read(buffer1) == -1;
                    System.arraycopy(buffer1, 0, buffer3, 0, buffer1.length);
                }
                if (!end2) {
                    end2 = is2.read(buffer2) == -1;
                    for (int i = 0; i < buffer2.length; i += 2) {
                        short temp2 = (short)(buffer2[i] & 0xFF | (buffer2[i + 1] & 0xFF) << 8);
                        short temp1 = (short)(buffer1[i] & 0xFF | (buffer1[i + 1] & 0xFF) << 8);
                        int temp = (int)((float)temp2 * vol2 + (float)temp1 * vol1);
                        if (temp > Short.MAX_VALUE) {
                            temp = Short.MAX_VALUE;
                        } else if (temp < Short.MIN_VALUE) {
                            temp = Short.MIN_VALUE;
                        }
                        buffer3[i] = (byte)(temp & 0xFF);
                        buffer3[i + 1] = (byte)(temp >>> 8 & 0xFF);
                    }
                }
                fileOutputStream.write(buffer3);
            }
        }
        finally {
            is1.close();
            is2.close();
            fileOutputStream.close();
        }
    }

    public static void stereoToMono(String from, String to) throws IOException {
        AudioUtil.stereoToMonoSimple(from, to, 2);
    }

    public static void stereoToMonoSimple(String from, String to, @IntRange(from=2L) int srcChannelCount) throws IOException {
        FileInputStream is = new FileInputStream(from);
        FileOutputStream os = new FileOutputStream(to);
        byte[] buffer1 = new byte[1024 * srcChannelCount];
        byte[] buffer2 = new byte[1024];
        while (is.read(buffer1) != -1) {
            for (int i = 0; i < buffer2.length; i += 2) {
                buffer2[i] = buffer1[srcChannelCount * i];
                buffer2[i + 1] = buffer1[srcChannelCount * i + 1];
            }
            os.write(buffer2);
        }
        is.close();
        os.close();
    }

    public static void copyFile(String from, String to) throws IOException {
        FileChannel toChannel = new FileOutputStream(to).getChannel();
        FileChannel fromChannel = new FileInputStream(from).getChannel();
        fromChannel.transferTo(0L, fromChannel.size(), toChannel);
    }

    public static boolean isStereo(String aacPath) throws IOException {
        String mime;
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(aacPath);
        MediaFormat format = null;
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks && !(mime = (format = extractor.getTrackFormat(i)).getString("mime")).startsWith("audio/"); ++i) {
        }
        extractor.release();
        if (format == null) {
            return false;
        }
        return format.getInteger("channel-count") > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Integer, Integer> checkAndAdjustAudioFormat(String pcm1, String pcm2, MediaFormat format1, MediaFormat format2) {
        int sampleRate2;
        int DEFAULT_SAMPLE_RATE = 44100;
        int channelCount1 = format1.containsKey("channel-count") ? format1.getInteger("channel-count") : 1;
        int channelCount2 = format2.containsKey("channel-count") ? format2.getInteger("channel-count") : 1;
        int sampleRate1 = format1.containsKey("sample-rate") ? format1.getInteger("sample-rate") : 44100;
        int n = sampleRate2 = format2.containsKey("sample-rate") ? format2.getInteger("sample-rate") : 44100;
        if (channelCount1 == channelCount2 && sampleRate1 == sampleRate2 && channelCount1 <= 2) {
            return new Pair((Object)channelCount1, (Object)sampleRate1);
        }
        File temp1 = new File(pcm1 + ".temp");
        File temp2 = new File(pcm2 + ".temp");
        int channelCount = channelCount1;
        int sampleRate = sampleRate1;
        try {
            File file;
            if (channelCount1 != channelCount2 || channelCount1 > 2 || channelCount2 > 2) {
                if (channelCount1 > 1) {
                    AudioUtil.stereoToMonoSimple(pcm1, temp1.getAbsolutePath(), channelCount1);
                    file = new File(pcm1);
                    file.delete();
                    temp1.renameTo(file);
                    channelCount1 = 1;
                }
                if (channelCount2 > 1) {
                    AudioUtil.stereoToMonoSimple(pcm2, temp2.getAbsolutePath(), channelCount2);
                    file = new File(pcm2);
                    file.delete();
                    temp2.renameTo(file);
                    channelCount2 = 1;
                }
                channelCount = 1;
            } else {
                channelCount = channelCount1;
            }
            if (sampleRate1 != sampleRate2) {
                sampleRate = Math.min(sampleRate1, sampleRate2);
                if (sampleRate1 != sampleRate) {
                    AudioUtil.reSamplePcm(pcm1, temp1.getAbsolutePath(), sampleRate1, sampleRate, channelCount1);
                    file = new File(pcm1);
                    file.delete();
                    temp1.renameTo(file);
                }
                if (sampleRate2 != sampleRate) {
                    AudioUtil.reSamplePcm(pcm2, temp2.getAbsolutePath(), sampleRate2, sampleRate, channelCount2);
                    file = new File(pcm2);
                    file.delete();
                    temp2.renameTo(file);
                }
            }
            file = new Pair((Object)channelCount, (Object)sampleRate);
            return file;
        }
        catch (Exception e) {
            CL.e(e);
            Pair pair = new Pair((Object)channelCount, (Object)sampleRate);
            return pair;
        }
        finally {
            temp1.delete();
            temp2.exists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File checkAndFillPcm(File aacPcmFile, int pcmDuration, int fileToDuration) {
        if (pcmDuration >= fileToDuration) {
            return aacPcmFile;
        }
        File cacheFile = new File(aacPcmFile.getAbsolutePath() + ".concat");
        FileInputStream is = null;
        FileOutputStream os = null;
        AbstractInterruptibleChannel from = null;
        AbstractInterruptibleChannel to = null;
        try {
            float repeat = (float)fileToDuration / (float)pcmDuration;
            int repeatInt = (int)repeat;
            is = new FileInputStream(aacPcmFile);
            os = new FileOutputStream(cacheFile);
            from = is.getChannel();
            to = os.getChannel();
            for (int i = 0; i < repeatInt; ++i) {
                ((FileChannel)from).transferTo(0L, ((FileChannel)from).size(), (WritableByteChannel)((Object)to));
                ((FileChannel)from).position(0L);
            }
            float remain = repeat - (float)repeatInt;
            int remainSize = (int)((float)aacPcmFile.length() * remain);
            if (remainSize > 1024) {
                ((FileChannel)from).transferTo(0L, remainSize, (WritableByteChannel)((Object)to));
            }
            from.close();
            to.close();
            aacPcmFile.delete();
            cacheFile.renameTo(aacPcmFile);
            File file = aacPcmFile;
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheFile.delete();
            File file = aacPcmFile;
            return file;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                if (from != null) {
                    from.close();
                }
                if (to != null) {
                    to.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeToPCM(String audioPath, String outPath, Integer startTimeUs, Integer endTimeUs) throws IOException {
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(audioPath);
        int audioTrack = VideoUtil.selectTrack(extractor, true);
        extractor.selectTrack(audioTrack);
        if (startTimeUs == null) {
            startTimeUs = 0;
        }
        extractor.seekTo((long)startTimeUs.intValue(), 2);
        MediaFormat oriAudioFormat = extractor.getTrackFormat(audioTrack);
        int maxBufferSize = oriAudioFormat.containsKey("max-input-size") ? oriAudioFormat.getInteger("max-input-size") : 100000;
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        MediaCodec decoder = MediaCodec.createDecoderByType((String)oriAudioFormat.getString("mime"));
        decoder.configure(oriAudioFormat, null, null, 0);
        decoder.start();
        boolean decodeDone = false;
        boolean decodeInputDone = false;
        int TIMEOUT_US = 2500;
        File pcmFile = new File(outPath);
        FileChannel writeChannel = new FileOutputStream(pcmFile).getChannel();
        try {
            while (!decodeDone) {
                int outputBufferIndex;
                if (!decodeInputDone) {
                    boolean eof = false;
                    int decodeInputIndex = decoder.dequeueInputBuffer(2500L);
                    if (decodeInputIndex >= 0) {
                        long sampleTimeUs = extractor.getSampleTime();
                        if (sampleTimeUs == -1L) {
                            eof = true;
                        } else {
                            if (sampleTimeUs < (long)startTimeUs.intValue()) {
                                extractor.advance();
                                continue;
                            }
                            if (endTimeUs != null && sampleTimeUs > (long)endTimeUs.intValue()) {
                                eof = true;
                            }
                        }
                        if (eof) {
                            decodeInputDone = true;
                            decoder.queueInputBuffer(decodeInputIndex, 0, 0, 0L, 4);
                        } else {
                            info.size = extractor.readSampleData(buffer, 0);
                            info.presentationTimeUs = sampleTimeUs;
                            info.flags = extractor.getSampleFlags();
                            ByteBuffer inputBuffer = decoder.getInputBuffer(decodeInputIndex);
                            inputBuffer.put(buffer);
                            CL.it(TAG, "audio decode queueInputBuffer " + info.presentationTimeUs / 1000L, new Object[0]);
                            decoder.queueInputBuffer(decodeInputIndex, 0, info.size, info.presentationTimeUs, info.flags);
                            extractor.advance();
                        }
                    }
                }
                while (!decodeDone && (outputBufferIndex = decoder.dequeueOutputBuffer(info, 2500L)) != -1) {
                    if (outputBufferIndex == -2) {
                        MediaFormat newFormat = decoder.getOutputFormat();
                        CL.it(TAG, "audio decode newFormat = " + newFormat, new Object[0]);
                        continue;
                    }
                    if (outputBufferIndex < 0) {
                        CL.et(TAG, "unexpected result from audio decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                        continue;
                    }
                    if (info.flags == 4) {
                        decodeDone = true;
                    } else {
                        ByteBuffer decodeOutputBuffer = decoder.getOutputBuffer(outputBufferIndex);
                        CL.it(TAG, "audio decode saveFrame " + info.presentationTimeUs / 1000L, new Object[0]);
                        writeChannel.write(decodeOutputBuffer);
                    }
                    decoder.releaseOutputBuffer(outputBufferIndex, false);
                }
            }
        }
        finally {
            writeChannel.close();
            extractor.release();
            decoder.stop();
            decoder.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encodeWAVToAAC(String wavPath, String outPath, MediaFormat aacFormat, @Nullable VideoProgressListener listener) throws IOException {
        int sampleRate = aacFormat.getInteger("sample-rate");
        int channelCount = aacFormat.getInteger("channel-count");
        int bitrate = AudioUtil.getAudioBitrate(aacFormat);
        int maxBufferSize = AudioUtil.getAudioMaxBufferSize(aacFormat);
        MediaCodec encoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
        MediaFormat encodeFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channelCount);
        encodeFormat.setInteger("bitrate", bitrate);
        encodeFormat.setInteger("aac-profile", 2);
        encodeFormat.setInteger("max-input-size", maxBufferSize);
        encoder.configure(encodeFormat, null, null, 1);
        encoder.start();
        MediaExtractor wavExtrator = new MediaExtractor();
        wavExtrator.setDataSource(wavPath);
        int audioTrackIndex = VideoUtil.selectTrack(wavExtrator, true);
        wavExtrator.selectTrack(audioTrackIndex);
        MediaFormat pcmTrackFormat = wavExtrator.getTrackFormat(audioTrackIndex);
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        maxBufferSize = AudioUtil.getAudioMaxBufferSize(pcmTrackFormat);
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        long durationUs = pcmTrackFormat.getLong("durationUs");
        boolean encodeInputDone = false;
        long lastAudioFrameTimeUs = -1L;
        int TIMEOUT_US = 2500;
        int AAC_FRAME_TIME_US = 1024000000 / sampleRate;
        boolean detectTimeError = false;
        MediaMuxer mediaMuxer = new MediaMuxer(outPath, 0);
        int muxerTrackIndex = mediaMuxer.addTrack(aacFormat);
        mediaMuxer.start();
        try {
            boolean encodeDone = false;
            block3: while (!encodeDone) {
                int outputBufferIndex;
                int inputBufferIndex = encoder.dequeueInputBuffer(2500L);
                if (!encodeInputDone && inputBufferIndex >= 0) {
                    long sampleTime = wavExtrator.getSampleTime();
                    if (sampleTime < 0L) {
                        encodeInputDone = true;
                        encoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                    } else {
                        int flags = wavExtrator.getSampleFlags();
                        buffer.clear();
                        int size = wavExtrator.readSampleData(buffer, 0);
                        ByteBuffer inputBuffer = encoder.getInputBuffer(inputBufferIndex);
                        inputBuffer.clear();
                        inputBuffer.put(buffer);
                        inputBuffer.position(0);
                        CL.i("audio queuePcmBuffer " + sampleTime / 1000L + " size:" + size, new Object[0]);
                        encoder.queueInputBuffer(inputBufferIndex, 0, size, sampleTime, flags);
                        wavExtrator.advance();
                    }
                }
                while ((outputBufferIndex = encoder.dequeueOutputBuffer(info, 2500L)) != -1) {
                    if (outputBufferIndex == -2) {
                        MediaFormat newFormat = encoder.getOutputFormat();
                        CL.i("audio decode newFormat = " + newFormat, new Object[0]);
                        continue;
                    }
                    if (outputBufferIndex < 0) {
                        CL.e("unexpected result from audio decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                        continue;
                    }
                    if (info.flags == 4) {
                        encodeDone = true;
                        continue block3;
                    }
                    ByteBuffer encodeOutputBuffer = encoder.getOutputBuffer(outputBufferIndex);
                    CL.i("audio writeSampleData " + info.presentationTimeUs + " size:" + info.size + " flags:" + info.flags, new Object[0]);
                    if (!detectTimeError && lastAudioFrameTimeUs != -1L && info.presentationTimeUs < lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US) {
                        CL.e("audio \u65f6\u95f4\u6233\u9519\u8bef\uff0clastAudioFrameTimeUs:" + lastAudioFrameTimeUs + " info.presentationTimeUs:" + info.presentationTimeUs, new Object[0]);
                        detectTimeError = true;
                    }
                    if (detectTimeError) {
                        info.presentationTimeUs = lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US;
                        CL.e("audio \u65f6\u95f4\u6233\u9519\u8bef\uff0c\u4f7f\u7528\u4fee\u6b63\u7684\u65f6\u95f4\u6233:" + info.presentationTimeUs, new Object[0]);
                        detectTimeError = false;
                    }
                    if (info.flags != 2) {
                        lastAudioFrameTimeUs = info.presentationTimeUs;
                    }
                    mediaMuxer.writeSampleData(muxerTrackIndex, encodeOutputBuffer, info);
                    if (listener != null) {
                        float encodeProgress = (float)(info.presentationTimeUs - 0L) / (float)durationUs;
                        encodeProgress = encodeProgress < 0.0f ? 0.0f : encodeProgress;
                        encodeProgress = encodeProgress > 1.0f ? 1.0f : encodeProgress;
                        listener.onProgress(0.5f + encodeProgress * 0.5f);
                    }
                    encodeOutputBuffer.clear();
                    encoder.releaseOutputBuffer(outputBufferIndex, false);
                }
            }
        }
        finally {
            wavExtrator.release();
            encoder.release();
            mediaMuxer.release();
        }
    }

    public static boolean reSamplePcm(String srcPath, String dstPath, int srcSampleRate, int dstSampleRate, int srcChannelCount) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(srcPath);
            fos = new FileOutputStream(dstPath);
            new SSRC(fis, fos, srcSampleRate, dstSampleRate, 2, 2, srcChannelCount, (int)new File(srcPath).length(), 0.0, 0, true);
        }
        catch (IOException e) {
            CL.e(e);
            e.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reversePcm(String srcPath, String dstPath) throws IOException {
        int bit = 16;
        RandomAccessFile srcFile = null;
        FileOutputStream fos = null;
        try {
            srcFile = new RandomAccessFile(srcPath, "r");
            fos = new FileOutputStream(dstPath);
            int step = 2;
            long len = srcFile.length();
            byte[] temp = new byte[step];
            for (long offset = len - (long)step; offset >= 0L; offset -= (long)step) {
                srcFile.seek(offset);
                srcFile.read(temp);
                fos.write(temp);
            }
        }
        finally {
            if (srcFile != null) {
                srcFile.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static long writeAudioTrack(MediaExtractor extractor, MediaMuxer mediaMuxer, int muxerAudioTrackIndex, Integer startTimeUs, Integer endTimeUs, VideoProgressListener listener) throws IOException {
        return AudioUtil.writeAudioTrack(extractor, mediaMuxer, muxerAudioTrackIndex, startTimeUs, endTimeUs, 0L, listener);
    }

    public static long writeAudioTrack(MediaExtractor extractor, MediaMuxer mediaMuxer, int muxerAudioTrackIndex, Integer startTimeUs, Integer endTimeUs, long baseMuxerFrameTimeUs, VideoProgressListener listener) throws IOException {
        long sampleTimeUs;
        int audioTrack = VideoUtil.selectTrack(extractor, true);
        extractor.selectTrack(audioTrack);
        if (startTimeUs == null) {
            startTimeUs = 0;
        }
        extractor.seekTo((long)startTimeUs.intValue(), 2);
        MediaFormat audioFormat = extractor.getTrackFormat(audioTrack);
        long durationUs = audioFormat.getLong("durationUs");
        int maxBufferSize = audioFormat.getInteger("max-input-size");
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        long lastFrametimeUs = baseMuxerFrameTimeUs;
        while ((sampleTimeUs = extractor.getSampleTime()) != -1L) {
            if (sampleTimeUs < (long)startTimeUs.intValue()) {
                extractor.advance();
                continue;
            }
            if (endTimeUs != null && sampleTimeUs > (long)endTimeUs.intValue()) break;
            if (listener != null) {
                float progress = (float)(sampleTimeUs - (long)startTimeUs.intValue()) / (float)(endTimeUs == null ? durationUs : (long)(endTimeUs - startTimeUs));
                progress = progress < 0.0f ? 0.0f : progress;
                progress = progress > 1.0f ? 1.0f : progress;
                listener.onProgress(progress);
            }
            info.presentationTimeUs = sampleTimeUs - (long)startTimeUs.intValue() + baseMuxerFrameTimeUs;
            info.flags = extractor.getSampleFlags();
            info.size = extractor.readSampleData(buffer, 0);
            if (info.size < 0) break;
            CL.i("writeAudioSampleData,time:" + (float)info.presentationTimeUs / 1000.0f, new Object[0]);
            mediaMuxer.writeSampleData(muxerAudioTrackIndex, buffer, info);
            lastFrametimeUs = info.presentationTimeUs;
            extractor.advance();
        }
        return lastFrametimeUs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAudioTrackDecode(Context context, MediaExtractor extractor, MediaMuxer mediaMuxer, int muxerAudioTrackIndex, Integer startTimeUs, Integer endTimeUs, @NonNull Float speed, @Nullable VideoProgressListener listener) throws Exception {
        int audioTrack = VideoUtil.selectTrack(extractor, true);
        extractor.selectTrack(audioTrack);
        if (startTimeUs == null) {
            startTimeUs = 0;
        }
        extractor.seekTo((long)startTimeUs.intValue(), 2);
        MediaFormat oriAudioFormat = extractor.getTrackFormat(audioTrack);
        long durationUs = oriAudioFormat.getLong("durationUs");
        int maxBufferSize = AudioUtil.getAudioMaxBufferSize(oriAudioFormat);
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        MediaCodec decoder = MediaCodec.createDecoderByType((String)oriAudioFormat.getString("mime"));
        decoder.configure(oriAudioFormat, null, null, 0);
        decoder.start();
        boolean decodeDone = false;
        boolean encodeDone = false;
        boolean decodeInputDone = false;
        int TIMEOUT_US = 2500;
        File pcmFile = new File(context.getCacheDir(), System.currentTimeMillis() + ".pcm");
        FileChannel writeChannel = new FileOutputStream(pcmFile).getChannel();
        try {
            while (!decodeDone) {
                int outputBufferIndex;
                if (!decodeInputDone) {
                    boolean eof = false;
                    int decodeInputIndex = decoder.dequeueInputBuffer(2500L);
                    if (decodeInputIndex >= 0) {
                        long sampleTimeUs = extractor.getSampleTime();
                        if (sampleTimeUs == -1L) {
                            eof = true;
                        } else {
                            if (sampleTimeUs < (long)startTimeUs.intValue()) {
                                extractor.advance();
                                continue;
                            }
                            if (endTimeUs != null && sampleTimeUs > (long)endTimeUs.intValue()) {
                                eof = true;
                            }
                        }
                        if (eof) {
                            decodeInputDone = true;
                            decoder.queueInputBuffer(decodeInputIndex, 0, 0, 0L, 4);
                        } else {
                            info.size = extractor.readSampleData(buffer, 0);
                            info.presentationTimeUs = sampleTimeUs;
                            info.flags = extractor.getSampleFlags();
                            ByteBuffer inputBuffer = decoder.getInputBuffer(decodeInputIndex);
                            inputBuffer.put(buffer);
                            CL.i("audio decode queueInputBuffer " + info.presentationTimeUs / 1000L, new Object[0]);
                            decoder.queueInputBuffer(decodeInputIndex, 0, info.size, info.presentationTimeUs, info.flags);
                            extractor.advance();
                        }
                    }
                }
                while (!decodeDone && (outputBufferIndex = decoder.dequeueOutputBuffer(info, 2500L)) != -1) {
                    if (outputBufferIndex == -2) {
                        MediaFormat newFormat = decoder.getOutputFormat();
                        CL.i("audio decode newFormat = " + newFormat, new Object[0]);
                        continue;
                    }
                    if (outputBufferIndex < 0) {
                        CL.e("unexpected result from audio decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                        continue;
                    }
                    if (info.flags == 4) {
                        decodeDone = true;
                    } else {
                        ByteBuffer decodeOutputBuffer = decoder.getOutputBuffer(outputBufferIndex);
                        CL.i("audio decode saveFrame " + info.presentationTimeUs / 1000L, new Object[0]);
                        writeChannel.write(decodeOutputBuffer);
                        if (listener != null) {
                            float decodeProgress = (float)(info.presentationTimeUs - (long)startTimeUs.intValue()) / (float)(endTimeUs == null ? durationUs : (long)(endTimeUs - startTimeUs));
                            listener.onProgress(decodeProgress * 0.5f);
                        }
                    }
                    decoder.releaseOutputBuffer(outputBufferIndex, false);
                }
            }
        }
        finally {
            writeChannel.close();
            extractor.release();
            decoder.release();
        }
        int sampleRate = oriAudioFormat.getInteger("sample-rate");
        int oriChannelCount = oriAudioFormat.getInteger("channel-count");
        File wavFile = new File(context.getCacheDir(), pcmFile.getName() + ".wav");
        int channelConfig = 16;
        if (oriChannelCount == 2) {
            channelConfig = 12;
        }
        new PcmToWavUtil(sampleRate, channelConfig, oriChannelCount, 2).pcmToWav(pcmFile.getAbsolutePath(), wavFile.getAbsolutePath());
        CL.i("start process pcm speed", new Object[0]);
        File outFile = new File(context.getCacheDir(), pcmFile.getName() + ".outpcm");
        SoundTouch st = new SoundTouch();
        st.setTempo(speed.floatValue());
        int res = st.processFile(wavFile.getAbsolutePath(), outFile.getAbsolutePath());
        if (res < 0) {
            pcmFile.delete();
            wavFile.delete();
            outFile.delete();
            return;
        }
        MediaExtractor pcmExtrator = new MediaExtractor();
        pcmExtrator.setDataSource(outFile.getAbsolutePath());
        audioTrack = VideoUtil.selectTrack(pcmExtrator, true);
        pcmExtrator.selectTrack(audioTrack);
        MediaFormat pcmTrackFormat = pcmExtrator.getTrackFormat(audioTrack);
        maxBufferSize = AudioUtil.getAudioMaxBufferSize(pcmTrackFormat);
        durationUs = pcmTrackFormat.getLong("durationUs");
        buffer = ByteBuffer.allocateDirect(maxBufferSize);
        int bitrate = AudioUtil.getAudioBitrate(oriAudioFormat);
        int channelCount = oriAudioFormat.getInteger("channel-count");
        MediaFormat encodeFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channelCount);
        encodeFormat.setInteger("bitrate", bitrate);
        encodeFormat.setInteger("aac-profile", 2);
        encodeFormat.setInteger("max-input-size", maxBufferSize);
        MediaCodec encoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
        encoder.configure(encodeFormat, null, null, 1);
        encoder.start();
        boolean encodeInputDone = false;
        long lastAudioFrameTimeUs = -1L;
        int AAC_FRAME_TIME_US = 1024000000 / sampleRate;
        boolean detectTimeError = false;
        try {
            block8: while (!encodeDone) {
                int outputBufferIndex;
                int inputBufferIndex = encoder.dequeueInputBuffer(2500L);
                if (!encodeInputDone && inputBufferIndex >= 0) {
                    long sampleTime = pcmExtrator.getSampleTime();
                    if (sampleTime < 0L) {
                        encodeInputDone = true;
                        encoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                    } else {
                        int flags = pcmExtrator.getSampleFlags();
                        buffer.clear();
                        int size = pcmExtrator.readSampleData(buffer, 0);
                        ByteBuffer inputBuffer = encoder.getInputBuffer(inputBufferIndex);
                        inputBuffer.clear();
                        inputBuffer.put(buffer);
                        inputBuffer.position(0);
                        CL.i("audio queuePcmBuffer " + sampleTime / 1000L + " size:" + size, new Object[0]);
                        encoder.queueInputBuffer(inputBufferIndex, 0, size, sampleTime, flags);
                        pcmExtrator.advance();
                    }
                }
                while ((outputBufferIndex = encoder.dequeueOutputBuffer(info, 2500L)) != -1) {
                    if (outputBufferIndex == -2) {
                        MediaFormat newFormat = encoder.getOutputFormat();
                        CL.i("audio decode newFormat = " + newFormat, new Object[0]);
                        continue;
                    }
                    if (outputBufferIndex < 0) {
                        CL.e("unexpected result from audio decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                        continue;
                    }
                    if (info.flags == 4) {
                        encodeDone = true;
                        continue block8;
                    }
                    ByteBuffer encodeOutputBuffer = encoder.getOutputBuffer(outputBufferIndex);
                    CL.i("audio writeSampleData " + info.presentationTimeUs + " size:" + info.size + " flags:" + info.flags, new Object[0]);
                    if (!detectTimeError && lastAudioFrameTimeUs != -1L && info.presentationTimeUs < lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US) {
                        CL.e("audio \u65f6\u95f4\u6233\u9519\u8bef\uff0clastAudioFrameTimeUs:" + lastAudioFrameTimeUs + " info.presentationTimeUs:" + info.presentationTimeUs, new Object[0]);
                        detectTimeError = true;
                    }
                    if (detectTimeError) {
                        info.presentationTimeUs = lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US;
                        CL.e("audio \u65f6\u95f4\u6233\u9519\u8bef\uff0c\u4f7f\u7528\u4fee\u6b63\u7684\u65f6\u95f4\u6233:" + info.presentationTimeUs, new Object[0]);
                        detectTimeError = false;
                    }
                    if (info.flags != 2) {
                        lastAudioFrameTimeUs = info.presentationTimeUs;
                    }
                    mediaMuxer.writeSampleData(muxerAudioTrackIndex, encodeOutputBuffer, info);
                    if (listener != null) {
                        float encodeProgress = (float)(info.presentationTimeUs - (long)startTimeUs.intValue()) / (float)(endTimeUs == null ? durationUs : (long)(endTimeUs - startTimeUs));
                        encodeProgress = encodeProgress < 0.0f ? 0.0f : encodeProgress;
                        encodeProgress = encodeProgress > 1.0f ? 1.0f : encodeProgress;
                        listener.onProgress(0.5f + encodeProgress * 0.5f);
                    }
                    encodeOutputBuffer.clear();
                    encoder.releaseOutputBuffer(outputBufferIndex, false);
                }
            }
        }
        finally {
            pcmFile.delete();
            wavFile.delete();
            outFile.delete();
            pcmExtrator.release();
            encoder.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAudioTrack(String videoPath, String outPath) throws IOException {
        MediaExtractor videoExtractor = new MediaExtractor();
        videoExtractor.setDataSource(videoPath);
        try {
            long sampleTimeUs;
            int videoTrack = VideoUtil.selectTrack(videoExtractor, false);
            videoExtractor.selectTrack(videoTrack);
            MediaFormat videoFormat = videoExtractor.getTrackFormat(videoTrack);
            MediaMuxer mediaMuxer = new MediaMuxer(outPath, 0);
            int muxerVideoTrackIndex = mediaMuxer.addTrack(videoFormat);
            mediaMuxer.start();
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int maxBufferSize = videoFormat.getInteger("max-input-size");
            ByteBuffer videoBuffer = ByteBuffer.allocateDirect(maxBufferSize);
            while ((sampleTimeUs = videoExtractor.getSampleTime()) != -1L) {
                int flags = videoExtractor.getSampleFlags();
                int size = videoExtractor.readSampleData(videoBuffer, 0);
                info.presentationTimeUs = sampleTimeUs;
                info.flags = flags;
                info.size = size;
                mediaMuxer.writeSampleData(muxerVideoTrackIndex, videoBuffer, info);
                videoExtractor.advance();
            }
            mediaMuxer.stop();
            mediaMuxer.release();
        }
        finally {
            videoExtractor.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceAudioTrack(String videoPath, String aacPath, String outPath, boolean repeat) throws IOException {
        MediaExtractor videoExtractor = new MediaExtractor();
        videoExtractor.setDataSource(videoPath);
        MediaExtractor aacExtractor = new MediaExtractor();
        aacExtractor.setDataSource(aacPath);
        try {
            long sampleTimeUs;
            int videoTrack = VideoUtil.selectTrack(videoExtractor, false);
            int audioTrack = VideoUtil.selectTrack(aacExtractor, true);
            videoExtractor.selectTrack(videoTrack);
            aacExtractor.selectTrack(audioTrack);
            MediaFormat audioFormat = aacExtractor.getTrackFormat(audioTrack);
            MediaFormat videoFormat = videoExtractor.getTrackFormat(videoTrack);
            MediaMuxer mediaMuxer = new MediaMuxer(outPath, 0);
            int muxerAudioTrackIndex = mediaMuxer.addTrack(audioFormat);
            int muxerVideoTrackIndex = mediaMuxer.addTrack(videoFormat);
            mediaMuxer.start();
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            long lastVideoTimeUs = 0L;
            int maxBufferSize = videoFormat.getInteger("max-input-size");
            ByteBuffer videoBuffer = ByteBuffer.allocateDirect(maxBufferSize);
            while ((sampleTimeUs = videoExtractor.getSampleTime()) != -1L) {
                int flags = videoExtractor.getSampleFlags();
                int size = videoExtractor.readSampleData(videoBuffer, 0);
                info.presentationTimeUs = sampleTimeUs;
                info.flags = flags;
                info.size = size;
                mediaMuxer.writeSampleData(muxerVideoTrackIndex, videoBuffer, info);
                lastVideoTimeUs = sampleTimeUs;
                videoExtractor.advance();
            }
            maxBufferSize = AudioUtil.getAudioMaxBufferSize(audioFormat);
            ByteBuffer audioBuffer = ByteBuffer.allocateDirect(maxBufferSize);
            long lastAudioSampleTime = 0L;
            long baseAudioSampleTime = 0L;
            while (lastAudioSampleTime < lastVideoTimeUs) {
                long sampleTimeUs2;
                aacExtractor.seekTo(0L, 2);
                while ((sampleTimeUs2 = aacExtractor.getSampleTime()) != -1L && sampleTimeUs2 <= lastVideoTimeUs) {
                    int flags = aacExtractor.getSampleFlags();
                    int size = aacExtractor.readSampleData(audioBuffer, 0);
                    info.presentationTimeUs = sampleTimeUs2 += baseAudioSampleTime;
                    lastAudioSampleTime = sampleTimeUs2;
                    info.flags = flags;
                    info.size = size;
                    mediaMuxer.writeSampleData(muxerAudioTrackIndex, audioBuffer, info);
                    aacExtractor.advance();
                }
                baseAudioSampleTime = lastAudioSampleTime;
                if (repeat) continue;
            }
            mediaMuxer.stop();
            mediaMuxer.release();
        }
        finally {
            videoExtractor.release();
            aacExtractor.release();
        }
    }

    public static int getAudioMaxBufferSize(MediaFormat format) {
        if (format.containsKey("max-input-size")) {
            return format.getInteger("max-input-size");
        }
        return 100000;
    }

    public static int getAudioBitrate(MediaFormat format) {
        if (format.containsKey("bitrate")) {
            return format.getInteger("bitrate");
        }
        return 192000;
    }
}

