/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor.jssrc;

public class SplitRadixFft {
    private static final int CDFT_RECURSIVE_N = 512;

    public void cdft(int n, int isgn, double[] a, int[] ip, double[] w) {
        int nw = ip[0];
        if (n > nw << 2) {
            nw = n >> 2;
            this.makewt(nw, ip, w);
        }
        if (isgn >= 0) {
            this.cftfsub(n, a, ip, 2, nw, w);
        } else {
            this.cftbsub(n, a, ip, 2, nw, w);
        }
    }

    public void rdft(int n, int isgn, double[] a, int[] ip, double[] w) {
        int nc;
        int nw = ip[0];
        if (n > nw << 2) {
            nw = n >> 2;
            this.makewt(nw, ip, w);
        }
        if (n > (nc = ip[1]) << 2) {
            nc = n >> 2;
            this.makect(nc, ip, w, nw);
        }
        if (isgn >= 0) {
            if (n > 4) {
                this.cftfsub(n, a, ip, 2, nw, w);
                this.rftfsub(n, a, nc, w, nw);
            } else if (n == 4) {
                this.cftfsub(n, a, ip, 2, nw, w);
            }
            double xi = a[0] - a[1];
            a[0] = a[0] + a[1];
            a[1] = xi;
        } else {
            a[1] = 0.5 * (a[0] - a[1]);
            a[0] = a[0] - a[1];
            if (n > 4) {
                this.rftbsub(n, a, nc, w, nw);
                this.cftbsub(n, a, ip, 2, nw, w);
            } else if (n == 4) {
                this.cftbsub(n, a, ip, 2, nw, w);
            }
        }
    }

    public void ddct(int n, int isgn, double[] a, int[] ip, double[] w) {
        int j;
        double xr;
        int nc;
        int nw = ip[0];
        if (n > nw << 2) {
            nw = n >> 2;
            this.makewt(nw, ip, w);
        }
        if (n > (nc = ip[1])) {
            nc = n;
            this.makect(nc, ip, w, nw);
        }
        if (isgn < 0) {
            xr = a[n - 1];
            for (j = n - 2; j >= 2; j -= 2) {
                a[j + 1] = a[j] - a[j - 1];
                int n2 = j;
                a[n2] = a[n2] + a[j - 1];
            }
            a[1] = a[0] - xr;
            a[0] = a[0] + xr;
            if (n > 4) {
                this.rftbsub(n, a, nc, w, nw);
                this.cftbsub(n, a, ip, 2, nw, w);
            } else if (n == 4) {
                this.cftbsub(n, a, ip, 2, nw, w);
            }
        }
        this.dctsub(n, a, nc, w, nw);
        if (isgn >= 0) {
            if (n > 4) {
                this.cftfsub(n, a, ip, 2, nw, w);
                this.rftfsub(n, a, nc, w, nw);
            } else if (n == 4) {
                this.cftfsub(n, a, ip, 2, nw, w);
            }
            xr = a[0] - a[1];
            a[0] = a[0] + a[1];
            for (j = 2; j < n; j += 2) {
                a[j - 1] = a[j] - a[j + 1];
                int n3 = j;
                a[n3] = a[n3] + a[j + 1];
            }
            a[n - 1] = xr;
        }
    }

    public void ddst(int n, int isgn, double[] a, int[] ip, double[] w) {
        int j;
        double xr;
        int nc;
        int nw = ip[0];
        if (n > nw << 2) {
            nw = n >> 2;
            this.makewt(nw, ip, w);
        }
        if (n > (nc = ip[1])) {
            nc = n;
            this.makect(nc, ip, w, nw);
        }
        if (isgn < 0) {
            xr = a[n - 1];
            for (j = n - 2; j >= 2; j -= 2) {
                a[j + 1] = -a[j] - a[j - 1];
                int n2 = j;
                a[n2] = a[n2] - a[j - 1];
            }
            a[1] = a[0] + xr;
            a[0] = a[0] - xr;
            if (n > 4) {
                this.rftbsub(n, a, nc, w, nw);
                this.cftbsub(n, a, ip, 2, nw, w);
            } else if (n == 4) {
                this.cftbsub(n, a, ip, 2, nw, w);
            }
        }
        this.dstsub(n, a, nc, w, nw);
        if (isgn >= 0) {
            if (n > 4) {
                this.cftfsub(n, a, ip, 2, nw, w);
                this.rftfsub(n, a, nc, w, nw);
            } else if (n == 4) {
                this.cftfsub(n, a, ip, 2, nw, w);
            }
            xr = a[0] - a[1];
            a[0] = a[0] + a[1];
            for (j = 2; j < n; j += 2) {
                a[j - 1] = -a[j] - a[j + 1];
                int n3 = j;
                a[n3] = a[n3] - a[j + 1];
            }
            a[n - 1] = -xr;
        }
    }

    public void dfct(int n, double[] a, double[] t, int[] ip, double[] w) {
        int nc;
        int nw = ip[0];
        if (n > nw << 3) {
            nw = n >> 3;
            this.makewt(nw, ip, w);
        }
        if (n > (nc = ip[1]) << 1) {
            nc = n >> 1;
            this.makect(nc, ip, w, nw);
        }
        int m = n >> 1;
        double yi = a[m];
        double xi = a[0] + a[n];
        a[0] = a[0] - a[n];
        t[0] = xi - yi;
        t[m] = xi + yi;
        if (n > 2) {
            int k;
            int j;
            int mh = m >> 1;
            for (j = 1; j < mh; ++j) {
                k = m - j;
                double xr = a[j] - a[n - j];
                xi = a[j] + a[n - j];
                double yr = a[k] - a[n - k];
                yi = a[k] + a[n - k];
                a[j] = xr;
                a[k] = yr;
                t[j] = xi - yi;
                t[k] = xi + yi;
            }
            t[mh] = a[mh] + a[n - mh];
            int n2 = mh;
            a[n2] = a[n2] - a[n - mh];
            this.dctsub(m, a, nc, w, nw);
            if (m > 4) {
                this.cftfsub(m, a, ip, 2, nw, w);
                this.rftfsub(m, a, nc, w, nw);
            } else if (m == 4) {
                this.cftfsub(m, a, ip, 2, nw, w);
            }
            a[n - 1] = a[0] - a[1];
            a[1] = a[0] + a[1];
            for (j = m - 2; j >= 2; j -= 2) {
                a[2 * j + 1] = a[j] + a[j + 1];
                a[2 * j - 1] = a[j] - a[j + 1];
            }
            int l = 2;
            m = mh;
            while (m >= 2) {
                this.dctsub(m, t, nc, w, nw);
                if (m > 4) {
                    this.cftfsub(m, t, ip, 2, nw, w);
                    this.rftfsub(m, t, nc, w, nw);
                } else if (m == 4) {
                    this.cftfsub(m, t, ip, 2, nw, w);
                }
                a[n - l] = t[0] - t[1];
                a[l] = t[0] + t[1];
                k = 0;
                for (j = 2; j < m; j += 2) {
                    a[(k += l << 2) - l] = t[j] - t[j + 1];
                    a[k + l] = t[j] + t[j + 1];
                }
                l <<= 1;
                mh = m >> 1;
                for (j = 0; j < mh; ++j) {
                    k = m - j;
                    t[j] = t[m + k] - t[m + j];
                    t[k] = t[m + k] + t[m + j];
                }
                t[mh] = t[m + mh];
                m = mh;
            }
            a[l] = t[0];
            a[n] = t[2] - t[1];
            a[0] = t[2] + t[1];
        } else {
            a[1] = a[0];
            a[2] = t[0];
            a[0] = t[1];
        }
    }

    public void dfst(int n, double[] a, double[] t, int[] ip, double[] w) {
        int nc;
        int nw = ip[0];
        if (n > nw << 3) {
            nw = n >> 3;
            this.makewt(nw, ip, w);
        }
        if (n > (nc = ip[1]) << 1) {
            nc = n >> 1;
            this.makect(nc, ip, w, nw);
        }
        if (n > 2) {
            int k;
            int j;
            int m = n >> 1;
            int mh = m >> 1;
            for (j = 1; j < mh; ++j) {
                k = m - j;
                double xr = a[j] + a[n - j];
                double xi = a[j] - a[n - j];
                double yr = a[k] + a[n - k];
                double yi = a[k] - a[n - k];
                a[j] = xr;
                a[k] = yr;
                t[j] = xi + yi;
                t[k] = xi - yi;
            }
            t[0] = a[mh] - a[n - mh];
            int n2 = mh;
            a[n2] = a[n2] + a[n - mh];
            a[0] = a[m];
            this.dstsub(m, a, nc, w, nw);
            if (m > 4) {
                this.cftfsub(m, a, ip, 2, nw, w);
                this.rftfsub(m, a, nc, w, nw);
            } else if (m == 4) {
                this.cftfsub(m, a, ip, 2, nw, w);
            }
            a[n - 1] = a[1] - a[0];
            a[1] = a[0] + a[1];
            for (j = m - 2; j >= 2; j -= 2) {
                a[2 * j + 1] = a[j] - a[j + 1];
                a[2 * j - 1] = -a[j] - a[j + 1];
            }
            int l = 2;
            m = mh;
            while (m >= 2) {
                this.dstsub(m, t, nc, w, nw);
                if (m > 4) {
                    this.cftfsub(m, t, ip, 2, nw, w);
                    this.rftfsub(m, t, nc, w, nw);
                } else if (m == 4) {
                    this.cftfsub(m, t, ip, 2, nw, w);
                }
                a[n - l] = t[1] - t[0];
                a[l] = t[0] + t[1];
                k = 0;
                for (j = 2; j < m; j += 2) {
                    a[(k += l << 2) - l] = -t[j] - t[j + 1];
                    a[k + l] = t[j] - t[j + 1];
                }
                l <<= 1;
                mh = m >> 1;
                for (j = 1; j < mh; ++j) {
                    k = m - j;
                    t[j] = t[m + k] + t[m + j];
                    t[k] = t[m + k] - t[m + j];
                }
                t[0] = t[m + mh];
                m = mh;
            }
            a[l] = t[0];
        }
        a[0] = 0.0;
    }

    private void makewt(int nw, int[] ip, double[] w) {
        ip[0] = nw;
        ip[1] = 1;
        if (nw > 2) {
            int j;
            int nwh = nw >> 1;
            double delta = 0.7853981633974483 / (double)nwh;
            double wn4r = Math.cos(delta * (double)nwh);
            w[0] = 1.0;
            w[1] = wn4r;
            if (nwh >= 4) {
                w[2] = 0.5 / Math.cos(delta * 2.0);
                w[3] = 0.5 / Math.cos(delta * 6.0);
            }
            for (j = 4; j < nwh; j += 4) {
                w[j] = Math.cos(delta * (double)j);
                w[j + 1] = Math.sin(delta * (double)j);
                w[j + 2] = Math.cos(3.0 * delta * (double)j);
                w[j + 3] = Math.sin(3.0 * delta * (double)j);
            }
            int nw0 = 0;
            while (nwh > 2) {
                double wk3r;
                double wk1r;
                int nw1 = nw0 + nwh;
                w[nw1] = 1.0;
                w[nw1 + 1] = wn4r;
                if ((nwh >>= 1) >= 4) {
                    wk1r = w[nw0 + 4];
                    wk3r = w[nw0 + 6];
                    w[nw1 + 2] = 0.5 / wk1r;
                    w[nw1 + 3] = 0.5 / wk3r;
                }
                for (j = 4; j < nwh; j += 4) {
                    wk1r = w[nw0 + 2 * j];
                    double wk1i = w[nw0 + 2 * j + 1];
                    wk3r = w[nw0 + 2 * j + 2];
                    double wk3i = w[nw0 + 2 * j + 3];
                    w[nw1 + j] = wk1r;
                    w[nw1 + j + 1] = wk1i;
                    w[nw1 + j + 2] = wk3r;
                    w[nw1 + j + 3] = wk3i;
                }
                nw0 = nw1;
            }
        }
    }

    private void makect(int nc, int[] ip, double[] c, int cP) {
        ip[1] = nc;
        if (nc > 1) {
            int nch = nc >> 1;
            double delta = 0.7853981633974483 / (double)nch;
            c[cP + 0] = Math.cos(delta * (double)nch);
            c[cP + nch] = 0.5 * c[cP + 0];
            for (int j = 1; j < nch; ++j) {
                c[cP + j] = 0.5 * Math.cos(delta * (double)j);
                c[cP + nc - j] = 0.5 * Math.sin(delta * (double)j);
            }
        }
    }

    private void cftfsub(int n, double[] a, int[] ip, int ipP, int nw, double[] w) {
        if (n > 32) {
            int m = n >> 2;
            this.cftf1st(n, a, w, nw - m);
            if (n > 512) {
                this.cftrec1(m, a, 0, nw, w);
                this.cftrec2(m, a, m, nw, w);
                this.cftrec1(m, a, 2 * m, nw, w);
                this.cftrec1(m, a, 3 * m, nw, w);
            } else if (m > 32) {
                this.cftexp1(n, a, 0, nw, w);
            } else {
                this.cftfx41(n, a, 0, nw, w);
            }
            this.bitrv2(n, ip, ipP, a);
        } else if (n > 8) {
            if (n == 32) {
                this.cftf161(a, 0, w, nw - 8);
                this.bitrv216(a);
            } else {
                this.cftf081(a, 0, w, 0);
                this.bitrv208(a);
            }
        } else if (n == 8) {
            this.cftf040(a);
        } else if (n == 4) {
            this.cftx020(a);
        }
    }

    private void cftbsub(int n, double[] a, int[] ip, int ipP, int nw, double[] w) {
        if (n > 32) {
            int m = n >> 2;
            this.cftb1st(n, a, w, nw - m);
            if (n > 512) {
                this.cftrec1(m, a, 0, nw, w);
                this.cftrec2(m, a, m, nw, w);
                this.cftrec1(m, a, 2 * m, nw, w);
                this.cftrec1(m, a, 3 * m, nw, w);
            } else if (m > 32) {
                this.cftexp1(n, a, 0, nw, w);
            } else {
                this.cftfx41(n, a, 0, nw, w);
            }
            this.bitrv2conj(n, ip, ipP, a);
        } else if (n > 8) {
            if (n == 32) {
                this.cftf161(a, 0, w, nw - 8);
                this.bitrv216neg(a);
            } else {
                this.cftf081(a, 0, w, 0);
                this.bitrv208neg(a);
            }
        } else if (n == 8) {
            this.cftb040(a);
        } else if (n == 4) {
            this.cftx020(a);
        }
    }

    private final void bitrv2(int n, int[] ip, int ipP, double[] a) {
        int j;
        ip[ipP + 0] = 0;
        int l = n;
        int m = 1;
        while (m << 3 < l) {
            l >>= 1;
            for (j = 0; j < m; ++j) {
                ip[ipP + m + j] = ip[ipP + j] + l;
            }
            m <<= 1;
        }
        int m2 = 2 * m;
        if (m << 3 == l) {
            for (int k = 0; k < m; ++k) {
                double yi;
                double yr;
                double xi;
                double xr;
                int k1;
                int j1;
                for (j = 0; j < k; ++j) {
                    j1 = 2 * j + ip[ipP + k];
                    k1 = 2 * k + ip[ipP + j];
                    xr = a[j1];
                    xi = a[j1 + 1];
                    yr = a[k1];
                    yi = a[k1 + 1];
                    a[j1] = yr;
                    a[j1 + 1] = yi;
                    a[k1] = xr;
                    a[k1 + 1] = xi;
                    xr = a[j1 += m2];
                    xi = a[j1 + 1];
                    yr = a[k1 += 2 * m2];
                    yi = a[k1 + 1];
                    a[j1] = yr;
                    a[j1 + 1] = yi;
                    a[k1] = xr;
                    a[k1 + 1] = xi;
                    xr = a[j1 += m2];
                    xi = a[j1 + 1];
                    yr = a[k1 -= m2];
                    yi = a[k1 + 1];
                    a[j1] = yr;
                    a[j1 + 1] = yi;
                    a[k1] = xr;
                    a[k1 + 1] = xi;
                    xr = a[j1 += m2];
                    xi = a[j1 + 1];
                    yr = a[k1 += 2 * m2];
                    yi = a[k1 + 1];
                    a[j1] = yr;
                    a[j1 + 1] = yi;
                    a[k1] = xr;
                    a[k1 + 1] = xi;
                }
                j1 = 2 * k + m2 + ip[ipP + k];
                k1 = j1 + m2;
                xr = a[j1];
                xi = a[j1 + 1];
                yr = a[k1];
                yi = a[k1 + 1];
                a[j1] = yr;
                a[j1 + 1] = yi;
                a[k1] = xr;
                a[k1 + 1] = xi;
            }
        } else {
            for (int k = 1; k < m; ++k) {
                for (j = 0; j < k; ++j) {
                    int j1 = 2 * j + ip[ipP + k];
                    int k1 = 2 * k + ip[ipP + j];
                    double xr = a[j1];
                    double xi = a[j1 + 1];
                    double yr = a[k1];
                    double yi = a[k1 + 1];
                    a[j1] = yr;
                    a[j1 + 1] = yi;
                    a[k1] = xr;
                    a[k1 + 1] = xi;
                    xr = a[j1 += m2];
                    xi = a[j1 + 1];
                    yr = a[k1 += m2];
                    yi = a[k1 + 1];
                    a[j1] = yr;
                    a[j1 + 1] = yi;
                    a[k1] = xr;
                    a[k1 + 1] = xi;
                }
            }
        }
    }

    private final void bitrv2conj(int n, int[] ip, int ipP, double[] a) {
        int j;
        ip[ipP + 0] = 0;
        int l = n;
        int m = 1;
        while (m << 3 < l) {
            l >>= 1;
            for (j = 0; j < m; ++j) {
                ip[ipP + m + j] = ip[ipP + j] + l;
            }
            m <<= 1;
        }
        int m2 = 2 * m;
        if (m << 3 == l) {
            for (int k = 0; k < m; ++k) {
                double yi;
                double yr;
                double xi;
                double xr;
                int k1;
                int j1;
                for (j = 0; j < k; ++j) {
                    j1 = 2 * j + ip[ipP + k];
                    k1 = 2 * k + ip[ipP + j];
                    xr = a[j1];
                    xi = -a[j1 + 1];
                    yr = a[k1];
                    yi = -a[k1 + 1];
                    a[j1] = yr;
                    a[j1 + 1] = yi;
                    a[k1] = xr;
                    a[k1 + 1] = xi;
                    xr = a[j1 += m2];
                    xi = -a[j1 + 1];
                    yr = a[k1 += 2 * m2];
                    yi = -a[k1 + 1];
                    a[j1] = yr;
                    a[j1 + 1] = yi;
                    a[k1] = xr;
                    a[k1 + 1] = xi;
                    xr = a[j1 += m2];
                    xi = -a[j1 + 1];
                    yr = a[k1 -= m2];
                    yi = -a[k1 + 1];
                    a[j1] = yr;
                    a[j1 + 1] = yi;
                    a[k1] = xr;
                    a[k1 + 1] = xi;
                    xr = a[j1 += m2];
                    xi = -a[j1 + 1];
                    yr = a[k1 += 2 * m2];
                    yi = -a[k1 + 1];
                    a[j1] = yr;
                    a[j1 + 1] = yi;
                    a[k1] = xr;
                    a[k1 + 1] = xi;
                }
                k1 = 2 * k + ip[ipP + k];
                a[k1 + 1] = -a[k1 + 1];
                j1 = k1 + m2;
                k1 = j1 + m2;
                xr = a[j1];
                xi = -a[j1 + 1];
                yr = a[k1];
                yi = -a[k1 + 1];
                a[j1] = yr;
                a[j1 + 1] = yi;
                a[k1] = xr;
                a[k1 + 1] = xi;
                a[(k1 += m2) + 1] = -a[k1 + 1];
            }
        } else {
            a[1] = -a[1];
            a[m2 + 1] = -a[m2 + 1];
            for (int k = 1; k < m; ++k) {
                int k1;
                for (j = 0; j < k; ++j) {
                    int j1 = 2 * j + ip[ipP + k];
                    k1 = 2 * k + ip[ipP + j];
                    double xr = a[j1];
                    double xi = -a[j1 + 1];
                    double yr = a[k1];
                    double yi = -a[k1 + 1];
                    a[j1] = yr;
                    a[j1 + 1] = yi;
                    a[k1] = xr;
                    a[k1 + 1] = xi;
                    xr = a[j1 += m2];
                    xi = -a[j1 + 1];
                    yr = a[k1 += m2];
                    yi = -a[k1 + 1];
                    a[j1] = yr;
                    a[j1 + 1] = yi;
                    a[k1] = xr;
                    a[k1 + 1] = xi;
                }
                k1 = 2 * k + ip[ipP + k];
                a[k1 + 1] = -a[k1 + 1];
                a[k1 + m2 + 1] = -a[k1 + m2 + 1];
            }
        }
    }

    private void bitrv216(double[] a) {
        double x1r = a[2];
        double x1i = a[3];
        double x2r = a[4];
        double x2i = a[5];
        double x3r = a[6];
        double x3i = a[7];
        double x4r = a[8];
        double x4i = a[9];
        double x5r = a[10];
        double x5i = a[11];
        double x7r = a[14];
        double x7i = a[15];
        double x8r = a[16];
        double x8i = a[17];
        double x10r = a[20];
        double x10i = a[21];
        double x11r = a[22];
        double x11i = a[23];
        double x12r = a[24];
        double x12i = a[25];
        double x13r = a[26];
        double x13i = a[27];
        double x14r = a[28];
        double x14i = a[29];
        a[2] = x8r;
        a[3] = x8i;
        a[4] = x4r;
        a[5] = x4i;
        a[6] = x12r;
        a[7] = x12i;
        a[8] = x2r;
        a[9] = x2i;
        a[10] = x10r;
        a[11] = x10i;
        a[14] = x14r;
        a[15] = x14i;
        a[16] = x1r;
        a[17] = x1i;
        a[20] = x5r;
        a[21] = x5i;
        a[22] = x13r;
        a[23] = x13i;
        a[24] = x3r;
        a[25] = x3i;
        a[26] = x11r;
        a[27] = x11i;
        a[28] = x7r;
        a[29] = x7i;
    }

    private void bitrv216neg(double[] a) {
        double x1r = a[2];
        double x1i = a[3];
        double x2r = a[4];
        double x2i = a[5];
        double x3r = a[6];
        double x3i = a[7];
        double x4r = a[8];
        double x4i = a[9];
        double x5r = a[10];
        double x5i = a[11];
        double x6r = a[12];
        double x6i = a[13];
        double x7r = a[14];
        double x7i = a[15];
        double x8r = a[16];
        double x8i = a[17];
        double x9r = a[18];
        double x9i = a[19];
        double x10r = a[20];
        double x10i = a[21];
        double x11r = a[22];
        double x11i = a[23];
        double x12r = a[24];
        double x12i = a[25];
        double x13r = a[26];
        double x13i = a[27];
        double x14r = a[28];
        double x14i = a[29];
        double x15r = a[30];
        double x15i = a[31];
        a[2] = x15r;
        a[3] = x15i;
        a[4] = x7r;
        a[5] = x7i;
        a[6] = x11r;
        a[7] = x11i;
        a[8] = x3r;
        a[9] = x3i;
        a[10] = x13r;
        a[11] = x13i;
        a[12] = x5r;
        a[13] = x5i;
        a[14] = x9r;
        a[15] = x9i;
        a[16] = x1r;
        a[17] = x1i;
        a[18] = x14r;
        a[19] = x14i;
        a[20] = x6r;
        a[21] = x6i;
        a[22] = x10r;
        a[23] = x10i;
        a[24] = x2r;
        a[25] = x2i;
        a[26] = x12r;
        a[27] = x12i;
        a[28] = x4r;
        a[29] = x4i;
        a[30] = x8r;
        a[31] = x8i;
    }

    private void bitrv208(double[] a) {
        double x1r = a[2];
        double x1i = a[3];
        double x3r = a[6];
        double x3i = a[7];
        double x4r = a[8];
        double x4i = a[9];
        double x6r = a[12];
        double x6i = a[13];
        a[2] = x4r;
        a[3] = x4i;
        a[6] = x6r;
        a[7] = x6i;
        a[8] = x1r;
        a[9] = x1i;
        a[12] = x3r;
        a[13] = x3i;
    }

    private void bitrv208neg(double[] a) {
        double x1r = a[2];
        double x1i = a[3];
        double x2r = a[4];
        double x2i = a[5];
        double x3r = a[6];
        double x3i = a[7];
        double x4r = a[8];
        double x4i = a[9];
        double x5r = a[10];
        double x5i = a[11];
        double x6r = a[12];
        double x6i = a[13];
        double x7r = a[14];
        double x7i = a[15];
        a[2] = x7r;
        a[3] = x7i;
        a[4] = x3r;
        a[5] = x3i;
        a[6] = x5r;
        a[7] = x5i;
        a[8] = x1r;
        a[9] = x1i;
        a[10] = x6r;
        a[11] = x6i;
        a[12] = x2r;
        a[13] = x2i;
        a[14] = x4r;
        a[15] = x4i;
    }

    private void cftf1st(int n, double[] a, double[] w, int wP) {
        int j0;
        double wk3i;
        double wk3r;
        double wk1i;
        double wk1r;
        int m;
        int mh = n >> 3;
        int j1 = m = 2 * mh;
        int j2 = j1 + m;
        int j3 = j2 + m;
        double x0r = a[0] + a[j2];
        double x0i = a[1] + a[j2 + 1];
        double x1r = a[0] - a[j2];
        double x1i = a[1] - a[j2 + 1];
        double x2r = a[j1] + a[j3];
        double x2i = a[j1 + 1] + a[j3 + 1];
        double x3r = a[j1] - a[j3];
        double x3i = a[j1 + 1] - a[j3 + 1];
        a[0] = x0r + x2r;
        a[1] = x0i + x2i;
        a[j1] = x0r - x2r;
        a[j1 + 1] = x0i - x2i;
        a[j2] = x1r - x3i;
        a[j2 + 1] = x1i + x3r;
        a[j3] = x1r + x3i;
        a[j3 + 1] = x1i - x3r;
        double wn4r = w[wP + 1];
        double csc1 = w[wP + 2];
        double csc3 = w[wP + 3];
        double wd1r = 1.0;
        double wd1i = 0.0;
        double wd3r = 1.0;
        double wd3i = 0.0;
        int k = 0;
        for (int j = 2; j < mh - 2; j += 4) {
            wk1r = csc1 * (wd1r + w[wP + (k += 4)]);
            wk1i = csc1 * (wd1i + w[wP + k + 1]);
            wk3r = csc3 * (wd3r + w[wP + k + 2]);
            wk3i = csc3 * (wd3i - w[wP + k + 3]);
            wd1r = w[wP + k];
            wd1i = w[wP + k + 1];
            wd3r = w[wP + k + 2];
            wd3i = -w[wP + k + 3];
            j1 = j + m;
            j2 = j1 + m;
            j3 = j2 + m;
            x0r = a[j] + a[j2];
            x0i = a[j + 1] + a[j2 + 1];
            x1r = a[j] - a[j2];
            x1i = a[j + 1] - a[j2 + 1];
            double y0r = a[j + 2] + a[j2 + 2];
            double y0i = a[j + 3] + a[j2 + 3];
            double y1r = a[j + 2] - a[j2 + 2];
            double y1i = a[j + 3] - a[j2 + 3];
            x2r = a[j1] + a[j3];
            x2i = a[j1 + 1] + a[j3 + 1];
            x3r = a[j1] - a[j3];
            x3i = a[j1 + 1] - a[j3 + 1];
            double y2r = a[j1 + 2] + a[j3 + 2];
            double y2i = a[j1 + 3] + a[j3 + 3];
            double y3r = a[j1 + 2] - a[j3 + 2];
            double y3i = a[j1 + 3] - a[j3 + 3];
            a[j] = x0r + x2r;
            a[j + 1] = x0i + x2i;
            a[j + 2] = y0r + y2r;
            a[j + 3] = y0i + y2i;
            a[j1] = x0r - x2r;
            a[j1 + 1] = x0i - x2i;
            a[j1 + 2] = y0r - y2r;
            a[j1 + 3] = y0i - y2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a[j2] = wk1r * x0r - wk1i * x0i;
            a[j2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = y1r - y3i;
            x0i = y1i + y3r;
            a[j2 + 2] = wd1r * x0r - wd1i * x0i;
            a[j2 + 3] = wd1r * x0i + wd1i * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a[j3] = wk3r * x0r + wk3i * x0i;
            a[j3 + 1] = wk3r * x0i - wk3i * x0r;
            x0r = y1r + y3i;
            x0i = y1i - y3r;
            a[j3 + 2] = wd3r * x0r + wd3i * x0i;
            a[j3 + 3] = wd3r * x0i - wd3i * x0r;
            j0 = m - j;
            j1 = j0 + m;
            j2 = j1 + m;
            j3 = j2 + m;
            x0r = a[j0] + a[j2];
            x0i = a[j0 + 1] + a[j2 + 1];
            x1r = a[j0] - a[j2];
            x1i = a[j0 + 1] - a[j2 + 1];
            y0r = a[j0 - 2] + a[j2 - 2];
            y0i = a[j0 - 1] + a[j2 - 1];
            y1r = a[j0 - 2] - a[j2 - 2];
            y1i = a[j0 - 1] - a[j2 - 1];
            x2r = a[j1] + a[j3];
            x2i = a[j1 + 1] + a[j3 + 1];
            x3r = a[j1] - a[j3];
            x3i = a[j1 + 1] - a[j3 + 1];
            y2r = a[j1 - 2] + a[j3 - 2];
            y2i = a[j1 - 1] + a[j3 - 1];
            y3r = a[j1 - 2] - a[j3 - 2];
            y3i = a[j1 - 1] - a[j3 - 1];
            a[j0] = x0r + x2r;
            a[j0 + 1] = x0i + x2i;
            a[j0 - 2] = y0r + y2r;
            a[j0 - 1] = y0i + y2i;
            a[j1] = x0r - x2r;
            a[j1 + 1] = x0i - x2i;
            a[j1 - 2] = y0r - y2r;
            a[j1 - 1] = y0i - y2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a[j2] = wk1i * x0r - wk1r * x0i;
            a[j2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = y1r - y3i;
            x0i = y1i + y3r;
            a[j2 - 2] = wd1i * x0r - wd1r * x0i;
            a[j2 - 1] = wd1i * x0i + wd1r * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a[j3] = wk3i * x0r + wk3r * x0i;
            a[j3 + 1] = wk3i * x0i - wk3r * x0r;
            x0r = y1r + y3i;
            x0i = y1i - y3r;
            a[j3 - 2] = wd3i * x0r + wd3r * x0i;
            a[j3 - 1] = wd3i * x0i - wd3r * x0r;
        }
        wk1r = csc1 * (wd1r + wn4r);
        wk1i = csc1 * (wd1i + wn4r);
        wk3r = csc3 * (wd3r - wn4r);
        wk3i = csc3 * (wd3i - wn4r);
        j0 = mh;
        j1 = j0 + m;
        j2 = j1 + m;
        j3 = j2 + m;
        x0r = a[j0 - 2] + a[j2 - 2];
        x0i = a[j0 - 1] + a[j2 - 1];
        x1r = a[j0 - 2] - a[j2 - 2];
        x1i = a[j0 - 1] - a[j2 - 1];
        x2r = a[j1 - 2] + a[j3 - 2];
        x2i = a[j1 - 1] + a[j3 - 1];
        x3r = a[j1 - 2] - a[j3 - 2];
        x3i = a[j1 - 1] - a[j3 - 1];
        a[j0 - 2] = x0r + x2r;
        a[j0 - 1] = x0i + x2i;
        a[j1 - 2] = x0r - x2r;
        a[j1 - 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a[j2 - 2] = wk1r * x0r - wk1i * x0i;
        a[j2 - 1] = wk1r * x0i + wk1i * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a[j3 - 2] = wk3r * x0r + wk3i * x0i;
        a[j3 - 1] = wk3r * x0i - wk3i * x0r;
        x0r = a[j0] + a[j2];
        x0i = a[j0 + 1] + a[j2 + 1];
        x1r = a[j0] - a[j2];
        x1i = a[j0 + 1] - a[j2 + 1];
        x2r = a[j1] + a[j3];
        x2i = a[j1 + 1] + a[j3 + 1];
        x3r = a[j1] - a[j3];
        x3i = a[j1 + 1] - a[j3 + 1];
        a[j0] = x0r + x2r;
        a[j0 + 1] = x0i + x2i;
        a[j1] = x0r - x2r;
        a[j1 + 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a[j2] = wn4r * (x0r - x0i);
        a[j2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a[j3] = -wn4r * (x0r + x0i);
        a[j3 + 1] = -wn4r * (x0i - x0r);
        x0r = a[j0 + 2] + a[j2 + 2];
        x0i = a[j0 + 3] + a[j2 + 3];
        x1r = a[j0 + 2] - a[j2 + 2];
        x1i = a[j0 + 3] - a[j2 + 3];
        x2r = a[j1 + 2] + a[j3 + 2];
        x2i = a[j1 + 3] + a[j3 + 3];
        x3r = a[j1 + 2] - a[j3 + 2];
        x3i = a[j1 + 3] - a[j3 + 3];
        a[j0 + 2] = x0r + x2r;
        a[j0 + 3] = x0i + x2i;
        a[j1 + 2] = x0r - x2r;
        a[j1 + 3] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a[j2 + 2] = wk1i * x0r - wk1r * x0i;
        a[j2 + 3] = wk1i * x0i + wk1r * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a[j3 + 2] = wk3i * x0r + wk3r * x0i;
        a[j3 + 3] = wk3i * x0i - wk3r * x0r;
    }

    private final void cftb1st(int n, double[] a, double[] w, int wP) {
        int j0;
        double wk3i;
        double wk3r;
        double wk1i;
        double wk1r;
        int m;
        int mh = n >> 3;
        int j1 = m = 2 * mh;
        int j2 = j1 + m;
        int j3 = j2 + m;
        double x0r = a[0] + a[j2];
        double x0i = -a[1] - a[j2 + 1];
        double x1r = a[0] - a[j2];
        double x1i = -a[1] + a[j2 + 1];
        double x2r = a[j1] + a[j3];
        double x2i = a[j1 + 1] + a[j3 + 1];
        double x3r = a[j1] - a[j3];
        double x3i = a[j1 + 1] - a[j3 + 1];
        a[0] = x0r + x2r;
        a[1] = x0i - x2i;
        a[j1] = x0r - x2r;
        a[j1 + 1] = x0i + x2i;
        a[j2] = x1r + x3i;
        a[j2 + 1] = x1i + x3r;
        a[j3] = x1r - x3i;
        a[j3 + 1] = x1i - x3r;
        double wn4r = w[wP + 1];
        double csc1 = w[wP + 2];
        double csc3 = w[wP + 3];
        double wd1r = 1.0;
        double wd1i = 0.0;
        double wd3r = 1.0;
        double wd3i = 0.0;
        int k = 0;
        for (int j = 2; j < mh - 2; j += 4) {
            wk1r = csc1 * (wd1r + w[wP + (k += 4)]);
            wk1i = csc1 * (wd1i + w[wP + k + 1]);
            wk3r = csc3 * (wd3r + w[wP + k + 2]);
            wk3i = csc3 * (wd3i - w[wP + k + 3]);
            wd1r = w[wP + k];
            wd1i = w[wP + k + 1];
            wd3r = w[wP + k + 2];
            wd3i = -w[wP + k + 3];
            j1 = j + m;
            j2 = j1 + m;
            j3 = j2 + m;
            x0r = a[j] + a[j2];
            x0i = -a[j + 1] - a[j2 + 1];
            x1r = a[j] - a[j2];
            x1i = -a[j + 1] + a[j2 + 1];
            double y0r = a[j + 2] + a[j2 + 2];
            double y0i = -a[j + 3] - a[j2 + 3];
            double y1r = a[j + 2] - a[j2 + 2];
            double y1i = -a[j + 3] + a[j2 + 3];
            x2r = a[j1] + a[j3];
            x2i = a[j1 + 1] + a[j3 + 1];
            x3r = a[j1] - a[j3];
            x3i = a[j1 + 1] - a[j3 + 1];
            double y2r = a[j1 + 2] + a[j3 + 2];
            double y2i = a[j1 + 3] + a[j3 + 3];
            double y3r = a[j1 + 2] - a[j3 + 2];
            double y3i = a[j1 + 3] - a[j3 + 3];
            a[j] = x0r + x2r;
            a[j + 1] = x0i - x2i;
            a[j + 2] = y0r + y2r;
            a[j + 3] = y0i - y2i;
            a[j1] = x0r - x2r;
            a[j1 + 1] = x0i + x2i;
            a[j1 + 2] = y0r - y2r;
            a[j1 + 3] = y0i + y2i;
            x0r = x1r + x3i;
            x0i = x1i + x3r;
            a[j2] = wk1r * x0r - wk1i * x0i;
            a[j2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = y1r + y3i;
            x0i = y1i + y3r;
            a[j2 + 2] = wd1r * x0r - wd1i * x0i;
            a[j2 + 3] = wd1r * x0i + wd1i * x0r;
            x0r = x1r - x3i;
            x0i = x1i - x3r;
            a[j3] = wk3r * x0r + wk3i * x0i;
            a[j3 + 1] = wk3r * x0i - wk3i * x0r;
            x0r = y1r - y3i;
            x0i = y1i - y3r;
            a[j3 + 2] = wd3r * x0r + wd3i * x0i;
            a[j3 + 3] = wd3r * x0i - wd3i * x0r;
            j0 = m - j;
            j1 = j0 + m;
            j2 = j1 + m;
            j3 = j2 + m;
            x0r = a[j0] + a[j2];
            x0i = -a[j0 + 1] - a[j2 + 1];
            x1r = a[j0] - a[j2];
            x1i = -a[j0 + 1] + a[j2 + 1];
            y0r = a[j0 - 2] + a[j2 - 2];
            y0i = -a[j0 - 1] - a[j2 - 1];
            y1r = a[j0 - 2] - a[j2 - 2];
            y1i = -a[j0 - 1] + a[j2 - 1];
            x2r = a[j1] + a[j3];
            x2i = a[j1 + 1] + a[j3 + 1];
            x3r = a[j1] - a[j3];
            x3i = a[j1 + 1] - a[j3 + 1];
            y2r = a[j1 - 2] + a[j3 - 2];
            y2i = a[j1 - 1] + a[j3 - 1];
            y3r = a[j1 - 2] - a[j3 - 2];
            y3i = a[j1 - 1] - a[j3 - 1];
            a[j0] = x0r + x2r;
            a[j0 + 1] = x0i - x2i;
            a[j0 - 2] = y0r + y2r;
            a[j0 - 1] = y0i - y2i;
            a[j1] = x0r - x2r;
            a[j1 + 1] = x0i + x2i;
            a[j1 - 2] = y0r - y2r;
            a[j1 - 1] = y0i + y2i;
            x0r = x1r + x3i;
            x0i = x1i + x3r;
            a[j2] = wk1i * x0r - wk1r * x0i;
            a[j2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = y1r + y3i;
            x0i = y1i + y3r;
            a[j2 - 2] = wd1i * x0r - wd1r * x0i;
            a[j2 - 1] = wd1i * x0i + wd1r * x0r;
            x0r = x1r - x3i;
            x0i = x1i - x3r;
            a[j3] = wk3i * x0r + wk3r * x0i;
            a[j3 + 1] = wk3i * x0i - wk3r * x0r;
            x0r = y1r - y3i;
            x0i = y1i - y3r;
            a[j3 - 2] = wd3i * x0r + wd3r * x0i;
            a[j3 - 1] = wd3i * x0i - wd3r * x0r;
        }
        wk1r = csc1 * (wd1r + wn4r);
        wk1i = csc1 * (wd1i + wn4r);
        wk3r = csc3 * (wd3r - wn4r);
        wk3i = csc3 * (wd3i - wn4r);
        j0 = mh;
        j1 = j0 + m;
        j2 = j1 + m;
        j3 = j2 + m;
        x0r = a[j0 - 2] + a[j2 - 2];
        x0i = -a[j0 - 1] - a[j2 - 1];
        x1r = a[j0 - 2] - a[j2 - 2];
        x1i = -a[j0 - 1] + a[j2 - 1];
        x2r = a[j1 - 2] + a[j3 - 2];
        x2i = a[j1 - 1] + a[j3 - 1];
        x3r = a[j1 - 2] - a[j3 - 2];
        x3i = a[j1 - 1] - a[j3 - 1];
        a[j0 - 2] = x0r + x2r;
        a[j0 - 1] = x0i - x2i;
        a[j1 - 2] = x0r - x2r;
        a[j1 - 1] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a[j2 - 2] = wk1r * x0r - wk1i * x0i;
        a[j2 - 1] = wk1r * x0i + wk1i * x0r;
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a[j3 - 2] = wk3r * x0r + wk3i * x0i;
        a[j3 - 1] = wk3r * x0i - wk3i * x0r;
        x0r = a[j0] + a[j2];
        x0i = -a[j0 + 1] - a[j2 + 1];
        x1r = a[j0] - a[j2];
        x1i = -a[j0 + 1] + a[j2 + 1];
        x2r = a[j1] + a[j3];
        x2i = a[j1 + 1] + a[j3 + 1];
        x3r = a[j1] - a[j3];
        x3i = a[j1 + 1] - a[j3 + 1];
        a[j0] = x0r + x2r;
        a[j0 + 1] = x0i - x2i;
        a[j1] = x0r - x2r;
        a[j1 + 1] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a[j2] = wn4r * (x0r - x0i);
        a[j2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a[j3] = -wn4r * (x0r + x0i);
        a[j3 + 1] = -wn4r * (x0i - x0r);
        x0r = a[j0 + 2] + a[j2 + 2];
        x0i = -a[j0 + 3] - a[j2 + 3];
        x1r = a[j0 + 2] - a[j2 + 2];
        x1i = -a[j0 + 3] + a[j2 + 3];
        x2r = a[j1 + 2] + a[j3 + 2];
        x2i = a[j1 + 3] + a[j3 + 3];
        x3r = a[j1 + 2] - a[j3 + 2];
        x3i = a[j1 + 3] - a[j3 + 3];
        a[j0 + 2] = x0r + x2r;
        a[j0 + 3] = x0i - x2i;
        a[j1 + 2] = x0r - x2r;
        a[j1 + 3] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a[j2 + 2] = wk1i * x0r - wk1r * x0i;
        a[j2 + 3] = wk1i * x0i + wk1r * x0r;
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a[j3 + 2] = wk3i * x0r + wk3r * x0i;
        a[j3 + 3] = wk3i * x0i - wk3r * x0r;
    }

    private void cftrec1(int n, double[] a, int aP, int nw, double[] w) {
        int m = n >> 2;
        this.cftmdl1(n, a, aP, w, nw - 2 * m);
        if (n > 512) {
            this.cftrec1(m, a, aP, nw, w);
            this.cftrec2(m, a, aP + m, nw, w);
            this.cftrec1(m, a, aP + 2 * m, nw, w);
            this.cftrec1(m, a, aP + 3 * m, nw, w);
        } else {
            this.cftexp1(n, a, aP, nw, w);
        }
    }

    private void cftrec2(int n, double[] a, int aP, int nw, double[] w) {
        int m = n >> 2;
        this.cftmdl2(n, a, aP, w, nw - n);
        if (n > 512) {
            this.cftrec1(m, a, aP, nw, w);
            this.cftrec2(m, a, aP + m, nw, w);
            this.cftrec1(m, a, aP + 2 * m, nw, w);
            this.cftrec2(m, a, aP + 3 * m, nw, w);
        } else {
            this.cftexp2(n, a, aP, nw, w);
        }
    }

    private void cftexp1(int n, double[] a, int aP, int nw, double[] w) {
        int j;
        int k;
        int l;
        for (l = n >> 2; l > 128; l >>= 2) {
            for (k = l; k < n; k <<= 2) {
                for (j = k - l; j < n; j += 4 * k) {
                    this.cftmdl1(l, a, aP + j, w, nw - (l >> 1));
                    this.cftmdl2(l, a, aP + k + j, w, nw - l);
                    this.cftmdl1(l, a, aP + 2 * k + j, w, nw - (l >> 1));
                }
            }
            this.cftmdl1(l, a, aP + n - l, w, nw - (l >> 1));
        }
        for (k = l; k < n; k <<= 2) {
            for (j = k - l; j < n; j += 4 * k) {
                this.cftmdl1(l, a, aP + j, w, nw - (l >> 1));
                this.cftfx41(l, a, aP + j, nw, w);
                this.cftmdl2(l, a, aP + k + j, w, nw - l);
                this.cftfx42(l, a, aP + k + j, nw, w);
                this.cftmdl1(l, a, aP + 2 * k + j, w, nw - (l >> 1));
                this.cftfx41(l, a, aP + 2 * k + j, nw, w);
            }
        }
        this.cftmdl1(l, a, aP + n - l, w, nw - (l >> 1));
        this.cftfx41(l, a, aP + n - l, nw, w);
    }

    private void cftexp2(int n, double[] a, int aP, int nw, double[] w) {
        int j;
        int k;
        int l;
        int m = n >> 1;
        for (l = n >> 2; l > 128; l >>= 2) {
            for (k = l; k < m; k <<= 2) {
                for (j = k - l; j < m; j += 2 * k) {
                    this.cftmdl1(l, a, aP + j, w, nw - (l >> 1));
                    this.cftmdl1(l, a, aP + m + j, w, nw - (l >> 1));
                }
                for (j = 2 * k - l; j < m; j += 4 * k) {
                    this.cftmdl2(l, a, aP + j, w, nw - l);
                    this.cftmdl2(l, a, aP + m + j, w, nw - l);
                }
            }
        }
        for (k = l; k < m; k <<= 2) {
            for (j = k - l; j < m; j += 2 * k) {
                this.cftmdl1(l, a, aP + j, w, nw - (l >> 1));
                this.cftfx41(l, a, aP + j, nw, w);
                this.cftmdl1(l, a, aP + m + j, w, nw - (l >> 1));
                this.cftfx41(l, a, aP + m + j, nw, w);
            }
            for (j = 2 * k - l; j < m; j += 4 * k) {
                this.cftmdl2(l, a, aP + j, w, nw - l);
                this.cftfx42(l, a, aP + j, nw, w);
                this.cftmdl2(l, a, aP + m + j, w, nw - l);
                this.cftfx42(l, a, aP + m + j, nw, w);
            }
        }
    }

    private final void cftmdl1(int n, double[] a, int aP, double[] w, int wP) {
        int j0;
        int m;
        int mh = n >> 3;
        int j1 = m = 2 * mh;
        int j2 = j1 + m;
        int j3 = j2 + m;
        double x0r = a[aP + 0] + a[aP + j2];
        double x0i = a[aP + 1] + a[aP + j2 + 1];
        double x1r = a[aP + 0] - a[aP + j2];
        double x1i = a[aP + 1] - a[aP + j2 + 1];
        double x2r = a[aP + j1] + a[aP + j3];
        double x2i = a[aP + j1 + 1] + a[aP + j3 + 1];
        double x3r = a[aP + j1] - a[aP + j3];
        double x3i = a[aP + j1 + 1] - a[aP + j3 + 1];
        a[aP + 0] = x0r + x2r;
        a[aP + 1] = x0i + x2i;
        a[aP + j1] = x0r - x2r;
        a[aP + j1 + 1] = x0i - x2i;
        a[aP + j2] = x1r - x3i;
        a[aP + j2 + 1] = x1i + x3r;
        a[aP + j3] = x1r + x3i;
        a[aP + j3 + 1] = x1i - x3r;
        double wn4r = w[wP + 1];
        int k = 0;
        for (int j = 2; j < mh; j += 2) {
            double wk1r = w[wP + (k += 4)];
            double wk1i = w[wP + k + 1];
            double wk3r = w[wP + k + 2];
            double wk3i = -w[wP + k + 3];
            j1 = j + m;
            j2 = j1 + m;
            j3 = j2 + m;
            x0r = a[aP + j] + a[aP + j2];
            x0i = a[aP + j + 1] + a[aP + j2 + 1];
            x1r = a[aP + j] - a[aP + j2];
            x1i = a[aP + j + 1] - a[aP + j2 + 1];
            x2r = a[aP + j1] + a[aP + j3];
            x2i = a[aP + j1 + 1] + a[aP + j3 + 1];
            x3r = a[aP + j1] - a[aP + j3];
            x3i = a[aP + j1 + 1] - a[aP + j3 + 1];
            a[aP + j] = x0r + x2r;
            a[aP + j + 1] = x0i + x2i;
            a[aP + j1] = x0r - x2r;
            a[aP + j1 + 1] = x0i - x2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a[aP + j2] = wk1r * x0r - wk1i * x0i;
            a[aP + j2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a[aP + j3] = wk3r * x0r + wk3i * x0i;
            a[aP + j3 + 1] = wk3r * x0i - wk3i * x0r;
            j0 = m - j;
            j1 = j0 + m;
            j2 = j1 + m;
            j3 = j2 + m;
            x0r = a[aP + j0] + a[aP + j2];
            x0i = a[aP + j0 + 1] + a[aP + j2 + 1];
            x1r = a[aP + j0] - a[aP + j2];
            x1i = a[aP + j0 + 1] - a[aP + j2 + 1];
            x2r = a[aP + j1] + a[aP + j3];
            x2i = a[aP + j1 + 1] + a[aP + j3 + 1];
            x3r = a[aP + j1] - a[aP + j3];
            x3i = a[aP + j1 + 1] - a[aP + j3 + 1];
            a[aP + j0] = x0r + x2r;
            a[aP + j0 + 1] = x0i + x2i;
            a[aP + j1] = x0r - x2r;
            a[aP + j1 + 1] = x0i - x2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a[aP + j2] = wk1i * x0r - wk1r * x0i;
            a[aP + j2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a[aP + j3] = wk3i * x0r + wk3r * x0i;
            a[aP + j3 + 1] = wk3i * x0i - wk3r * x0r;
        }
        j0 = mh;
        j1 = j0 + m;
        j2 = j1 + m;
        j3 = j2 + m;
        x0r = a[aP + j0] + a[aP + j2];
        x0i = a[aP + j0 + 1] + a[aP + j2 + 1];
        x1r = a[aP + j0] - a[aP + j2];
        x1i = a[aP + j0 + 1] - a[aP + j2 + 1];
        x2r = a[aP + j1] + a[aP + j3];
        x2i = a[aP + j1 + 1] + a[aP + j3 + 1];
        x3r = a[aP + j1] - a[aP + j3];
        x3i = a[aP + j1 + 1] - a[aP + j3 + 1];
        a[aP + j0] = x0r + x2r;
        a[aP + j0 + 1] = x0i + x2i;
        a[aP + j1] = x0r - x2r;
        a[aP + j1 + 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a[aP + j2] = wn4r * (x0r - x0i);
        a[aP + j2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a[aP + j3] = -wn4r * (x0r + x0i);
        a[aP + j3 + 1] = -wn4r * (x0i - x0r);
    }

    private final void cftmdl2(int n, double[] a, int aP, double[] w, int wP) {
        int j0;
        double y2i;
        double y2r;
        double wk1i;
        double wk1r;
        int mh = n >> 3;
        int m = 2 * mh;
        double wn4r = w[wP + 1];
        int j1 = m;
        int j2 = j1 + m;
        int j3 = j2 + m;
        double x0r = a[aP + 0] - a[aP + j2 + 1];
        double x0i = a[aP + 1] + a[aP + j2];
        double x1r = a[aP + 0] + a[aP + j2 + 1];
        double x1i = a[aP + 1] - a[aP + j2];
        double x2r = a[aP + j1] - a[aP + j3 + 1];
        double x2i = a[aP + j1 + 1] + a[aP + j3];
        double x3r = a[aP + j1] + a[aP + j3 + 1];
        double x3i = a[aP + j1 + 1] - a[aP + j3];
        double y0r = wn4r * (x2r - x2i);
        double y0i = wn4r * (x2i + x2r);
        a[aP + 0] = x0r + y0r;
        a[aP + 1] = x0i + y0i;
        a[aP + j1] = x0r - y0r;
        a[aP + j1 + 1] = x0i - y0i;
        y0r = wn4r * (x3r - x3i);
        y0i = wn4r * (x3i + x3r);
        a[aP + j2] = x1r - y0i;
        a[aP + j2 + 1] = x1i + y0r;
        a[aP + j3] = x1r + y0i;
        a[aP + j3 + 1] = x1i - y0r;
        int k = 0;
        int kr = 2 * m;
        for (int j = 2; j < mh; j += 2) {
            wk1r = w[wP + (k += 4)];
            wk1i = w[wP + k + 1];
            double wk3r = w[wP + k + 2];
            double wk3i = -w[wP + k + 3];
            double wd1i = w[wP + (kr -= 4)];
            double wd1r = w[wP + kr + 1];
            double wd3i = w[wP + kr + 2];
            double wd3r = -w[wP + kr + 3];
            j1 = j + m;
            j2 = j1 + m;
            j3 = j2 + m;
            x0r = a[aP + j] - a[aP + j2 + 1];
            x0i = a[aP + j + 1] + a[aP + j2];
            x1r = a[aP + j] + a[aP + j2 + 1];
            x1i = a[aP + j + 1] - a[aP + j2];
            x2r = a[aP + j1] - a[aP + j3 + 1];
            x2i = a[aP + j1 + 1] + a[aP + j3];
            x3r = a[aP + j1] + a[aP + j3 + 1];
            x3i = a[aP + j1 + 1] - a[aP + j3];
            y0r = wk1r * x0r - wk1i * x0i;
            y0i = wk1r * x0i + wk1i * x0r;
            y2r = wd1r * x2r - wd1i * x2i;
            y2i = wd1r * x2i + wd1i * x2r;
            a[aP + j] = y0r + y2r;
            a[aP + j + 1] = y0i + y2i;
            a[aP + j1] = y0r - y2r;
            a[aP + j1 + 1] = y0i - y2i;
            y0r = wk3r * x1r + wk3i * x1i;
            y0i = wk3r * x1i - wk3i * x1r;
            y2r = wd3r * x3r + wd3i * x3i;
            y2i = wd3r * x3i - wd3i * x3r;
            a[aP + j2] = y0r + y2r;
            a[aP + j2 + 1] = y0i + y2i;
            a[aP + j3] = y0r - y2r;
            a[aP + j3 + 1] = y0i - y2i;
            j0 = m - j;
            j1 = j0 + m;
            j2 = j1 + m;
            j3 = j2 + m;
            x0r = a[aP + j0] - a[aP + j2 + 1];
            x0i = a[aP + j0 + 1] + a[aP + j2];
            x1r = a[aP + j0] + a[aP + j2 + 1];
            x1i = a[aP + j0 + 1] - a[aP + j2];
            x2r = a[aP + j1] - a[aP + j3 + 1];
            x2i = a[aP + j1 + 1] + a[aP + j3];
            x3r = a[aP + j1] + a[aP + j3 + 1];
            x3i = a[aP + j1 + 1] - a[aP + j3];
            y0r = wd1i * x0r - wd1r * x0i;
            y0i = wd1i * x0i + wd1r * x0r;
            y2r = wk1i * x2r - wk1r * x2i;
            y2i = wk1i * x2i + wk1r * x2r;
            a[aP + j0] = y0r + y2r;
            a[aP + j0 + 1] = y0i + y2i;
            a[aP + j1] = y0r - y2r;
            a[aP + j1 + 1] = y0i - y2i;
            y0r = wd3i * x1r + wd3r * x1i;
            y0i = wd3i * x1i - wd3r * x1r;
            y2r = wk3i * x3r + wk3r * x3i;
            y2i = wk3i * x3i - wk3r * x3r;
            a[aP + j2] = y0r + y2r;
            a[aP + j2 + 1] = y0i + y2i;
            a[aP + j3] = y0r - y2r;
            a[aP + j3 + 1] = y0i - y2i;
        }
        wk1r = w[wP + m];
        wk1i = w[wP + m + 1];
        j0 = mh;
        j1 = j0 + m;
        j2 = j1 + m;
        j3 = j2 + m;
        x0r = a[aP + j0] - a[aP + j2 + 1];
        x0i = a[aP + j0 + 1] + a[aP + j2];
        x1r = a[aP + j0] + a[aP + j2 + 1];
        x1i = a[aP + j0 + 1] - a[aP + j2];
        x2r = a[aP + j1] - a[aP + j3 + 1];
        x2i = a[aP + j1 + 1] + a[aP + j3];
        x3r = a[aP + j1] + a[aP + j3 + 1];
        x3i = a[aP + j1 + 1] - a[aP + j3];
        y0r = wk1r * x0r - wk1i * x0i;
        y0i = wk1r * x0i + wk1i * x0r;
        y2r = wk1i * x2r - wk1r * x2i;
        y2i = wk1i * x2i + wk1r * x2r;
        a[aP + j0] = y0r + y2r;
        a[aP + j0 + 1] = y0i + y2i;
        a[aP + j1] = y0r - y2r;
        a[aP + j1 + 1] = y0i - y2i;
        y0r = wk1i * x1r - wk1r * x1i;
        y0i = wk1i * x1i + wk1r * x1r;
        y2r = wk1r * x3r - wk1i * x3i;
        y2i = wk1r * x3i + wk1i * x3r;
        a[aP + j2] = y0r - y2r;
        a[aP + j2 + 1] = y0i - y2i;
        a[aP + j3] = y0r + y2r;
        a[aP + j3 + 1] = y0i + y2i;
    }

    private void cftfx41(int n, double[] a, int aP, int nw, double[] w) {
        if (n == 128) {
            this.cftf161(a, aP, w, nw - 8);
            this.cftf162(a, aP + 32, w, nw - 32);
            this.cftf161(a, aP + 64, w, nw - 8);
            this.cftf161(a, aP + 96, w, nw - 8);
        } else {
            this.cftf081(a, aP, w, nw - 16);
            this.cftf082(a, aP + 16, w, nw - 16);
            this.cftf081(a, aP + 32, w, nw - 16);
            this.cftf081(a, aP + 48, w, nw - 16);
        }
    }

    private void cftfx42(int n, double[] a, int aP, int nw, double[] w) {
        if (n == 128) {
            this.cftf161(a, aP, w, nw - 8);
            this.cftf162(a, aP + 32, w, nw - 32);
            this.cftf161(a, aP + 64, w, nw - 8);
            this.cftf162(a, aP + 96, w, nw - 32);
        } else {
            this.cftf081(a, aP, w, nw - 16);
            this.cftf082(a, aP + 16, w, nw - 16);
            this.cftf081(a, aP + 32, w, nw - 16);
            this.cftf082(a, aP + 48, w, nw - 16);
        }
    }

    private void cftf161(double[] a, int aP, double[] w, int wP) {
        double wn4r = w[wP + 1];
        double wk1i = wn4r * w[wP + 2];
        double wk1r = wk1i + w[wP + 2];
        double x0r = a[aP + 0] + a[aP + 16];
        double x0i = a[aP + 1] + a[aP + 17];
        double x1r = a[aP + 0] - a[aP + 16];
        double x1i = a[aP + 1] - a[aP + 17];
        double x2r = a[aP + 8] + a[aP + 24];
        double x2i = a[aP + 9] + a[aP + 25];
        double x3r = a[aP + 8] - a[aP + 24];
        double x3i = a[aP + 9] - a[aP + 25];
        double y0r = x0r + x2r;
        double y0i = x0i + x2i;
        double y4r = x0r - x2r;
        double y4i = x0i - x2i;
        double y8r = x1r - x3i;
        double y8i = x1i + x3r;
        double y12r = x1r + x3i;
        double y12i = x1i - x3r;
        x0r = a[aP + 2] + a[aP + 18];
        x0i = a[aP + 3] + a[aP + 19];
        x1r = a[aP + 2] - a[aP + 18];
        x1i = a[aP + 3] - a[aP + 19];
        x2r = a[aP + 10] + a[aP + 26];
        x2i = a[aP + 11] + a[aP + 27];
        x3r = a[aP + 10] - a[aP + 26];
        x3i = a[aP + 11] - a[aP + 27];
        double y1r = x0r + x2r;
        double y1i = x0i + x2i;
        double y5r = x0r - x2r;
        double y5i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y9r = wk1r * x0r - wk1i * x0i;
        double y9i = wk1r * x0i + wk1i * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y13r = wk1i * x0r - wk1r * x0i;
        double y13i = wk1i * x0i + wk1r * x0r;
        x0r = a[aP + 4] + a[aP + 20];
        x0i = a[aP + 5] + a[aP + 21];
        x1r = a[aP + 4] - a[aP + 20];
        x1i = a[aP + 5] - a[aP + 21];
        x2r = a[aP + 12] + a[aP + 28];
        x2i = a[aP + 13] + a[aP + 29];
        x3r = a[aP + 12] - a[aP + 28];
        x3i = a[aP + 13] - a[aP + 29];
        double y2r = x0r + x2r;
        double y2i = x0i + x2i;
        double y6r = x0r - x2r;
        double y6i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y10r = wn4r * (x0r - x0i);
        double y10i = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y14r = wn4r * (x0r + x0i);
        double y14i = wn4r * (x0i - x0r);
        x0r = a[aP + 6] + a[aP + 22];
        x0i = a[aP + 7] + a[aP + 23];
        x1r = a[aP + 6] - a[aP + 22];
        x1i = a[aP + 7] - a[aP + 23];
        x2r = a[aP + 14] + a[aP + 30];
        x2i = a[aP + 15] + a[aP + 31];
        x3r = a[aP + 14] - a[aP + 30];
        x3i = a[aP + 15] - a[aP + 31];
        double y3r = x0r + x2r;
        double y3i = x0i + x2i;
        double y7r = x0r - x2r;
        double y7i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y11r = wk1i * x0r - wk1r * x0i;
        double y11i = wk1i * x0i + wk1r * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y15r = wk1r * x0r - wk1i * x0i;
        double y15i = wk1r * x0i + wk1i * x0r;
        x0r = y12r - y14r;
        x0i = y12i - y14i;
        x1r = y12r + y14r;
        x1i = y12i + y14i;
        x2r = y13r - y15r;
        x2i = y13i - y15i;
        x3r = y13r + y15r;
        x3i = y13i + y15i;
        a[aP + 24] = x0r + x2r;
        a[aP + 25] = x0i + x2i;
        a[aP + 26] = x0r - x2r;
        a[aP + 27] = x0i - x2i;
        a[aP + 28] = x1r - x3i;
        a[aP + 29] = x1i + x3r;
        a[aP + 30] = x1r + x3i;
        a[aP + 31] = x1i - x3r;
        x0r = y8r + y10r;
        x0i = y8i + y10i;
        x1r = y8r - y10r;
        x1i = y8i - y10i;
        x2r = y9r + y11r;
        x2i = y9i + y11i;
        x3r = y9r - y11r;
        x3i = y9i - y11i;
        a[aP + 16] = x0r + x2r;
        a[aP + 17] = x0i + x2i;
        a[aP + 18] = x0r - x2r;
        a[aP + 19] = x0i - x2i;
        a[aP + 20] = x1r - x3i;
        a[aP + 21] = x1i + x3r;
        a[aP + 22] = x1r + x3i;
        a[aP + 23] = x1i - x3r;
        x0r = y5r - y7i;
        x0i = y5i + y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        x0r = y5r + y7i;
        x0i = y5i - y7r;
        x3r = wn4r * (x0r - x0i);
        x3i = wn4r * (x0i + x0r);
        x0r = y4r - y6i;
        x0i = y4i + y6r;
        x1r = y4r + y6i;
        x1i = y4i - y6r;
        a[aP + 8] = x0r + x2r;
        a[aP + 9] = x0i + x2i;
        a[aP + 10] = x0r - x2r;
        a[aP + 11] = x0i - x2i;
        a[aP + 12] = x1r - x3i;
        a[aP + 13] = x1i + x3r;
        a[aP + 14] = x1r + x3i;
        a[aP + 15] = x1i - x3r;
        x0r = y0r + y2r;
        x0i = y0i + y2i;
        x1r = y0r - y2r;
        x1i = y0i - y2i;
        x2r = y1r + y3r;
        x2i = y1i + y3i;
        x3r = y1r - y3r;
        x3i = y1i - y3i;
        a[aP + 0] = x0r + x2r;
        a[aP + 1] = x0i + x2i;
        a[aP + 2] = x0r - x2r;
        a[aP + 3] = x0i - x2i;
        a[aP + 4] = x1r - x3i;
        a[aP + 5] = x1i + x3r;
        a[aP + 6] = x1r + x3i;
        a[aP + 7] = x1i - x3r;
    }

    private void cftf162(double[] a, int aP, double[] w, int wP) {
        double wn4r = w[wP + 1];
        double wk1r = w[wP + 4];
        double wk1i = w[wP + 5];
        double wk3r = w[wP + 6];
        double wk3i = w[wP + 7];
        double wk2r = w[wP + 8];
        double wk2i = w[wP + 9];
        double x1r = a[aP + 0] - a[aP + 17];
        double x1i = a[aP + 1] + a[aP + 16];
        double x0r = a[aP + 8] - a[aP + 25];
        double x0i = a[aP + 9] + a[aP + 24];
        double x2r = wn4r * (x0r - x0i);
        double x2i = wn4r * (x0i + x0r);
        double y0r = x1r + x2r;
        double y0i = x1i + x2i;
        double y4r = x1r - x2r;
        double y4i = x1i - x2i;
        x1r = a[aP + 0] + a[aP + 17];
        x1i = a[aP + 1] - a[aP + 16];
        x0r = a[aP + 8] + a[aP + 25];
        x0i = a[aP + 9] - a[aP + 24];
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        double y8r = x1r - x2i;
        double y8i = x1i + x2r;
        double y12r = x1r + x2i;
        double y12i = x1i - x2r;
        x0r = a[aP + 2] - a[aP + 19];
        x0i = a[aP + 3] + a[aP + 18];
        x1r = wk1r * x0r - wk1i * x0i;
        x1i = wk1r * x0i + wk1i * x0r;
        x0r = a[aP + 10] - a[aP + 27];
        x0i = a[aP + 11] + a[aP + 26];
        x2r = wk3i * x0r - wk3r * x0i;
        x2i = wk3i * x0i + wk3r * x0r;
        double y1r = x1r + x2r;
        double y1i = x1i + x2i;
        double y5r = x1r - x2r;
        double y5i = x1i - x2i;
        x0r = a[aP + 2] + a[aP + 19];
        x0i = a[aP + 3] - a[aP + 18];
        x1r = wk3r * x0r - wk3i * x0i;
        x1i = wk3r * x0i + wk3i * x0r;
        x0r = a[aP + 10] + a[aP + 27];
        x0i = a[aP + 11] - a[aP + 26];
        x2r = wk1r * x0r + wk1i * x0i;
        x2i = wk1r * x0i - wk1i * x0r;
        double y9r = x1r - x2r;
        double y9i = x1i - x2i;
        double y13r = x1r + x2r;
        double y13i = x1i + x2i;
        x0r = a[aP + 4] - a[aP + 21];
        x0i = a[aP + 5] + a[aP + 20];
        x1r = wk2r * x0r - wk2i * x0i;
        x1i = wk2r * x0i + wk2i * x0r;
        x0r = a[aP + 12] - a[aP + 29];
        x0i = a[aP + 13] + a[aP + 28];
        x2r = wk2i * x0r - wk2r * x0i;
        x2i = wk2i * x0i + wk2r * x0r;
        double y2r = x1r + x2r;
        double y2i = x1i + x2i;
        double y6r = x1r - x2r;
        double y6i = x1i - x2i;
        x0r = a[aP + 4] + a[aP + 21];
        x0i = a[aP + 5] - a[aP + 20];
        x1r = wk2i * x0r - wk2r * x0i;
        x1i = wk2i * x0i + wk2r * x0r;
        x0r = a[aP + 12] + a[aP + 29];
        x0i = a[aP + 13] - a[aP + 28];
        x2r = wk2r * x0r - wk2i * x0i;
        x2i = wk2r * x0i + wk2i * x0r;
        double y10r = x1r - x2r;
        double y10i = x1i - x2i;
        double y14r = x1r + x2r;
        double y14i = x1i + x2i;
        x0r = a[aP + 6] - a[aP + 23];
        x0i = a[aP + 7] + a[aP + 22];
        x1r = wk3r * x0r - wk3i * x0i;
        x1i = wk3r * x0i + wk3i * x0r;
        x0r = a[aP + 14] - a[aP + 31];
        x0i = a[aP + 15] + a[aP + 30];
        x2r = wk1i * x0r - wk1r * x0i;
        x2i = wk1i * x0i + wk1r * x0r;
        double y3r = x1r + x2r;
        double y3i = x1i + x2i;
        double y7r = x1r - x2r;
        double y7i = x1i - x2i;
        x0r = a[aP + 6] + a[aP + 23];
        x0i = a[aP + 7] - a[aP + 22];
        x1r = wk1i * x0r + wk1r * x0i;
        x1i = wk1i * x0i - wk1r * x0r;
        x0r = a[aP + 14] + a[aP + 31];
        x0i = a[aP + 15] - a[aP + 30];
        x2r = wk3i * x0r - wk3r * x0i;
        x2i = wk3i * x0i + wk3r * x0r;
        double y11r = x1r + x2r;
        double y11i = x1i + x2i;
        double y15r = x1r - x2r;
        double y15i = x1i - x2i;
        x1r = y0r + y2r;
        x1i = y0i + y2i;
        x2r = y1r + y3r;
        x2i = y1i + y3i;
        a[aP + 0] = x1r + x2r;
        a[aP + 1] = x1i + x2i;
        a[aP + 2] = x1r - x2r;
        a[aP + 3] = x1i - x2i;
        x1r = y0r - y2r;
        x1i = y0i - y2i;
        x2r = y1r - y3r;
        x2i = y1i - y3i;
        a[aP + 4] = x1r - x2i;
        a[aP + 5] = x1i + x2r;
        a[aP + 6] = x1r + x2i;
        a[aP + 7] = x1i - x2r;
        x1r = y4r - y6i;
        x1i = y4i + y6r;
        x0r = y5r - y7i;
        x0i = y5i + y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a[aP + 8] = x1r + x2r;
        a[aP + 9] = x1i + x2i;
        a[aP + 10] = x1r - x2r;
        a[aP + 11] = x1i - x2i;
        x1r = y4r + y6i;
        x1i = y4i - y6r;
        x0r = y5r + y7i;
        x0i = y5i - y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a[aP + 12] = x1r - x2i;
        a[aP + 13] = x1i + x2r;
        a[aP + 14] = x1r + x2i;
        a[aP + 15] = x1i - x2r;
        x1r = y8r + y10r;
        x1i = y8i + y10i;
        x2r = y9r - y11r;
        x2i = y9i - y11i;
        a[aP + 16] = x1r + x2r;
        a[aP + 17] = x1i + x2i;
        a[aP + 18] = x1r - x2r;
        a[aP + 19] = x1i - x2i;
        x1r = y8r - y10r;
        x1i = y8i - y10i;
        x2r = y9r + y11r;
        x2i = y9i + y11i;
        a[aP + 20] = x1r - x2i;
        a[aP + 21] = x1i + x2r;
        a[aP + 22] = x1r + x2i;
        a[aP + 23] = x1i - x2r;
        x1r = y12r - y14i;
        x1i = y12i + y14r;
        x0r = y13r + y15i;
        x0i = y13i - y15r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a[aP + 24] = x1r + x2r;
        a[aP + 25] = x1i + x2i;
        a[aP + 26] = x1r - x2r;
        a[aP + 27] = x1i - x2i;
        x1r = y12r + y14i;
        x1i = y12i - y14r;
        x0r = y13r - y15i;
        x0i = y13i + y15r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a[aP + 28] = x1r - x2i;
        a[aP + 29] = x1i + x2r;
        a[aP + 30] = x1r + x2i;
        a[aP + 31] = x1i - x2r;
    }

    private void cftf081(double[] a, int aP, double[] w, int wP) {
        double wn4r = w[wP + 1];
        double x0r = a[aP + 0] + a[aP + 8];
        double x0i = a[aP + 1] + a[aP + 9];
        double x1r = a[aP + 0] - a[aP + 8];
        double x1i = a[aP + 1] - a[aP + 9];
        double x2r = a[aP + 4] + a[aP + 12];
        double x2i = a[aP + 5] + a[aP + 13];
        double x3r = a[aP + 4] - a[aP + 12];
        double x3i = a[aP + 5] - a[aP + 13];
        double y0r = x0r + x2r;
        double y0i = x0i + x2i;
        double y2r = x0r - x2r;
        double y2i = x0i - x2i;
        double y1r = x1r - x3i;
        double y1i = x1i + x3r;
        double y3r = x1r + x3i;
        double y3i = x1i - x3r;
        x0r = a[aP + 2] + a[aP + 10];
        x0i = a[aP + 3] + a[aP + 11];
        x1r = a[aP + 2] - a[aP + 10];
        x1i = a[aP + 3] - a[aP + 11];
        x2r = a[aP + 6] + a[aP + 14];
        x2i = a[aP + 7] + a[aP + 15];
        x3r = a[aP + 6] - a[aP + 14];
        x3i = a[aP + 7] - a[aP + 15];
        double y4r = x0r + x2r;
        double y4i = x0i + x2i;
        double y6r = x0r - x2r;
        double y6i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        x2r = x1r + x3i;
        x2i = x1i - x3r;
        double y5r = wn4r * (x0r - x0i);
        double y5i = wn4r * (x0r + x0i);
        double y7r = wn4r * (x2r - x2i);
        double y7i = wn4r * (x2r + x2i);
        a[aP + 8] = y1r + y5r;
        a[aP + 9] = y1i + y5i;
        a[aP + 10] = y1r - y5r;
        a[aP + 11] = y1i - y5i;
        a[aP + 12] = y3r - y7i;
        a[aP + 13] = y3i + y7r;
        a[aP + 14] = y3r + y7i;
        a[aP + 15] = y3i - y7r;
        a[aP + 0] = y0r + y4r;
        a[aP + 1] = y0i + y4i;
        a[aP + 2] = y0r - y4r;
        a[aP + 3] = y0i - y4i;
        a[aP + 4] = y2r - y6i;
        a[aP + 5] = y2i + y6r;
        a[aP + 6] = y2r + y6i;
        a[aP + 7] = y2i - y6r;
    }

    private void cftf082(double[] a, int aP, double[] w, int wP) {
        double wn4r = w[wP + 1];
        double wk1r = w[wP + 4];
        double wk1i = w[wP + 5];
        double y0r = a[aP + 0] - a[aP + 9];
        double y0i = a[aP + 1] + a[aP + 8];
        double y1r = a[aP + 0] + a[aP + 9];
        double y1i = a[aP + 1] - a[aP + 8];
        double x0r = a[aP + 4] - a[aP + 13];
        double x0i = a[aP + 5] + a[aP + 12];
        double y2r = wn4r * (x0r - x0i);
        double y2i = wn4r * (x0i + x0r);
        x0r = a[aP + 4] + a[aP + 13];
        x0i = a[aP + 5] - a[aP + 12];
        double y3r = wn4r * (x0r - x0i);
        double y3i = wn4r * (x0i + x0r);
        x0r = a[aP + 2] - a[aP + 11];
        x0i = a[aP + 3] + a[aP + 10];
        double y4r = wk1r * x0r - wk1i * x0i;
        double y4i = wk1r * x0i + wk1i * x0r;
        x0r = a[aP + 2] + a[aP + 11];
        x0i = a[aP + 3] - a[aP + 10];
        double y5r = wk1i * x0r - wk1r * x0i;
        double y5i = wk1i * x0i + wk1r * x0r;
        x0r = a[aP + 6] - a[aP + 15];
        x0i = a[aP + 7] + a[aP + 14];
        double y6r = wk1i * x0r - wk1r * x0i;
        double y6i = wk1i * x0i + wk1r * x0r;
        x0r = a[aP + 6] + a[aP + 15];
        x0i = a[aP + 7] - a[aP + 14];
        double y7r = wk1r * x0r - wk1i * x0i;
        double y7i = wk1r * x0i + wk1i * x0r;
        x0r = y0r + y2r;
        x0i = y0i + y2i;
        double x1r = y4r + y6r;
        double x1i = y4i + y6i;
        a[aP + 0] = x0r + x1r;
        a[aP + 1] = x0i + x1i;
        a[aP + 2] = x0r - x1r;
        a[aP + 3] = x0i - x1i;
        x0r = y0r - y2r;
        x0i = y0i - y2i;
        x1r = y4r - y6r;
        x1i = y4i - y6i;
        a[aP + 4] = x0r - x1i;
        a[aP + 5] = x0i + x1r;
        a[aP + 6] = x0r + x1i;
        a[aP + 7] = x0i - x1r;
        x0r = y1r - y3i;
        x0i = y1i + y3r;
        x1r = y5r - y7r;
        x1i = y5i - y7i;
        a[aP + 8] = x0r + x1r;
        a[aP + 9] = x0i + x1i;
        a[aP + 10] = x0r - x1r;
        a[aP + 11] = x0i - x1i;
        x0r = y1r + y3i;
        x0i = y1i - y3r;
        x1r = y5r + y7r;
        x1i = y5i + y7i;
        a[aP + 12] = x0r - x1i;
        a[aP + 13] = x0i + x1r;
        a[aP + 14] = x0r + x1i;
        a[aP + 15] = x0i - x1r;
    }

    private void cftf040(double[] a) {
        double x0r = a[0] + a[4];
        double x0i = a[1] + a[5];
        double x1r = a[0] - a[4];
        double x1i = a[1] - a[5];
        double x2r = a[2] + a[6];
        double x2i = a[3] + a[7];
        double x3r = a[2] - a[6];
        double x3i = a[3] - a[7];
        a[0] = x0r + x2r;
        a[1] = x0i + x2i;
        a[4] = x0r - x2r;
        a[5] = x0i - x2i;
        a[2] = x1r - x3i;
        a[3] = x1i + x3r;
        a[6] = x1r + x3i;
        a[7] = x1i - x3r;
    }

    private void cftb040(double[] a) {
        double x0r = a[0] + a[4];
        double x0i = a[1] + a[5];
        double x1r = a[0] - a[4];
        double x1i = a[1] - a[5];
        double x2r = a[2] + a[6];
        double x2i = a[3] + a[7];
        double x3r = a[2] - a[6];
        double x3i = a[3] - a[7];
        a[0] = x0r + x2r;
        a[1] = x0i + x2i;
        a[4] = x0r - x2r;
        a[5] = x0i - x2i;
        a[2] = x1r + x3i;
        a[3] = x1i - x3r;
        a[6] = x1r - x3i;
        a[7] = x1i + x3r;
    }

    private void cftx020(double[] a) {
        double x0r = a[0] - a[2];
        double x0i = a[1] - a[3];
        a[0] = a[0] + a[2];
        a[1] = a[1] + a[3];
        a[2] = x0r;
        a[3] = x0i;
    }

    private void rftfsub(int n, double[] a, int nc, double[] c, int cP) {
        int m = n >> 1;
        int ks = 2 * nc / m;
        int kk = 0;
        for (int j = 2; j < m; j += 2) {
            int k = n - j;
            double wkr = 0.5 - c[cP + nc - (kk += ks)];
            double wki = c[cP + kk];
            double xr = a[j] - a[k];
            double xi = a[j + 1] + a[k + 1];
            double yr = wkr * xr - wki * xi;
            double yi = wkr * xi + wki * xr;
            int n2 = j;
            a[n2] = a[n2] - yr;
            int n3 = j + 1;
            a[n3] = a[n3] - yi;
            int n4 = k;
            a[n4] = a[n4] + yr;
            int n5 = k + 1;
            a[n5] = a[n5] - yi;
        }
    }

    private void rftbsub(int n, double[] a, int nc, double[] c, int cP) {
        int m = n >> 1;
        int ks = 2 * nc / m;
        int kk = 0;
        for (int j = 2; j < m; j += 2) {
            int k = n - j;
            double wkr = 0.5 - c[cP + nc - (kk += ks)];
            double wki = c[cP + kk];
            double xr = a[j] - a[k];
            double xi = a[j + 1] + a[k + 1];
            double yr = wkr * xr + wki * xi;
            double yi = wkr * xi - wki * xr;
            int n2 = j;
            a[n2] = a[n2] - yr;
            int n3 = j + 1;
            a[n3] = a[n3] - yi;
            int n4 = k;
            a[n4] = a[n4] + yr;
            int n5 = k + 1;
            a[n5] = a[n5] - yi;
        }
    }

    private void dctsub(int n, double[] a, int nc, double[] c, int cP) {
        int m = n >> 1;
        int ks = nc / n;
        int kk = 0;
        for (int j = 1; j < m; ++j) {
            int k = n - j;
            double wkr = c[cP + (kk += ks)] - c[cP + nc - kk];
            double wki = c[cP + kk] + c[cP + nc - kk];
            double xr = wki * a[j] - wkr * a[k];
            a[j] = wkr * a[j] + wki * a[k];
            a[k] = xr;
        }
        int n2 = m;
        a[n2] = a[n2] * c[cP + 0];
    }

    private void dstsub(int n, double[] a, int nc, double[] c, int cP) {
        int m = n >> 1;
        int ks = nc / n;
        int kk = 0;
        for (int j = 1; j < m; ++j) {
            int k = n - j;
            double wkr = c[cP + (kk += ks)] - c[cP + nc - kk];
            double wki = c[cP + kk] + c[cP + nc - kk];
            double xr = wki * a[k] - wkr * a[j];
            a[k] = wkr * a[k] + wki * a[j];
            a[j] = xr;
        }
        int n2 = m;
        a[n2] = a[n2] * c[cP + 0];
    }
}

