/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.view.Surface;
import com.hw.videoprocessor.IVideoEncodeThread;
import com.hw.videoprocessor.VideoProcessor;
import com.hw.videoprocessor.util.CL;
import com.hw.videoprocessor.util.VideoProgressAve;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class VideoEncodeThread
extends Thread
implements IVideoEncodeThread {
    private MediaCodec mEncoder;
    private MediaMuxer mMuxer;
    private AtomicBoolean mDecodeDone;
    private CountDownLatch mMuxerStartLatch;
    private Exception mException;
    private int mBitrate;
    private int mResultWidth;
    private int mResultHeight;
    private int mIFrameInterval;
    private int mFrameRate;
    private MediaExtractor mExtractor;
    private int mVideoIndex;
    private volatile CountDownLatch mEglContextLatch;
    private volatile Surface mSurface;
    private VideoProgressAve mProgressAve;

    public VideoEncodeThread(MediaExtractor extractor, MediaMuxer muxer, int bitrate, int resultWidth, int resultHeight, int iFrameInterval, int frameRate, int videoIndex, AtomicBoolean decodeDone, CountDownLatch muxerStartLatch) {
        super("VideoProcessEncodeThread");
        this.mMuxer = muxer;
        this.mDecodeDone = decodeDone;
        this.mMuxerStartLatch = muxerStartLatch;
        this.mExtractor = extractor;
        this.mBitrate = bitrate;
        this.mResultHeight = resultHeight;
        this.mResultWidth = resultWidth;
        this.mIFrameInterval = iFrameInterval;
        this.mVideoIndex = videoIndex;
        this.mFrameRate = frameRate;
        this.mEglContextLatch = new CountDownLatch(1);
    }

    @Override
    public void run() {
        super.run();
        try {
            this.doEncode();
        }
        catch (Exception e) {
            CL.e(e);
            this.mException = e;
        }
        finally {
            if (this.mEncoder != null) {
                this.mEncoder.stop();
                this.mEncoder.release();
            }
        }
    }

    private void doEncode() throws IOException {
        block9: {
            MediaFormat inputFormat = this.mExtractor.getTrackFormat(this.mVideoIndex);
            int frameRate = this.mFrameRate > 0 ? this.mFrameRate : (inputFormat.containsKey("frame-rate") ? inputFormat.getInteger("frame-rate") : VideoProcessor.DEFAULT_FRAME_RATE);
            MediaFormat outputFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)this.mResultWidth, (int)this.mResultHeight);
            outputFormat.setInteger("color-format", 2130708361);
            outputFormat.setInteger("bitrate", this.mBitrate);
            outputFormat.setInteger("frame-rate", frameRate);
            outputFormat.setInteger("i-frame-interval", this.mIFrameInterval);
            this.mEncoder = MediaCodec.createEncoderByType((String)"video/avc");
            this.mEncoder.configure(outputFormat, null, null, 1);
            this.mSurface = this.mEncoder.createInputSurface();
            this.mEncoder.start();
            this.mEglContextLatch.countDown();
            boolean signalEncodeEnd = false;
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int encodeTryAgainCount = 0;
            int videoTrackIndex = -5;
            while (true) {
                if (this.mDecodeDone.get() && !signalEncodeEnd) {
                    signalEncodeEnd = true;
                    this.mEncoder.signalEndOfInputStream();
                }
                int outputBufferIndex = this.mEncoder.dequeueOutputBuffer(info, 2500L);
                CL.i("encode outputBufferIndex = " + outputBufferIndex, new Object[0]);
                if (signalEncodeEnd && outputBufferIndex == -1) {
                    if (++encodeTryAgainCount > 10) {
                        CL.e("INFO_TRY_AGAIN_LATER 10 times,force End!", new Object[0]);
                        break block9;
                    }
                } else {
                    encodeTryAgainCount = 0;
                }
                if (outputBufferIndex == -1) continue;
                if (outputBufferIndex == -2) {
                    MediaFormat newFormat = this.mEncoder.getOutputFormat();
                    if (videoTrackIndex == -5) {
                        videoTrackIndex = this.mMuxer.addTrack(newFormat);
                        this.mMuxer.start();
                        this.mMuxerStartLatch.countDown();
                    }
                    CL.i("encode newFormat = " + newFormat, new Object[0]);
                    continue;
                }
                if (outputBufferIndex < 0) {
                    CL.e("unexpected result from decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                    continue;
                }
                ByteBuffer outputBuffer = this.mEncoder.getOutputBuffer(outputBufferIndex);
                CL.i("writeSampleData,size:" + info.size + " time:" + info.presentationTimeUs / 1000L, new Object[0]);
                if (info.flags == 4 && info.presentationTimeUs < 0L) {
                    info.presentationTimeUs = 0L;
                }
                this.mMuxer.writeSampleData(videoTrackIndex, outputBuffer, info);
                this.notifyProgress(info);
                this.mEncoder.releaseOutputBuffer(outputBufferIndex, false);
                if (info.flags == 4) break;
            }
            CL.i("encoderDone", new Object[0]);
        }
    }

    private void notifyProgress(MediaCodec.BufferInfo info) {
        if (this.mProgressAve == null) {
            return;
        }
        this.mProgressAve.setEncodeTimeStamp((info.flags & 4) > 0 ? Long.MAX_VALUE : info.presentationTimeUs);
    }

    @Override
    public Surface getSurface() {
        return this.mSurface;
    }

    @Override
    public CountDownLatch getEglContextLatch() {
        return this.mEglContextLatch;
    }

    public Exception getException() {
        return this.mException;
    }

    public void setProgressAve(VideoProgressAve progressAve) {
        this.mProgressAve = progressAve;
    }
}

