/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor;

import android.content.Context;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.media.MediaMuxer;
import android.util.Pair;
import com.hw.videoprocessor.VideoAppendEncodeThread;
import com.hw.videoprocessor.VideoDecodeThread;
import com.hw.videoprocessor.VideoProcessor;
import com.hw.videoprocessor.util.AudioUtil;
import com.hw.videoprocessor.util.CL;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class VideoUtil {
    public static List<File> splitVideo(Context context, String inputVideo, String outputDir, int splitTimeMs, int minSliceSize, Integer bitrate, float speed, Integer iFrameInterval) throws Exception {
        int durationMs;
        splitTimeMs = (int)((float)splitTimeMs * speed);
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(inputVideo);
        int remainTimeMs = durationMs = Integer.parseInt(retriever.extractMetadata(9));
        LinkedList<Pair> sliceList = new LinkedList<Pair>();
        int sliceStartTimeMs = 0;
        while (remainTimeMs > 0) {
            if ((remainTimeMs -= splitTimeMs) < minSliceSize) {
                sliceList.add(new Pair((Object)sliceStartTimeMs, (Object)(sliceStartTimeMs + splitTimeMs + remainTimeMs)));
                break;
            }
            sliceList.add(new Pair((Object)sliceStartTimeMs, (Object)(sliceStartTimeMs + splitTimeMs)));
            sliceStartTimeMs += splitTimeMs;
        }
        ArrayList<File> fileList = new ArrayList<File>(sliceList.size());
        for (Pair pair : sliceList) {
            File file = new File(outputDir, pair.first + ".mp4");
            VideoProcessor.processVideo(context, inputVideo, file.getAbsolutePath(), null, null, (Integer)pair.first, (Integer)pair.second, Float.valueOf(speed), bitrate, null, iFrameInterval, null);
            fileList.add(file);
        }
        return fileList;
    }

    public static void combineVideos(List<File> inputVideos, String outputVideo, Integer bitrate, Integer iFrameInterval) throws Exception {
        boolean audioExist;
        if (inputVideos == null || inputVideos.size() == 0) {
            return;
        }
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(inputVideos.get(0).getAbsolutePath());
        int combineBitrate = bitrate == null ? Integer.parseInt(retriever.extractMetadata(20)) : bitrate;
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(inputVideos.get(0).getAbsolutePath());
        int videoIndex = VideoUtil.selectTrack(extractor, false);
        int audioIndex = VideoUtil.selectTrack(extractor, true);
        MediaMuxer mediaMuxer = new MediaMuxer(outputVideo, 0);
        int videoMuxerIndex = mediaMuxer.addTrack(extractor.getTrackFormat(videoIndex));
        int audioMuxerIndex = 0;
        boolean bl = audioExist = audioIndex >= 0;
        if (audioExist) {
            audioMuxerIndex = mediaMuxer.addTrack(extractor.getTrackFormat(audioIndex));
        }
        mediaMuxer.start();
        long audioFrameTimeUs = 0L;
        long baseFrameTimeUs = 0L;
        for (int i = 0; i < inputVideos.size(); ++i) {
            if (i > 0) {
                extractor = new MediaExtractor();
                extractor.setDataSource(inputVideos.get(i).getAbsolutePath());
                audioIndex = VideoUtil.selectTrack(extractor, true);
            }
            if (audioExist) {
                audioFrameTimeUs = AudioUtil.writeAudioTrack(extractor, mediaMuxer, audioMuxerIndex, null, null, baseFrameTimeUs, null);
                extractor.unselectTrack(audioIndex);
            }
            long videoFrameTimeUs = VideoUtil.appendVideoTrack(extractor, mediaMuxer, videoMuxerIndex, null, null, baseFrameTimeUs, combineBitrate, iFrameInterval, i == 0, false);
            baseFrameTimeUs = videoFrameTimeUs > audioFrameTimeUs ? videoFrameTimeUs : audioFrameTimeUs;
            CL.i("\u7247\u6bb5" + i + "\u5df2\u5408\u6210,audioFrameTime:" + (float)audioFrameTimeUs / 1000.0f + " videoFrameTime:" + (float)videoFrameTimeUs / 1000.0f, new Object[0]);
            baseFrameTimeUs += 33000L;
            extractor.release();
            long s1 = System.currentTimeMillis();
            String out = inputVideos.get(i).getAbsolutePath() + ".rev";
            VideoProcessor.reverseVideoNoDecode(inputVideos.get(i).getAbsolutePath(), out);
            long e1 = System.currentTimeMillis();
            CL.e("reverseVideoNoDecode:" + (e1 - s1) + "ms", new Object[0]);
            extractor = new MediaExtractor();
            extractor.setDataSource(out);
            if (audioExist) {
                audioIndex = VideoUtil.selectTrack(extractor, true);
                audioFrameTimeUs = AudioUtil.writeAudioTrack(extractor, mediaMuxer, audioMuxerIndex, null, null, baseFrameTimeUs, null);
                extractor.unselectTrack(audioIndex);
            }
            videoFrameTimeUs = VideoUtil.appendVideoTrack(extractor, mediaMuxer, videoMuxerIndex, null, null, baseFrameTimeUs, combineBitrate, iFrameInterval, false, i == inputVideos.size() - 1);
            baseFrameTimeUs = videoFrameTimeUs > audioFrameTimeUs ? videoFrameTimeUs : audioFrameTimeUs;
            CL.i("\u53cd\u5e8f\u7247\u6bb5" + i + "\u5df2\u5408\u6210,audioFrameTime:" + (float)audioFrameTimeUs / 1000.0f + " videoFrameTime:" + (float)videoFrameTimeUs / 1000.0f, new Object[0]);
            baseFrameTimeUs += 33000L;
            extractor.release();
            new File(out).delete();
        }
        mediaMuxer.release();
    }

    public static int selectTrack(MediaExtractor extractor, boolean audio) {
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            MediaFormat format = extractor.getTrackFormat(i);
            String mime = format.getString("mime");
            if (!(audio ? mime.startsWith("audio/") : mime.startsWith("video/"))) continue;
            return i;
        }
        return -5;
    }

    static long appendVideoTrack(MediaExtractor extractor, MediaMuxer mediaMuxer, int muxerVideoTrackIndex, Integer startTimeUs, Integer endTimeUs, long baseMuxerFrameTimeUs, int bitrate, int iFrameInterval, boolean isFirst, boolean isLast) throws Exception {
        int videoTrack = VideoUtil.selectTrack(extractor, false);
        extractor.selectTrack(videoTrack);
        if (startTimeUs == null) {
            startTimeUs = 0;
        }
        extractor.seekTo((long)startTimeUs.intValue(), 2);
        MediaFormat videoFormat = extractor.getTrackFormat(videoTrack);
        int resultWidth = videoFormat.getInteger("width");
        int resultHeight = videoFormat.getInteger("height");
        AtomicBoolean decodeDone = new AtomicBoolean(false);
        VideoAppendEncodeThread encodeThread = new VideoAppendEncodeThread(extractor, mediaMuxer, bitrate, resultWidth, resultHeight, iFrameInterval, videoTrack, decodeDone, baseMuxerFrameTimeUs, isFirst, isLast, muxerVideoTrackIndex);
        VideoDecodeThread decodeThread = new VideoDecodeThread(encodeThread, extractor, startTimeUs == null ? null : Integer.valueOf(startTimeUs / 1000), endTimeUs == null ? null : Integer.valueOf(endTimeUs / 1000), null, null, videoTrack, decodeDone);
        decodeThread.start();
        encodeThread.start();
        try {
            decodeThread.join();
            encodeThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            extractor.release();
        }
        catch (Exception e2) {
            CL.e(e2);
        }
        if (encodeThread.getException() != null) {
            throw encodeThread.getException();
        }
        if (decodeThread.getException() != null) {
            throw decodeThread.getException();
        }
        return encodeThread.getLastFrametimeUs();
    }

    public static int getBitrateForAllKeyFrameVideo(String input) throws IOException {
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(input);
        int trackIndex = VideoUtil.selectTrack(extractor, false);
        extractor.selectTrack(trackIndex);
        int keyFrameCount = 0;
        int frameCount = 0;
        while (true) {
            long sampleTime;
            int flags;
            if ((flags = extractor.getSampleFlags()) > 0 && (flags & 1) != 0) {
                ++keyFrameCount;
            }
            if ((sampleTime = extractor.getSampleTime()) < 0L) break;
            ++frameCount;
            extractor.advance();
        }
        extractor.release();
        float bitrateMultiple = (float)(frameCount - keyFrameCount) / (float)keyFrameCount + 1.0f;
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(input);
        int oriBitrate = Integer.parseInt(retriever.extractMetadata(20));
        retriever.release();
        if (frameCount == keyFrameCount) {
            return oriBitrate;
        }
        return (int)(bitrateMultiple * (float)oriBitrate);
    }

    public static Pair<Integer, Integer> getVideoFrameCount(String input) throws IOException {
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(input);
        int trackIndex = VideoUtil.selectTrack(extractor, false);
        extractor.selectTrack(trackIndex);
        int keyFrameCount = 0;
        int frameCount = 0;
        while (true) {
            long sampleTime;
            int flags;
            if ((flags = extractor.getSampleFlags()) > 0 && (flags & 1) != 0) {
                ++keyFrameCount;
            }
            if ((sampleTime = extractor.getSampleTime()) < 0L) break;
            ++frameCount;
            extractor.advance();
        }
        extractor.release();
        return new Pair((Object)keyFrameCount, (Object)frameCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFrameRate(String videoPath) {
        MediaExtractor extractor = new MediaExtractor();
        try {
            extractor.setDataSource(videoPath);
            int trackIndex = VideoUtil.selectTrack(extractor, false);
            MediaFormat format = extractor.getTrackFormat(trackIndex);
            int n = format.containsKey("frame-rate") ? format.getInteger("frame-rate") : -1;
            return n;
        }
        catch (IOException e) {
            CL.e(e);
            int n = -1;
            return n;
        }
        finally {
            extractor.release();
        }
    }

    public static void seekToLastFrame(MediaExtractor extractor, int trackIndex, int durationMs) {
        int seekToDuration = durationMs * 1000;
        if (extractor.getSampleTrackIndex() != trackIndex) {
            extractor.selectTrack(trackIndex);
        }
        extractor.seekTo((long)seekToDuration, 0);
        while (seekToDuration > 0 && extractor.getSampleTrackIndex() != trackIndex) {
            extractor.seekTo((long)(seekToDuration -= 10000), 0);
        }
    }
}

