/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor.jssrc;

import com.hw.videoprocessor.jssrc.I0Bessel;
import com.hw.videoprocessor.jssrc.SplitRadixFft;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Random;

public class SSRC {
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private SplitRadixFft fft = new SplitRadixFft();
    private static final String VERSION = "1.30";
    private double AA = 170.0;
    private double DF = 100.0;
    private int FFTFIRLEN = 65536;
    private static final int RANDBUFLEN = 65536;
    private static final int[] scoeffreq = new int[]{0, 48000, 44100, 37800, 32000, 22050, 48000, 44100};
    private static final int[] scoeflen = new int[]{1, 16, 20, 16, 16, 15, 16, 15};
    private static final int[] samp = new int[]{8, 18, 27, 8, 8, 8, 10, 9};
    private static final double[][] shapercoefs = new double[][]{{-1.0}, {-2.87207293510437, 5.041323184967041, -6.244299411773682, 5.848398685455322, -3.706754207611084, 1.0495119094848633, 1.1830236911773682, -2.1126792430877686, 1.9094531536102295, -0.9991308450698853, 0.17090806365013123, 0.32615602016448975, -0.39127644896507263, 0.2687646150588989, -0.0976761057972908, 0.023473845794796944}, {-2.6773197650909424, 4.830892562866211, -6.570110321044922, 7.4572014808654785, -6.726327419281006, 4.848165035247803, -2.041209f, -0.7006359100341797, 2.95375657081604, -4.080038547515869, 4.184521675109863, -3.331181287765503, 2.117992639541626, -0.879302978515625, 0.031759146600961685, 0.4238278865814209, -0.4788210391998291, 0.35490813851356506, -0.1749683916568756, 0.06090816855430603}, {-1.6335992813110352, 2.261549234390259, -2.407702922821045, 2.634171724319458, -2.144036293029785, 1.8153258562088013, -1.0816224813461304, 0.703026533126831, -0.15991993248462677, -0.04154951870441437, 0.2941657602787018, -0.25183168053627014, 0.27766478061676025, -0.15785403549671173, 0.10165894031524658, -0.016833892092108727}, {-0.829013f, 0.9892265796661377, -0.5982571244239807, 1.0028809309005737, -0.5993821620941162, 0.7950245141983032, -0.42723315954208374, 0.5449252724647522, -0.3079260587692261, 0.368718f, -0.187920480966568, 0.2261127084493637, -0.10573341697454453, 0.11435490846633911, -0.0388006791472435, 0.040842197835445404}, {-0.06522997468709946, 0.5498126149177551, 0.4027854800224304, 0.3178376853466034, 0.2820179760456085, 0.16985194385051727, 0.15433363616466522, 0.1250714f, 0.08903945237398148, 0.06441012024879456, 0.04714600369334221, 0.03280523791909218, 0.028495194390416145, 0.011695005930960178, 0.011831838637590408}, {-2.3925774097442627, 3.4350297451019287, -3.185370922088623, 1.8117271661758423, 0.2012477070093155, -1.4759907722473145, 1.7210904359817505, -0.977467f, 0.13790138065814972, 0.38185903429985046, -0.27421241998672485, -0.06658421456813812, 0.35223302245140076, -0.37672343850135803, 0.23964276909828186, -0.06867482513189316}, {-2.0833916664123535, 3.041845f, -3.204789876937866, 2.757192611694336, -1.497863f, 0.34275946021080017, 0.7173374891281128, -1.073705792427063, 1.0225815773010254, -0.5664999485015869, 0.20968692004680634, 0.06537853181362152, -0.10322438180446625, 0.06744202226400375, 0.00495197344571352}};
    private double[][] shapebuf;
    private int shaper_type;
    private int shaper_len;
    private int shaper_clipmin;
    private int shaper_clipmax;
    private double[] randbuf;
    private int randptr;
    private boolean quiet = false;
    private int lastshowed2;
    private long starttime;
    private long lastshowed;
    private static final int POOLSIZE = 97;
    private static final double[] presets = new double[]{0.7, 0.9, 0.18};

    private int RINT(double x) {
        return x >= 0.0 ? (int)(x + 0.5) : (int)(x - 0.5);
    }

    public int init_shaper(int freq, int nch, int min, int max, int dtype, int pdf, double noiseamp) {
        int i;
        int[] pool = new int[97];
        for (i = 1; i < 6 && freq != scoeffreq[i]; ++i) {
        }
        if ((dtype == 3 || dtype == 4) && i == 6) {
            System.err.printf("Warning: ATH based noise shaping for destination frequency %dHz is not available, using triangular dither\n", freq);
        }
        if (dtype == 2 || i == 6) {
            i = 0;
        }
        if (dtype == 4 && (i == 1 || i == 2)) {
            i += 5;
        }
        this.shaper_type = i;
        this.shapebuf = new double[nch][];
        this.shaper_len = scoeflen[this.shaper_type];
        for (i = 0; i < nch; ++i) {
            this.shapebuf[i] = new double[this.shaper_len];
        }
        this.shaper_clipmin = min;
        this.shaper_clipmax = max;
        this.randbuf = new double[65536];
        Random random = new Random(System.currentTimeMillis());
        for (i = 0; i < 97; ++i) {
            pool[i] = random.nextInt();
        }
        switch (pdf) {
            case 0: {
                for (i = 0; i < 65536; ++i) {
                    int p = random.nextInt() % 97;
                    int r = pool[p];
                    pool[p] = random.nextInt();
                    this.randbuf[i] = noiseamp * ((double)r / 2.147483647E9 - 0.5);
                }
                break;
            }
            case 1: {
                for (i = 0; i < 65536; ++i) {
                    int p = random.nextInt() % 97;
                    int r1 = pool[p];
                    pool[p] = random.nextInt();
                    p = random.nextInt() % 97;
                    int r2 = pool[p];
                    pool[p] = random.nextInt();
                    this.randbuf[i] = noiseamp * ((double)r1 / 2.147483647E9 - (double)r2 / 2.147483647E9);
                }
                break;
            }
            case 2: {
                boolean sw = false;
                double t = 0.0;
                double u = 0.0;
                for (i = 0; i < 65536; ++i) {
                    if (!sw) {
                        sw = true;
                        int p = random.nextInt() % 97;
                        double r = (double)pool[p] / 2.147483647E9;
                        pool[p] = random.nextInt();
                        if (r == 1.0) {
                            r = 0.0;
                        }
                        t = Math.sqrt(-2.0 * Math.log(1.0 - r));
                        p = random.nextInt() % 97;
                        r = (double)pool[p] / 2.147483647E9;
                        pool[p] = random.nextInt();
                        u = Math.PI * 2 * r;
                        this.randbuf[i] = noiseamp * t * Math.cos(u);
                        continue;
                    }
                    sw = false;
                    this.randbuf[i] = noiseamp * t * Math.sin(u);
                }
                break;
            }
        }
        this.randptr = 0;
        if (dtype == 0 || dtype == 1) {
            return 1;
        }
        return samp[this.shaper_type];
    }

    public int do_shaping(double s, double[] peak, int dtype, int ch) {
        int i;
        if (dtype == 1) {
            double d;
            int n = this.randptr++;
            if ((s += this.randbuf[n & 0xFFFF]) < (double)this.shaper_clipmin) {
                d = s / (double)this.shaper_clipmin;
                peak[0] = peak[0] < d ? d : peak[0];
                s = this.shaper_clipmin;
            }
            if (s > (double)this.shaper_clipmax) {
                d = s / (double)this.shaper_clipmax;
                peak[0] = peak[0] < d ? d : peak[0];
                s = this.shaper_clipmax;
            }
            return this.RINT(s);
        }
        double h = 0.0;
        for (i = 0; i < this.shaper_len; ++i) {
            h += shapercoefs[this.shaper_type][i] * this.shapebuf[ch][i];
        }
        double u = s += h;
        s += this.randbuf[this.randptr++ & 0xFFFF];
        for (i = this.shaper_len - 2; i >= 0; --i) {
            this.shapebuf[ch][i + 1] = this.shapebuf[ch][i];
        }
        if (s < (double)this.shaper_clipmin) {
            double d = s / (double)this.shaper_clipmin;
            peak[0] = peak[0] < d ? d : peak[0];
            s = this.shaper_clipmin;
            this.shapebuf[ch][0] = s - u;
            if (this.shapebuf[ch][0] > 1.0) {
                this.shapebuf[ch][0] = 1.0;
            }
            if (this.shapebuf[ch][0] < -1.0) {
                this.shapebuf[ch][0] = -1.0;
            }
        } else if (s > (double)this.shaper_clipmax) {
            double d = s / (double)this.shaper_clipmax;
            peak[0] = peak[0] < d ? d : peak[0];
            s = this.shaper_clipmax;
            this.shapebuf[ch][0] = s - u;
            if (this.shapebuf[ch][0] > 1.0) {
                this.shapebuf[ch][0] = 1.0;
            }
            if (this.shapebuf[ch][0] < -1.0) {
                this.shapebuf[ch][0] = -1.0;
            }
        } else {
            s = this.RINT(s);
            this.shapebuf[ch][0] = s - u;
        }
        return (int)s;
    }

    private void quit_shaper(int nch) {
    }

    private double alpha(double a) {
        if (a <= 21.0) {
            return 0.0;
        }
        if (a <= 50.0) {
            return 0.5842 * Math.pow(a - 21.0, 0.4) + 0.07886 * (a - 21.0);
        }
        return 0.1102 * (a - 8.7);
    }

    private double win(double n, int len, double alp, double iza) {
        return I0Bessel.value(alp * Math.sqrt(1.0 - 4.0 * n * n / (((double)len - 1.0) * ((double)len - 1.0)))) / iza;
    }

    private double sinc(double x) {
        return x == 0.0 ? 1.0 : Math.sin(x) / x;
    }

    private double hn_lpf(int n, double lpf, double fs) {
        double t = 1.0 / fs;
        double omega = Math.PI * 2 * lpf;
        return 2.0 * lpf * t * this.sinc((double)n * omega * t);
    }

    private void usage() {
        System.err.printf("http://shibatch.sourceforge.net/\n\n", new Object[0]);
        System.err.printf("usage: ssrc [<options>] <source wav file> <destination wav file>\n", new Object[0]);
        System.err.printf("options : --rate <sampling rate>     output sample rate\n", new Object[0]);
        System.err.printf("          --att <attenuation(dB)>    attenuate signal\n", new Object[0]);
        System.err.printf("          --bits <number of bits>    output quantization bit length\n", new Object[0]);
        System.err.printf("          --tmpfile <file name>      specify temporal file\n", new Object[0]);
        System.err.printf("          --twopass                  two pass processing to avoid clipping\n", new Object[0]);
        System.err.printf("          --normalize                normalize the wave file\n", new Object[0]);
        System.err.printf("          --quiet                    nothing displayed except error\n", new Object[0]);
        System.err.printf("          --dither [<type>]          dithering\n", new Object[0]);
        System.err.printf("                                       0 : no dither\n", new Object[0]);
        System.err.printf("                                       1 : no noise shaping\n", new Object[0]);
        System.err.printf("                                       2 : triangular spectral shape\n", new Object[0]);
        System.err.printf("                                       3 : ATH based noise shaping\n", new Object[0]);
        System.err.printf("                                       4 : less dither amplitude than type 3\n", new Object[0]);
        System.err.printf("          --pdf <type> [<amp>]       select p.d.f. of noise\n", new Object[0]);
        System.err.printf("                                       0 : rectangular\n", new Object[0]);
        System.err.printf("                                       1 : triangular\n", new Object[0]);
        System.err.printf("                                       2 : Gaussian\n", new Object[0]);
        System.err.printf("          --profile <type>           specify profile\n", new Object[0]);
        System.err.printf("                                       standard : the default quality\n", new Object[0]);
        System.err.printf("                                       fast     : fast, not so bad quality\n", new Object[0]);
    }

    private void fmterr(int x) {
        throw new IllegalStateException("unknown error " + x);
    }

    private void setstarttime() {
        this.starttime = System.currentTimeMillis();
        this.lastshowed = 0L;
        this.lastshowed2 = -1;
    }

    private void showprogress(double p) {
        if (this.quiet) {
            return;
        }
        long t = System.currentTimeMillis() - this.starttime;
        int eta = p == 0.0 ? 0 : (int)((double)t * (1.0 - p) / p);
        int pc = (int)(p * 100.0);
        if (pc != this.lastshowed2 || t != this.lastshowed) {
            System.err.printf(" %3d%% processed", pc);
            this.lastshowed2 = pc;
        }
        if (t != this.lastshowed) {
            System.err.printf(", ETA =%4dmsec", eta);
            this.lastshowed = t;
        }
        System.err.printf("\r", new Object[0]);
        System.err.flush();
    }

    private int gcd(int x, int y) {
        while (y != 0) {
            int t = x % y;
            x = y;
            y = t;
        }
        return x;
    }

    /*
     * Enabled aggressive block sorting
     */
    public double upsample(InputStream fpi, OutputStream fpo, int nch, int bps, int dbps, int sfrq, int dfrq, double gain, int chanklen, boolean twopass, int dither) throws IOException {
        int n2b;
        int n2;
        int i;
        int osf = 0;
        int[] fft_ip = null;
        double[] fft_w = null;
        double[] peak = new double[]{0.0};
        int spcount = 0;
        int filter2len = this.FFTFIRLEN;
        double aa = this.AA;
        double guard = 2.0;
        int frqgcd = this.gcd(sfrq, dfrq);
        int fs1 = sfrq / frqgcd * dfrq;
        if (fs1 / dfrq == 1) {
            osf = 1;
        } else if (fs1 / dfrq % 2 == 0) {
            osf = 2;
        } else {
            if (fs1 / dfrq % 3 != 0) {
                throw new IllegalArgumentException(String.format("Resampling from %dHz to %dHz is not supported.\n%d/gcd(%d,%d)=%d must be divided by 2 or 3.\n", sfrq, dfrq, sfrq, sfrq, dfrq, fs1 / dfrq));
            }
            osf = 3;
        }
        double df = (double)((dfrq * osf / 2 - sfrq / 2) * 2) / guard;
        double lpf = (double)(sfrq / 2) + (double)(dfrq * osf / 2 - sfrq / 2) / guard;
        double d = aa <= 21.0 ? 0.9222 : (aa - 7.95) / 14.36;
        int n1 = (int)((double)fs1 / df * d + 1.0);
        if (n1 % 2 == 0) {
            ++n1;
        }
        double alp = this.alpha(aa);
        double iza = I0Bessel.value(alp);
        int n1y = fs1 / sfrq;
        int n1x = n1 / n1y + 1;
        int[] f1order = new int[n1y * osf];
        for (i = 0; i < n1y * osf; ++i) {
            f1order[i] = fs1 / sfrq - i * (fs1 / (dfrq * osf)) % (fs1 / sfrq);
            if (f1order[i] != fs1 / sfrq) continue;
            f1order[i] = 0;
        }
        int[] f1inc = new int[n1y * osf];
        for (i = 0; i < n1y * osf; ++i) {
            int n = f1inc[i] = f1order[i] < fs1 / (dfrq * osf) ? nch : 0;
            if (f1order[i] != fs1 / sfrq) continue;
            f1order[i] = 0;
        }
        double[][] stage1 = new double[n1y][n1x];
        for (i = -(n1 / 2); i <= n1 / 2; ++i) {
            stage1[(i + n1 / 2) % n1y][(i + n1 / 2) / n1y] = this.win(i, n1, alp, iza) * this.hn_lpf(i, lpf, fs1) * (double)fs1 / (double)sfrq;
        }
        aa = this.AA;
        d = aa <= 21.0 ? 0.9222 : (aa - 7.95) / 14.36;
        int fs2 = dfrq * osf;
        i = 1;
        while (true) {
            if ((n2 = filter2len * i) % 2 == 0) {
                --n2;
            }
            df = (double)fs2 * d / (double)(n2 - 1);
            lpf = sfrq / 2;
            if (df < this.DF) {
                alp = this.alpha(aa);
                iza = I0Bessel.value(alp);
                break;
            }
            i *= 2;
        }
        for (n2b = 1; n2b < n2; n2b *= 2) {
        }
        double[] stage2 = new double[n2b *= 2];
        for (i = -(n2 / 2); i <= n2 / 2; ++i) {
            stage2[i + n2 / 2] = this.win(i, n2, alp, iza) * this.hn_lpf(i, lpf, fs2) / (double)n2b * 2.0;
        }
        int ipsize = (int)(2.0 + Math.sqrt(n2b));
        fft_ip = new int[ipsize];
        fft_ip[0] = 0;
        int wsize = n2b / 2;
        fft_w = new double[wsize];
        this.fft.rdft(n2b, 1, stage2, fft_ip, fft_w);
        this.setstarttime();
        int n2b2 = n2b / 2;
        int nsmplwrt2 = 0;
        int delay = 0;
        double[][] buf1 = new double[nch][n2b2 / osf + 1];
        double[][] buf2 = new double[nch][n2b];
        ByteBuffer rawinbuf = ByteBuffer.allocate(nch * (n2b2 + n1x) * bps);
        ByteBuffer rawoutbuf = ByteBuffer.allocate(nch * (n2b2 / osf + 1) * dbps);
        double[] inbuf = new double[nch * (n2b2 + n1x)];
        double[] outbuf = new double[nch * (n2b2 / osf + 1)];
        int s1p = 0;
        int rp = 0;
        int ds = 0;
        int osc = 0;
        boolean init = true;
        boolean ending = false;
        int inbuflen = n1 / 2 / (fs1 / sfrq) + 1;
        delay = (int)((double)n2 / 2.0 / (double)(fs2 / dfrq));
        int sumwrite = 0;
        int sumread = 0;
        while (true) {
            block76: {
                int ch;
                int toberead;
                int toberead2 = toberead = (int)(Math.floor((double)n2b2 * (double)sfrq / (double)(dfrq * osf)) + 1.0 + (double)n1x - (double)inbuflen);
                if (toberead + sumread > chanklen) {
                    toberead = chanklen - sumread;
                }
                rawinbuf.position(0);
                rawinbuf.limit(Math.min(rawinbuf.limit(), bps * nch * toberead));
                byte[] tempData = new byte[rawinbuf.limit()];
                int nsmplread = fpi.read(tempData);
                if (nsmplread < 0) {
                    nsmplread = 0;
                }
                if (nsmplread < rawinbuf.limit()) {
                    chanklen = sumread + nsmplread / bps * nch;
                }
                rawinbuf.limit(nsmplread);
                rawinbuf = ByteBuffer.wrap(tempData);
                rawinbuf.position(nsmplread);
                rawinbuf.flip();
                nsmplread /= bps * nch;
                switch (bps) {
                    case 1: {
                        for (i = 0; i < nsmplread * nch; ++i) {
                            inbuf[nch * inbuflen + i] = 0.007874015748031496 * ((double)rawinbuf.get(i) - 128.0);
                        }
                        break;
                    }
                    case 2: {
                        for (i = 0; i < nsmplread * nch; ++i) {
                            short v = rawinbuf.order(this.byteOrder).asShortBuffer().get(i);
                            inbuf[nch * inbuflen + i] = 3.051850947599719E-5 * (double)v;
                        }
                        break;
                    }
                    case 3: {
                        for (i = 0; i < nsmplread * nch; ++i) {
                            inbuf[nch * inbuflen + i] = 1.1920930376163766E-7 * (double)(rawinbuf.get(i * 3) << 0 | rawinbuf.get(i * 3 + 1) << 8 | rawinbuf.get(i * 3 + 2) << 16);
                        }
                        break;
                    }
                    case 4: {
                        for (i = 0; i < nsmplread * nch; ++i) {
                            int v = rawinbuf.order(this.byteOrder).asIntBuffer().get(i);
                            inbuf[nch * inbuflen + i] = 4.656612875245797E-10 * (double)v;
                        }
                        break;
                    }
                }
                while (i < nch * toberead2) {
                    inbuf[nch * inbuflen + i] = 0.0;
                    ++i;
                }
                inbuflen += toberead2;
                ending = (sumread += nsmplread) >= chanklen;
                int nsmplwrt1 = n2b2;
                int ip = (sfrq * (rp - 1) + fs1) / fs1 * nch;
                int s1p_backup = s1p;
                int ip_backup = ip;
                int osc_backup = osc;
                for (ch = 0; ch < nch; ++ch) {
                    int p;
                    int op = ch;
                    int no = n1y * osf;
                    s1p = s1p_backup;
                    ip = ip_backup + ch;
                    switch (n1x) {
                        case 7: {
                            for (p = 0; p < nsmplwrt1; ++p) {
                                int s1o = f1order[s1p];
                                buf2[ch][p] = stage1[s1o][0] * inbuf[ip + 0 * nch] + stage1[s1o][1] * inbuf[ip + 1 * nch] + stage1[s1o][2] * inbuf[ip + 2 * nch] + stage1[s1o][3] * inbuf[ip + 3 * nch] + stage1[s1o][4] * inbuf[ip + 4 * nch] + stage1[s1o][5] * inbuf[ip + 5 * nch] + stage1[s1o][6] * inbuf[ip + 6 * nch];
                                ip += f1inc[s1p];
                                if (++s1p != no) continue;
                                s1p = 0;
                            }
                            break;
                        }
                        case 9: {
                            for (p = 0; p < nsmplwrt1; ++p) {
                                int s1o = f1order[s1p];
                                buf2[ch][p] = stage1[s1o][0] * inbuf[ip + 0 * nch] + stage1[s1o][1] * inbuf[ip + 1 * nch] + stage1[s1o][2] * inbuf[ip + 2 * nch] + stage1[s1o][3] * inbuf[ip + 3 * nch] + stage1[s1o][4] * inbuf[ip + 4 * nch] + stage1[s1o][5] * inbuf[ip + 5 * nch] + stage1[s1o][6] * inbuf[ip + 6 * nch] + stage1[s1o][7] * inbuf[ip + 7 * nch] + stage1[s1o][8] * inbuf[ip + 8 * nch];
                                ip += f1inc[s1p];
                                if (++s1p != no) continue;
                                s1p = 0;
                            }
                            break;
                        }
                        default: {
                            for (p = 0; p < nsmplwrt1; ++p) {
                                double tmp = 0.0;
                                int ip2 = ip;
                                int s1o = f1order[s1p];
                                for (i = 0; i < n1x; tmp += stage1[s1o][i] * inbuf[ip2], ip2 += nch, ++i) {
                                }
                                buf2[ch][p] = tmp;
                                ip += f1inc[s1p];
                                if (++s1p != no) continue;
                                s1p = 0;
                            }
                        }
                    }
                    osc = osc_backup;
                    for (p = nsmplwrt1; p < n2b; ++p) {
                        buf2[ch][p] = 0.0;
                    }
                    this.fft.rdft(n2b, 1, buf2[ch], fft_ip, fft_w);
                    buf2[ch][0] = stage2[0] * buf2[ch][0];
                    buf2[ch][1] = stage2[1] * buf2[ch][1];
                    for (i = 1; i < n2b / 2; ++i) {
                        double re = stage2[i * 2] * buf2[ch][i * 2] - stage2[i * 2 + 1] * buf2[ch][i * 2 + 1];
                        double im = stage2[i * 2 + 1] * buf2[ch][i * 2] + stage2[i * 2] * buf2[ch][i * 2 + 1];
                        buf2[ch][i * 2] = re;
                        buf2[ch][i * 2 + 1] = im;
                    }
                    this.fft.rdft(n2b, -1, buf2[ch], fft_ip, fft_w);
                    int j = 0;
                    for (i = osc; i < n2b2; i += osf, ++j) {
                        double f;
                        outbuf[op + j * nch] = f = buf1[ch][j] + buf2[ch][i];
                    }
                    nsmplwrt2 = j;
                    osc = i - n2b2;
                    j = 0;
                    while (i < n2b) {
                        buf1[ch][j] = buf2[ch][i];
                        i += osf;
                        ++j;
                    }
                }
                rp += nsmplwrt1 * (sfrq / frqgcd) / osf;
                rawoutbuf.clear();
                if (!twopass) {
                    switch (dbps) {
                        case 1: {
                            double d2;
                            double gain2 = gain * 127.0;
                            ch = 0;
                            for (i = 0; i < nsmplwrt2 * nch; ++i) {
                                int s;
                                if (dither != 0) {
                                    s = this.do_shaping(outbuf[i] * gain2, peak, dither, ch);
                                } else {
                                    s = this.RINT(outbuf[i] * gain2);
                                    if (s < -128) {
                                        d2 = (double)s / -128.0;
                                        peak[0] = peak[0] < d2 ? d2 : peak[0];
                                        s = -128;
                                    }
                                    if (127 < s) {
                                        d2 = (double)s / 127.0;
                                        peak[0] = peak[0] < d2 ? d2 : peak[0];
                                        s = 127;
                                    }
                                }
                                rawoutbuf.put(i, (byte)(s + 128));
                                if (++ch != nch) continue;
                                ch = 0;
                            }
                            break;
                        }
                        case 2: {
                            double d2;
                            double gain2 = gain * 32767.0;
                            ch = 0;
                            for (i = 0; i < nsmplwrt2 * nch; ++i) {
                                int s;
                                if (dither != 0) {
                                    s = this.do_shaping(outbuf[i] * gain2, peak, dither, ch);
                                } else {
                                    s = this.RINT(outbuf[i] * gain2);
                                    if (s < Short.MIN_VALUE) {
                                        d2 = (double)s / -32768.0;
                                        peak[0] = peak[0] < d2 ? d2 : peak[0];
                                        s = Short.MIN_VALUE;
                                    }
                                    if (Short.MAX_VALUE < s) {
                                        d2 = (double)s / 32767.0;
                                        peak[0] = peak[0] < d2 ? d2 : peak[0];
                                        s = Short.MAX_VALUE;
                                    }
                                }
                                rawoutbuf.order(this.byteOrder).asShortBuffer().put(i, (short)s);
                                if (++ch != nch) continue;
                                ch = 0;
                            }
                            break;
                        }
                        case 3: {
                            double d2;
                            double gain2 = gain * 8388607.0;
                            ch = 0;
                            for (i = 0; i < nsmplwrt2 * nch; ++i) {
                                int s;
                                if (dither != 0) {
                                    s = this.do_shaping(outbuf[i] * gain2, peak, dither, ch);
                                } else {
                                    s = this.RINT(outbuf[i] * gain2);
                                    if (s < -8388608) {
                                        d2 = (double)s / -8388608.0;
                                        peak[0] = peak[0] < d2 ? d2 : peak[0];
                                        s = -8388608;
                                    }
                                    if (0x7FFFFF < s) {
                                        d2 = (double)s / 8388607.0;
                                        peak[0] = peak[0] < d2 ? d2 : peak[0];
                                        s = 0x7FFFFF;
                                    }
                                }
                                rawoutbuf.put(i * 3, (byte)(s & 0xFF));
                                rawoutbuf.put(i * 3 + 1, (byte)((s >>= 8) & 0xFF));
                                rawoutbuf.put(i * 3 + 2, (byte)((s >>= 8) & 0xFF));
                                if (++ch != nch) continue;
                                ch = 0;
                            }
                            break;
                        }
                    }
                } else {
                    for (i = 0; i < nsmplwrt2 * nch; ++i) {
                        double f = outbuf[i] > 0.0 ? outbuf[i] : -outbuf[i];
                        peak[0] = peak[0] < f ? f : peak[0];
                        rawoutbuf.asDoubleBuffer().put(i, outbuf[i]);
                    }
                }
                if (!init) {
                    if (ending) {
                        if ((double)sumread * (double)dfrq / (double)sfrq + 2.0 > (double)(sumwrite + nsmplwrt2)) {
                            rawoutbuf.position(0);
                            rawoutbuf.limit(dbps * nch * nsmplwrt2);
                            this.writeBuffers(fpo, rawoutbuf);
                            sumwrite += nsmplwrt2;
                            break block76;
                        } else {
                            rawoutbuf.position(0);
                            int limitData = (int)((double)(dbps * nch) * (Math.floor((double)sumread * (double)dfrq / (double)sfrq) + 2.0 - (double)sumwrite));
                            if (limitData <= 0) break;
                            rawoutbuf.limit(limitData);
                            this.writeBuffers(fpo, rawoutbuf);
                            break;
                        }
                    }
                    rawoutbuf.position(0);
                    rawoutbuf.limit(dbps * nch * nsmplwrt2);
                    this.writeBuffers(fpo, rawoutbuf);
                    sumwrite += nsmplwrt2;
                } else if (nsmplwrt2 < delay) {
                    delay -= nsmplwrt2;
                } else {
                    if (ending) {
                        if ((double)sumread * (double)dfrq / (double)sfrq + 2.0 > (double)(sumwrite + nsmplwrt2 - delay)) {
                            rawoutbuf.position(dbps * nch * delay);
                            rawoutbuf.limit(dbps * nch * (nsmplwrt2 - delay));
                            this.writeBuffers(fpo, rawoutbuf);
                            sumwrite += nsmplwrt2 - delay;
                            break block76;
                        } else {
                            rawoutbuf.position(dbps * nch * delay);
                            rawoutbuf.limit((int)((double)(dbps * nch) * (Math.floor((double)sumread * (double)dfrq / (double)sfrq) + 2.0 + (double)sumwrite + (double)nsmplwrt2 - (double)delay)));
                            this.writeBuffers(fpo, rawoutbuf);
                            break;
                        }
                    }
                    rawoutbuf.position(dbps * nch * delay);
                    rawoutbuf.limit(dbps * nch * nsmplwrt2);
                    this.writeBuffers(fpo, rawoutbuf);
                    sumwrite += nsmplwrt2 - delay;
                    init = false;
                }
            }
            ds = (rp - 1) / (fs1 / sfrq);
            assert (inbuflen >= ds);
            System.arraycopy(inbuf, nch * ds, inbuf, 0, nch * (inbuflen - ds));
            inbuflen -= ds;
            rp -= ds * (fs1 / sfrq);
            if ((spcount++ & 7) != 7) continue;
            this.showprogress((double)sumread / (double)chanklen);
        }
        this.showprogress(1.0);
        return peak[0];
    }

    /*
     * Enabled aggressive block sorting
     */
    public double downsample(InputStream fpi, OutputStream fpo, int nch, int bps, int dbps, int sfrq, int dfrq, double gain, int chanklen, boolean twopass, int dither) throws IOException {
        double[][] stage2;
        int[] f2inc;
        int[] f2order;
        int n2y;
        int n2x;
        int n2;
        int fs2;
        int n1b;
        double iza;
        double alp;
        double lpf;
        double df;
        int osf = 0;
        int[] fft_ip = null;
        double[] fft_w = null;
        int spcount = 0;
        double[] peak = new double[]{0.0};
        int filter1len = this.FFTFIRLEN;
        double aa = this.AA;
        int frqgcd = this.gcd(sfrq, dfrq);
        if (dfrq / frqgcd == 1) {
            osf = 1;
        } else if (dfrq / frqgcd % 2 == 0) {
            osf = 2;
        } else {
            if (dfrq / frqgcd % 3 != 0) {
                throw new IllegalArgumentException(String.format("Resampling from %dHz to %dHz is not supported.\n%d/gcd(%d,%d)=%d must be divided by 2 or 3.", sfrq, dfrq, dfrq, sfrq, dfrq, dfrq / frqgcd));
            }
            osf = 3;
        }
        int fs1 = sfrq * osf;
        double d = aa <= 21.0 ? 0.9222 : (aa - 7.95) / 14.36;
        int n1 = filter1len;
        int i = 1;
        while (true) {
            if ((n1 = filter1len * i) % 2 == 0) {
                --n1;
            }
            df = (double)fs1 * d / (double)(n1 - 1);
            lpf = ((double)dfrq - df) / 2.0;
            if (df < this.DF) {
                alp = this.alpha(aa);
                iza = I0Bessel.value(alp);
                break;
            }
            i *= 2;
        }
        for (n1b = 1; n1b < n1; n1b *= 2) {
        }
        double[] stage1 = new double[n1b *= 2];
        for (i = -(n1 / 2); i <= n1 / 2; ++i) {
            stage1[i + n1 / 2] = this.win(i, n1, alp, iza) * this.hn_lpf(i, lpf, fs1) * (double)fs1 / (double)sfrq / (double)n1b * 2.0;
        }
        int ipsize = (int)(2.0 + Math.sqrt(n1b));
        fft_ip = new int[ipsize];
        fft_ip[0] = 0;
        int wsize = n1b / 2;
        fft_w = new double[wsize];
        this.fft.rdft(n1b, 1, stage1, fft_ip, fft_w);
        if (osf == 1) {
            fs2 = sfrq / frqgcd * dfrq;
            n2 = 1;
            n2x = 1;
            n2y = 1;
            f2order = new int[n2y];
            f2order[0] = 0;
            f2inc = new int[n2y];
            f2inc[0] = sfrq / dfrq;
            stage2 = new double[n2y][n2x];
            stage2[0][0] = 1.0;
        } else {
            aa = this.AA;
            double guard = 2.0;
            fs2 = sfrq / frqgcd * dfrq;
            df = (double)((fs1 / 2 - sfrq / 2) * 2) / guard;
            lpf = (double)(sfrq / 2) + (double)(fs1 / 2 - sfrq / 2) / guard;
            d = aa <= 21.0 ? 0.9222 : (aa - 7.95) / 14.36;
            n2 = (int)((double)fs2 / df * d + 1.0);
            if (n2 % 2 == 0) {
                ++n2;
            }
            alp = this.alpha(aa);
            iza = I0Bessel.value(alp);
            n2y = fs2 / fs1;
            n2x = n2 / n2y + 1;
            f2order = new int[n2y];
            for (i = 0; i < n2y; ++i) {
                f2order[i] = fs2 / fs1 - i * (fs2 / dfrq) % (fs2 / fs1);
                if (f2order[i] != fs2 / fs1) continue;
                f2order[i] = 0;
            }
            f2inc = new int[n2y];
            for (i = 0; i < n2y; ++i) {
                f2inc[i] = (fs2 / dfrq - f2order[i]) / (fs2 / fs1) + 1;
                if (f2order[i + 1 == n2y ? 0 : i + 1] != 0) continue;
                int n = i;
                f2inc[n] = f2inc[n] - 1;
            }
            stage2 = new double[n2y][n2x];
            for (i = -(n2 / 2); i <= n2 / 2; ++i) {
                stage2[(i + n2 / 2) % n2y][(i + n2 / 2) / n2y] = this.win(i, n2, alp, iza) * this.hn_lpf(i, lpf, fs2) * (double)fs2 / (double)fs1;
            }
        }
        this.setstarttime();
        int n1b2 = n1b / 2;
        int nsmplwrt2 = 0;
        int inbuflen = 0;
        int delay = 0;
        double[][] buf1 = new double[nch][n1b];
        double[][] buf2 = new double[nch][n2x + 1 + n1b2];
        ByteBuffer rawinbuf = ByteBuffer.allocate(nch * (n1b2 / osf + osf + 1) * bps);
        ByteBuffer rawoutbuf = ByteBuffer.allocate((int)(((double)n1b2 * (double)dfrq / (double)sfrq + 1.0) * (double)(dbps * nch)));
        double[] inbuf = new double[nch * (n1b2 / osf + osf + 1)];
        double[] outbuf = new double[(int)((double)nch * ((double)n1b2 * (double)dfrq / (double)sfrq + 1.0))];
        int op = 0;
        int s2p = 0;
        int rp = 0;
        int rps = 0;
        int ds = 0;
        int rp2 = 0;
        boolean init = true;
        boolean ending = false;
        delay = (int)((double)n1 / 2.0 / ((double)fs1 / (double)dfrq) + (double)n2 / 2.0 / ((double)fs2 / (double)dfrq));
        int sumwrite = 0;
        int sumread = 0;
        while (true) {
            int ch;
            block83: {
                block82: {
                    int toberead;
                    if ((toberead = (n1b2 - (rps = 0) - 1) / osf + 1) + sumread > chanklen) {
                        toberead = chanklen - sumread;
                    }
                    rawinbuf.position(0);
                    rawinbuf.limit(bps * nch * toberead);
                    byte[] tempData = new byte[rawinbuf.limit()];
                    int nsmplread = fpi.read(tempData);
                    if (nsmplread < 0) {
                        nsmplread = 0;
                    }
                    if (nsmplread < rawinbuf.limit()) {
                        chanklen = sumread + nsmplread / bps * nch;
                    }
                    rawinbuf.limit(nsmplread);
                    rawinbuf = ByteBuffer.wrap(tempData);
                    rawinbuf.position(nsmplread);
                    rawinbuf.flip();
                    nsmplread /= bps * nch;
                    switch (bps) {
                        case 1: {
                            for (i = 0; i < nsmplread * nch; ++i) {
                                inbuf[nch * inbuflen + i] = 0.007874015748031496 * (double)((rawinbuf.get(i) & 0xFF) - 128);
                            }
                            break;
                        }
                        case 2: {
                            for (i = 0; i < nsmplread * nch; ++i) {
                                short v = rawinbuf.order(this.byteOrder).asShortBuffer().get(i);
                                inbuf[nch * inbuflen + i] = 3.051850947599719E-5 * (double)v;
                            }
                            break;
                        }
                        case 3: {
                            for (i = 0; i < nsmplread * nch; ++i) {
                                inbuf[nch * inbuflen + i] = 1.1920930376163766E-7 * (double)((rawinbuf.get(i * 3) & 0xFF) << 0 | (rawinbuf.get(i * 3 + 1) & 0xFF) << 8 | (rawinbuf.get(i * 3 + 2) & 0xFF) << 16);
                            }
                            break;
                        }
                        case 4: {
                            for (i = 0; i < nsmplread * nch; ++i) {
                                int v = rawinbuf.order(this.byteOrder).getInt(i);
                                inbuf[nch * inbuflen + i] = 4.656612875245797E-10 * (double)v;
                            }
                            break;
                        }
                    }
                    while (i < nch * toberead) {
                        inbuf[i] = 0.0;
                        ++i;
                    }
                    ending = fpi.available() < 0 || (sumread += nsmplread) >= chanklen;
                    int rps_backup = rps;
                    int s2p_backup = s2p;
                    ch = 0;
                    while (true) {
                        int j;
                        int k;
                        if (ch < nch) {
                            rps = rps_backup;
                            for (k = 0; k < rps; ++k) {
                                buf1[ch][k] = 0.0;
                            }
                            j = 0;
                        } else {
                            rp2 += nsmplwrt2 * (fs2 / dfrq);
                            rawoutbuf.clear();
                            if (twopass) {
                                break;
                            }
                            switch (dbps) {
                                case 1: {
                                    double gain2 = gain * 127.0;
                                    ch = 0;
                                    for (i = 0; i < nsmplwrt2 * nch; ++i) {
                                        int s;
                                        if (dither != 0) {
                                            s = this.do_shaping(outbuf[i] * gain2, peak, dither, ch);
                                        } else {
                                            double d2;
                                            s = this.RINT(outbuf[i] * gain2);
                                            if (s < -128) {
                                                d2 = (double)s / -128.0;
                                                peak[0] = peak[0] < d2 ? d2 : peak[0];
                                                s = -128;
                                            }
                                            if (127 < s) {
                                                d2 = (double)s / 127.0;
                                                peak[0] = peak[0] < d2 ? d2 : peak[0];
                                                s = 127;
                                            }
                                        }
                                        rawoutbuf.put(i, (byte)(s + 128));
                                        if (++ch != nch) continue;
                                        ch = 0;
                                    }
                                    break;
                                }
                                case 2: {
                                    double gain2 = gain * 32767.0;
                                    ch = 0;
                                    for (i = 0; i < nsmplwrt2 * nch; ++i) {
                                        int s;
                                        if (dither != 0) {
                                            s = this.do_shaping(outbuf[i] * gain2, peak, dither, ch);
                                        } else {
                                            double d3;
                                            s = this.RINT(outbuf[i] * gain2);
                                            if (s < Short.MIN_VALUE) {
                                                d3 = (double)s / -32768.0;
                                                peak[0] = peak[0] < d3 ? d3 : peak[0];
                                                s = Short.MIN_VALUE;
                                            }
                                            if (Short.MAX_VALUE < s) {
                                                d3 = (double)s / 32767.0;
                                                peak[0] = peak[0] < d3 ? d3 : peak[0];
                                                s = Short.MAX_VALUE;
                                            }
                                        }
                                        rawoutbuf.order(this.byteOrder).asShortBuffer().put(i, (short)s);
                                        if (++ch != nch) continue;
                                        ch = 0;
                                    }
                                    break;
                                }
                                case 3: {
                                    double gain2 = gain * 8388607.0;
                                    ch = 0;
                                    for (i = 0; i < nsmplwrt2 * nch; ++i) {
                                        int s;
                                        if (dither != 0) {
                                            s = this.do_shaping(outbuf[i] * gain2, peak, dither, ch);
                                        } else {
                                            double d4;
                                            s = this.RINT(outbuf[i] * gain2);
                                            if (s < -8388608) {
                                                d4 = (double)s / -8388608.0;
                                                peak[0] = peak[0] < d4 ? d4 : peak[0];
                                                s = -8388608;
                                            }
                                            if (0x7FFFFF < s) {
                                                d4 = (double)s / 8388607.0;
                                                peak[0] = peak[0] < d4 ? d4 : peak[0];
                                                s = 0x7FFFFF;
                                            }
                                        }
                                        rawoutbuf.put(i * 3, (byte)(s & 0xFF));
                                        rawoutbuf.put(i * 3 + 1, (byte)((s >>= 8) & 0xFF));
                                        rawoutbuf.put(i * 3 + 2, (byte)((s >>= 8) & 0xFF));
                                        if (++ch != nch) continue;
                                        ch = 0;
                                    }
                                    break;
                                }
                            }
                            break block82;
                        }
                        for (i = rps; i < n1b2; i += osf, ++j) {
                            assert (j < (n1b2 - rps - 1) / osf + 1);
                            buf1[ch][i] = inbuf[j * nch + ch];
                            for (k = i + 1; k < i + osf; ++k) {
                                buf1[ch][k] = 0.0;
                            }
                        }
                        assert (j == (n1b2 - rps - 1) / osf + 1);
                        for (k = n1b2; k < n1b; ++k) {
                            buf1[ch][k] = 0.0;
                        }
                        rps = i - n1b2;
                        rp += j;
                        this.fft.rdft(n1b, 1, buf1[ch], fft_ip, fft_w);
                        buf1[ch][0] = stage1[0] * buf1[ch][0];
                        buf1[ch][1] = stage1[1] * buf1[ch][1];
                        for (i = 1; i < n1b2; ++i) {
                            double re = stage1[i * 2] * buf1[ch][i * 2] - stage1[i * 2 + 1] * buf1[ch][i * 2 + 1];
                            double im = stage1[i * 2 + 1] * buf1[ch][i * 2] + stage1[i * 2] * buf1[ch][i * 2 + 1];
                            buf1[ch][i * 2] = re;
                            buf1[ch][i * 2 + 1] = im;
                        }
                        this.fft.rdft(n1b, -1, buf1[ch], fft_ip, fft_w);
                        for (i = 0; i < n1b2; ++i) {
                            double[] dArray = buf2[ch];
                            int n = n2x + 1 + i;
                            dArray[n] = dArray[n] + buf1[ch][i];
                        }
                        int t1 = rp2 / (fs2 / fs1);
                        if (rp2 % (fs2 / fs1) != 0) {
                            ++t1;
                        }
                        int bp = buf2[0].length * ch + t1;
                        s2p = s2p_backup;
                        int p = 0;
                        while (bp - buf2[0].length * ch < n1b2 + 1) {
                            double tmp = 0.0;
                            int bp2 = bp;
                            int s2o = f2order[s2p];
                            bp += f2inc[s2p];
                            if (++s2p == n2y) {
                                s2p = 0;
                            }
                            assert ((bp2 - buf2[0].length * ch) * (fs2 / fs1) - (rp2 + p * (fs2 / dfrq)) == s2o);
                            for (i = 0; i < n2x; tmp += stage2[s2o][i] * buf2[bp2 / buf2[0].length][bp2 % buf2[0].length], ++bp2, ++i) {
                            }
                            outbuf[op + p * nch + ch] = tmp;
                            ++p;
                        }
                        nsmplwrt2 = p;
                        ++ch;
                    }
                    for (i = 0; i < nsmplwrt2 * nch; ++i) {
                        double f = outbuf[i] > 0.0 ? outbuf[i] : -outbuf[i];
                        peak[0] = peak[0] < f ? f : peak[0];
                        rawoutbuf.asDoubleBuffer().put(i, outbuf[i]);
                    }
                }
                if (!init) {
                    if (ending) {
                        if ((double)sumread * (double)dfrq / (double)sfrq + 2.0 > (double)(sumwrite + nsmplwrt2)) {
                            rawoutbuf.position(0);
                            rawoutbuf.limit(dbps * nch * nsmplwrt2);
                            this.writeBuffers(fpo, rawoutbuf);
                            sumwrite += nsmplwrt2;
                            break block83;
                        } else {
                            rawoutbuf.position(0);
                            int limitData = (int)((double)(dbps * nch) * (Math.floor((double)sumread * (double)dfrq / (double)sfrq) + 2.0 - (double)sumwrite));
                            if (limitData <= 0) break;
                            rawoutbuf.limit(limitData);
                            this.writeBuffers(fpo, rawoutbuf);
                            break;
                        }
                    }
                    rawoutbuf.position(0);
                    rawoutbuf.limit(dbps * nch * nsmplwrt2);
                    this.writeBuffers(fpo, rawoutbuf);
                    sumwrite += nsmplwrt2;
                } else if (nsmplwrt2 < delay) {
                    delay -= nsmplwrt2;
                } else {
                    if (ending) {
                        if ((double)sumread * (double)dfrq / (double)sfrq + 2.0 > (double)(sumwrite + nsmplwrt2 - delay)) {
                            rawoutbuf.position(dbps * nch * delay);
                            rawoutbuf.limit(dbps * nch * (nsmplwrt2 - delay));
                            this.writeBuffers(fpo, rawoutbuf);
                            sumwrite += nsmplwrt2 - delay;
                            break block83;
                        } else {
                            rawoutbuf.position(dbps * nch * delay);
                            rawoutbuf.limit((int)((double)(dbps * nch) * (Math.floor((double)sumread * (double)dfrq / (double)sfrq) + 2.0 + (double)sumwrite + (double)nsmplwrt2 - (double)delay)));
                            this.writeBuffers(fpo, rawoutbuf);
                            break;
                        }
                    }
                    rawoutbuf.position(dbps * nch * delay);
                    rawoutbuf.limit(dbps * nch * nsmplwrt2);
                    this.writeBuffers(fpo, rawoutbuf);
                    sumwrite += nsmplwrt2 - delay;
                    init = false;
                }
            }
            ds = (rp2 - 1) / (fs2 / fs1);
            if (ds > n1b2) {
                ds = n1b2;
            }
            for (ch = 0; ch < nch; ++ch) {
                System.arraycopy(buf2[ch], ds, buf2[ch], 0, n2x + 1 + n1b2 - ds);
            }
            rp2 -= ds * (fs2 / fs1);
            for (ch = 0; ch < nch; ++ch) {
                System.arraycopy(buf1[ch], n1b2, buf2[ch], n2x + 1, n1b2);
            }
            if ((spcount++ & 7) != 7) continue;
            this.showprogress((double)sumread / (double)chanklen);
        }
        this.showprogress(1.0);
        return peak[0];
    }

    public double no_src(InputStream fpi, OutputStream fpo, int nch, int bps, int dbps, double gain, int chanklen, boolean twopass, int dither) throws IOException {
        double[] peak = new double[]{0.0};
        int ch = 0;
        int sumread = 0;
        this.setstarttime();
        ByteBuffer leos = null;
        if (twopass) {
            leos = ByteBuffer.allocate(8);
        }
        ByteBuffer buf = ByteBuffer.allocate(4);
        while (sumread < chanklen * nch) {
            int s;
            double f = 0.0;
            switch (bps) {
                case 1: {
                    buf.position(0);
                    buf.limit(1);
                    byte[] tempData = new byte[buf.limit()];
                    fpi.read(tempData);
                    buf = ByteBuffer.wrap(tempData);
                    buf.position(buf.limit());
                    buf.flip();
                    f = 0.007874015748031496 * (double)(buf.get(0) - 128);
                    break;
                }
                case 2: {
                    buf.position(0);
                    buf.limit(2);
                    byte[] tempData = new byte[buf.limit()];
                    fpi.read(tempData);
                    buf = ByteBuffer.wrap(tempData);
                    buf.position(buf.limit());
                    buf.flip();
                    s = buf.order(this.byteOrder).asShortBuffer().get(0);
                    f = 3.051850947599719E-5 * (double)s;
                    break;
                }
                case 3: {
                    buf.position(0);
                    buf.limit(3);
                    byte[] tempData = new byte[buf.limit()];
                    fpi.read(tempData);
                    buf = ByteBuffer.wrap(tempData);
                    buf.position(buf.limit());
                    buf.flip();
                    f = 1.1920930376163766E-7 * (double)((buf.get(0) & 0xFF) << 0 | (buf.get(1) & 0xFF) << 8 | (buf.get(2) & 0xFF) << 16);
                    break;
                }
                case 4: {
                    buf.position(0);
                    buf.limit(4);
                    byte[] tempData = new byte[buf.limit()];
                    fpi.read(tempData);
                    buf = ByteBuffer.wrap(tempData);
                    buf.position(buf.limit());
                    buf.flip();
                    s = buf.order(this.byteOrder).asIntBuffer().get(0);
                    f = 4.656612875245797E-10 * (double)s;
                }
            }
            if (fpi.available() == 0) break;
            f *= gain;
            if (!twopass) {
                switch (dbps) {
                    case 1: {
                        s = dither != 0 ? this.do_shaping(f, peak, dither, ch) : this.RINT(f *= 127.0);
                        buf.position(0);
                        buf.limit(1);
                        buf.put(0, (byte)(s + 128));
                        buf.flip();
                        this.writeBuffers(fpo, buf);
                        break;
                    }
                    case 2: {
                        s = dither != 0 ? this.do_shaping(f, peak, dither, ch) : this.RINT(f *= 32767.0);
                        buf.position(0);
                        buf.limit(2);
                        buf.asShortBuffer().put(0, (short)s);
                        buf.flip();
                        this.writeBuffers(fpo, buf);
                        break;
                    }
                    case 3: {
                        s = dither != 0 ? this.do_shaping(f, peak, dither, ch) : this.RINT(f *= 8388607.0);
                        buf.position(0);
                        buf.limit(3);
                        buf.put(0, (byte)(s & 0xFF));
                        buf.put(1, (byte)((s >>= 8) & 0xFF));
                        buf.put(2, (byte)((s >>= 8) & 0xFF));
                        buf.flip();
                        this.writeBuffers(fpo, buf);
                    }
                }
            } else {
                double p = f > 0.0 ? f : -f;
                peak[0] = peak[0] < p ? p : peak[0];
                leos.position(0);
                leos.putDouble(f);
                leos.flip();
                this.writeBuffers(fpo, leos);
            }
            if (++ch == nch) {
                ch = 0;
            }
            if ((++sumread & 0x3FFFF) != 0) continue;
            this.showprogress((double)sumread / (double)(chanklen * nch));
        }
        this.showprogress(1.0);
        return peak[0];
    }

    public static void main(String[] args) throws Exception {
        new SSRC(args);
    }

    public SSRC() {
    }

    SSRC(String[] argv) throws IOException {
        int length;
        int i;
        String tmpfn = null;
        FileInputStream fpi = null;
        File fo = null;
        FileOutputStream fpo = null;
        File ft = null;
        FileOutputStream fpto = null;
        int samp = 0;
        double[] peak = new double[]{0.0};
        int dfrq = -1;
        double att = 0.0;
        int dbps = -1;
        boolean twopass = false;
        boolean normalize = false;
        int dither = 0;
        int pdf = 0;
        double noiseamp = 0.18;
        for (i = 0; i < argv.length && argv[i].charAt(0) == '-'; ++i) {
            if (argv[i].equals("--rate")) {
                dfrq = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("--att")) {
                att = Float.parseFloat(argv[++i]);
                continue;
            }
            if (argv[i].equals("--bits")) {
                if ((dbps = Integer.parseInt(argv[++i])) != 8 && dbps != 16 && dbps != 24) {
                    throw new IllegalArgumentException("Error: Only 8bit, 16bit and 24bit PCM are supported.");
                }
                dbps /= 8;
                continue;
            }
            if (argv[i].equals("--twopass")) {
                twopass = true;
                continue;
            }
            if (argv[i].equals("--normalize")) {
                twopass = true;
                normalize = true;
                continue;
            }
            if (argv[i].equals("--dither")) {
                try {
                    dither = Integer.parseInt(argv[i + 1]);
                    if (dither < 0 || dither > 4) {
                        throw new IllegalArgumentException("unrecognized dither type : " + argv[i + 1]);
                    }
                    ++i;
                }
                catch (NumberFormatException e) {
                    dither = -1;
                }
                continue;
            }
            if (argv[i].equals("--pdf")) {
                try {
                    pdf = Integer.parseInt(argv[i + 1]);
                    if (pdf < 0 || pdf > 2) {
                        throw new IllegalArgumentException("unrecognized p.d.f. type : " + argv[i + 1]);
                    }
                    ++i;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("unrecognized p.d.f. type : " + argv[i + 1]);
                }
                try {
                    noiseamp = Double.parseDouble(argv[i + 1]);
                    ++i;
                }
                catch (NumberFormatException e) {
                    noiseamp = presets[pdf];
                }
                continue;
            }
            if (argv[i].equals("--quiet")) {
                this.quiet = true;
                continue;
            }
            if (argv[i].equals("--tmpfile")) {
                tmpfn = argv[++i];
                continue;
            }
            if (argv[i].equals("--profile")) {
                if (argv[i + 1].equals("fast")) {
                    this.AA = 96.0;
                    this.DF = 8000.0;
                    this.FFTFIRLEN = 1024;
                } else if (!argv[i + 1].equals("standard")) {
                    throw new IllegalArgumentException("unrecognized profile : " + argv[i + 1]);
                }
                ++i;
                continue;
            }
            throw new IllegalArgumentException("unrecognized option : " + argv[i]);
        }
        if (!this.quiet) {
            System.err.printf("Shibatch sampling rate converter version 1.30(high precision/nio)\n\n", new Object[0]);
        }
        if (argv.length - i != 2) {
            this.usage();
            throw new IllegalStateException("too few arguments");
        }
        String sfn = argv[i];
        String dfn = argv[i + 1];
        try {
            fpi = new FileInputStream(sfn);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot open input file.");
        }
        ByteBuffer bb = ByteBuffer.allocate(256).order(ByteOrder.LITTLE_ENDIAN);
        bb.limit(36);
        fpi.getChannel().read(bb);
        bb.flip();
        System.err.println("p: " + bb.position() + ", l: " + bb.limit());
        if (bb.get() != 82) {
            this.fmterr(1);
        }
        if (bb.get() != 73) {
            this.fmterr(1);
        }
        if (bb.get() != 70) {
            this.fmterr(1);
        }
        if (bb.get() != 70) {
            this.fmterr(1);
        }
        int dword = bb.getInt();
        if (bb.get() != 87) {
            this.fmterr(2);
        }
        if (bb.get() != 65) {
            this.fmterr(2);
        }
        if (bb.get() != 86) {
            this.fmterr(2);
        }
        if (bb.get() != 69) {
            this.fmterr(2);
        }
        if (bb.get() != 102) {
            this.fmterr(2);
        }
        if (bb.get() != 109) {
            this.fmterr(2);
        }
        if (bb.get() != 116) {
            this.fmterr(2);
        }
        if (bb.get() != 32) {
            this.fmterr(2);
        }
        int sizeOfFmt = bb.getInt();
        if (bb.getShort() != 1) {
            throw new IllegalStateException("Error: Only PCM is supported.");
        }
        short nch = bb.getShort();
        int sfrq = bb.getInt();
        int bps = bb.getInt();
        if (bps % sfrq * nch != 0) {
            this.fmterr(4);
        }
        short word = bb.getShort();
        word = bb.getShort();
        bps /= sfrq * nch;
        if (sizeOfFmt > 16) {
            bb.position(0);
            bb.limit(2);
            fpi.read(this.getDataFromByteBuffer(bb));
            bb.flip();
            short sizeofExtended = bb.getShort();
            fpi.getChannel().position(fpi.getChannel().position() + (long)sizeofExtended);
        }
        while (true) {
            bb.position(0);
            bb.limit(8);
            fpi.getChannel().read(bb);
            bb.flip();
            byte c0 = bb.get();
            byte c1 = bb.get();
            byte c2 = bb.get();
            byte c3 = bb.get();
            length = bb.getInt();
            System.err.printf("chunk: %c%c%c%c\n", c0, (int)c1, (int)c2, (int)c3);
            if (c0 == 100 && c1 == 97 && c2 == 116 && c3 == 97 || fpi.getChannel().position() == fpi.getChannel().size()) break;
            fpi.getChannel().position(fpi.getChannel().position() + (long)length);
        }
        if (fpi.getChannel().position() == fpi.getChannel().size()) {
            throw new IllegalStateException("Couldn't find data chank");
        }
        if (bps != 1 && bps != 2 && bps != 3 && bps != 4) {
            throw new IllegalStateException("Error : Only 8bit, 16bit, 24bit and 32bit PCM are supported.");
        }
        if (dbps == -1 && (dbps = bps != 1 ? bps : 2) == 4) {
            dbps = 3;
        }
        if (dfrq == -1) {
            dfrq = sfrq;
        }
        if (dither == -1) {
            dither = dbps < bps ? (dbps == 1 ? 4 : 3) : 1;
        }
        if (!this.quiet) {
            String[] dtype = new String[]{"none", "no noise shaping", "triangular spectral shape", "ATH based noise shaping", "ATH based noise shaping(less amplitude)"};
            String[] ptype = new String[]{"rectangular", "triangular", "gaussian"};
            System.err.printf("frequency : %d -> %d\n", sfrq, dfrq);
            System.err.printf("attenuation : %gdB\n", att);
            System.err.printf("bits per sample : %d -> %d\n", bps * 8, dbps * 8);
            System.err.printf("nchannels : %d\n", nch);
            System.err.printf("length : %d bytes, %g secs\n", length, (double)length / (double)bps / (double)nch / (double)sfrq);
            if (dither == 0) {
                System.err.printf("dither type : none\n", new Object[0]);
            } else {
                System.err.printf("dither type : %s, %s p.d.f, amp = %g\n", dtype[dither], ptype[pdf], noiseamp);
            }
            System.err.printf("\n", new Object[0]);
        }
        if (twopass) {
            // empty if block
        }
        try {
            fo = new File(dfn);
            fpo = new FileOutputStream(fo);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot open output file.");
        }
        ByteBuffer leos = ByteBuffer.allocate(44).order(ByteOrder.LITTLE_ENDIAN);
        leos.put("RIFF".getBytes());
        dword = 0;
        leos.putInt(dword);
        leos.put("WAVEfmt ".getBytes());
        dword = 16;
        leos.putInt(dword);
        word = 1;
        leos.putShort(word);
        word = nch;
        leos.putShort(word);
        dword = dfrq;
        leos.putInt(dword);
        dword = dfrq * nch * dbps;
        leos.putInt(dword);
        word = (short)(dbps * nch);
        leos.putShort(word);
        word = (short)(dbps * 8);
        leos.putShort(word);
        leos.put("data".getBytes());
        dword = 0;
        leos.putInt(dword);
        leos.flip();
        this.writeBuffers(fpo, leos);
        if (dither != 0) {
            int min = 0;
            int max = 0;
            if (dbps == 1) {
                min = -128;
                max = 127;
            }
            if (dbps == 2) {
                min = Short.MIN_VALUE;
                max = Short.MAX_VALUE;
            }
            if (dbps == 3) {
                min = -8388608;
                max = 0x7FFFFF;
            }
            if (dbps == 4) {
                min = Integer.MIN_VALUE;
                max = Integer.MAX_VALUE;
            }
            samp = this.init_shaper(dfrq, nch, min, max, dither, pdf, noiseamp);
        }
        if (twopass) {
            double gain = 0.0;
            short ch = 0;
            if (!this.quiet) {
                System.err.printf("Pass 1\n", new Object[0]);
            }
            try {
                ft = tmpfn != null ? new File(tmpfn) : File.createTempFile("ssrc_", ".tmp");
                fpto = new FileOutputStream(ft);
            }
            catch (IOException e) {
                throw new IllegalStateException("cannot open temporary file.");
            }
            peak[0] = normalize ? (sfrq < dfrq ? this.upsample(fpi, fpto, nch, bps, 8, sfrq, dfrq, 1.0, length / bps / nch, twopass, dither) : (sfrq > dfrq ? this.downsample(fpi, fpto, nch, bps, 8, sfrq, dfrq, 1.0, length / bps / nch, twopass, dither) : this.no_src(fpi, fpto, nch, bps, 8, 1.0, length / bps / nch, twopass, dither))) : (sfrq < dfrq ? this.upsample(fpi, fpto, nch, bps, 8, sfrq, dfrq, Math.pow(10.0, -att / 20.0), length / bps / nch, twopass, dither) : (sfrq > dfrq ? this.downsample(fpi, fpto, nch, bps, 8, sfrq, dfrq, Math.pow(10.0, -att / 20.0), length / bps / nch, twopass, dither) : this.no_src(fpi, fpto, nch, bps, 8, Math.pow(10.0, -att / 20.0), length / bps / nch, twopass, dither)));
            fpto.close();
            if (!this.quiet) {
                System.err.printf("\npeak : %gdB\n", 20.0 * Math.log10(peak[0]));
            }
            peak[0] = !normalize ? (peak[0] < Math.pow(10.0, -att / 20.0) ? 1.0 : peak[0] * Math.pow(10.0, att / 20.0)) : peak[0] * Math.pow(10.0, att / 20.0);
            if (!this.quiet) {
                System.err.printf("\nPass 2\n", new Object[0]);
            }
            if (dither != 0) {
                switch (dbps) {
                    case 1: {
                        gain = normalize || peak[0] >= (double)(127 - samp) / 127.0 ? 1.0 / peak[0] * (double)(127 - samp) : 1.0 / peak[0] * 127.0;
                        break;
                    }
                    case 2: {
                        gain = normalize || peak[0] >= (double)(Short.MAX_VALUE - samp) / 32767.0 ? 1.0 / peak[0] * (double)(Short.MAX_VALUE - samp) : 1.0 / peak[0] * 32767.0;
                        break;
                    }
                    case 3: {
                        gain = normalize || peak[0] >= (double)(0x7FFFFF - samp) / 8388607.0 ? 1.0 / peak[0] * (double)(0x7FFFFF - samp) : 1.0 / peak[0] * 8388607.0;
                    }
                }
            } else {
                switch (dbps) {
                    case 1: {
                        gain = 1.0 / peak[0] * 127.0;
                        break;
                    }
                    case 2: {
                        gain = 1.0 / peak[0] * 32767.0;
                        break;
                    }
                    case 3: {
                        gain = 1.0 / peak[0] * 8388607.0;
                    }
                }
            }
            this.randptr = 0;
            this.setstarttime();
            int fptlen = (int)(ft.length() / 8L);
            FileChannel fpti = new FileInputStream(ft).getChannel();
            ByteBuffer leis = ByteBuffer.allocate(8);
            int sumread = 0;
            while (sumread < fptlen) {
                leis.clear();
                fpti.read(leis);
                leis.flip();
                double f = leis.getDouble();
                f *= gain;
                ++sumread;
                switch (dbps) {
                    case 1: {
                        int s = dither != 0 ? this.do_shaping(f, peak, dither, ch) : this.RINT(f);
                        ByteBuffer buf = ByteBuffer.allocate(1);
                        buf.put((byte)(s + 128));
                        buf.flip();
                        this.writeBuffers(fpo, buf);
                        break;
                    }
                    case 2: {
                        int s = dither != 0 ? this.do_shaping(f, peak, dither, ch) : this.RINT(f);
                        ByteBuffer buf = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
                        buf.putShort((short)s);
                        buf.flip();
                        this.writeBuffers(fpo, buf);
                        break;
                    }
                    case 3: {
                        int s = dither != 0 ? this.do_shaping(f, peak, dither, ch) : this.RINT(f);
                        ByteBuffer buf = ByteBuffer.allocate(3);
                        buf.put((byte)(s & 0xFF));
                        buf.put((byte)((s >>= 8) & 0xFF));
                        buf.put((byte)((s >>= 8) & 0xFF));
                        buf.flip();
                        this.writeBuffers(fpo, buf);
                    }
                }
                if (++ch == nch) {
                    ch = 0;
                }
                if ((sumread & 0x3FFFF) != 0) continue;
                this.showprogress((double)sumread / (double)fptlen);
            }
            this.showprogress(1.0);
            if (!this.quiet) {
                System.err.printf("\n", new Object[0]);
            }
            fpti.close();
            if (ft != null && !ft.delete()) {
                System.err.printf("Failed to remove %s\n", ft);
            }
        } else {
            peak[0] = sfrq < dfrq ? this.upsample(fpi, fpo, nch, bps, dbps, sfrq, dfrq, Math.pow(10.0, -att / 20.0), length / bps / nch, twopass, dither) : (sfrq > dfrq ? this.downsample(fpi, fpo, nch, bps, dbps, sfrq, dfrq, Math.pow(10.0, -att / 20.0), length / bps / nch, twopass, dither) : this.no_src(fpi, fpo, nch, bps, dbps, Math.pow(10.0, -att / 20.0), length / bps / nch, twopass, dither));
            if (!this.quiet) {
                System.err.printf("\n", new Object[0]);
            }
        }
        if (dither != 0) {
            this.quit_shaper(nch);
        }
        if (!twopass && peak[0] > 1.0 && !this.quiet) {
            System.err.printf("clipping detected : %gdB\n", 20.0 * Math.log10(peak[0]));
        }
        fpo.close();
        fo = new File(dfn);
        int len = (int)fo.length();
        FileChannel fpo1 = new RandomAccessFile(fo, "rw").getChannel();
        ByteBuffer leos2 = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        int dword2 = len - 8;
        leos2.position(0);
        leos2.limit(4);
        leos2.putInt(dword2);
        leos2.flip();
        fpo1.write(leos2, 4L);
        dword2 = len - 44;
        leos2.position(0);
        leos2.limit(4);
        leos2.putInt(dword2);
        leos2.flip();
        fpo1.write(leos2, 40L);
        fpo1.close();
    }

    public SSRC(InputStream fpi, OutputStream fpo, int sfrq, int dfrq, int bps, int dbps, int nch, int length, double att, int dither, boolean quiet_) throws IOException {
        Object tmpfn = null;
        int samp = 0;
        double[] peak = new double[]{0.0};
        boolean twopass = false;
        boolean normalize = false;
        int pdf = 0;
        double noiseamp = 0.18;
        if (dither < 0 || dither > 4) {
            throw new IllegalArgumentException("unrecognized dither type : " + dither);
        }
        this.quiet = quiet_;
        if (!this.quiet) {
            System.err.printf("Shibatch sampling rate converter version 1.30(high precision/nio)\n\n", new Object[0]);
        }
        if (bps != 1 && bps != 2 && bps != 3 && bps != 4) {
            throw new IllegalStateException("Error : Only 8bit, 16bit, 24bit and 32bit PCM are supported.");
        }
        if (dbps == -1 && (dbps = bps != 1 ? bps : 2) == 4) {
            dbps = 3;
        }
        if (dfrq == -1) {
            dfrq = sfrq;
        }
        if (dither == -1) {
            dither = dbps < bps ? (dbps == 1 ? 4 : 3) : 1;
        }
        if (!this.quiet) {
            String[] dtype = new String[]{"none", "no noise shaping", "triangular spectral shape", "ATH based noise shaping", "ATH based noise shaping(less amplitude)"};
            String[] ptype = new String[]{"rectangular", "triangular", "gaussian"};
            System.err.printf("frequency : %d -> %d\n", sfrq, dfrq);
            System.err.printf("attenuation : %gdB\n", att);
            System.err.printf("bits per sample : %d -> %d\n", bps * 8, dbps * 8);
            System.err.printf("nchannels : %d\n", nch);
            System.err.printf("length : %d bytes, %g secs\n", length, (double)length / (double)bps / (double)nch / (double)sfrq);
            if (dither == 0) {
                System.err.printf("dither type : none\n", new Object[0]);
            } else {
                System.err.printf("dither type : %s, %s p.d.f, amp = %g\n", dtype[dither], ptype[pdf], noiseamp);
            }
            System.err.printf("\n", new Object[0]);
        }
        if (dither != 0) {
            int min = 0;
            int max = 0;
            if (dbps == 1) {
                min = -128;
                max = 127;
            }
            if (dbps == 2) {
                min = Short.MIN_VALUE;
                max = Short.MAX_VALUE;
            }
            if (dbps == 3) {
                min = -8388608;
                max = 0x7FFFFF;
            }
            if (dbps == 4) {
                min = Integer.MIN_VALUE;
                max = Integer.MAX_VALUE;
            }
            samp = this.init_shaper(dfrq, nch, min, max, dither, pdf, noiseamp);
        }
        peak[0] = sfrq < dfrq ? this.upsample(fpi, fpo, nch, bps, dbps, sfrq, dfrq, Math.pow(10.0, -att / 20.0), length / bps / nch, twopass, dither) : (sfrq > dfrq ? this.downsample(fpi, fpo, nch, bps, dbps, sfrq, dfrq, Math.pow(10.0, -att / 20.0), length / bps / nch, twopass, dither) : this.no_src(fpi, fpo, nch, bps, dbps, Math.pow(10.0, -att / 20.0), length / bps / nch, twopass, dither));
        if (!this.quiet) {
            System.err.printf("\n", new Object[0]);
        }
        if (dither != 0) {
            this.quit_shaper(nch);
        }
        if (!twopass && peak[0] > 1.0 && !this.quiet) {
            System.err.printf("clipping detected : %gdB\n", 20.0 * Math.log10(peak[0]));
        }
    }

    protected byte[] getDataFromByteBuffer(ByteBuffer rawoutbuf) {
        byte[] tempDataWrt = new byte[rawoutbuf.limit() - rawoutbuf.position()];
        rawoutbuf.get(tempDataWrt, 0, tempDataWrt.length);
        return tempDataWrt;
    }

    protected void writeBuffers(OutputStream fpo, ByteBuffer rawoutbuf) {
        try {
            fpo.write(this.getDataFromByteBuffer(rawoutbuf));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

