/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor.util;

import java.io.IOException;
import java.io.RandomAccessFile;

public class AudioFadeUtil {
    public static void audioFade(String pcmPath, int sampleRate, int channelCount, float fadeInSec, float fadeOutSec) throws IOException {
        int bit = 16;
        int startLen = (int)((float)(sampleRate * bit / 8 * channelCount) * fadeInSec);
        int endLen = (int)((float)(sampleRate * bit / 8 * channelCount) * fadeOutSec);
        byte[] startArray = new byte[startLen];
        byte[] endArray = new byte[endLen];
        RandomAccessFile raf = new RandomAccessFile(pcmPath, "rw");
        raf.read(startArray, 0, startLen);
        raf.seek((int)(raf.length() - (long)endLen));
        raf.read(endArray, 0, endLen);
        AudioFadeUtil.doFaceIn(startArray);
        AudioFadeUtil.doFaceOut(endArray);
        raf.seek(0L);
        raf.write(startArray, 0, startLen);
        raf.seek((int)(raf.length() - (long)endLen));
        raf.write(endArray, 0, endLen);
        raf.close();
    }

    private static void doFaceIn(byte[] bytes) {
        float step = 1.0f / ((float)bytes.length / 2.0f);
        float volume = 0.0f;
        for (int i = 0; i < bytes.length; i += 2) {
            int tmp = bytes[i] & 0xFF | (bytes[i + 1] & 0xFF) << 8;
            if ((tmp = (int)((float)tmp * volume)) > Short.MAX_VALUE) {
                tmp = Short.MAX_VALUE;
            } else if (tmp < Short.MIN_VALUE) {
                tmp = Short.MIN_VALUE;
            }
            bytes[i] = (byte)(tmp & 0xFF);
            bytes[i + 1] = (byte)(tmp >>> 8 & 0xFF);
            volume += step;
        }
    }

    private static void doFaceOut(byte[] bytes) {
        float step = 1.0f / ((float)bytes.length / 2.0f);
        float volume = 1.0f;
        for (int i = 0; i < bytes.length; i += 2) {
            int tmp = bytes[i] & 0xFF | (bytes[i + 1] & 0xFF) << 8;
            if ((tmp = (int)((float)tmp * volume)) > Short.MAX_VALUE) {
                tmp = Short.MAX_VALUE;
            } else if (tmp < Short.MIN_VALUE) {
                tmp = Short.MIN_VALUE;
            }
            bytes[i] = (byte)(tmp & 0xFF);
            bytes[i + 1] = (byte)(tmp >>> 8 & 0xFF);
            volume -= step;
        }
    }
}

