/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.media.MediaMuxer;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.hw.videoprocessor.AudioProcessThread;
import com.hw.videoprocessor.VideoDecodeThread;
import com.hw.videoprocessor.VideoEncodeThread;
import com.hw.videoprocessor.VideoUtil;
import com.hw.videoprocessor.util.AudioUtil;
import com.hw.videoprocessor.util.CL;
import com.hw.videoprocessor.util.PcmToWavUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import net.surina.soundtouch.SoundTouch;

@TargetApi(value=21)
public class VideoProcessor {
    static final String TAG = "VideoProcessor";
    static final String MIME_TYPE = "video/avc";
    public static int DEFAULT_FRAME_RATE = 20;
    public static final int DEFAULT_I_FRAME_INTERVAL = 1;
    public static final int DEFAULT_AAC_BITRATE = 192000;
    public static boolean AUDIO_MIX_REPEAT = true;
    static final int TIMEOUT_USEC = 2500;

    public static void scaleVideo(Context context, String input, String output, int outWidth, int outHeight) throws Exception {
        VideoProcessor.processVideo(context, input, output, outWidth, outHeight, null, null, null, null, null);
    }

    public static void cutVideo(Context context, String input, String output, int startTimeMs, int endTimeMs) throws Exception {
        VideoProcessor.processVideo(context, input, output, null, null, startTimeMs, endTimeMs, null, null, null);
    }

    public static void changeVideoSpeed(Context context, String input, String output, float speed) throws Exception {
        VideoProcessor.processVideo(context, input, output, null, null, null, null, Float.valueOf(speed), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revertVideo(Context context, String input, String output) throws Exception {
        block8: {
            File tempFile = new File(context.getCacheDir(), System.currentTimeMillis() + ".temp");
            File temp2File = new File(context.getCacheDir(), System.currentTimeMillis() + ".temp2");
            try {
                long sampleTime;
                MediaExtractor extractor = new MediaExtractor();
                extractor.setDataSource(input);
                int trackIndex = VideoUtil.selectTrack(extractor, false);
                extractor.selectTrack(trackIndex);
                int keyFrameCount = 0;
                int frameCount = 0;
                while ((sampleTime = extractor.getSampleTime()) >= 0L) {
                    int flags = extractor.getSampleFlags();
                    if ((flags & 1) != 0) {
                        ++keyFrameCount;
                    }
                    ++frameCount;
                    extractor.advance();
                }
                extractor.release();
                if (frameCount == keyFrameCount) {
                    VideoProcessor.revertVideoNoDecode(input, output);
                    break block8;
                }
                int bitrateMultiple = (frameCount - keyFrameCount) / keyFrameCount;
                MediaMetadataRetriever retriever = new MediaMetadataRetriever();
                retriever.setDataSource(input);
                int oriBitrate = Integer.parseInt(retriever.extractMetadata(20));
                int duration = Integer.parseInt(retriever.extractMetadata(9));
                try {
                    VideoProcessor.processVideo(context, input, tempFile.getAbsolutePath(), null, null, null, null, null, oriBitrate * bitrateMultiple, 0);
                }
                catch (MediaCodec.CodecException e) {
                    CL.e(e);
                    VideoProcessor.processVideo(context, input, tempFile.getAbsolutePath(), null, null, null, null, null, oriBitrate * bitrateMultiple, -1);
                }
                VideoProcessor.revertVideoNoDecode(tempFile.getAbsolutePath(), temp2File.getAbsolutePath());
                int oriIFrameInterval = (int)((float)keyFrameCount / ((float)duration / 1000.0f));
                oriIFrameInterval = oriIFrameInterval == 0 ? 1 : oriIFrameInterval;
                VideoProcessor.processVideo(context, temp2File.getAbsolutePath(), output, null, null, null, null, null, oriBitrate, oriIFrameInterval);
            }
            finally {
                tempFile.delete();
                temp2File.delete();
            }
        }
    }

    public static void processVideo(Context context, String input, String output, @Nullable Integer outWidth, @Nullable Integer outHeight, @Nullable Integer startTimeMs, @Nullable Integer endTimeMs, @Nullable Float speed, @Nullable Integer bitrate, @Nullable Integer iFrameInterval) throws Exception {
        int resultHeight;
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(input);
        int originWidth = Integer.parseInt(retriever.extractMetadata(18));
        int originHeight = Integer.parseInt(retriever.extractMetadata(19));
        int rotationValue = Integer.parseInt(retriever.extractMetadata(24));
        int oriBitrate = Integer.parseInt(retriever.extractMetadata(20));
        retriever.release();
        if (bitrate == null) {
            bitrate = oriBitrate;
        }
        if (iFrameInterval == null) {
            iFrameInterval = 1;
        }
        int resultWidth = outWidth == null ? originWidth : outWidth;
        int n = resultHeight = outHeight == null ? originHeight : outHeight;
        if (rotationValue == 90 || rotationValue == 270) {
            int temp = resultHeight;
            resultHeight = resultWidth;
            resultWidth = temp;
        }
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(input);
        int videoIndex = VideoUtil.selectTrack(extractor, false);
        int audioIndex = VideoUtil.selectTrack(extractor, true);
        MediaMuxer mediaMuxer = new MediaMuxer(output, 0);
        int muxerAudioTrackIndex = 0;
        if (audioIndex >= 0) {
            MediaFormat audioTrackFormat = extractor.getTrackFormat(audioIndex);
            if (startTimeMs != null || endTimeMs != null || speed != null) {
                long durationUs = audioTrackFormat.getLong("durationUs");
                if (startTimeMs != null && endTimeMs != null) {
                    durationUs = (endTimeMs - startTimeMs) * 1000;
                }
                if (speed != null) {
                    durationUs = (long)((float)durationUs / speed.floatValue());
                }
                audioTrackFormat.setLong("durationUs", durationUs);
            }
            muxerAudioTrackIndex = mediaMuxer.addTrack(audioTrackFormat);
        }
        extractor.selectTrack(videoIndex);
        if (startTimeMs != null) {
            extractor.seekTo((long)(startTimeMs * 1000), 0);
        } else {
            extractor.seekTo(0L, 0);
        }
        AtomicBoolean decodeDone = new AtomicBoolean(false);
        CountDownLatch muxerStartLatch = new CountDownLatch(1);
        VideoEncodeThread encodeThread = new VideoEncodeThread(extractor, mediaMuxer, bitrate, resultWidth, resultHeight, iFrameInterval, videoIndex, decodeDone, muxerStartLatch);
        VideoDecodeThread decodeThread = new VideoDecodeThread(encodeThread, extractor, startTimeMs, endTimeMs, speed, videoIndex, decodeDone);
        AudioProcessThread audioProcessThread = new AudioProcessThread(context, input, mediaMuxer, startTimeMs, endTimeMs, speed, muxerAudioTrackIndex, muxerStartLatch);
        decodeThread.start();
        encodeThread.start();
        audioProcessThread.start();
        try {
            long s = System.currentTimeMillis();
            decodeThread.join();
            encodeThread.join();
            long e1 = System.currentTimeMillis();
            audioProcessThread.join();
            long e2 = System.currentTimeMillis();
            CL.w(String.format("\u7f16\u89e3\u7801:%dms,\u97f3\u9891:%dms", e1 - s, e2 - s), new Object[0]);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            mediaMuxer.release();
            extractor.release();
        }
        catch (Exception e2) {
            CL.e(e2);
        }
        if (encodeThread.getException() != null) {
            throw encodeThread.getException();
        }
        if (decodeThread.getException() != null) {
            throw decodeThread.getException();
        }
        if (audioProcessThread.getException() != null) {
            throw audioProcessThread.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeAudioTrack(Context context, MediaExtractor extractor, MediaMuxer mediaMuxer, int muxerAudioTrackIndex, Integer startTimeUs, Integer endTimeUs, @NonNull Float speed) throws Exception {
        int audioTrack = VideoUtil.selectTrack(extractor, true);
        extractor.selectTrack(audioTrack);
        if (startTimeUs == null) {
            startTimeUs = 0;
        }
        extractor.seekTo((long)startTimeUs.intValue(), 2);
        MediaFormat oriAudioFormat = extractor.getTrackFormat(audioTrack);
        int maxBufferSize = VideoUtil.getAudioMaxBufferSize(oriAudioFormat);
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        MediaCodec decoder = MediaCodec.createDecoderByType((String)oriAudioFormat.getString("mime"));
        decoder.configure(oriAudioFormat, null, null, 0);
        decoder.start();
        boolean decodeDone = false;
        boolean encodeDone = false;
        boolean decodeInputDone = false;
        int TIMEOUT_US = 2500;
        File pcmFile = new File(context.getCacheDir(), System.currentTimeMillis() + ".pcm");
        FileChannel writeChannel = new FileOutputStream(pcmFile).getChannel();
        try {
            while (!decodeDone) {
                int outputBufferIndex;
                if (!decodeInputDone) {
                    boolean eof = false;
                    int decodeInputIndex = decoder.dequeueInputBuffer(2500L);
                    if (decodeInputIndex >= 0) {
                        long sampleTimeUs = extractor.getSampleTime();
                        if (sampleTimeUs == -1L) {
                            eof = true;
                        } else {
                            if (sampleTimeUs < (long)startTimeUs.intValue()) {
                                extractor.advance();
                                continue;
                            }
                            if (endTimeUs != null && sampleTimeUs > (long)endTimeUs.intValue()) {
                                eof = true;
                            }
                        }
                        if (eof) {
                            decodeInputDone = true;
                            decoder.queueInputBuffer(decodeInputIndex, 0, 0, 0L, 4);
                        } else {
                            info.size = extractor.readSampleData(buffer, 0);
                            info.presentationTimeUs = sampleTimeUs;
                            info.flags = extractor.getSampleFlags();
                            ByteBuffer inputBuffer = decoder.getInputBuffer(decodeInputIndex);
                            inputBuffer.put(buffer);
                            CL.it(TAG, "audio decode queueInputBuffer " + info.presentationTimeUs / 1000L, new Object[0]);
                            decoder.queueInputBuffer(decodeInputIndex, 0, info.size, info.presentationTimeUs, info.flags);
                            extractor.advance();
                        }
                    }
                }
                while (!decodeDone && (outputBufferIndex = decoder.dequeueOutputBuffer(info, 2500L)) != -1) {
                    if (outputBufferIndex == -2) {
                        MediaFormat newFormat = decoder.getOutputFormat();
                        CL.it(TAG, "audio decode newFormat = " + newFormat, new Object[0]);
                        continue;
                    }
                    if (outputBufferIndex < 0) {
                        CL.et(TAG, "unexpected result from audio decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                        continue;
                    }
                    if (info.flags == 4) {
                        decodeDone = true;
                    } else {
                        ByteBuffer decodeOutputBuffer = decoder.getOutputBuffer(outputBufferIndex);
                        CL.it(TAG, "audio decode saveFrame " + info.presentationTimeUs / 1000L, new Object[0]);
                        writeChannel.write(decodeOutputBuffer);
                    }
                    decoder.releaseOutputBuffer(outputBufferIndex, false);
                }
            }
        }
        finally {
            writeChannel.close();
            extractor.release();
            decoder.release();
        }
        int sampleRate = oriAudioFormat.getInteger("sample-rate");
        int oriChannelCount = oriAudioFormat.getInteger("channel-count");
        File wavFile = new File(context.getCacheDir(), pcmFile.getName() + ".wav");
        int channelConfig = 16;
        if (oriChannelCount == 2) {
            channelConfig = 12;
        }
        new PcmToWavUtil(sampleRate, channelConfig, oriChannelCount, 2).pcmToWav(pcmFile.getAbsolutePath(), wavFile.getAbsolutePath());
        CL.i(TAG, "start process pcm speed");
        File outFile = new File(context.getCacheDir(), pcmFile.getName() + ".outpcm");
        SoundTouch st = new SoundTouch();
        st.setTempo(speed.floatValue());
        int res = st.processFile(wavFile.getAbsolutePath(), outFile.getAbsolutePath());
        if (res < 0) {
            pcmFile.delete();
            wavFile.delete();
            outFile.delete();
            return;
        }
        MediaExtractor pcmExtrator = new MediaExtractor();
        pcmExtrator.setDataSource(outFile.getAbsolutePath());
        audioTrack = VideoUtil.selectTrack(pcmExtrator, true);
        pcmExtrator.selectTrack(audioTrack);
        MediaFormat pcmTrackFormat = pcmExtrator.getTrackFormat(audioTrack);
        maxBufferSize = VideoUtil.getAudioMaxBufferSize(pcmTrackFormat);
        buffer = ByteBuffer.allocateDirect(maxBufferSize);
        int bitrate = VideoUtil.getAudioBitrate(oriAudioFormat);
        int channelCount = oriAudioFormat.getInteger("channel-count");
        MediaFormat encodeFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channelCount);
        encodeFormat.setInteger("bitrate", bitrate);
        encodeFormat.setInteger("aac-profile", 2);
        encodeFormat.setInteger("max-input-size", maxBufferSize);
        MediaCodec encoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
        encoder.configure(encodeFormat, null, null, 1);
        encoder.start();
        boolean encodeInputDone = false;
        long lastAudioFrameTimeUs = -1L;
        int AAC_FRAME_TIME_US = 1024000000 / sampleRate;
        boolean detectTimeError = false;
        try {
            block8: while (!encodeDone) {
                int outputBufferIndex;
                int inputBufferIndex = encoder.dequeueInputBuffer(2500L);
                if (!encodeInputDone && inputBufferIndex >= 0) {
                    long sampleTime = pcmExtrator.getSampleTime();
                    if (sampleTime < 0L) {
                        encodeInputDone = true;
                        encoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                    } else {
                        int flags = pcmExtrator.getSampleFlags();
                        buffer.clear();
                        int size = pcmExtrator.readSampleData(buffer, 0);
                        ByteBuffer inputBuffer = encoder.getInputBuffer(inputBufferIndex);
                        inputBuffer.clear();
                        inputBuffer.put(buffer);
                        inputBuffer.position(0);
                        CL.it(TAG, "audio queuePcmBuffer " + sampleTime / 1000L + " size:" + size, new Object[0]);
                        encoder.queueInputBuffer(inputBufferIndex, 0, size, sampleTime, flags);
                        pcmExtrator.advance();
                    }
                }
                while ((outputBufferIndex = encoder.dequeueOutputBuffer(info, 2500L)) != -1) {
                    if (outputBufferIndex == -2) {
                        MediaFormat newFormat = encoder.getOutputFormat();
                        CL.it(TAG, "audio decode newFormat = " + newFormat, new Object[0]);
                        continue;
                    }
                    if (outputBufferIndex < 0) {
                        CL.et(TAG, "unexpected result from audio decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                        continue;
                    }
                    if (info.flags == 4) {
                        encodeDone = true;
                        continue block8;
                    }
                    ByteBuffer encodeOutputBuffer = encoder.getOutputBuffer(outputBufferIndex);
                    CL.it(TAG, "audio writeSampleData " + info.presentationTimeUs + " size:" + info.size + " flags:" + info.flags, new Object[0]);
                    if (!detectTimeError && lastAudioFrameTimeUs != -1L && info.presentationTimeUs < lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US) {
                        CL.et(TAG, "audio \u65f6\u95f4\u6233\u9519\u8bef\uff0clastAudioFrameTimeUs:" + lastAudioFrameTimeUs + " info.presentationTimeUs:" + info.presentationTimeUs, new Object[0]);
                        detectTimeError = true;
                    }
                    if (detectTimeError) {
                        info.presentationTimeUs = lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US;
                        CL.et(TAG, "audio \u65f6\u95f4\u6233\u9519\u8bef\uff0c\u4f7f\u7528\u4fee\u6b63\u7684\u65f6\u95f4\u6233:" + info.presentationTimeUs, new Object[0]);
                    }
                    lastAudioFrameTimeUs = info.presentationTimeUs;
                    mediaMuxer.writeSampleData(muxerAudioTrackIndex, encodeOutputBuffer, info);
                    encodeOutputBuffer.clear();
                    encoder.releaseOutputBuffer(outputBufferIndex, false);
                }
            }
        }
        finally {
            pcmFile.delete();
            wavFile.delete();
            outFile.delete();
            pcmExtrator.release();
            encoder.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revertVideoNoDecode(String input, String output) throws IOException {
        block10: {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource(input);
            int durationMs = Integer.parseInt(retriever.extractMetadata(9));
            retriever.release();
            MediaExtractor extractor = new MediaExtractor();
            extractor.setDataSource(input);
            int videoTrackIndex = VideoUtil.selectTrack(extractor, false);
            int audioTrackIndex = VideoUtil.selectTrack(extractor, true);
            boolean audioExist = audioTrackIndex >= 0;
            int MIN_FRAME_INTERVAL = 10000;
            MediaMuxer mediaMuxer = new MediaMuxer(output, 0);
            extractor.selectTrack(videoTrackIndex);
            MediaFormat videoTrackFormat = extractor.getTrackFormat(videoTrackIndex);
            int videoMuxerTrackIndex = mediaMuxer.addTrack(videoTrackFormat);
            int audioMuxerTrackIndex = 0;
            if (audioExist) {
                MediaFormat audioTrackFormat = extractor.getTrackFormat(audioTrackIndex);
                audioMuxerTrackIndex = mediaMuxer.addTrack(audioTrackFormat);
            }
            mediaMuxer.start();
            int maxBufferSize = videoTrackFormat.getInteger("max-input-size");
            ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
            VideoUtil.seekToLastFrame(extractor, videoTrackIndex, durationMs);
            long lastFrameTimeUs = -1L;
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            try {
                long seekTime;
                long sampleTime;
                while (true) {
                    sampleTime = extractor.getSampleTime();
                    if (lastFrameTimeUs == -1L) {
                        lastFrameTimeUs = sampleTime;
                    }
                    info.presentationTimeUs = lastFrameTimeUs - sampleTime;
                    info.size = extractor.readSampleData(buffer, 0);
                    info.flags = extractor.getSampleFlags();
                    if (info.size < 0) break;
                    mediaMuxer.writeSampleData(videoMuxerTrackIndex, buffer, info);
                    seekTime = sampleTime - 10000L;
                    if (seekTime <= 0L) break;
                    extractor.seekTo(seekTime, 0);
                }
                if (!audioExist) break block10;
                extractor.unselectTrack(videoTrackIndex);
                extractor.selectTrack(audioTrackIndex);
                VideoUtil.seekToLastFrame(extractor, audioTrackIndex, durationMs);
                lastFrameTimeUs = -1L;
                while (true) {
                    sampleTime = extractor.getSampleTime();
                    if (lastFrameTimeUs == -1L) {
                        lastFrameTimeUs = sampleTime;
                    }
                    info.presentationTimeUs = lastFrameTimeUs - sampleTime;
                    info.size = extractor.readSampleData(buffer, 0);
                    info.flags = extractor.getSampleFlags();
                    if (info.size < 0) {
                        break;
                    }
                    mediaMuxer.writeSampleData(audioMuxerTrackIndex, buffer, info);
                    seekTime = sampleTime - 10000L;
                    if (seekTime <= 0L) {
                        break;
                    }
                    extractor.seekTo(seekTime, 0);
                }
            }
            finally {
                extractor.release();
                mediaMuxer.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mixAudioTrack(Context context, String videoInput, String aacInput, String output, Integer startTimeMs, Integer endTimeMs, @IntRange(from=0L, to=100L) int videoVolume, @IntRange(from=0L, to=100L) int aacVolume) throws IOException {
        File wavFile;
        File adjustedPcm;
        int channelCount;
        int muxerAudioIndex;
        int audioBitrate;
        int sampleRate;
        int videoDurationMs;
        MediaMetadataRetriever retriever;
        Integer endTimeUs;
        File cacheDir = new File(context.getCacheDir(), "pcm");
        cacheDir.mkdir();
        File videoPcmFile = new File(cacheDir, "video_" + System.currentTimeMillis() + ".pcm");
        File aacPcmFile = new File(cacheDir, "aac_" + System.currentTimeMillis() + ".pcm");
        Integer startTimeUs = startTimeMs == null ? 0 : startTimeMs * 1000;
        Integer n = endTimeUs = endTimeMs == null ? null : Integer.valueOf(endTimeMs * 1000);
        if (endTimeUs == null) {
            retriever = new MediaMetadataRetriever();
            retriever.setDataSource(videoInput);
            videoDurationMs = Integer.parseInt(retriever.extractMetadata(9));
        } else {
            videoDurationMs = (endTimeUs - startTimeUs) / 1000;
        }
        retriever = new MediaMetadataRetriever();
        retriever.setDataSource(aacInput);
        int aacDurationMs = Integer.parseInt(retriever.extractMetadata(9));
        retriever.release();
        MediaExtractor oriExtrator = new MediaExtractor();
        oriExtrator.setDataSource(videoInput);
        int oriAudioIndex = VideoUtil.selectTrack(oriExtrator, true);
        MediaExtractor aacExtractor = new MediaExtractor();
        aacExtractor.setDataSource(aacInput);
        int aacAudioIndex = VideoUtil.selectTrack(aacExtractor, true);
        int TIMEOUT_US = 2500;
        MediaMuxer mediaMuxer = new MediaMuxer(output, 0);
        int oriVideoIndex = VideoUtil.selectTrack(oriExtrator, false);
        MediaFormat oriVideoFormat = oriExtrator.getTrackFormat(oriVideoIndex);
        int muxerVideoIndex = mediaMuxer.addTrack(oriVideoFormat);
        if (oriAudioIndex >= 0) {
            AudioUtil.decodeToPCM(videoInput, videoPcmFile.getAbsolutePath(), startTimeUs, endTimeUs);
            AudioUtil.decodeToPCM(aacInput, aacPcmFile.getAbsolutePath(), 0, aacDurationMs > videoDurationMs ? videoDurationMs * 1000 : aacDurationMs * 1000);
            MediaFormat oriAudioFormat = oriExtrator.getTrackFormat(oriAudioIndex);
            sampleRate = oriAudioFormat.getInteger("sample-rate");
            audioBitrate = VideoUtil.getAudioBitrate(oriAudioFormat);
            muxerAudioIndex = mediaMuxer.addTrack(oriAudioFormat);
            Pair<Integer, Integer> resultPair = AudioUtil.checkAndAdjustAudioFormat(videoPcmFile.getAbsolutePath(), aacPcmFile.getAbsolutePath(), oriExtrator.getTrackFormat(oriAudioIndex), aacExtractor.getTrackFormat(aacAudioIndex));
            channelCount = (Integer)resultPair.first;
            int adjustedSampleRate = (Integer)resultPair.second;
            aacExtractor.release();
            if (AUDIO_MIX_REPEAT) {
                aacPcmFile = AudioUtil.checkAndFillPcm(aacPcmFile, aacDurationMs, videoDurationMs);
            }
            adjustedPcm = new File(cacheDir, "adjusted_" + System.currentTimeMillis() + ".pcm");
            AudioUtil.mixPcm(videoPcmFile.getAbsolutePath(), aacPcmFile.getAbsolutePath(), adjustedPcm.getAbsolutePath(), videoVolume, aacVolume);
            wavFile = new File(context.getCacheDir(), adjustedPcm.getName() + ".wav");
            int channelConfig = 16;
            if (channelCount == 2) {
                channelConfig = 12;
            }
            new PcmToWavUtil(adjustedSampleRate, channelConfig, channelCount, 2).pcmToWav(adjustedPcm.getAbsolutePath(), wavFile.getAbsolutePath());
        } else {
            AudioUtil.decodeToPCM(aacInput, aacPcmFile.getAbsolutePath(), 0, aacDurationMs > videoDurationMs ? videoDurationMs * 1000 : aacDurationMs * 1000);
            MediaFormat aacTrackFormat = aacExtractor.getTrackFormat(aacAudioIndex);
            audioBitrate = VideoUtil.getAudioBitrate(aacTrackFormat);
            muxerAudioIndex = mediaMuxer.addTrack(aacTrackFormat);
            sampleRate = aacTrackFormat.getInteger("sample-rate");
            int n2 = channelCount = aacTrackFormat.containsKey("channel-count") ? aacTrackFormat.getInteger("channel-count") : 1;
            if (channelCount > 2) {
                File tempFile = new File(aacPcmFile + ".channel");
                AudioUtil.stereoToMonoSimple(aacPcmFile.getAbsolutePath(), tempFile.getAbsolutePath(), channelCount);
                channelCount = 1;
                aacPcmFile.delete();
                aacPcmFile = tempFile;
            }
            if (aacVolume != 50) {
                adjustedPcm = new File(cacheDir, "adjusted_" + System.currentTimeMillis() + ".pcm");
                AudioUtil.adjustPcmVolume(aacPcmFile.getAbsolutePath(), adjustedPcm.getAbsolutePath(), aacVolume);
            } else {
                adjustedPcm = aacPcmFile;
            }
            int channelConfig = 16;
            if (channelCount == 2) {
                channelConfig = 12;
            }
            wavFile = new File(context.getCacheDir(), adjustedPcm.getName() + ".wav");
            new PcmToWavUtil(sampleRate, channelConfig, channelCount, 2).pcmToWav(adjustedPcm.getAbsolutePath(), wavFile.getAbsolutePath());
        }
        mediaMuxer.start();
        MediaExtractor pcmExtrator = new MediaExtractor();
        pcmExtrator.setDataSource(wavFile.getAbsolutePath());
        int audioTrack = VideoUtil.selectTrack(pcmExtrator, true);
        pcmExtrator.selectTrack(audioTrack);
        MediaFormat pcmTrackFormat = pcmExtrator.getTrackFormat(audioTrack);
        int maxBufferSize = VideoUtil.getAudioMaxBufferSize(pcmTrackFormat);
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        MediaFormat encodeFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channelCount);
        encodeFormat.setInteger("bitrate", audioBitrate);
        encodeFormat.setInteger("aac-profile", 2);
        encodeFormat.setInteger("max-input-size", maxBufferSize);
        MediaCodec encoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
        encoder.configure(encodeFormat, null, null, 1);
        encoder.start();
        boolean encodeInputDone = false;
        boolean encodeDone = false;
        long lastAudioFrameTimeUs = -1L;
        int AAC_FRAME_TIME_US = 1024000000 / sampleRate;
        boolean detectTimeError = false;
        try {
            long sampleTimeUs;
            block7: while (!encodeDone) {
                int outputBufferIndex;
                int inputBufferIndex = encoder.dequeueInputBuffer(2500L);
                if (!encodeInputDone && inputBufferIndex >= 0) {
                    long sampleTime = pcmExtrator.getSampleTime();
                    if (sampleTime < 0L) {
                        encodeInputDone = true;
                        encoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                    } else {
                        int flags = pcmExtrator.getSampleFlags();
                        buffer.clear();
                        int size = pcmExtrator.readSampleData(buffer, 0);
                        ByteBuffer inputBuffer = encoder.getInputBuffer(inputBufferIndex);
                        inputBuffer.clear();
                        inputBuffer.put(buffer);
                        inputBuffer.position(0);
                        CL.it(TAG, "audio queuePcmBuffer " + sampleTime / 1000L + " size:" + size, new Object[0]);
                        encoder.queueInputBuffer(inputBufferIndex, 0, size, sampleTime, flags);
                        pcmExtrator.advance();
                    }
                }
                while ((outputBufferIndex = encoder.dequeueOutputBuffer(info, 2500L)) != -1) {
                    if (outputBufferIndex == -2) {
                        MediaFormat newFormat = encoder.getOutputFormat();
                        CL.it(TAG, "audio decode newFormat = " + newFormat, new Object[0]);
                        continue;
                    }
                    if (outputBufferIndex < 0) {
                        CL.et(TAG, "unexpected result from audio decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                        continue;
                    }
                    if (info.flags == 4) {
                        encodeDone = true;
                        continue block7;
                    }
                    ByteBuffer encodeOutputBuffer = encoder.getOutputBuffer(outputBufferIndex);
                    CL.it(TAG, "audio writeSampleData " + info.presentationTimeUs + " size:" + info.size + " flags:" + info.flags, new Object[0]);
                    if (!detectTimeError && lastAudioFrameTimeUs != -1L && info.presentationTimeUs < lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US) {
                        CL.et(TAG, "audio \u65f6\u95f4\u6233\u9519\u8bef\uff0clastAudioFrameTimeUs:" + lastAudioFrameTimeUs + " info.presentationTimeUs:" + info.presentationTimeUs, new Object[0]);
                        detectTimeError = true;
                    }
                    if (detectTimeError) {
                        info.presentationTimeUs = lastAudioFrameTimeUs + (long)AAC_FRAME_TIME_US;
                        CL.et(TAG, "audio \u65f6\u95f4\u6233\u9519\u8bef\uff0c\u4f7f\u7528\u4fee\u6b63\u7684\u65f6\u95f4\u6233:" + info.presentationTimeUs, new Object[0]);
                    }
                    lastAudioFrameTimeUs = info.presentationTimeUs;
                    mediaMuxer.writeSampleData(muxerAudioIndex, encodeOutputBuffer, info);
                    encodeOutputBuffer.clear();
                    encoder.releaseOutputBuffer(outputBufferIndex, false);
                }
            }
            if (oriAudioIndex >= 0) {
                oriExtrator.unselectTrack(oriAudioIndex);
            }
            oriExtrator.selectTrack(oriVideoIndex);
            oriExtrator.seekTo((long)startTimeUs.intValue(), 0);
            maxBufferSize = oriVideoFormat.getInteger("max-input-size");
            int frameRate = oriVideoFormat.containsKey("frame-rate") ? oriVideoFormat.getInteger("frame-rate") : DEFAULT_FRAME_RATE;
            buffer = ByteBuffer.allocateDirect(maxBufferSize);
            int VIDEO_FRAME_TIME_US = (int)(1000000.0f / (float)frameRate);
            long lastVideoFrameTimeUs = -1L;
            detectTimeError = false;
            while ((sampleTimeUs = oriExtrator.getSampleTime()) != -1L) {
                if (sampleTimeUs < (long)startTimeUs.intValue()) {
                    oriExtrator.advance();
                    continue;
                }
                if (endTimeUs != null && sampleTimeUs > (long)endTimeUs.intValue()) {
                    break;
                }
                info.presentationTimeUs = sampleTimeUs - (long)startTimeUs.intValue();
                info.flags = oriExtrator.getSampleFlags();
                info.size = oriExtrator.readSampleData(buffer, 0);
                if (info.size < 0) {
                    break;
                }
                if (!detectTimeError && lastVideoFrameTimeUs != -1L && info.presentationTimeUs < lastVideoFrameTimeUs + (long)VIDEO_FRAME_TIME_US) {
                    CL.et(TAG, "video \u65f6\u95f4\u6233\u9519\u8bef\uff0clastVideoFrameTimeUs:" + lastVideoFrameTimeUs + " info.presentationTimeUs:" + info.presentationTimeUs, new Object[0]);
                    detectTimeError = true;
                }
                if (detectTimeError) {
                    info.presentationTimeUs = lastVideoFrameTimeUs + (long)VIDEO_FRAME_TIME_US;
                    CL.et(TAG, "video \u65f6\u95f4\u6233\u9519\u8bef\uff0c\u4f7f\u7528\u4fee\u6b63\u7684\u65f6\u95f4\u6233:" + info.presentationTimeUs, new Object[0]);
                }
                lastVideoFrameTimeUs = info.presentationTimeUs;
                CL.et(TAG, "video writeSampleData:" + info.presentationTimeUs + " type:" + info.flags + " size:" + info.size, new Object[0]);
                mediaMuxer.writeSampleData(muxerVideoIndex, buffer, info);
                oriExtrator.advance();
            }
        }
        finally {
            aacPcmFile.delete();
            videoPcmFile.delete();
            adjustedPcm.delete();
            wavFile.delete();
            try {
                pcmExtrator.release();
                oriExtrator.release();
                mediaMuxer.release();
                encoder.stop();
                encoder.release();
            }
            catch (Exception e) {
                CL.e(e);
            }
        }
    }
}

