/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor.util;

import android.util.Log;

public class CL {
    private static boolean sLogEnable = false;
    private static int sCount = 0;

    private CL() {
    }

    public static boolean isLogEnable() {
        return sLogEnable;
    }

    public static void setLogEnable(boolean enable) {
        if (++sCount > 1) {
            Log.e((String)"L", (String)"setLogEnable() could only be called once");
        } else {
            sLogEnable = enable;
        }
    }

    private static String createLog(TagInfo tagInfo, String log, Object ... args) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        buffer.append(tagInfo.fileName);
        buffer.append(".");
        buffer.append(tagInfo.methodName);
        buffer.append("():");
        buffer.append(tagInfo.lineNumber);
        buffer.append("]");
        buffer.append(CL.formatString(log, args));
        return buffer.toString();
    }

    private static String createLogWithoutFileName(TagInfo tagInfo, String log, Object ... args) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        buffer.append(tagInfo.methodName);
        buffer.append("():");
        buffer.append(tagInfo.lineNumber);
        buffer.append("]");
        buffer.append(CL.formatString(log, args));
        return buffer.toString();
    }

    private static TagInfo getMethodNames(StackTraceElement[] sElements) {
        TagInfo info = new TagInfo();
        if (sElements.length > 1) {
            info.fileName = sElements[1].getFileName();
            if (info.fileName.endsWith(".java")) {
                info.fileName = info.fileName.substring(0, info.fileName.length() - 5);
            }
            info.methodName = sElements[1].getMethodName();
            info.lineNumber = sElements[1].getLineNumber();
        }
        return info;
    }

    private static String formatString(String message, Object ... args) {
        return args.length == 0 ? message : String.format(message, args);
    }

    public static void v(String message, Object ... args) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(new Throwable().getStackTrace());
            String msg = CL.createLogWithoutFileName(tagInfo, message, args);
            Log.v((String)tagInfo.fileName, (String)msg);
        }
    }

    public static void v(Throwable ex) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(ex.getStackTrace());
            Log.v((String)tagInfo.fileName, (String)"", (Throwable)ex);
        }
    }

    public static void vt(String tag, String message, Object ... args) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(new Throwable().getStackTrace());
            String msg = CL.createLog(tagInfo, message, args);
            Log.v((String)tag, (String)msg);
        }
    }

    public static void d(String message, Object ... args) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(new Throwable().getStackTrace());
            String msg = CL.createLogWithoutFileName(tagInfo, message, args);
            Log.d((String)tagInfo.fileName, (String)msg);
        }
    }

    public static void d(Throwable ex) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(ex.getStackTrace());
            Log.d((String)tagInfo.fileName, (String)"", (Throwable)ex);
        }
    }

    public static void dt(String tag, String message, Object ... args) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(new Throwable().getStackTrace());
            String msg = CL.createLog(tagInfo, message, args);
            Log.d((String)tag, (String)msg);
        }
    }

    public static void i(String message, Object ... args) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(new Throwable().getStackTrace());
            String msg = CL.createLogWithoutFileName(tagInfo, message, args);
            Log.i((String)tagInfo.fileName, (String)msg);
        }
    }

    public static void i(Throwable ex) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(ex.getStackTrace());
            Log.i((String)tagInfo.fileName, (String)"", (Throwable)ex);
        }
    }

    public static void it(String tag, String message, Object ... args) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(new Throwable().getStackTrace());
            String msg = CL.createLog(tagInfo, message, args);
            Log.i((String)tag, (String)msg);
        }
    }

    public static void w(String message, Object ... args) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(new Throwable().getStackTrace());
            String msg = CL.createLogWithoutFileName(tagInfo, message, args);
            Log.w((String)tagInfo.fileName, (String)msg);
        }
    }

    public static void w(Throwable ex) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(ex.getStackTrace());
            Log.v((String)tagInfo.fileName, (String)"", (Throwable)ex);
        }
    }

    public static void wt(String tag, String message, Object ... args) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(new Throwable().getStackTrace());
            String msg = CL.createLog(tagInfo, message, args);
            Log.w((String)tag, (String)msg);
        }
    }

    public static void e(String message, Object ... args) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(new Throwable().getStackTrace());
            String msg = CL.createLogWithoutFileName(tagInfo, message, args);
            Log.e((String)tagInfo.fileName, (String)msg);
        }
    }

    public static void e(Throwable ex) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(ex.getStackTrace());
            Log.e((String)tagInfo.fileName, (String)"", (Throwable)ex);
        }
    }

    public static void et(String tag, String message, Object ... args) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(new Throwable().getStackTrace());
            String msg = CL.createLog(tagInfo, message, args);
            Log.e((String)tag, (String)msg);
        }
    }

    public static void wtf(String message, Object ... args) {
        if (sLogEnable) {
            TagInfo tagInfo = CL.getMethodNames(new Throwable().getStackTrace());
            String msg = CL.createLogWithoutFileName(tagInfo, message, args);
            Log.wtf((String)tagInfo.fileName, (String)msg);
        }
    }

    public static void printStackTrace(String tag) {
        if (sLogEnable) {
            String stackTrace = Log.getStackTraceString((Throwable)new Throwable());
            Log.d((String)tag, (String)stackTrace);
        }
    }

    static class TagInfo {
        String fileName;
        String methodName;
        int lineNumber;

        TagInfo() {
        }
    }
}

